

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetCompanyDefaultAlerts.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppSetCompanyDefaultAlerts()
--  | Description:  This procedure will be used while creating a company. This will create default alerts for a company
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetCompanyDefaultAlerts.sp,v $ $Id: AppSetCompanyDefaultAlerts.sp,v 1.1.2.8 2020/03/12 01:33:39 mnatarajan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetCompanyDefaultAlerts')
BEGIN
	print '>>> Drop Stored Procedure: AppSetCompanyDefaultAlerts <<<'
	drop procedure AppSetCompanyDefaultAlerts
END
IF EXISTS (select * from GxQscripts where name='AppSetCompanyDefaultAlerts')
	delete from GxQscripts where name = 'AppSetCompanyDefaultAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCompanyDefaultAlerts')
	delete from GXDBVersions where aliasname = 'AppSetCompanyDefaultAlerts'
GO
print '... Creating Procedure: AppSetCompanyDefaultAlerts'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetCompanyDefaultAlerts
  @i_companyId INTEGER,
  @i_tenantAdminUserName NVARCHAR(255),
  @i_localeId INTEGER
AS
  DECLARE @errCode INTEGER=0
  DECLARE @errString NVARCHAR(MAX) = ''
SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	DECLARE @companyName nvarchar(255) = (SELECT hostName FROM UMDSProviders WHERE ID = @i_companyId)
DECLARE @TenantAdminGroupId int = ISNULL((SELECT id FROM umgroups WHERE umdsProviderId=@i_companyId AND groupFlags&0x10000 <> 0 ),0)
DECLARE @tenantAdminUserId INT = ISNULL((SELECT id FROM UMUSERS WITH(NOLOCK) 	 WHERE login = @i_tenantAdminUserName AND umDSproviderId=@i_companyId),0)
DECLARE @tenantClientGrpId NVARCHAR(64) = ISNULL((SELECT id FROM App_ClientGroup WHERE name = @companyName ), N'0')
DECLARE @dontCreateOrganizationAlerts INT = 0
SELECT @dontCreateOrganizationAlerts = value FROM GXGlobalParam (NOLOCK) WHERE name='disableDefaultOrganizationAlerts' AND Modified = 0
IF @TenantAdminGroupId>0 AND @tenantAdminUserId>0 AND @tenantClientGrpId>0
BEGIN
	-- If key is not there to disable/not create default organization alerts, then create default organization alerts
	IF @dontCreateOrganizationAlerts = 0
	BEGIN
		EXEC NTCreateDefaultAlertsForOrganization @TenantAdminGroupId, @tenantAdminUserId, @tenantClientGrpId, @errCode OUTPUT, @errString OUTPUT
	END
END
ELSE
BEGIN
SET @errCode = (3208 | (CAST(POWER(2, 24) AS BIGINT) * 35))-- (3208 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3208 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId)--(3208 | (CAST(POWER(2, 24) AS BIGINT) * 35))
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @errCode = ERROR_NUMBER()
    set @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
	select @errCode, @errString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetCompanyDefaultAlerts')
	delete from GxQscripts where name = 'AppSetCompanyDefaultAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCompanyDefaultAlerts')
	delete from GXDBVersions where aliasname = 'AppSetCompanyDefaultAlerts'
GO

insert into GXDBVersions values(2, 'AppSetCompanyDefaultAlerts',  '00010001000200080000', 'AppSetCompanyDefaultAlerts', '00010001000200080000')
GO

