

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetCompanyCustomization.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppSetCompanyProperties()
--  | Description:  Allows for GET of company properties for provided ProviderID
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetCompanyCustomization.sp,v $ $Id: AppSetCompanyCustomization.sp,v 1.1.2.3.14.1 2021/03/05 00:45:11 nshah Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppSetCompanyCustomization')
BEGIN
	print '>>> Drop Stored Procedure: AppSetCompanyCustomization <<<'
	drop procedure AppSetCompanyCustomization
END
IF EXISTS (select * from GxQscripts where name='AppSetCompanyCustomization')
	delete from GxQscripts where name = 'AppSetCompanyCustomization'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCompanyCustomization')
	delete from GXDBVersions where aliasname = 'AppSetCompanyCustomization'
GO
print '... Creating Procedure: AppSetCompanyCustomization'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppSetCompanyCustomization
  @callerId INT,
  @localeId INT,
  @i_providerId INT,
  @i_customizationString NVARCHAR(MAX),
  @o_xmlText XML OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
DECLARE @canManageProvider INT
DECLARE @tenantAdminGroupId INT = 0
DECLARE @webconsoleClients  table(clientId int)
DECLARE @nowTime   integer
SET     @nowTime  =   dbo.GetUnixTime (GetUTCdate())
DECLARE @ownerCompany INT = 0
DECLARE @o_errCode integer=0
DECLARE @o_errString nvarchar(1024)=''
SET @ownerCompany = dbo.AppGetCompanyForProvider(@i_providerId)
EXEC sec_checkPermissionOnEntity @callerId, 1, @canManageProvider OUTPUT, 61, @ownerCompany
--For customization registry
    DECLARE @newSettings TABLE
(
    ActionType VARCHAR(50),
    keyId int
);
IF @canManageProvider = 1
BEGIN
	DECLARE @doAudit int = 0
	DECLARE @oldCustomization nvarchar(max)
SET @oldCustomization = (SELECT attrVal FROM App_CompanyProp WHERE componentNameId=@ownerCompany AND attrName =  'Customization'   AND modified=0)
	IF(@oldcustomization is null)
	BEGIN
		INSERT INTO App_CompanyProp(componentNameId,  attrName, attrType, attrVal, created, modified)
VALUES (@ownerCompany,'Customization' , 1, @i_customizationString,  dbo.GetUnixTime(GetUTCDate()), 0);
		SET @doAudit = 1
	END
	ELSE IF (@oldcustomization <> @i_customizationString)
	BEGIN
UPDATE App_CompanyProp SET attrVal=@i_customizationString WHERE componentNameId=@ownerCompany AND attrName =  'Customization'  AND modified=0
		SET @doAudit = 1
	END
	--Audit
	IF(@doAudit=1)
	BEGIN
		DECLARE @opMsgId            INTEGER
		DECLARE @opEvMsgId          INTEGER
		DECLARE @opId               INTEGER
		DECLARE @paramMsgId         INTEGER
		DECLARE @paramData          NVARCHAR(1024)
		DECLARE @dataIsEvent        INTEGER = 0
SET @opMsgId = (611 | (CAST(POWER(2, 24) AS BIGINT) * 84))
		EXEC EvGuiAuditSetOperation @opMsgId, @callerId, @opEvMsgId OUTPUT, @opId OUTPUT
SET @paramMsgId  = (1649 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		SET @paramData = (SELECT hostname FROM UMDSProviders WHERE id = @ownerCompany AND enabled <> 0)
		EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
		EXEC EvGuiAuditSetParamData @opId, @i_customizationString, @dataIsEvent
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @callerId
		--User
SET @paramMsgId  = (1189 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		SET @paramData = (SELECT login FROM UMUsers WHERE id = @callerId)
		EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @callerId
		INSERT INTO @webconsoleClients
		SELECT c.id
		FROM app_client c
INNER JOIN simInstalledPackages sim ON c.id = sim.ClientId AND sim.simPackageID IN (726,1135)
		LEFT JOIN App_VMToPMMAp vm ON vm.PMClientId=c.id WHERE VMClientId IS NULL
		UNION
		SELECT vm.VMClientId
		FROM app_client c
		INNER JOIN App_VMToPMMAp vm ON c.id=PMClientId
INNER JOIN simInstalledPackages sim ON c.id = sim.ClientId AND sim.simPackageID in (726,1135)
		--Add key for custom settings
		MERGE APP_AdvanceSettings AS AV
		USING
		(
			SELECT clientId,cast( @ownerCompany as nvarchar) keyName, 'STRING' type, 'WebConsole\Customization' relativePath, 1 enabled, 0 deleted, 3 entityType, @i_customizationString stringVal
			FROM @webconsoleClients
		) AS CT
		ON CT.clientId = AV.entityId AND CT.keyName = AV.keyName AND CT.type = AV.type AND CT.relativePath = AV.relativePath
		WHEN MATCHED THEN
			UPDATE SET value = CT.stringVal
		WHEN NOT MATCHED THEN
			INSERT (entityId, keyName, type, relativePath, value, enabled, deleted, entityType, sourceId, sourceEntityType)
			VALUES (CT.clientId, CT.keyName, CT.type, CT.relativePath, CT.stringVal, CT.enabled, 0, CT.entityType, 0, 0)
		OUTPUT $action AS ActionType, Inserted.id INTO @newSettings;
		INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
		SELECT clientId, 6 /*WORK_TOKEN_REGISTRY*/, '', @nowTime, 0, 0, 0, -1
		FROM @webconsoleClients
		--Mark the keys hidden
		INSERT INTO APP_AdvanceSettingsEx(keyId  , details, hidden)
		SELECT keyId, '',1 from @newSettings WHERE ActionType = 'INSERT';
	END
END
ELSE
BEGIN
SET @o_errCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
	GOTO SCRIPT_EXIT
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @o_errCode = ERROR_NUMBER()
    set @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
SCRIPT_EXIT:
SET @o_xmlText = (SELECT @o_errCode AS '@errorCode', @o_errString AS '@errorMessage' FOR XML PATH ('error'), ROOT('Api_UpdateOrganizationPropertiesResponse'))
SELECT @o_xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetCompanyCustomization')
	delete from GxQscripts where name = 'AppSetCompanyCustomization'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCompanyCustomization')
	delete from GXDBVersions where aliasname = 'AppSetCompanyCustomization'
GO

insert into GXDBVersions values(2, 'AppSetCompanyCustomization',  'v1.1.2.3.14.1', 'AppSetCompanyCustomization', 'v1.1.2.3.14.1')
GO

