

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetCommcellNotifications.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetCommcellNotifications.sp,v $ $Id: AppSetCommcellNotifications.sp,v 1.1.2.3 2018/09/16 03:17:49 vdevassy Exp $";
-- =============================================================
-- Author:		Rohit Iyer
-- Create date: 03/14/2018
-- Description: Update status of commcell push notifications
-- =============================================================
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSetCommcellNotifications <<<'

IF EXISTS (select * from sysobjects where name='AppSetCommcellNotifications')
	drop procedure AppSetCommcellNotifications
IF EXISTS (select * from GxQscripts where name='AppSetCommcellNotifications')
	delete from GxQscripts where name = 'AppSetCommcellNotifications'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCommcellNotifications')
	delete from GXDBVersions where aliasname = 'AppSetCommcellNotifications'
GO
print '... Creating Procedure: AppSetCommcellNotifications'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetCommcellNotifications
  @in_xml XML
AS
  DECLARE @outXml XML
BEGIN TRY
SET NOCOUNT ON
DECLARE @userId						      	INT
DECLARE @localeId           				INT
DECLARE @isAdminUser        				INT
DECLARE @errorCode 							INT
DECLARE @notifType 							INT
DECLARE @title 								VARCHAR(50)
DECLARE @msgStr 							VARCHAR(512)
DECLARE @errorMessage 						VARCHAR(MAX)
declare @nowTime 							INT
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
set @errorCode = 0
set @errorMessage = ''
select  @userId 	= isnull(userRef.value('@userId', 'int'),0),
		@localeId 	= isnull(locRef.value('@localeId', 'int'),0)
FROM    @in_xml.nodes('App_SetComcellNotificationReq') A ( ref )
        outer apply ref.nodes('./processinginstructioninfo/user') B ( userRef )
		outer apply ref.nodes('./processinginstructioninfo/locale') C ( locRef )
--check requesting user details
IF (NOT EXISTS(SELECT 1 FROM UMUsers WITH(nolock) WHERE id = @userId))
BEGIN
	SET @errorCode  = 1
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3290 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
	SET @errorMessage = REPLACE(@errorMessage, '^1%s', @userId)
	GOTO SEND_RESPONSE
END
--Users with Administrative capability at commcell level
EXEC sec_checkPermissionOnEntity @userId, 1, @isAdminUser OUT,1,2
IF(@isAdminUser = 0)
BEGIN
	SET @errorCode  = 1
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2034 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
	GOTO SEND_RESPONSE
END
------------------------------------------------Message Status----------------------------------------------
--WAITING_ON_USER_ACK = 1
--WAITING_ON_TASK_COMPLETION = 2
--COMPLETED = 4
--ERROR = 8
--Store notificaiton list and properties in temp table
IF object_id('tempdb.dbo.#CommcellNotifListTbl') is not null
		DROP TABLE #CommcellNotifListTbl
Create Table #CommcellNotifListTbl
(
	notifGuid     		nvarchar(50),
	status       		integer,
	ackTime             integer
)
insert into #CommcellNotifListTbl
select  isnull(ref.value('@notifGuid', 'nvarchar(50)'),''),
		isnull(ref.value('@status', 'int'),0),
		isnull(ref.value('@ackTime', 'int'),0)
FROM    @in_xml.nodes('App_SetComcellNotificationReq/notification') A ( ref )
delete from #CommcellNotifListTbl where notifGuid is null or notifGuid = ''-- Weed out the bad entries.
SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
--Only update mutable properties, namely [ackUserid, ackTime, modified, flag]
update CPN
set	 CPN.ackUserId = @userId, CPN.ackTime = @nowTime , CPN.flag = CNLT.status, CPN.modified = @nowTime
from CommcellPopupNotifications CPN inner join #CommcellNotifListTbl CNLT on CPN.msgGUID = CNLT.notifGuid
where (CPN.flag & 4 = 0)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode     = ERROR_NUMBER()
    SET @errorMessage  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
SEND_RESPONSE:
SET @outXml = ( SELECT  @errorCode AS '@errorCode', @errorMessage AS '@errorString'
                 FOR xml path('error'),ROOT('App_SetComcellNotificationResp')
               )
select @outXml
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetCommcellNotifications')
	delete from GxQscripts where name = 'AppSetCommcellNotifications'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCommcellNotifications')
	delete from GXDBVersions where aliasname = 'AppSetCommcellNotifications'
GO

insert into GXDBVersions values(2, 'AppSetCommcellNotifications',  '00010001000200030000', 'AppSetCommcellNotifications', '00010001000200030000')
GO

