

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetCloudAppUserBackupStats.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+=========================================================================================================+
--	|  							AppSetCloudAppUserBackupStats				    							  |
--	| Procedure for Set backup reference time, Usersize, items, IdxCollection Time for for cloudapps onedrive |
--	+=========================================================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetCloudAppUserBackupStats')
BEGIN
	print '>>> Drop Stored Procedure: AppSetCloudAppUserBackupStats <<<'
	drop procedure AppSetCloudAppUserBackupStats
END
IF EXISTS (select * from GxQscripts where name='AppSetCloudAppUserBackupStats')
	delete from GxQscripts where name = 'AppSetCloudAppUserBackupStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCloudAppUserBackupStats')
	delete from GXDBVersions where aliasname = 'AppSetCloudAppUserBackupStats'
GO
print '... Creating Procedure: AppSetCloudAppUserBackupStats'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetCloudAppUserBackupStats
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xmlString		XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowUtcTime			DATETIME = GETUTCDATE()
	DECLARE @nowUtcUnix			INT = DATEDIFF(second, '01/01/1970', @nowUtcTime)
	DECLARE @DISCOVERTYPE_USER													INT = 1
	DECLARE @DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES						INT = 6
	DECLARE @DISCOVERTYPE_TEAM												INT = 12
	DECLARE @DISCOVERTYPE_DYNAMICS_365_TABLE						INT = 14
	DECLARE @DISCOVERTYPE_DYNAMICS_365_INSTANCE				INT = 15
	IF OBJECT_ID('tempdb.dbo.#userAssociation') IS NOT NULL
       DROP TABLE #userAssociation
CREATE TABLE #userAssociation (userGuid varchar(40), subclientId INT, RefTime INT, CollectionTime INT, nItems BIGINT, userSize BIGINT)
	CREATE CLUSTERED INDEX #userAssociation_userGuid_subclientId_Index ON #userAssociation ([userGuid],[subclientId])
	INSERT INTO #userAssociation(userGuid, subclientId, RefTime,CollectionTime, nItems, userSize)
	SELECT US.value('(user[1]/@userGUID)', 'NVARCHAR(MAX)'),
			US.value('(../../subclientEntity[1]/@subclientId)','INT'),
			CASE WHEN US.value('(lastBackupJobRanTime[1]/@time)','INT') IS NULL
				 THEN US.value('(lastBackupJobRanTime[1]/@timeValue)', 'VARCHAR(30)') --check if other field is set and read from it
			ELSE US.value('(lastBackupJobRanTime[1]/@time)','INT') END,
			CASE WHEN US.value('(IdxCollectionTime[1]/@time)','INT') IS NULL
		         THEN US.value('(IdxCollectionTime[1]/@timeValue)', 'VARCHAR(30)') --check if other field is set and read from it
		    ELSE US.value('(IdxCollectionTime[1]/@time)','INT') END,
		    US.value('@numberOfItems','BIGINT'),
		    US.value('@accountSize','BIGINT')
	FROM @i_xmlString.nodes('Ida_SetCloudAppUserBackupStats/userAssociation/cloudAppDiscoverinfo/userAccounts') M(US)
	--Check if received input has valid values
	IF EXISTS(SELECT TOP 1 1 FROM #userAssociation WHERE userSize<0 OR nItems<0 OR CollectionTime<0 OR RefTime <0 OR subclientId <=0 OR userGuid IS NULL OR LEN(userGuid)<=0)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Invalid input received. Check input request. Exiting'
		GOTO ERROR_EXIT
	END
	BEGIN TRANSACTION
		UPDATE APP_CloudAppUserDetails
		SET backupReferenceTime = CASE WHEN US.RefTime IS NOT NULL AND  US.RefTime != 0 THEN US.RefTime
			                      ELSE backupReferenceTime  END,
	        IdxCollectionTime = CASE WHEN US.CollectionTime IS NOT NULL AND  US.CollectionTime != 0 THEN US.CollectionTime
	                            ELSE IdxCollectionTime  END,
			numberOfItems = CASE WHEN US.nItems IS NOT NULL AND US.nItems != 0 THEN US.nItems
	                        ELSE numberOfItems END,
	 	    userAccountSize = CASE WHEN US.userSize IS NOT NULL AND US.userSize != 0 THEN US.userSize
                     		  ELSE userAccountSize END
		FROM #userAssociation US
		WHERE APP_CloudAppUserDetails.userGuid = US.userGuid AND APP_CloudAppUserDetails.subClientId = US.subclientId
		AND APP_CloudAppUserDetails.discoverByType in (@DISCOVERTYPE_USER,@DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES, @DISCOVERTYPE_TEAM, @DISCOVERTYPE_DYNAMICS_365_TABLE, @DISCOVERTYPE_DYNAMICS_365_INSTANCE)
		AND  APP_CloudAppUserDetails.modified=0
		SET @errorCode = @@ERROR
	ERROR:
	IF @errorCode <> 0
		ROLLBACK TRAN
	ELSE
		COMMIT TRAN
	ERROR_EXIT:
	SET @o_xmlString = (SELECT @errorCode '@errorCode', @errorString '@errorMessage' FOR XML PATH ('Ida_GenericResp'), TYPE )
	SELECT @o_xmlString
	IF object_id('tempdb.dbo.#userAssociation') is not null
       DROP TABLE #userAssociation
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetCloudAppUserBackupStats')
	delete from GxQscripts where name = 'AppSetCloudAppUserBackupStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCloudAppUserBackupStats')
	delete from GXDBVersions where aliasname = 'AppSetCloudAppUserBackupStats'
GO

insert into GXDBVersions values(2, 'AppSetCloudAppUserBackupStats',  '00000000000000000000', 'AppSetCloudAppUserBackupStats', '00000000000000000000')
GO

