

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetClientVersion.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetClientVersion.sp,v $ $Id: AppSetClientVersion.sp,v 1.8.204.6 2018/03/27 22:03:04 abilbrey Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppSetClientVersion"	|
-- 	+-----------------------------------------------------------------------+
--  +-------------------------------------------------------------------------------------+
--  |   Revision History                                                                  |
--  |   ================                                                                  |
--  |   Procedure Name                        Description                                 |
--  |   -----------------------------         ------------------------------------------  |
--  +-------------------------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSetClientVersion <<<'

IF EXISTS (select * from sysobjects where name='AppSetClientVersion')
	drop procedure AppSetClientVersion
IF EXISTS (select * from GxQscripts where name='AppSetClientVersion')
	delete from GxQscripts where name = 'AppSetClientVersion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetClientVersion')
	delete from GXDBVersions where aliasname = 'AppSetClientVersion'
GO
print '... Creating Procedure: AppSetClientVersion'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetClientVersion
  @i_clientId integer
AS
-- output result not use but left here to remain compatible with source code from previous implementation
  DECLARE @o_clientVersion varchar(255)
BEGIN
	SET NOCOUNT ON
	-- Converted the previous implementation from a CURSOR to a Data Set operation.
	IF OBJECT_ID('tempdb.dbo.#clientVer') IS NOT NULL
		DROP TABLE #clientVer
	CREATE TABLE #clientVer (
		clientId	INT,
		type		INT,
		useFcv		INT,
		fcv			NVARCHAR(128),
		rel			NVARCHAR(128),
		ver			NVARCHAR(128)
		 PRIMARY KEY(clientId, useFcv)
	)
	-- Compute all Client Version data
	INSERT INTO #clientVer
		SELECT
			c.id clientId,
			cc.type,
			CASE	-- foreign client version used or not
				WHEN cc.type <> 1 AND ip.clientId IS NULL THEN 1
				ELSE 0
			END useFcv,
			CASE	-- foreign client version computed
				WHEN cc.type <> 1 AND ip.clientId IS NULL THEN (CASE WHEN fcv.id IS NOT NULL THEN fcv.attrVal ELSE '' END)
				ELSE ''
			END ver,
			ISNULL(sr.release, '') rel,
			CASE	-- local client version computed
				WHEN sr.release IS NULL THEN ''
				WHEN CHARINDEX('.', sr.release) > 0 THEN sr.release + N'.0' + (
						CASE c.releaseId
							WHEN 12 THEN N'(BUILD76)'
							WHEN 13 THEN N'(BUILD68)'
							WHEN 14 THEN N'(BUILD84)'
							WHEN 15 THEN N'(BUILD116)'
							ELSE N'(' + gb.attrVal + N')'
						END
					)
				ELSE sr.release + (
						CASE c.releaseId
							WHEN 12 THEN N'(BUILD76)'
							WHEN 13 THEN N'(BUILD68)'
							WHEN 14 THEN N'(BUILD84)'
							WHEN 15 THEN N'(BUILD116)'
							ELSE N'(' + gb.attrVal + N')'
						END
					)
			END ver
		FROM APP_Client c WITH(NOLOCK)
			INNER JOIN APP_CommCell cc WITH(NOLOCK) ON
				cc.id = c.origCCId
			LEFT OUTER JOIN (
				SELECT DISTINCT
					clientId
				FROM simInstalledPackages WITH(NOLOCK)
			) ip ON
				ip.clientId = c.id
			LEFT OUTER JOIN APP_ClientProp fcv WITH(NOLOCK) ON
				fcv.attrName = N'Foreign Client Version'
				AND fcv.modified = 0
				AND fcv.componentNameId = c.id
			LEFT OUTER JOIN SimAllGalaxyRel sr WITH(NOLOCK) ON
				sr.id = c.releaseId
			LEFT OUTER JOIN APP_ClientProp gb WITH(NOLOCK) ON
				gb.attrName = N'Galaxy Build'
				AND gb.modified = 0
				AND gb.componentNameId = c.id
		WHERE
			@i_clientId = 0
			OR c.id = @i_clientId
	-- Delete existing Client Version rows if out-of-date
	DELETE cp
	FROM APP_ClientProp cp
		INNER JOIN #clientVer cv ON
			cv.clientId = cp.componentNameId
			AND cp.attrName = N'Client Version'
			AND cp.modified = 0
	WHERE
		cv.useFcv = 0
		AND LEN(cv.ver) > 0
		AND cp.attrVal <> cv.ver
	DELETE cp
	FROM APP_ClientProp cp
		INNER JOIN #clientVer cv ON
			cv.clientId = cp.componentNameId
			AND cp.attrName = N'Client Version'
			AND cp.modified = 0
	WHERE
		cv.useFcv = 1
		AND LEN(cv.fcv) > 0
		AND cp.attrVal <> cv.fcv
	-- Insert Client Version data that was either deleted or missing
	DECLARE @now INT = dbo.GetUnixTime(GETUTCDATE())
	INSERT INTO APP_ClientProp (
		[componentNameId]
		,[attrName]
		,[attrType]
		,[attrVal]
		,[created]
		,[modified]
		,[ccpId]
	)
		SELECT
			cv.clientId
			,N'Client Version'
			,1
			,CASE
				WHEN cv.useFcv = 1 THEN cv.fcv
				ELSE cv.ver
			END
			,@now
			,0
			,0
		FROM #clientVer cv
			LEFT OUTER JOIN APP_ClientProp cp WITH(NOLOCK) ON
				cp.componentNameId = cv.clientId
				AND cp.modified = 0
				AND cp.attrName = N'Client Version'
		WHERE
			cv.clientId > 1
			AND cp.id IS NULL	-- only insert the ones deleted or missing from the table
			AND (
				(cv.useFcv = 1 AND cv.fcv IS NOT NULL)
				OR (cv.useFcv = 0 AND cv.ver IS NOT NULL)
			)
	-- Insert client Release rows if not present
	INSERT INTO APP_ClientProp (
		[componentNameId]
		,[attrName]
		,[attrType]
		,[attrVal]
		,[created]
		,[modified]
		,[ccpId]
	)
		SELECT
			cv.clientId
			,N'Release '+ cv.rel
			,2
			,CAST(@now AS NVARCHAR(12))
			,@now
			,0
			,0
		FROM #clientVer cv
			LEFT OUTER JOIN APP_ClientProp cp WITH(NOLOCK) ON
				cp.componentNameId = cv.clientId
				AND cp.modified = 0
				AND cp.attrName = N'Release '+ cv.rel
		WHERE
			cp.id IS NULL	-- insert row where release property is not present
	-- previous implementation commented out, left as reference that result is not used.
	--SELECT    @o_clientVersion
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'AppSetClientVersion')
	delete from GxQscripts where name = 'AppSetClientVersion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetClientVersion')
	delete from GXDBVersions where aliasname = 'AppSetClientVersion'
GO

insert into GXDBVersions values(2, 'AppSetClientVersion',  '00010008020400060000', 'AppSetClientVersion', '00010008020400060000')
GO

