

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetClientUserProfile.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetClientUserProfile.sp,v $ $Id: AppSetClientUserProfile.sp,v 1.5.60.2 2018/03/22 01:38:48 jiechen Exp $";
--	+===================================================================+
--	| AppSetClientUserMap - Set User profile mapping for a client		|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSetClientUserProfile <<<'

IF EXISTS (select * from sysobjects where name='AppSetClientUserProfile')
	drop procedure AppSetClientUserProfile
IF EXISTS (select * from GxQscripts where name='AppSetClientUserProfile')
	delete from GxQscripts where name = 'AppSetClientUserProfile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetClientUserProfile')
	delete from GXDBVersions where aliasname = 'AppSetClientUserProfile'
GO
print '... Creating Procedure: AppSetClientUserProfile'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetClientUserProfile
  @i_xmlText XML
AS
  DECLARE @o_xmlMsg XML;
BEGIN TRY
    DECLARE @o_errorCode        INT = 0
    DECLARE @o_errorStr NVARCHAR(1024) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
    DECLARE @clientInfo Table (userProfileName NVARCHAR(MAX), clientId bigint)
    DECLARE @operationType int = ISNULL (( SELECT ref.value('@clientUserProfilesOperationType', 'INT')
					FROM @i_xmlText.nodes ('App_SetLocalUserProfileForClientReq') R(ref)), 1) -- by default, its always overwrite
    INSERT INTO @clientInfo
    SELECT  ow.value('@val', 'NVARCHAR(1024)') AS userProfileName,
            CASE
                WHEN cl.value('@clientId', 'int')=0
                    THEN (SELECT id FROM APP_Client WHERE name=cl.value('@clientName', 'NVARCHAR(1024)'))
                ELSE cl.value('@clientId', 'int') END
                AS clientId
        FROM    @i_xmlText.nodes('App_SetLocalUserProfileForClientReq/clientUserProfiles') R ( cw )
        CROSS APPLY cw.nodes('./userProfileName') O(ow)
        CROSS APPLY cw.nodes('./client') C(cl)
--
	DELETE UMClientUserMap
	WHERE  localUserLogin NOT IN (SELECT userProfileName FROM @clientInfo) AND clientId IN (SELECT DISTINCT clientId FROM @clientInfo) AND umUserId = 0
--
	INSERT INTO UMClientUserMap(umUserId,clientId,localUserLogin,modified)
	SELECT 0,clientId,userProfileName,@nowTime
	FROM @clientInfo C
	WHERE NOT EXISTS (SELECT UM.localUserLogin FROM UMClientUserMap UM WHERE UM.clientId = C.clientId AND UM.localUserLogin = C.userProfileName)
--
-- Now check if the clients has any user mapping, if not try to assign a mapping
	DECLARE @clientId INT = 0
	DECLARE @umUserId INT = 0
	DECLARE ClientInfoCursor CURSOR
	FOR SELECT DISTINCT clientId FROM @clientInfo
--
    OPEN ClientInfoCursor
    FETCH FROM ClientInfoCursor INTO @clientId
--
    WHILE @@FETCH_STATUS = 0
    BEGIN
		IF NOT EXISTS (SELECT * FROM UMClientUserMap WHERE clientId = @clientId AND umUserId <> 0)
		BEGIN
			SET @umUserId = ISNULL((SELECT TOP 1 id FROM UMUsers WHERE EXISTS (SELECT * FROM UMClientUserMap WHERE localUserLogin = login AND clientId = @clientId)),-1)
			IF @umUserId > 0
			BEGIN
				UPDATE UMClientUserMap
				SET umUserId = @umUserId
				WHERE clientId = @clientId AND localUserLogin = (SELECT login FROM UMUsers WHERE id = @umUserId)
			END
		END
		FETCH FROM ClientInfoCursor INTO @clientId
    END
--
    CLOSE ClientInfoCursor
    DEALLOCATE ClientInfoCursor
--
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @o_errorCode     = ERROR_NUMBER()
    SET @o_errorStr  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
--
EXIT_PROC:
--
SET @o_xmlMsg = ( SELECT @o_errorCode '@errorCode', @o_errorStr '@errorMessage'
FOR XML PATH('App_GenericResp'))
--
    SELECT @o_xmlMsg AS [o_xmlMsg]
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetClientUserProfile')
	delete from GxQscripts where name = 'AppSetClientUserProfile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetClientUserProfile')
	delete from GXDBVersions where aliasname = 'AppSetClientUserProfile'
GO

insert into GXDBVersions values(2, 'AppSetClientUserProfile',  '00010005006000020000', 'AppSetClientUserProfile', '00010005006000020000')
GO

