

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetClientGroupGlobalFilters.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Rohith Engu
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetClientGroupGlobalFilters')
BEGIN
	print '>>> Drop Stored Procedure: AppSetClientGroupGlobalFilters <<<'
	drop procedure AppSetClientGroupGlobalFilters
END
IF EXISTS (select * from GxQscripts where name='AppSetClientGroupGlobalFilters')
	delete from GxQscripts where name = 'AppSetClientGroupGlobalFilters'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetClientGroupGlobalFilters')
	delete from GXDBVersions where aliasname = 'AppSetClientGroupGlobalFilters'
GO
print '... Creating Procedure: AppSetClientGroupGlobalFilters'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetClientGroupGlobalFilters
  @i_xml XML,
  @clientGroupId INT,
  @localeId INT,
  @userId INT,
  @o_errorCode INT OUTPUT,
  @o_errorString nvarchar(MAX) OUTPUT,
  @selectOutput INT = 0,
  @getPropertiesForAudit INT = 0 --Used for getting before and after update XML so that CPP side we can audit
AS
  DECLARE @errorCode INT = 0
  DECLARE @errorString nvarchar(MAX)= N'Success'
  DECLARE @o_beforeUpdateXML XML = ''
  DECLARE @o_afterUpdateXML XML = '' 
BEGIN
	DECLARE @nowTime   integer
	SET     @nowTime  =   dbo.GetUnixTime (GetUTCdate())
	DECLARE @getGlobalFilters AS TABLE (filterStr NVARCHAR(MAX),filterXml XML, errCode INTEGER, errMsg NVARCHAR(MAX))
	DECLARE @finalString NVARCHAR(MAX)
	DECLARE @opType INT = 0
	-- Include Security check and set global filters at the smart client group.
	DECLARE @userHasPermission INT = 0
EXEC sec_checkPermissionOnEntity @userId, 2,
@userHasPermission OUTPUT,  28, @clientGroupId
	IF @userHasPermission = 0
	BEGIN
SET @errorCode = (2497 | (CAST(POWER(2, 24) AS BIGINT) * 35))
        SET @errorString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
WHERE messageId = (2497 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @localeId)
SET @errorString = REPLACE(@errorString, '^1%s', dbo.fn_EvFormatEventMsgText(0,@localeId, (Select tokenId from UMCapability WITH (NOLOCK) where id = 2), 0,2))
		GOTO ENDSP
	END
	IF object_id('tempdb.dbo.#ReqGlobalfilters') IS NOT null DROP TABLE #ReqGlobalfilters
	CREATE TABLE #ReqGlobalfilters (filter NVARCHAR(MAX), operationType int, OperatingSystemType int)
	IF object_id('tempdb.dbo.#ExistingWinGlobalFilters') IS NOT null DROP TABLE #ExistingWinGlobalFilters
	CREATE TABLE #ExistingWinGlobalFilters (filter NVARCHAR(MAX), operationType int, OperatingSystemType int)
	IF object_id('tempdb.dbo.#ExistingUnixGlobalFilters') IS NOT null DROP TABLE #ExistingUnixGlobalFilters
	CREATE TABLE #ExistingUnixGlobalFilters (filter NVARCHAR(MAX), operationType int, OperatingSystemType int)
	IF object_id('tempdb.dbo.#MergedList') IS NOT null DROP TABLE #MergedList
	CREATE TABLE #MergedList (filter NVARCHAR(MAX))
	IF @getPropertiesForAudit = 1
	BEGIN
		INSERT INTO @getGlobalFilters
EXEC AppGetCompanyGlobalFilter @clientGroupId, 28, 0
		IF EXISTS(SELECT 1 FROM @getGlobalFilters)
		BEGIN
			SELECT TOP 1 @errorCode=errCode, @errorString = errMsg, @o_beforeUpdateXML= filterXML FROM @getGlobalFilters
		END
	END
	INSERT INTO #ReqGlobalfilters
	SELECT  ISNULL(filters.value('@val[1]', 'NVARCHAR(MAX)'),'') AS filter, globalFilters.value('@opType[1]','int') as operationType, GGF.value('@operatingSystemType[1]','int') as OperatingSystemType
        FROM    @i_xml.nodes('//globalFiltersInfoList') GFI ( GGF )
        CROSS APPLY GGF.nodes('./globalFilters') GF(globalFilters)
        OUTER APPLY globalFilters.nodes('./filters') F(filters)
	INSERT INTO #ExistingWinGlobalFilters
	SELECT REPLACE(_ID,'+1',' ') AS filter,0,1
	FROM dbo.SplitStringByDelimiter(
		ISNULL(
			(SELECT ACP.stringVal FROM App_ComponentProp ACP
WHERE ACP.propertyTypeId = 3620
				AND ACP.componentId = @clientGroupId AND ACP.modified = 0
			)
		,' '),' ')
	INSERT INTO #ExistingUnixGlobalFilters
	SELECT REPLACE(_ID,'+1',' ') AS filter,0,2
	FROM dbo.SplitStringByDelimiter(
		ISNULL(
			(SELECT ACP.stringVal FROM App_ComponentProp ACP
WHERE ACP.propertyTypeId = 3621
				AND ACP.componentId = @clientGroupId AND ACP.modified = 0
			)
		,' '),' ')
	-- If the request contains windows filters
	IF EXISTS(SELECT 1 FROM #ReqGlobalFilters WHERE OperatingSystemType = 1)
	BEGIN
		SET @opType = ISNULL((SELECT TOP 1 operationType FROM #ReqGlobalFilters WHERE OperatingSystemType = 1),0)
		IF @opType > 0
		BEGIN
			SET @finalString = N''
			UPDATE APP_COMPONENTPROP
			SET modified = @nowTime
WHERE propertyTypeId = 3620
			AND componentId = @clientGroupId
			AND modified = 0
		END
		--Overwrite
		IF @opType = 1
		BEGIN
			SELECT @finalString = COALESCE(@finalString+' ' , '') + REPLACE(filter,' ','+1')
				FROM #ReqGlobalfilters WHERE OperatingSystemType = 1
			IF @finalString <> ''
			BEGIN
				INSERT INTO APP_ComponentProp (componenttype, componentid, propertytypeid,datatype,longval,longlongval,stringval,created,modified)
VALUES (8, @clientGroupId,  3620,1,0,0,
					@finalString , @nowTime, 0)
			END
		END
		--Add
		ELSE IF @opType = 2
		BEGIN
			TRUNCATE TABLE #MergedList
			INSERT INTO #MergedList
			SELECT filter FROM #ReqGlobalFilters WHERE OperatingSystemType = 1
			UNION
			SELECT filter FROM #ExistingWinGlobalFilters
			SELECT @finalString = COALESCE(@finalString+' ' , '') + REPLACE(filter,' ','+1')
				FROM #MergedList
			IF @finalString <> ''
			BEGIN
				INSERT INTO APP_ComponentProp (componenttype, componentid, propertytypeid,datatype,longval,longlongval,stringval,created,modified)
VALUES (8, @clientGroupId,  3620,1,0,0,
					@finalString , @nowTime, 0)
			END
		END
		-- Delete
		ELSE IF @opType = 3
		BEGIN
			TRUNCATE TABLE #MergedList
			INSERT INTO #MergedList
			SELECT filter FROM #ExistingWinGlobalFilters
			EXCEPT
			SELECT filter FROM #ReqGlobalFilters WHERE OperatingSystemType = 1
			SELECT @finalString = COALESCE(@finalString+' ' , '') + REPLACE(filter,' ','+1')
				FROM #MergedList
			IF @finalString <> ''
			BEGIN
				INSERT INTO APP_ComponentProp (componenttype, componentid, propertytypeid,datatype,longval,longlongval,stringval,created,modified)
VALUES (8, @clientGroupId,  3620,1,0,0,
					@finalString , @nowTime, 0)
			END
		END
		-- Clear
		ELSE IF @opType = 4
		BEGIN
			IF @finalString <> ''
			BEGIN
				INSERT INTO APP_ComponentProp (componenttype, componentid, propertytypeid,datatype,longval,longlongval,stringval,created,modified)
VALUES (8, @clientGroupId,  3620,1,0,0,
					@finalString , @nowTime, 0)
			END
		END
	END
	-- If the request contains Unix filters
	IF EXISTS(SELECT 1 FROM #ReqGlobalFilters WHERE OperatingSystemType = 2)
	BEGIN
		SET @opType = ISNULL((SELECT TOP 1 operationType FROM #ReqGlobalFilters WHERE OperatingSystemType = 2),0)
		IF @opType > 0
		BEGIN
			SET @finalString = N''
			UPDATE APP_COMPONENTPROP
			SET modified = @nowTime
WHERE propertyTypeId = 3621
			AND componentId = @clientGroupId
			AND modified = 0
		END
		--Overwrite
		IF @opType = 1
		BEGIN
			SELECT @finalString = COALESCE(@finalString+' ' , '') + REPLACE(filter,' ','+1')
				FROM #ReqGlobalfilters WHERE OperatingSystemType = 2
			IF @finalString <> ''
			BEGIN
				INSERT INTO APP_ComponentProp (componenttype, componentid, propertytypeid,datatype,longval,longlongval,stringval,created,modified)
VALUES (8, @clientGroupId,  3621,1,0,0,
					@finalString , @nowTime, 0)
			END
		END
		--Add
		ELSE IF @opType = 2
		BEGIN
			TRUNCATE TABLE #MergedList
			INSERT INTO #MergedList
			SELECT filter FROM #ReqGlobalFilters WHERE OperatingSystemType = 2
			UNION
			SELECT filter FROM #ExistingUnixGlobalFilters
			SELECT @finalString = COALESCE(@finalString+' ' , '') + REPLACE(filter,' ','+1')
				FROM #MergedList
			IF @finalString <> ''
			BEGIN
				INSERT INTO APP_ComponentProp (componenttype, componentid, propertytypeid,datatype,longval,longlongval,stringval,created,modified)
VALUES (8, @clientGroupId,  3621,1,0,0,
					@finalString , @nowTime, 0)
			END
		END
		-- Delete
		ELSE IF @opType = 3
		BEGIN
			TRUNCATE TABLE #MergedList
			INSERT INTO #MergedList
			SELECT filter FROM #ExistingWinGlobalFilters
			EXCEPT
			SELECT filter FROM #ReqGlobalFilters WHERE OperatingSystemType = 2
			SELECT @finalString = COALESCE(@finalString+' ' , '') + REPLACE(filter,' ','+1')
				FROM #MergedList
			IF @finalString <> ''
			BEGIN
				INSERT INTO APP_ComponentProp (componenttype, componentid, propertytypeid,datatype,longval,longlongval,stringval,created,modified)
VALUES (8, @clientGroupId,  3621,1,0,0,
					@finalString , @nowTime, 0)
			END
		END
		-- Clear
		ELSE IF @opType = 4
		BEGIN
			IF @finalString <> ''
			BEGIN
				INSERT INTO APP_ComponentProp (componenttype, componentid, propertytypeid,datatype,longval,longlongval,stringval,created,modified)
VALUES (8, @clientGroupId,  3621,1,0,0,
					@finalString , @nowTime, 0)
			END
		END
	END
	ENDSP:
	IF @errorString = N''
	BEGIN
		SET @errorString =(SELECT Message
						from EvLocaleMsgs
						where EvLocaleMsgs.MessageId = @errorCode
						AND [localeId] = @localeId)
	END
	SET @o_errorCode = @errorCode
	SET @o_errorString = @errorString
	IF @getPropertiesForAudit = 1
	BEGIN
		DELETE FROM @getGlobalFilters
		INSERT INTO @getGlobalFilters
		EXEC AppGetCompanyGlobalFilter @clientGroupId, 28, 0
		IF EXISTS(SELECT 1 FROM @getGlobalFilters)
		BEGIN
			SELECT TOP 1 @errorCode=errCode, @errorString = errMsg, @o_afterUpdateXML= filterXML FROM @getGlobalFilters
		END
	END
	IF @getPropertiesForAudit = 1 OR @selectOutput = 1
	BEGIN
		SELECT @errorCode as errorCode,@errorString as errorString, @o_beforeUpdateXML AS beforeUpdateXML, @o_afterUpdateXML AS afterUpdateXML
	END
	IF object_id('tempdb.dbo.#ReqGlobalfilters') IS NOT null DROP TABLE #ReqGlobalfilters
	IF object_id('tempdb.dbo.#ExistingWinGlobalFilters') IS NOT null DROP TABLE #ExistingWinGlobalFilters
	IF object_id('tempdb.dbo.#ExistingUnixGlobalFilters') IS NOT null DROP TABLE #ExistingUnixGlobalFilters
	IF object_id('tempdb.dbo.#MergedList') IS NOT null DROP TABLE #MergedList
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetClientGroupGlobalFilters')
	delete from GxQscripts where name = 'AppSetClientGroupGlobalFilters'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetClientGroupGlobalFilters')
	delete from GXDBVersions where aliasname = 'AppSetClientGroupGlobalFilters'
GO

insert into GXDBVersions values(2, 'AppSetClientGroupGlobalFilters',  '00000000000000000000', 'AppSetClientGroupGlobalFilters', '00000000000000000000')
GO

