

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetCSFailoverConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppSetCSFailoverConfig')
BEGIN
	print '>>> Drop Stored Procedure: AppSetCSFailoverConfig <<<'
	drop procedure AppSetCSFailoverConfig
END
IF EXISTS (select * from GxQscripts where name='AppSetCSFailoverConfig')
	delete from GxQscripts where name = 'AppSetCSFailoverConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCSFailoverConfig')
	delete from GXDBVersions where aliasname = 'AppSetCSFailoverConfig'
GO
print '... Creating Procedure: AppSetCSFailoverConfig'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppSetCSFailoverConfig
  @i_xmlString XML
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
BEGIN
begin try
	-- Output xml string.
	DECLARE	@o_xmlString	XML
	-- Error handlers.
	DECLARE	@errorCode		INT = 0
	DECLARE	@errorString	NVARCHAR(1024) = N''
	DECLARE @userId			INT = 0
	DECLARE @isAdminUser	INT = 0
	DECLARE @sendAlertInfo	INT = 0
	DECLARE @i_localeId int = 0
	DECLARE @nowTime	int = dbo.getunixtime(getutcdate())
	DECLARE @networkInfo nvarchar(max) = ''
	DECLARE @failoverScheduleDetails xml = null
	DECLARE @workTokenId int = 43 -- WORK_TOKEN_REFRESH_FAILOVER_CONFIG
	DECLARE @cvFailoverConfigStatus INT
	DECLARE @oldCvFailoverConfigStatus INT = -1
	DECLARE @isAutomaticFailoverEnabled INT
	DECLARE @oldIsAutomaticFailoverEnabled INT
	DECLARE @monitoringClientGrpId INT = 0
	DECLARE @isAutoScaleEnabled INT
	DECLARE @monitoringGrpChanged INT = 0
	DECLARE @activeNodeSysConfig NVARCHAR(MAX) = ''
	-- Reading from xml.
	-- First get whether we need to send miscSettings from Gxglobalparam
	SET @i_localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS Agent
      FROM    @i_xmlString.nodes('App_SetMonitoredNodesFailoverReq/processinginstructioninfo/locale') R ( ref )),0)
	SET @userId = ISNULL (( SELECT ref.value('@userId', 'INT')
              FROM @i_xmlString.nodes('App_SetMonitoredNodesFailoverReq/processinginstructioninfo/user') R(ref)), 0)
	SELECT @cvFailoverConfigStatus = ref.value('@configStatus', 'INT')
	FROM @i_xmlString.nodes('App_SetMonitoredNodesFailoverReq/csFailoverConfigInfo') R(ref)
	SELECT @isAutomaticFailoverEnabled = ref.value('@isAutomaticFailoverEnabled', 'INT'),
		   @isAutoScaleEnabled	 = ref.value('@isAutoScaleEnabled', 'INT')
	FROM @i_xmlString.nodes('App_SetMonitoredNodesFailoverReq/csFailoverConfigInfo') R(ref)
	-- check whether user has administrative management at CS level.Else dont return these details.
EXEC sec_checkPermissionOnEntity @userId, 1, @isAdminUser OUT,1,2
	IF(@isAdminUser = 0)
	BEGIN
		SET @errorCode  = 1
SET @errorString = ( SELECT message FROM EvLocaleMsgs WITH(nolock) WHERE messageId = (2034 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @i_localeId )
		GOTO ERROR_EXIT
	END
	-- First check whether alert settings are there. If so, set them into GxGlobalParam
	DECLARE @monitoringInterval int = NULL
	DECLARE @criticalFailOverStrikeCount int = NULL -- default to 1 day
	DECLARE @failOverType int = NULL -- default to manual failover
	DECLARE @testFailoverClientGroup INT = NULL
	DECLARE @testFailoverProxyGroup INT = NULL
	DECLARE @floatingCSHostName INT = NULL
	select @monitoringInterval = ref.value('@monitoringInterval', 'int'),
		@criticalFailOverStrikeCount = ref.value('@criticalFailOverStrikeCount', 'int'),
		@failOverType = ref.value('@failOverType', 'int'),
		@floatingCSHostName = ref.value('@floatingCommserveHostName', 'int'),
		@testFailoverClientGroup = ref.value('(testFailoverClientGroup/@clientGroupId)[1]', 'int'),
		@testFailoverProxyGroup = ref.value('(testFailoverProxyGroup/@clientGroupId)[1]', 'int')
		FROM @i_xmlString.nodes('App_SetMonitoredNodesFailoverReq/csFailoverConfigInfo/miscSettings') R(ref)
	if @monitoringInterval is not null
	begin
		Update GxGlobalParam
		set value=@monitoringInterval
where name='CSMonitoringInterval'
		and modified=0
	end
	if @criticalFailOverStrikeCount is not null
	begin
		Update GxGlobalParam
		set value=@criticalFailOverStrikeCount
where name='CSCriticalFailOverTimeOutCount'
		and modified=0
	end
	if @failOverType is not null
	begin
		Update GxGlobalParam
		set value=@failOverType
where name='CSFailoverType'
		and modified=0
	end
	IF @floatingCSHostName IS NOT NULL
	begin
if exists(select 1 from GxGlobalParam where name='nCvFailoverFloatingHostName' and modified=0)
		begin
			Update GxGlobalParam
			set value=@floatingCSHostName
where name='nCvFailoverFloatingHostName'
			and modified=0
		end
		else
		begin
			Insert into GxGlobalParam(name,value,created,modified)
select 'nCvFailoverFloatingHostName', @floatingCSHostName, @nowTime, 0
		end
	end
SELECT @oldCvFailoverConfigStatus = value FROM GxGlobalParam WHERE name='nCSFailoverConfigStatus' and modified=0
	IF @cvFailoverConfigStatus IS NOT NULL
	BEGIN
		if @oldCvFailoverConfigStatus <> -1
		BEGIN
			UPDATE GxGlobalParam
			SET value=@cvFailoverConfigStatus
WHERE name='nCSFailoverConfigStatus'
			AND modified=0
		END
		ELSE
		BEGIN
			INSERT INTO GxGlobalParam(name,value,created,modified)
SELECT 'nCSFailoverConfigStatus', @cvFailoverConfigStatus, @nowTime, 0
		END
	END
SELECT @oldIsAutomaticFailoverEnabled = value FROM GxGlobalParam WHERE name = 'nCSAutoFailoverConfigStatus' and modified = 0
	IF @isAutomaticFailoverEnabled IS NOT NULL
	BEGIN
		IF @oldIsAutomaticFailoverEnabled IS NOT NULL
		BEGIN
			UPDATE GxGlobalParam
			SET value = @isAutomaticFailoverEnabled
WHERE name = 'nCSAutoFailoverConfigStatus'
			AND modified = 0
		END
		ELSE
		BEGIN
			INSERT INTO GxGlobalParam(name,value,created,modified)
SELECT 'nCSAutoFailoverConfigStatus', @isAutomaticFailoverEnabled, @nowTime, 0
		END
	END
	ELSE
	-- In case of delete of monitoring node request, we are not setting the enable/disable option so get it from db and use it.
	IF @oldIsAutomaticFailoverEnabled IS NOT NULL
	BEGIN
		SET @isAutomaticFailoverEnabled = @oldIsAutomaticFailoverEnabled
	END
	DECLARE @hypervisorClientId INT = 0
	DECLARE @oldHypervisorClientId INT = 0
	DECLARE @oldIsAutoScaleEnabled INT = 0
SELECT @oldIsAutoScaleEnabled = value FROM GxGlobalParam WHERE name = 'nCSFailoverAutoScaleConfigStatus' and modified = 0
SELECT @oldHypervisorClientId = value FROM GxGlobalParam WHERE name = 'nCSFailoverHyperVisorClientId' and modified = 0
	IF @isAutoScaleEnabled IS NOT NULL
	BEGIN
		IF @oldIsAutoScaleEnabled IS NOT NULL
		BEGIN
			UPDATE GxGlobalParam
			SET value = @isAutoScaleEnabled
WHERE name = 'nCSFailoverAutoScaleConfigStatus'
			AND modified = 0
		END
		ELSE
		BEGIN
			INSERT INTO GxGlobalParam(name,value,created,modified)
SELECT 'nCSFailoverAutoScaleConfigStatus', @isAutoScaleEnabled, @nowTime, 0
		END
		SELECT @hypervisorClientId = ref.value('(selectedHyperVisorClient/@clientId)[1]', 'INT')
		FROM @i_xmlString.nodes('App_SetMonitoredNodesFailoverReq/csFailoverConfigInfo') R(ref)
		IF @hypervisorClientId IS NOT NULL
		BEGIN
			IF @oldHypervisorClientId IS NOT NULL
			BEGIN
				UPDATE GxGlobalParam
				SET value = @hypervisorClientId
WHERE name = 'nCSFailoverHyperVisorClientId'
				AND modified = 0
			END
			ELSE
			BEGIN
				INSERT INTO GxGlobalParam(name,value,created,modified)
SELECT 'nCSFailoverHyperVisorClientId', @hypervisorClientId, @nowTime, 0
			END
			IF @hypervisorClientId != @oldHypervisorClientId
			BEGIN
				-- Set the failover nodes group as proxy client group.
				DECLARE @memberServersStr NVARCHAR(MAX)
				DECLARE @clientGrpXml XML
				DECLARE @verTag NVARCHAR(1024)
				DECLARE @index INT
				DECLARE @memberServersXml XML
				SET @memberServersStr = ISNULL(
				(
					SELECT A.attrVal
					FROM APP_InstanceProp A
						INNER JOIN APP_Application B ON A.componentNameId = B.instance
WHERE B.appTypeId = 106 AND B.clientId = @hypervisorClientId
						AND A.attrName = 'Vs Member Servers' AND A.modified = 0
				), '')
				SET @memberServersXml =  CAST(@memberServersStr AS XML)
				IF OBJECT_ID('tempdb..#memberServers') IS NOT NULL
					DROP TABLE #memberServers
				CREATE TABLE #memberServers
				(
				_type_ INT,
				clientGroupId INT,
				clientGroupName NVARCHAR(1024)
				)
				INSERT INTO #memberServers
				SELECT
				doc.col.value('@_type_', 'INT'),
				doc.col.value('@clientGroupId', 'INT'),
				doc.col.value('@clientGroupName', 'NVARCHAR(1024)')
				FROM @memberServersXml.nodes('/App_MemberServers/memberServers/client') doc(col)
WHERE doc.col.value('@_type_', 'INT') = 28
				SET @clientGrpXml = ISNULL(
				 (
SELECT  28 as 'client/@_type_',
							id as 'client/@clientGroupId',
							name as 'client/@clientGroupName'
					FROM APP_ClientGroup A
					WHERE name LIKE 'Proxy Clients for Failover'
					AND NOT EXISTS (SELECT 1 FROM #memberServers B WHERE B.clientGroupId = A.id)
					FOR xml PATH ('memberServers')
				 ),  '')
				SET @index = PATINDEX ('%?>%', @memberServersStr)
				SET @verTag = SUBSTRING(@memberServersStr, 0, @index + 2)
				SET @memberServersXml.modify('
				insert sql:variable("@clientGrpXml")
				into (/App_MemberServers)[1] ')
				SET @memberServersStr = @verTag + CAST(@memberServersXml AS NVARCHAR(MAX))
				UPDATE APP_InstanceProp
				SET attrVal = @memberServersStr
				FROM APP_InstanceProp A
				INNER JOIN APP_Application B ON A.componentNameId = B.instance
WHERE B.appTypeId = 106 AND B.clientId = @hypervisorClientId
					AND A.attrName = 'Vs Member Servers' AND A.modified = 0
			END
		END
		ELSE
		IF @oldHypervisorClientId IS NOT NULL
		BEGIN
			SET @hypervisorClientId = @oldHypervisorClientId
		END
	END
	ELSE
	IF @oldIsAutoScaleEnabled IS NOT NULL
	BEGIN
		SET @isAutoScaleEnabled = @oldIsAutoScaleEnabled
	END
	IF @isAutoScaleEnabled > 0
	BEGIN
		-- Update active node HW config.
		SELECT @activeNodeSysConfig = CONVERT(NVARCHAR(MAX), ref.query('activeNodeSysConfig'))
		FROM @i_xmlString.nodes('App_SetMonitoredNodesFailoverReq/csFailoverConfigInfo') R(ref)
		IF @activeNodeSysConfig IS NOT NULL
		BEGIN
IF EXISTS(SELECT 1 FROM GxGlobalParam WHERE name = 'CSFailoverActiveNodeHwConfig' AND modified = 0)
			BEGIN
				UPDATE GxGlobalParam
				SET value = @activeNodeSysConfig
WHERE name = 'CSFailoverActiveNodeHwConfig'
				AND modified = 0
			END
			ELSE
			BEGIN
				INSERT INTO GxGlobalParam(name,value,created,modified)
SELECT 'CSFailoverActiveNodeHwConfig', @activeNodeSysConfig, @nowTime, 0
			END
		END
	END
	-- Update networkinfo and failover schedule info
	select @networkInfo = convert(nvarchar(max), ref.query('networkInfo')),
		@failoverScheduleDetails = ref.query('failoverScheduleDetails')
		FROM @i_xmlString.nodes('App_SetMonitoredNodesFailoverReq/csFailoverConfigInfo') R(ref)
	if @networkInfo is not null
	begin
if exists(select 1 from GxGlobalParam where name='CSFailoverNetworkConnectivity' and modified=0)
		begin
			Update GxGlobalParam
			set value=@networkInfo
where name='CSFailoverNetworkConnectivity'
			and modified=0
		end
		else
		begin
			Insert into GxGlobalParam(name,value,created,modified)
select 'CSFailoverNetworkConnectivity', @networkInfo, @nowTime, 0
		end
	end
	if @testFailoverClientGroup is not null
	begin
if exists(select 1 from GxGlobalParam where name='CSTestFailoverClientGroup' and modified=0)
		begin
			Update GxGlobalParam
			set value=@testFailoverClientGroup
where name='CSTestFailoverClientGroup'
			and modified=0
		end
		else
		begin
			Insert into GxGlobalParam(name,value,created,modified)
select 'CSTestFailoverClientGroup', @testFailoverClientGroup, @nowTime, 0
		end
	end
	if @testFailoverProxyGroup is not null
	begin
if exists(select 1 from GxGlobalParam where name='CSTestFailoverProxyClientGroup' and modified=0)
		begin
			Update GxGlobalParam
			set value=@testFailoverProxyGroup
where name='CSTestFailoverProxyClientGroup'
			and modified=0
		end
		else
		begin
			Insert into GxGlobalParam(name,value,created,modified)
select 'CSTestFailoverProxyClientGroup', @testFailoverProxyGroup, @nowTime, 0
		end
	end
	if @failoverScheduleDetails is not null
	begin
		-- Update the schedule pattern to use updated freq_subday_interval
		declare @freqIntervalForTLLogGUI int = 900
		declare @freqIntervalForTLLogDB  int = 0
		declare @patternForTLSchedDB int = 0
		select @freqIntervalForTLLogGUI = @failoverScheduleDetails.value('(failoverScheduleDetails/@liveSyncRPO)[1]','int')
		set @freqIntervalForTLLogGUI = @freqIntervalForTLLogGUI*60
		select @patternForTLSchedDB = TM_pattern.patternId from TM_pattern inner join TM_Patternassoc on
		TM_Patternassoc.patternId = TM_pattern.patternId inner join TM_Subtask
		on TM_Patternassoc.subTaskId = TM_subtask.subtaskId
inner join TM_Task on TM_Subtask.taskId = TM_task.taskId and TM_task.deleted=0 and (TM_Subtask.flags & 0x80000)>0
		select @freqIntervalForTLLogDB = TM_pattern.freq_subday_interval from TM_Pattern where patternId=@patternForTLSchedDB
		if (@freqIntervalForTLLogDB <> @freqIntervalForTLLogGUI)
		begin
			Update TM_pattern
			set freq_subday_interval = 	@freqIntervalForTLLogGUI
			where patternID = @patternForTLSchedDB
			-- pattern changed. So delete all associations like we do from C# code. So that next run time is recompouted.
			delete TM_RunTime where patternId = @patternForTLSchedDB
		end
if exists(select 1 from GxGlobalParam where name='CSFailoverRecoveryMode' and modified=0)
		begin
			Update GxGlobalParam
			set value=convert(nvarchar(max),@failoverScheduleDetails)
where name='CSFailoverRecoveryMode'
			and modified=0
		end
		else
		begin
			Insert into GxGlobalParam(name,value,created,modified)
select 'CSFailoverRecoveryMode', convert(nvarchar(max),@failoverScheduleDetails), @nowTime, 0
		end
	end
SET @monitoringClientGrpId = ISNULL((SELECT id FROM APP_ClientGroup WHERE name = 'Monitoring Clients'), 0)
	--Look at selected clients list and do push install if needed.
	IF object_id('tempdb.dbo.#CLIST_GUI') IS NOT Null DROP TABLE #CLIST_GUI
	CREATE TABLE #CLIST_GUI
	(
		clientId int primary key(clientId)
	)
	IF object_id('tempdb.dbo.#CLIST_DB') IS NOT Null DROP TABLE #CLIST_DB
	CREATE TABLE #CLIST_DB
	(
		clientId int primary key(clientId)
	)
	Insert into #CLIST_DB
SELECT distinct PKG.ClientId clientId from SimInstalledPackages PKG WHERE PKG.SimpackageId = 725
	except
	select componentNameId from app_clientprop where attrname = N'CS Failover Monitoring' and attrVal = N'0'
	-- Set client prop attribute for all clients irrespective of whether package is installed or not.
	Insert into #CLIST_GUI
	select ref.value('@clientId', 'int')
		FROM @i_xmlString.nodes('App_SetMonitoredNodesFailoverReq/csFailoverConfigInfo/monitoringClients/selectedClients') R(ref)
	-- Do all processing if atleast one entry is sent from GUI.
	if exists(select 1 from #CLIST_GUI)
	begin
		-- Compare GUI and DB... First handle case entities removed now. Only need to set property value for case when client isnt selected. Because by default, client is selected.
		Update App_clientProp
		set attrval='0', created = @nowTime
		from App_clientProp inner join (
			select clientId from #CLIST_DB
			except
			select clientId from #CLIST_GUI
		) t on
		t.clientId = App_clientProp.componentnameId
		and App_clientProp.attrname = N'CS Failover Monitoring'
		and modified=0
		INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
		select t.clientId, 'CS Failover Monitoring', 7,'0', @nowTime, 0,0
		from
		(
			select clientId from #CLIST_DB
			except
			(
				select clientId from #CLIST_GUI
				union
				select componentnameId from App_clientprop
				where attrname = N'CS Failover Monitoring'
				and modified=0
			)
		) t
		Update App_clientProp
		set attrval='1', created = @nowTime
		from App_clientProp inner join
		(
			select clientId from #CLIST_GUI
			except
			select clientId from #CLIST_DB
		) t on
		t.clientId = App_clientProp.componentnameId
		and App_clientProp.attrname = N'CS Failover Monitoring'
		and modified=0
	end
	IF @isAutomaticFailoverEnabled > 0
	BEGIN
		DELETE #CLIST_GUI
		Insert into #CLIST_GUI
		select ref.value('@clientId', 'int')
			FROM @i_xmlString.nodes('App_SetMonitoredNodesFailoverReq/csFailoverConfigInfo/monitoringNodes/selectedClients/node') R(ref)
		-- After disabling the auto failover option, user re-enabling it, so we should return the last selection, we should not mark them as deleted.
		IF EXISTS (SELECT 1 FROM #CLIST_GUI)
		BEGIN
			-- some of the clients got removed from monitoring.
			UPDATE APP_ClientProp
			SET attrval = '0', modified = @nowTime
			FROM APP_ClientProp A
WHERE A.attrName = 'CSLiveSync Monitoring Client' AND A.attrVal = '1' AND A.modified = 0
			AND NOT EXISTS (SELECT 1 FROM #CLIST_GUI B WHERE B.clientId = A.componentNameId)
			-- some new clients added for monitoring.
			INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
SELECT A.clientId, 'CSLiveSync Monitoring Client', 7,'1', @nowTime, 0,0
			FROM #CLIST_GUI A
			WHERE NOT EXISTS (SELECT 1 FROM APP_ClientProp B
WHERE B.componentNameId = A.clientId AND B.attrName = N'CSLiveSync Monitoring Client' AND B.attrVal = N'1' AND B.modified = 0)
			IF @monitoringClientGrpId > 0
			BEGIN
				-- Delete the clients from Monitoring group if removed from monitoring.
				DELETE APP_ClientGroupAssoc
				FROM APP_ClientGroupAssoc A
				WHERE A.clientGroupId = @monitoringClientGrpId
					AND NOT EXISTS (SELECT 1 FROM #CLIST_GUI B WHERE B.clientId = A.clientId)
				IF @@ROWCOUNT > 0
					SET @monitoringGrpChanged = 1
				-- Insert the newly added monitoring clients to this group.
				INSERT APP_ClientGroupAssoc(clientGroupId, clientId)
				SELECT @monitoringClientGrpId, A.clientId
				FROM #CLIST_GUI A
				WHERE NOT EXISTS (SELECT 1 FROM APP_ClientGroupAssoc B WHERE B.clientGroupId = @monitoringClientGrpId AND B.clientId = A.clientId)
				IF @@ROWCOUNT > 0
					SET @monitoringGrpChanged = 1
			END
		END
		ELSE
		BEGIN
			IF OBJECT_ID('TEMPDB..#FilteredClientList') IS NOT NULL
				DROP TABLE #FilteredClientList
			CREATE TABLE #FilteredClientList(clientId INT Primary Key(clientId))
			INSERT INTO #FilteredClientList
			SELECT id FROM App_Client
			WHERE id > 1
AND (status & 0x00002) = 0
				AND csHostName <> ''
AND specialClientFlags & (CAST(0x20 AS INT) | CAST(0x200 AS INT)) = 0
			-- Filter out CommServ clients, Failover clients.
			DELETE T FROM #FilteredClientList T
WHERE EXISTS (SELECT 1 FROM SimInstalledPackages A WHERE T.clientId = A.clientId AND A.SimpackageId IN ( 1020, 20, 24, 1024))
			-- Filter out any pseudo clients, they do not have packags.
			DELETE T FROM #FilteredClientList T
			WHERE NOT EXISTS (SELECT 1 FROM SimInstalledPackages A WHERE T.clientId = A.clientId)
			-- Filter out Index server clients.
			DELETE T FROM #FilteredClientList T
WHERE EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentNameId = T.clientId AND attrName = N'Index Server Type'  AND CAST(attrVal AS INT) = 15 AND modified = 0)
			-- Filter out Cluster clients.
			DELETE T FROM #FilteredClientList T
			WHERE EXISTS(SELECT 1 FROM APP_VMToPMMap WHERE VMClientId = T.clientId OR PMClientId = T.clientId)
			-- Filter out Un supported OS types.
			DELETE T
			FROM #FilteredClientList T INNER JOIN APP_Client C ON T.clientId = C.id
			WHERE NOT EXISTS(SELECT 1 FROM simOperatingSystem A WHERE A.id = C.simOperatingSystemId AND ((A.SubType = 'Linux' AND A.PlatformType = 'X64') OR (A.Type = 'Windows' AND A.PlatformType = 'X64')))
			-- When there are no monitoring nodes selected, then by default select some nodes.
IF NOT EXISTS (SELECT 1 FROM App_ClientProp WHERE attrName = N'CSLiveSync Monitoring Client' AND attrVal = N'1' AND modified = 0)
			BEGIN
				INSERT APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
SELECT TOP 7 A.id, 'CSLiveSync Monitoring Client', 7,'1', @nowTime, 0,0
				FROM APP_Client A INNER JOIN #FilteredClientList B ON A.id = B.clientId
INNER JOIN simInstalledPackages C ON C.clientId = B.clientId AND C.simPackageID IN (725, 1157)
				ORDER BY
				CASE WHEN EXISTS (SELECT 1 FROM MMHost B WHERE A.id = B.ClientId ) THEN 1 ELSE 0 END DESC,
				A.id DESC
				IF @monitoringClientGrpId > 0
				BEGIN
					-- Insert the newly added monitoring clients to this group.
					INSERT APP_ClientGroupAssoc(clientGroupId, clientId)
					SELECT @monitoringClientGrpId, A.componentNameId
					FROM App_ClientProp A
WHERE A.attrName = N'CSLiveSync Monitoring Client'
						AND A.attrVal = N'1'
						AND A.modified = 0
						AND NOT EXISTS (SELECT 1 FROM APP_ClientGroupAssoc B WHERE B.clientGroupId = @monitoringClientGrpId AND B.clientId = A.componentNameId)
					IF @@ROWCOUNT > 0
						SET @monitoringGrpChanged = 1
				END
			END
		END
	END
	-- Now update VirtualApp for entries
	IF object_id('tempdb.dbo.#NodesInfo') IS NOT Null DROP TABLE #NodesInfo
	CREATE TABLE #NodesInfo
	(
		sourceClientId int,
		destinationClientId int,
		recoveryMode int,
		failoverNodeXml xml,
		vappxml xml,
		primary key (sourceClientId , destinationClientId)
	)
	Insert into #NodesInfo
	select  ref.value('(sourceEntity/@clientId)[1]', 'int'),
			ref.value('(destinationEntity/@clientId)[1]', 'int'),
			ref.value('@recoveryMode', 'int'),
			ref.query('.'), -- <Api_VirtualAppReq><vApp> </vApp></Api_VirtualAppReq>,
			ref.query('<Api_VirtualAppReq><vApp> { for $item in . return $item } </vApp></Api_VirtualAppReq>')
	FROM @i_xmlString.nodes('App_SetMonitoredNodesFailoverReq/csFailoverConfigInfo/failoverNodes') R(ref)
	-- Update recovery mode property for client properties
	Update App_clientprop
	set attrval = convert(nvarchar(10),NodesInfo.recoveryMode),
		created = @nowTime
	from App_clientprop
	inner join #NodesInfo NodesInfo
	on NodesInfo.destinationClientId = App_clientprop.componentnameId
	and attrname = N'Failover RecoveryType' --CV_PROP_FAILOVER_RECOVERYTYPE
	and attrval <> convert(nvarchar(10),NodesInfo.recoveryMode)
	and NodesInfo.recoveryMode is not null AND modified = 0
	insert into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
	select NodesInfo.destinationClientId, 'Failover RecoveryType',7, convert(nvarchar(10),NodesInfo.recoveryMode),@nowTime,0
	from #NodesInfo NodesInfo
	left join App_clientprop on NodesInfo.destinationClientId = App_clientprop.componentnameId
	and attrname = N'Failover RecoveryType' --CV_PROP_FAILOVER_RECOVERYTYPE
	where App_clientprop.componentnameId is null
	and NodesInfo.recoveryMode is not null AND modified = 0
	update failoverNodesInfo
	set vappxml = vxml -- .modify('replace value of (Api_VirtualAppReq/vApp/failoverNodes)[1] with sql:column("failoverNodesInfo.failoverNodeXml") ')
	from #NodesInfo failoverNodesInfo
	inner join App_virtualapp  on
	App_virtualapp.operationType=128 --VAppOperation::CSFailover
	and App_virtualapp.vxml.value('(Api_VirtualAppReq/vApp/failoverNodes/sourceEntity/@clientId)[1]','int')= failoverNodesInfo.sourceClientID
	and App_virtualapp.vxml.value('(Api_VirtualAppReq/vApp/failoverNodes/destinationEntity/@clientId)[1]','int')= failoverNodesInfo.destinationclientID
	update failoverNodesInfo
	set vappxml.modify('insert sql:column("failoverNodeXml") as last into (Api_VirtualAppReq/vApp)[1]')
	from #NodesInfo failoverNodesInfo
	update failoverNodesInfo
	set vappxml.modify('delete (Api_VirtualAppReq/vApp/failoverNodes)[1] ')
	from #NodesInfo failoverNodesInfo
	update App_virtualApp
	set vxml = failoverNodesInfo.vappxml
	from App_virtualapp
	inner join #NodesInfo failoverNodesInfo on
	App_virtualapp.operationType=128 --VAppOperation::CSFailover
	and App_virtualapp.vxml.value('(Api_VirtualAppReq/vApp/failoverNodes/sourceEntity/@clientId)[1]','int')= failoverNodesInfo.sourceClientID
	and App_virtualapp.vxml.value('(Api_VirtualAppReq/vApp/failoverNodes/destinationEntity/@clientId)[1]','int')= failoverNodesInfo.destinationclientID
	-- Insert rows for new configurations
	Insert into App_VirtualApp
	select 'Failover_config_Client_'+convert(nvarchar(max),failoverNodesInfo.sourceClientID)+'_'+ convert(nvarchar(max),failoverNodesInfo.destinationclientID),
		128,'Failover config created for storing live sync configuration',vappxml,@userId,@nowTime,0,0,1
	from #NodesInfo failoverNodesInfo left join App_virtualapp on
	App_virtualapp.operationType=128 --VAppOperation::CSFailover
	and App_virtualapp.vxml.value('(Api_VirtualAppReq/vApp/failoverNodes/sourceEntity/@clientId)[1]','int')= failoverNodesInfo.sourceClientID
	and App_virtualapp.vxml.value('(Api_VirtualAppReq/vApp/failoverNodes/destinationEntity/@clientId)[1]','int')= failoverNodesInfo.destinationclientID
	where App_virtualapp.operationType is null
	-- Update retention settings on Cvfailoverlogshipping subclient
	DECLARE @LogShippingSubclientId int = 0
	SELECT @LogShippingSubclientId = LogShippingSubclientId FROM CvFailoverLogShippingScInfo WITH (NOLOCK)
	DECLARE @DisableRetentionOverride int = 0
SELECT @DisableRetentionOverride = value FROM GxGlobalParam(NOLOCK) WHERE name='nCSFailoverDisableLiveSyncRetentionOveride'
	IF (@LogShippingSubclientId>0)
	BEGIN
		IF @DisableRetentionOverride = 1
		BEGIN
			DELETE FROM APP_SubClientProp
			WHERE attrName = 'Override storage policy copy retention'
			AND componentNameId = @LogShippingSubclientId
			AND modified = 0
			AND cs_attrname = CHECKSUM(N'Override storage policy copy retention')
			DELETE FROM archAppCopyAgingRule
			WHERE appId = @LogShippingSubclientId
		END
		ELSE
		BEGIN
			DECLARE @retentionXml XML = '<App_RetentionOverrideSettings>
				<copySettings retentionDays="14" fullCycles="2">
					<copy copyId="0"/>
				</copySettings>
			</App_RetentionOverrideSettings>'
			IF NOT EXISTS(SELECT 1 FROM APP_SubClientProp(NOLOCK)
					WHERE attrName = 'Override storage policy copy retention'
					AND componentNameId = @LogShippingSubclientId
					AND modified = 0
					AND cs_attrname = CHECKSUM(N'Override storage policy copy retention')
					) -- CV_PROP_OVERRIDE_COPY_RETENTION_TYPE
			INSERT INTO APP_SubClientProp
			VALUES (@LogShippingSubclientId, 'Override storage policy copy retention', 7, 2, @nowTime, 0, 0) -- CV_PROP_OVERRIDE_COPY_RETENTION_TYPE
			DECLARE @tempTableOutputOverrideCopySettings TABLE(Response XML,ErrorCode INT, ErrorMessage NVARCHAR(1024) )
			INSERT INTO @tempTableOutputOverrideCopySettings
			EXEC OverrideCopySettingsFromSC @LogShippingSubclientId,@retentionXml, 1
			SELECT @errorCode = ErrorCode, @errorString = ErrorMessage FROM @tempTableOutputOverrideCopySettings
		END
	END
	-- Creates alert for failover which notifies admin if replication isnt running to DR node and enables/disables alert depedening on the feature
	EXEC NTCreateDefaultAlertForFailover
	IF @errorCode = 0
	BEGIN
		-- Submit workqueue request to all failover and monitoring nodes to refresh config.
		DECLARE @monitoringNodeId INT
		DECLARE @workQOutPutTbl TABLE (errCode INT, errString NVARCHAR(MAX))
		DECLARE MonitoringNodes Cursor LOCAL For
		SELECT DISTINCT C.Id
		FROM SimInstalledPackages Pkg
INNER JOIN App_client C ON Pkg.clientId = C.Id AND (C.status & 0x00002) = 0
AND (simPackageID IN (24, 1024) OR
			EXISTS (SELECT 1 FROM APP_ClientProp B
					WHERE B.componentNameId = C.Id
AND B.attrName = N'CSLiveSync Monitoring Client'
					AND B.attrVal = N'1' AND B.modified = 0
					-- In case of automatic failover is disabled, we still have to send the work token.
					AND ( @isAutomaticFailoverEnabled = 1 OR @oldIsAutomaticFailoverEnabled = 1)
					)
				)
		OPEN MonitoringNodes
		FETCH NEXT FROM MonitoringNodes
		INTO @monitoringNodeId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			INSERT INTO @workQOutPutTbl
			EXEC AppWorkQueueSubmitRequest @workTokenId, 0, 0, @monitoringNodeId, 0, ''
			FETCH NEXT FROM MonitoringNodes
			INTO @monitoringNodeId
		END
		CLOSE MonitoringNodes
		DEALLOCATE MonitoringNodes
		-- Refresh the smart client groups to get the latest monitoring nodes.
		IF @monitoringGrpChanged > 0
		BEGIN
			DECLARE @InternalClientGroupId INT = 0
			DECLARE @ExternalClientGroupId INT = 0
			SET @InternalClientGroupId = ISNULL((SELECT id FROM APP_ClientGroup WHERE name = 'Internal Clients for failover clients topology'), 0)
			SET @ExternalClientGroupId = ISNULL((SELECT id FROM APP_ClientGroup WHERE name = 'External Clients for failover clients topology'), 0)
			SET @workTokenId = 58 	-- WORK_TOKEN_SCG_REFRESH_GROUP
			IF @InternalClientGroupId > 0
			BEGIN
				INSERT INTO APP_WorkQueueRequest (clientId, remoteClient, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag)
				SELECT
						2 						clientId,         -- CSId
						-1 						remoteClient,
						@workTokenId 			workToken,
						@InternalClientGroupId 	workTokenParams,
						@nowTime 				createTime,
						0 						lastUpdateTime,
						0 						retryCount,
						0 						flag
			END
			IF @ExternalClientGroupId > 0
			BEGIN
				INSERT INTO APP_WorkQueueRequest (clientId, remoteClient, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag)
				SELECT
						2 						clientId,         -- CSId
						-1 						remoteClient,
						@workTokenId 			workToken,
						@ExternalClientGroupId 	workTokenParams,
						@nowTime 				createTime,
						0 						lastUpdateTime,
						0 						retryCount,
						0 						flag
			END
			-- We don't need to push the network firewall config for the monitoring nodes explicitly since the trigger(APP_ClientGroupAssocTable) takes care of it.
			--
		END
	END
	-- Handle CS Live Sync auto connect group
	IF @oldCvFailoverConfigStatus <> @cvFailoverConfigStatus
		EXEC AppHandleCSLiveSyncAutoConnectGroup
END TRY
 BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
     set @errorCode = ERROR_NUMBER()
     set @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
 END CATCH
ERROR_EXIT:
	IF @errorCode <> 0
		SET @o_xmlString = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
							FOR XML PATH('App_GenericResp'), Type)
	IF @o_xmlString IS NULL
		SET @o_xmlString = '<App_GenericResp/>'
	SELECT @o_xmlString
	IF object_id('tempdb.dbo.#CLIST_GUI') IS NOT Null DROP TABLE #CLIST_GUI
	IF object_id('tempdb.dbo.#CLIST_DB') IS NOT Null DROP TABLE #CLIST_DB
	IF object_id('tempdb.dbo.#NodesInfo') IS NOT Null DROP TABLE #NodesInfo
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetCSFailoverConfig')
	delete from GxQscripts where name = 'AppSetCSFailoverConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCSFailoverConfig')
	delete from GXDBVersions where aliasname = 'AppSetCSFailoverConfig'
GO

insert into GXDBVersions values(2, 'AppSetCSFailoverConfig',  '00000000000000000000', 'AppSetCSFailoverConfig', '00000000000000000000')
GO

