

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetAuthorizeForRestoreOnEntity.sp] ---------- 

--  +=============================================================================================+
--  |						Name: AppSetAuthorizeForRestoreOnEntity()
--  | Description: Authorizes users for restore on provided entity
--  |
--  |       Input: XML
--  |      Output: errorCode, errorString
--  |      Author: sravanan
--  +=============================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetAuthorizeForRestoreOnEntity')
BEGIN
	print '>>> Drop Stored Procedure: AppSetAuthorizeForRestoreOnEntity <<<'
	drop procedure AppSetAuthorizeForRestoreOnEntity
END
IF EXISTS (select * from GxQscripts where name='AppSetAuthorizeForRestoreOnEntity')
	delete from GxQscripts where name = 'AppSetAuthorizeForRestoreOnEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetAuthorizeForRestoreOnEntity')
	delete from GXDBVersions where aliasname = 'AppSetAuthorizeForRestoreOnEntity'
GO
print '... Creating Procedure: AppSetAuthorizeForRestoreOnEntity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetAuthorizeForRestoreOnEntity
  @i_xmlText XML
AS
  DECLARE @errorCode INT = 0
  DECLARE @errorString NVARCHAR(max)
  DECLARE @entityId INT = 0
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	DECLARE @userId INT = 0
	DECLARE @localeId INT = 0
	DECLARE @entityType INT = 0
	DECLARE @passkey NVARCHAR(MAX) = ''
	DECLARE @time INT = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @passkeyInDB NVARCHAR(MAX) = ''
	DECLARE @isStrongPwd INT = 0
	DECLARE @psErrorCode int = 0
	DECLARE @psErrorString NVARCHAR(MAX) = ''
	DECLARE @enableRestoreAuth INT = 0
	DECLARE @authForRestoreDuration INT = 0
	DECLARE @authUsersStr NVARCHAR(MAX) = ''
	DECLARE @authUsersXML XML
	DECLARE @companyId INT = 0
	SET @errorCode = 0
	SET @errorString = N''
	SET @localeId = ISNULL(@i_xmlText.value('(//App_AuthorizeForRestoreRequest/processinginstructioninfo/locale/@localeId)[1]', 'int') , 0)
	SET @userId = ISNULL (( SELECT ref.value('@userId', 'INT')
							FROM @i_xmlText.nodes ('App_AuthorizeForRestoreRequest/processinginstructioninfo/user') R(ref)), 0)
	SET @entityType = ISNULL(@i_xmlText.value('(//App_AuthorizeForRestoreRequest/entity/@_type_)[1]', 'int') , 0)
	SET @passkey = ISNULL(@i_xmlText.value('(//App_AuthorizeForRestoreRequest/@passkey)[1]', 'nvarchar(max)') , '')
	SET @enableRestoreAuth = ISNULL(@i_xmlText.value('(//App_AuthorizeForRestoreRequest/passkeySettings/@enableAuthorizeForRestore)[1]', 'int') , 0)
	SET @authForRestoreDuration = ISNULL(@i_xmlText.value('(//App_AuthorizeForRestoreRequest/passkeySettings/passkeyExpirationInterval/@toTime)[1]', 'int') , 0)
	-- Passkey is required only to enable authorize for restore
	IF (@enableRestoreAuth = 1)
	BEGIN
		-- passkey extraction and validation
		-- Passkey is in base64encoded->V3encrypted format
		IF((CHARINDEX('|#',@passkey, 1)) >0 )
		BEGIN
			SET @passkey=(select dbo.DecodeInvalidXMLChar(@passkey))
			SET @passkey = SUBSTRING(@passkey,2,LEN(@passkey))
		END
		SET @passkey = dbo.base64Decode(@passkey)
	END
	-- Fetch clientId from SUBCLIENT_ENTITY or BACKUPSET_ENTITY
IF(@entityType = 7)
	BEGIN
		SET @entityId = ISNULL(@i_xmlText.value('(//App_AuthorizeForRestoreRequest/entity/@subclientId)[1]', 'int') , 0)
		SELECT @entityId = clientId FROM App_Application WITH(NOLOCK) WHERE id = @entityId
SET @entityType = 3
	END
ELSE IF(@entityType = 6)
	BEGIN
		SET @entityId = ISNULL(@i_xmlText.value('(//App_AuthorizeForRestoreRequest/entity/@backupsetId)[1]', 'int') , 0)
		SET @entityId = (SELECT TOP 1 clientId FROM App_Application WITH(NOLOCK) WHERE backupSet = @entityId)
SET @entityType = 3
	END
ELSE IF(@entityType = 3)
	BEGIN
		SET @entityId = ISNULL(@i_xmlText.value('(//App_AuthorizeForRestoreRequest/entity/@clientId)[1]', 'int') , 0)
SET @entityType = 3
	END
	ELSE
	BEGIN
		SET @entityId = ISNULL(@i_xmlText.value('(//App_AuthorizeForRestoreRequest/company/@providerId)[1]', 'int') , -1)
		IF @entityId = -1
		BEGIN
SET @errorCode = (451 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			GOTO PROC_EXIT
		END
		ELSE
		BEGIN
-- SET @entityType = (CASE WHEN @entityId = 0 THEN 1 ELSE 61 END)
SET @entityType = 61
		END
	END
	-- clientId should have been fetched by now
IF (@entityType = 3) -- authorizeforRestore is set at client entity level
	BEGIN
		-- If client has authType = '2', then compare passkey with clientprop table.
IF (EXISTS(SELECT 1 FROM App_ClientProp WITH(NOLOCK) WHERE componentNameId = @entityId AND attrName = 'AuthorizationType' AND modified = 0 AND attrVal = '2'))
		BEGIN
			-- When requesting authorizeForRestore, all we need is correct passkey. Any user with correct passkey can authorize for restore.
			IF(@enableRestoreAuth = 1)
			BEGIN
				-- validate the provided passkey with clientprop table
SELECT @passkeyInDB = attrVal FROM App_ClientProp WITH(NOLOCK) WHERE componentNameId = @entityId AND attrName = 'b687613983d698ff59a973adccd71da9d327dacd691e38386a7062ff9bdcf6b0' AND modified = 0
				IF (@passkeyInDB <> @passkey)
				BEGIN
SET @errorCode = (3968 | (CAST(POWER(2, 24) AS BIGINT) * 35))
					GOTO PROC_EXIT
				END
			END
		END
		ELSE
		BEGIN
SET @companyId = ISNULL((SELECT CASE ISNUMERIC(attrVal) WHEN 1 THEN CONVERT(INT, attrVal) ELSE 0 END FROM App_ClientProp WITH(NOLOCK) WHERE componentNameId = @entityId AND attrName = 'Installation Company ID' AND modified = 0), -1)
			-- Some clients could have 0 as their "Installation company ID" for reasons like MSP admin creds were used during installation, so we need to check smart client group info to get true company Id
			IF @companyId = -1 OR @companyId = 0
			BEGIN
				SET @companyId = ISNULL((SELECT TOP 1 ACP.componentNameId FROM APP_Client AC
											INNER JOIN APP_ClientGroupAssoc ACGA ON AC.id = ACGA.clientId
											INNER JOIN App_CompanyProp ACP ON ACP.attrValInt=ACGA.clientGroupId
AND ACP.attrName='Associated Smart Client Group' AND cs_attrName = checksum('Associated Smart Client Group') AND ACP.modified = 0
											WHERE AC.id = @entityId), 0)
			END
			--If client belongs to a company and attrVal = '2'(meaning passkey is set at company level) validate passkey with AppCompanyprop table
IF (EXISTS(SELECT 1 FROM App_CompanyProp WITH(NOLOCK) WHERE componentNameId = @companyId AND attrName = 'AuthorizationType'
AND modified=0 AND cs_attrName=checksum('AuthorizationType') AND attrVal = '2'))
			BEGIN
				-- When requesting authorizeForRestore, all we need is correct passkey. Any user with correct passkey can authorize for restore.
				IF(@enableRestoreAuth = 1)
				BEGIN
					-- validate the provided passkey
SELECT @passkeyInDB = attrVal FROM App_CompanyProp WITH(NOLOCK) WHERE componentNameId = @companyId AND attrName = 'b687613983d698ff59a973adccd71da9d327dacd691e38386a7062ff9bdcf6b0'
AND modified=0 AND cs_attrName=checksum('b687613983d698ff59a973adccd71da9d327dacd691e38386a7062ff9bdcf6b0')
					IF (@passkeyInDB <> @passkey)
					BEGIN
SET @errorCode = (3968 | (CAST(POWER(2, 24) AS BIGINT) * 35))
						GOTO PROC_EXIT
					END
				END
			END
			ELSE
			BEGIN
SET @errorCode = (1771 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				GOTO PROC_EXIT
			END
		END
SET @authUsersStr = ISNULL((SELECT attrVal FROM App_ClientProp WITH(NOLOCK) WHERE componentNameId = @entityId AND attrName = 'AuthorizedUsersForRestore' AND modified = 0 AND attrVal <> ''),
									'<App_AuthorizedUsersForRestore></App_AuthorizedUsersForRestore>')
		IF(@enableRestoreAuth = 1)
		BEGIN
			IF (@authForRestoreDuration = 0)
			BEGIN
				-- set default auth for restore duration to 30 min
				SET @authForRestoreDuration = 30 * 60
			END
			SET @authForRestoreDuration = @authForRestoreDuration + @time
			IF CHARINDEX('userId="'+CONVERT(nvarchar(10), @userId)+'"',@authUsersStr) > 0
			BEGIN
				SET @authUsersXML = CAST(@authUsersStr AS XML)
				SET @authUsersXML.modify('replace value of (/App_AuthorizedUsersForRestore/authorizedUsers/user[@userId=sql:variable("@userId")]/../@expirationTime)[1] with sql:variable("@authForRestoreDuration")')
				SET @authUsersStr = CAST(@authUsersXML AS NVARCHAR(MAX))
UPDATE App_clientProp SET attrVal = @authUsersStr WHERE componentNameId = @entityId AND attrName = 'AuthorizedUsersForRestore' AND modified = 0 AND attrVal <> @authUsersStr
				GOTO PROC_EXIT
			END
			ELSE
			BEGIN
				SET @authUsersStr = LEFT(@authUsersStr, LEN(@authUsersStr)-LEN('</App_AuthorizedUsersForRestore>'))
				SET @authUsersStr = @authUsersStr + '<authorizedUsers expirationTime="' + CONVERT(nvarchar(10), @authForRestoreDuration) + '"><user _type_="13" userId="' + CONVERT(nvarchar(10),@userId)
									+ '"/></authorizedUsers></App_AuthorizedUsersForRestore>'
IF EXISTS(SELECT 1 FROM App_ClientProp WITH(NOLOCK) WHERE componentNameId = @entityId AND attrName = 'AuthorizedUsersForRestore' AND modified = 0)
UPDATE App_clientProp SET attrVal = @authUsersStr WHERE componentNameId = @entityId AND attrName = 'AuthorizedUsersForRestore' AND modified = 0 AND attrVal <> @authUsersStr
				ELSE
INSERT INTO App_ClientProp(ComponentNameId, attrName, attrVal, attrType, created, modified, ccpId) values(@entityId, 'AuthorizedUsersForRestore', @authUsersStr, 1, @time, 0, 0)
				GOTO PROC_EXIT
			END
		END
		ELSE IF(@enableRestoreAuth = 0)
		BEGIN
			SET @authUsersXML = CAST(@authUsersStr AS XML)
			SET @authUsersXML.modify('replace value of (/App_AuthorizedUsersForRestore/authorizedUsers/user[@userId=sql:variable("@userId")]/../@expirationTime)[1] with 0')
			SET @authUsersStr = CAST(@authUsersXML AS NVARCHAR(MAX))
UPDATE App_clientProp SET attrVal = @authUsersStr WHERE componentNameId = @entityId AND attrName = 'AuthorizedUsersForRestore' AND modified = 0 AND attrVal <> @authUsersStr
			GOTO PROC_EXIT
		END
	END
ELSE IF (@entityType = 61) -- authorizeforRestore is set at company entity level
	BEGIN
		-- When requesting authorizeForRestore, all we need is correct passkey. Any user with correct passkey can authorize for restore.
SET @authUsersStr = ISNULL((SELECT attrVal FROM App_CompanyProp WITH(NOLOCK) WHERE componentNameId = @entityId AND attrName = 'AuthorizedUsersForRestore'
AND modified=0 AND cs_attrName=checksum('AuthorizedUsersForRestore') AND attrVal <> ''), '<App_AuthorizedUsersForRestore></App_AuthorizedUsersForRestore>')
		IF(@enableRestoreAuth = 1)
		BEGIN
			IF (@authForRestoreDuration = 0)
			BEGIN
				-- set default auth for restore duration to 30 min
				SET @authForRestoreDuration = 30 * 60
			END
			SET @authForRestoreDuration = @authForRestoreDuration + @time
			-- validate the provided passkey
SELECT @passkeyInDB = attrVal FROM App_CompanyProp WITH(NOLOCK) WHERE componentNameId = @entityId AND attrName = 'b687613983d698ff59a973adccd71da9d327dacd691e38386a7062ff9bdcf6b0'
AND modified=0 AND cs_attrName=checksum('b687613983d698ff59a973adccd71da9d327dacd691e38386a7062ff9bdcf6b0')
			IF (@passkeyInDB <> @passkey)
			BEGIN
SET @errorCode = (3968 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				GOTO PROC_EXIT
			END
			IF CHARINDEX('userId="'+CONVERT(nvarchar(10), @userId)+'"',@authUsersStr) > 0
			BEGIN
				SET @authUsersXML = CAST(@authUsersStr AS XML)
				SET @authUsersXML.modify('replace value of (/App_AuthorizedUsersForRestore/authorizedUsers/user[@userId=sql:variable("@userId")]/../@expirationTime)[1] with sql:variable("@authForRestoreDuration")')
UPDATE App_CompanyProp SET attrVal = CAST(@authUsersXML AS NVARCHAR(MAX)) WHERE componentNameId = @entityId AND attrName = 'AuthorizedUsersForRestore'
AND modified=0 AND cs_attrName=checksum('AuthorizedUsersForRestore')
				GOTO PROC_EXIT
			END
			ELSE
			BEGIN
				SET @authUsersStr = LEFT(@authUsersStr, LEN(@authUsersStr)-LEN('</App_AuthorizedUsersForRestore>'))
				SET @authUsersStr = @authUsersStr + '<authorizedUsers expirationTime="' + CONVERT(nvarchar(10), @authForRestoreDuration) + '"><user _type_="13" userId="' + CONVERT(nvarchar(10),@userId)
									+ '"/></authorizedUsers></App_AuthorizedUsersForRestore>'
UPDATE App_CompanyProp SET attrVal = @authUsersStr WHERE componentNameId = @entityId AND attrName = 'AuthorizedUsersForRestore'
AND modified=0 AND cs_attrName=checksum('AuthorizedUsersForRestore')
				IF (@@ROWCOUNT = 0)
				BEGIN
					INSERT INTO App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@entityId, 'AuthorizedUsersForRestore', 1, @authUsersStr, @time, 0)
				END
				GOTO PROC_EXIT
			END
		END
		ELSE IF(@enableRestoreAuth = 0 AND CHARINDEX('userId="'+CONVERT(nvarchar(10), @userId)+'"',@authUsersStr) > 0)
		BEGIN
			SET @authUsersXML = CAST(@authUsersStr AS XML)
			SET @authUsersXML.modify('replace value of (/App_AuthorizedUsersForRestore/authorizedUsers/user[@userId=sql:variable("@userId")]/../@expirationTime)[1] with 0')
			SET @authUsersStr = CAST(@authUsersXML AS NVARCHAR(MAX))
UPDATE App_CompanyProp SET attrVal = @authUsersStr WHERE componentNameId = @entityId AND attrName = 'AuthorizedUsersForRestore'
AND modified=0 AND cs_attrName=checksum('AuthorizedUsersForRestore') AND attrVal <> @authUsersStr
			GOTO PROC_EXIT
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorString = 'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
END CATCH
PROC_EXIT:
	IF @errorCode <> 0 AND @errorString = ''
	BEGIN
		SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @errorCode AND localeId = @localeId)
	END
	SELECT @errorCode,@errorString,@entityId
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetAuthorizeForRestoreOnEntity')
	delete from GxQscripts where name = 'AppSetAuthorizeForRestoreOnEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetAuthorizeForRestoreOnEntity')
	delete from GXDBVersions where aliasname = 'AppSetAuthorizeForRestoreOnEntity'
GO

insert into GXDBVersions values(2, 'AppSetAuthorizeForRestoreOnEntity',  '00000000000000000000', 'AppSetAuthorizeForRestoreOnEntity', '00000000000000000000')
GO

