

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetAssociationsForSCP.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  AppSetAssociationsForSCP
--  |
--  | Description:  SP for setting associations of a subclient policy
--  |
--  |       Input:  userId, scpId, associations XML and operationType
--  |      Output:  errorCode and errorMessage.
--  |      Return:  xxx
--  |
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetAssociationsForSCP')
BEGIN
	print '>>> Drop Stored Procedure: AppSetAssociationsForSCP <<<'
	drop procedure AppSetAssociationsForSCP
END
IF EXISTS (select * from GxQscripts where name='AppSetAssociationsForSCP')
	delete from GxQscripts where name = 'AppSetAssociationsForSCP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetAssociationsForSCP')
	delete from GXDBVersions where aliasname = 'AppSetAssociationsForSCP'
GO
print '... Creating Procedure: AppSetAssociationsForSCP'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetAssociationsForSCP
  @userId INT,
  @localeId INT,
  @scpId INT,
  @associations XML,
  @operationType INT,
  @skipSecurityCheck INT = 0
AS
  DECLARE @errorCode INT = 0
  DECLARE @errorMessage NVARCHAR(1024) = ''
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
------------------------------- Initial Security Check ----------------------------------
IF @skipSecurityCheck = 0
BEGIN
	-- Check if user has 'Edit Subclient Policy Associations' permission on subclient policy
	DECLARE @userHasRight INT = 0
EXEC sec_checkPermissionOnEntity @userId, 177, @userHasRight OUTPUT, 3, 2 /* DEFAULT_COMMCELL_ID */, 4, 1030 /* CV_APPTYPE_SUBCLIENT_POLICY */, 5, 1 /* CV_DEFAULT_INSTANCE_ID */, 6, @scpId
	IF(@userHasRight<>1)
	BEGIN
SET @errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		SET @errorMessage = REPLACE(@errorMessage, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WHERE id = @userId),''))
SET @errorMessage = REPLACE(@errorMessage, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (3018 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId))
		SET @errorMessage = REPLACE(@errorMessage, '^3%s', ISNULL((SELECT name FROM APP_BackupSetName WHERE id = @scpId),''))
SET @errorMessage = REPLACE(@errorMessage, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2560 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId))
		GOTO EXIT_PROC
	END
END
-----------------------------------------------------------------------------------------
-- Get old associations of subclient policy for current user
DECLARE @oldAssociationsTbl TABLE( associations XML)
INSERT INTO @oldAssociationsTbl
EXEC AppGetAssociationsForSCP @scpId, @userId
DECLARE @oldAssociations XML = (SELECT associations FROM @oldAssociationsTbl)
-- GUI does not send apptypeId and instanceId in associations xml.
IF OBJECT_ID('tempdb.dbo.#AddedAndDeletedAssociationsTbl') IS NOT NULL
	DROP TABLE #AddedAndDeletedAssociationsTbl
CREATE TABLE #AddedAndDeletedAssociationsTbl
(
	_type_			INT,
	clientId		INT,
	backupsetId		INT,
	clientGroupId	INT,
	isDeleted		INT		-- This will 0 for added associations and 1 from deleted associations
)
-- For Overwrite and Add operation types, Added associations are Input - DB(for current user)
IF (@operationType = 1 /* OVERWRITE */) OR (@operationType = 2 /* ADD */)
BEGIN
	INSERT INTO #AddedAndDeletedAssociationsTbl
	(
		_type_,
		clientId,
		backupsetId,
		clientGroupId,
		isDeleted
	)
	(SELECT
		ISNULL(Entity.value('@_type_','INT'),0),
		ISNULL(Entity.value('@clientId','INT'),0),
		ISNULL(Entity.value('@backupsetId','INT'),0),
		ISNULL(Entity.value('@clientGroupId','INT'),0),
		0  -- isDeleted set to 0 for added associations
	FROM @associations.nodes ('App_Associations/entity') Ref(Entity)
	EXCEPT
	SELECT
		ISNULL(Entity.value('@_type_','INT'),0),
		ISNULL(Entity.value('@clientId','INT'),0),
		ISNULL(Entity.value('@backupsetId','INT'),0),
		ISNULL(Entity.value('@clientGroupId','INT'),0),
		0  -- isDeleted set to 0 for added associations
	FROM @oldAssociations.nodes ('App_Associations/entity') Ref(Entity))
END
-- For Overwrite operation type, Deleted associations are DB(for current user) - Input
IF (@operationType = 1 /* OVERWRITE */)
BEGIN
	INSERT INTO #AddedAndDeletedAssociationsTbl
	(
		_type_,
		clientId,
		backupsetId,
		clientGroupId,
		isDeleted
	)
	(SELECT
		ISNULL(Entity.value('@_type_','INT'),0),
		ISNULL(Entity.value('@clientId','INT'),0),
		ISNULL(Entity.value('@backupsetId','INT'),0),
		ISNULL(Entity.value('@clientGroupId','INT'),0),
		1  -- isDeleted set to 1 for deleted associations
	FROM @oldAssociations.nodes ('App_Associations/entity') Ref(Entity)
	EXCEPT
	SELECT
		ISNULL(Entity.value('@_type_','INT'),0),
		ISNULL(Entity.value('@clientId','INT'),0),
		ISNULL(Entity.value('@backupsetId','INT'),0),
		ISNULL(Entity.value('@clientGroupId','INT'),0),
		1  -- isDeleted set to 1 for deleted associations
	FROM @associations.nodes ('App_Associations/entity') Ref(Entity))
END
-- For Delete operation type, Deleted associations are Input
IF (@operationType = 3 /* DELETE */)
BEGIN
	INSERT INTO #AddedAndDeletedAssociationsTbl
	(
		_type_,
		clientId,
		backupsetId,
		clientGroupId,
		isDeleted
	)
	SELECT
		ISNULL(Entity.value('@_type_','INT'),0),
		ISNULL(Entity.value('@clientId','INT'),0),
		ISNULL(Entity.value('@backupsetId','INT'),0),
		ISNULL(Entity.value('@clientGroupId','INT'),0),
		1  -- isDeleted set to 1 for deleted associations
	FROM @associations.nodes ('App_Associations/entity') Ref(Entity)
END
IF NOT EXISTS (SELECT 1 FROM #AddedAndDeletedAssociationsTbl)
BEGIN
	GOTO EXIT_PROC
END
-------------------------- Security Check -------------------------------------------
-- User should have 'Agent Management' permission on all the clientGroups and
-- backupsets which he is trying to associate or dissociate from subclient policy.
-------------------------------------------------------------------------------------
IF @skipSecurityCheck = 0
BEGIN
	IF OBJECT_ID('tempdb.dbo.#UserClientGroups') IS NOT NULL
		DROP TABLE #UserClientGroups
	CREATE TABLE #UserClientGroups
	(
		clientGroupId	INT
	)
EXEC sec_getNonIdaObjectsForThisUser @userId, 28, 2, '#UserClientGroups'
	IF EXISTS (SELECT 1 FROM #AddedAndDeletedAssociationsTbl assoc LEFT OUTER JOIN #UserClientGroups cgs
					ON assoc.clientGroupId = cgs.clientGroupId
WHERE assoc._type_ = 28 AND cgs.clientGroupId IS NULL)
	BEGIN
SET @errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		SET @errorMessage = REPLACE(@errorMessage, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WHERE id = @userId),''))
SET @errorMessage = REPLACE(@errorMessage, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (970 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId))
		SET @errorMessage = REPLACE(@errorMessage, '^3%s', STUFF((SELECT ', ' + CG.name
																		FROM (SELECT DISTINCT assoc.clientGroupId FROM #AddedAndDeletedAssociationsTbl assoc LEFT OUTER JOIN #UserClientGroups cgs
																					ON assoc.clientGroupId = cgs.clientGroupId
WHERE assoc._type_ = 28 AND cgs.clientGroupId IS NULL) CGIds
																		INNER JOIN APP_ClientGroup CG
																			ON CGIds.clientGroupId = CG.id
																		FOR XML PATH('')), 1, 2, ''))
SET @errorMessage = REPLACE(@errorMessage, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (1013 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId))
		GOTO EXIT_PROC
	END
	IF OBJECT_ID('tempdb.dbo.#UserBackupsets') IS NOT NULL
		DROP TABLE #UserBackupsets
	CREATE TABLE #UserBackupsets
	(
		clientId		INT,
		apptypeId		INT,
		instanceId		INT,
		backupsetId		INT,
		subclientId		INT
	)
EXEC sec_getIdaObjectsForUser @userId, 6, 2, 0, '#UserBackupsets'
	IF EXISTS (SELECT 1 FROM #AddedAndDeletedAssociationsTbl assoc LEFT OUTER JOIN #UserBackupsets bkpSets
					ON assoc.clientId = bkpSets.clientId AND assoc.backupsetId = bkpSets.backupsetId
WHERE assoc._type_ = 6 AND bkpSets.backupsetId IS NULL)
	BEGIN
SET @errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		SET @errorMessage = REPLACE(@errorMessage, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WHERE id = @userId),''))
SET @errorMessage = REPLACE(@errorMessage, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (970 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId))
		SET @errorMessage = REPLACE(@errorMessage, '^3%s', STUFF((SELECT ', ' + client.name + ' - ' + backupset.name
																		FROM (SELECT DISTINCT assoc.clientId, assoc.backupsetId FROM #AddedAndDeletedAssociationsTbl assoc LEFT OUTER JOIN #UserBackupsets bkpSets
																					ON assoc.clientId = bkpSets.clientId AND assoc.backupsetId = bkpSets.backupsetId
WHERE assoc._type_ = 6 AND bkpSets.backupsetId IS NULL) BSIds
																		INNER JOIN APP_Client client
																			ON BSIds.clientId = client.id
																		INNER JOIN APP_BackupSetName backupset
																			ON BSIds.backupsetId = backupset.id
																		FOR XML PATH('')), 1, 2, ''))
SET @errorMessage = REPLACE(@errorMessage, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (1006 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId))
		GOTO EXIT_PROC
	END
END
-------------------------------- Sanity Checks ---------------------------------
-- If there are client groups for association that are already associated to a scp having same idaType as of given scp ignore them
DELETE assoc
	FROM #AddedAndDeletedAssociationsTbl assoc INNER JOIN APP_SubclientPolicyAssoc scpAssoc
ON assoc._type_ = 28 AND assoc.isDeleted = 0 AND scpAssoc.entityType = 28 AND assoc.clientGroupId = scpAssoc.entityId
	INNER JOIN APP_BackupSetProp BSProp
		ON scpAssoc.scpId = BSProp.componentNameId
		AND BSProp.attrName = N'Associated subclient Policy Ida Type' AND BSProp.modified = 0
		AND BSProp.attrVal = (SELECT CAST(attrVal AS INT) FROM APP_BackupSetProp WHERE componentNameId = @scpId AND attrName = N'Associated subclient Policy Ida Type' AND modified = 0)
-- If there are backupsets for association that are already associated to given scp from higher association level
-- Send error message that the backupset is already associated to scp through a client group
IF EXISTS (SELECT 1 FROM #AddedAndDeletedAssociationsTbl assoc INNER JOIN APP_BackupSetProp BSProp
ON assoc._type_ = 6 AND assoc.isDeleted = 0 AND assoc.backupsetId = BSProp.componentNameId
						AND BSProp.attrName = N'Associated subclient Policy' AND BSProp.modified = 0 AND BSProp.attrVal <> 0
					INNER JOIN APP_BackupSetProp BSProp1
						ON assoc.backupsetId = BSProp1.componentNameId
						AND BSProp1.attrName = N'Subclient Policy Association Level' AND BSProp1.modified = 0 AND BSProp1.attrVal <> 0)
BEGIN
	-- GUI will retain the window for this error case thus sending specific error code
SET @errorCode = 111
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3436 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
	SET @errorMessage = REPLACE(@errorMessage, '^1%s', STUFF((SELECT ', ' + client.name + ' - ' + backupset.name
																	FROM (SELECT DISTINCT assoc.clientId, assoc.backupsetId FROM #AddedAndDeletedAssociationsTbl assoc INNER JOIN APP_BackupSetProp BSProp
ON assoc._type_ = 6 AND assoc.isDeleted = 0 AND assoc.backupsetId = BSProp.componentNameId
																				AND BSProp.attrName = N'Associated subclient Policy' AND BSProp.modified = 0 AND BSProp.attrVal <> 0
																			INNER JOIN APP_BackupSetProp BSProp1
																				ON assoc.backupsetId = BSProp1.componentNameId
																				AND BSProp1.attrName = N'Subclient Policy Association Level' AND BSProp1.modified = 0 AND BSProp1.attrVal <> 0) BSIds
																	INNER JOIN APP_Client client
																		ON BSIds.clientId = client.id
																	INNER JOIN APP_BackupSetName backupset
																		ON BSIds.backupsetId = backupset.id
																	FOR XML PATH('')), 1, 2, ''))
	SET @errorMessage = REPLACE(@errorMessage, '^2%s', ISNULL((SELECT name FROM APP_BackupSetName WHERE id = @scpId),''))
	GOTO EXIT_PROC
END
-- If there are backupsets for association that are already associated to a scp ignore them
DELETE assoc
	FROM #AddedAndDeletedAssociationsTbl assoc INNER JOIN APP_BackupSetProp BSProp
ON assoc._type_ = 6 AND assoc.isDeleted = 0 AND assoc.backupsetId = BSProp.componentNameId
		AND BSProp.attrName = N'Associated subclient Policy' AND BSProp.modified = 0
		AND BSProp.attrVal <> 0
------------------------------------------------------------------------------------
-- Create table for final list of backupsets to be associated (i.e. also expanding from client group level)
IF OBJECT_ID('tempdb.dbo.#AssociateBackupsets') IS NOT NULL
	DROP TABLE #AssociateBackupsets
CREATE TABLE #AssociateBackupsets
(
	id				INT		IDENTITY (1,1),
	backupsetId		INT,
	clientGroupId	INT
)
-- Create table for final list of backupsets to be dissociated (i.e. also expanding from client group level)
IF OBJECT_ID('tempdb.dbo.#DissociateBackupsets') IS NOT NULL
	DROP TABLE #DissociateBackupsets
CREATE TABLE #DissociateBackupsets
(
	id				INT		IDENTITY (1,1),
	backupsetId		INT,
	clientGroupId	INT
)
---------------------- Expand client group associations and dissociations to backupset level ----------------------------
IF OBJECT_ID('tempdb.dbo.#ClientOrGroupIdList') IS NOT NULL
	DROP TABLE #ClientOrGroupIdList
CREATE TABLE #ClientOrGroupIdList
(
	id				INT
)
-- Get backupsets to be associated from client group level
INSERT INTO #ClientOrGroupIdList
SELECT clientGroupId FROM #AddedAndDeletedAssociationsTbl WHERE _type_ = 28 AND isDeleted = 0
IF EXISTS (SELECT 1 FROM #ClientOrGroupIdList)
BEGIN
	-- This sp will use #ClientOrGroupIdList temp table for list of client group ids if clientGroupId is passed as 0
	-- And it will populated #AssociateBackupsets temp table with backupsets to be associated
	EXEC AppGetBackupSetsForSCPAssociation @scpId, 0
END
-- Get backupsets to be dissociated from client group level
TRUNCATE TABLE #ClientOrGroupIdList
INSERT INTO #ClientOrGroupIdList
SELECT clientGroupId FROM #AddedAndDeletedAssociationsTbl WHERE _type_ = 28 AND isDeleted = 1
IF EXISTS (SELECT 1 FROM #ClientOrGroupIdList)
BEGIN
	-- This sp will use #ClientOrGroupIdList temp table for list of client group ids if clientGroupId is passed as 0
	-- And it will populated #DissociateBackupsets temp table with backupsets to be dissociated
	EXEC AppGetBackupSetsForSCPDissociation @scpId, 0
END
-------------------------------------------------------------------------------------------------------------------------------
-- Add individual backupsets associations and dissociations to associated and dissociated backupsets final list tables
INSERT INTO #AssociateBackupsets (backupsetId, clientGroupId)
SELECT backupsetId, 0 FROM #AddedAndDeletedAssociationsTbl WHERE _type_ = 6 AND isDeleted = 0
INSERT INTO #DissociateBackupsets (backupsetId, clientGroupId)
SELECT backupsetId, 0 FROM #AddedAndDeletedAssociationsTbl WHERE _type_ = 6 AND isDeleted = 1
----------------------------------- Insert and Delete Associations --------------------------------------------------------------
-- Insert Client Group Associations in APP_SubclientPolicyAssoc table
INSERT INTO APP_SubclientPolicyAssoc (scpId, commcellId, entityType, entityId, flags)
SELECT @scpId, 2 /* DEFAULT_COMMCELL_ID */, 28, clientGroupId, 0 FROM #AddedAndDeletedAssociationsTbl WHERE _type_ = 28 AND isDeleted = 0
-- Delete Client Group Dissociations from APP_SubclientPolicyAssoc table
DELETE scpAssoc
	FROM APP_SubclientPolicyAssoc scpAssoc INNER JOIN #AddedAndDeletedAssociationsTbl assoc
ON assoc._type_ = 28 AND assoc.isDeleted = 1
AND scpAssoc.scpId = @scpId AND scpAssoc.entityType = 28
		AND assoc.clientGroupId = scpAssoc.entityId
DECLARE @index INT
DECLARE @maxIndex INT
DECLARE @backupsetId INT
DECLARE @clientGroupId INT
DECLARE @currentTime INT = dbo.GetUnixTime(GetUTCDate())
DECLARE @returnValueTbl TABLE (rc INT)
--Dont associate backupsets that are already associated with Subclient Policy
DELETE AB
FROM #AssociateBackupsets AB
INNER JOIN APP_BackupSetProp BSP ON BSP.componentNameId = AB.backupsetId AND BSP.attrName = N'Associated subclient Policy' AND BSP.modified = 0
-- Call sp for association
-- As SP returns row count insert it into return table
IF EXISTS(SELECT 1 FROM #AssociateBackupsets)
BEGIN
	INSERT INTO @returnValueTbl
	EXEC AppAssocSubClientPolicy 0, @scpId, @currentTime
	-- Insert scp association level as 2 (i.e. Client Group Level)
	INSERT INTO APP_BackupSetProp (componentNameId, attrName, attrType, attrVal, created, modified)
		SELECT backupsetId, N'Subclient Policy Association Level', 7, 2, @currentTime, 0
		FROM #AssociateBackupsets
		WHERE clientGroupId<>0
	-- Insert client group id for inherited association from client group level
	INSERT INTO APP_BackupSetProp (componentNameId, attrName, attrType, attrVal, created, modified)
		SELECT backupsetId, N'Client Group For SCP Association', 7, clientGroupId, @currentTime, 0
		FROM #AssociateBackupsets
		WHERE clientGroupId<>0
END
-- Dissociate backupsets to Subclient Policy
IF EXISTS(SELECT 1 FROM #DissociateBackupsets)
BEGIN
	INSERT INTO @returnValueTbl
		EXEC AppDissocSubClientPolicy 0, @currentTime
END
EXIT_PROC:
SELECT @errorCode, @errorMessage
IF OBJECT_ID('tempdb.dbo.#AddedAndDeletedAssociationsTbl') IS NOT NULL
	DROP TABLE #AddedAndDeletedAssociationsTbl
IF OBJECT_ID('tempdb.dbo.#UserClientGroups') IS NOT NULL
	DROP TABLE #UserClientGroups
IF OBJECT_ID('tempdb.dbo.#UserBackupsets') IS NOT NULL
	DROP TABLE #UserBackupsets
IF OBJECT_ID('tempdb.dbo.#AssociateBackupsets') IS NOT NULL
	DROP TABLE #AssociateBackupsets
IF OBJECT_ID('tempdb.dbo.#DissociateBackupsets') IS NOT NULL
	DROP TABLE #DissociateBackupsets
IF OBJECT_ID('tempdb.dbo.#ClientOrGroupIdList') IS NOT NULL
	DROP TABLE #ClientOrGroupIdList
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetAssociationsForSCP')
	delete from GxQscripts where name = 'AppSetAssociationsForSCP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetAssociationsForSCP')
	delete from GXDBVersions where aliasname = 'AppSetAssociationsForSCP'
GO

insert into GXDBVersions values(2, 'AppSetAssociationsForSCP',  '00000000000000000000', 'AppSetAssociationsForSCP', '00000000000000000000')
GO

