

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetArrayAssociationToClient.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppSetArrayAssociationToClient()
--  | Description:  Allows for Setting and Removing Association for Plan to Array
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetArrayAssociationToClient.sp,v $ $Id: AppSetArrayAssociationToClient.sp,v 1.1.2.6 2018/03/27 09:00:39 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSetArrayAssociationToClient <<<'

IF EXISTS (select * from sysobjects where name='AppSetArrayAssociationToClient')
	drop procedure AppSetArrayAssociationToClient
IF EXISTS (select * from GxQscripts where name='AppSetArrayAssociationToClient')
	delete from GxQscripts where name = 'AppSetArrayAssociationToClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetArrayAssociationToClient')
	delete from GXDBVersions where aliasname = 'AppSetArrayAssociationToClient'
GO
print '... Creating Procedure: AppSetArrayAssociationToClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetArrayAssociationToClient
  @i_userId INTEGER,
  @i_xmlText XML,
  @o_clientsWithNoArrays NVARCHAR(1024) OUTPUT,
  @o_xmlText XML OUTPUT,
  @o_errCode INTEGER OUTPUT,
  @o_errString NVARCHAR(1024) OUTPUT
AS
  DECLARE @clientsWithNoArrays NVARCHAR(1024)
  DECLARE @xmlText XML
  DECLARE @errCode INTEGER
  DECLARE @errString NVARCHAR(1024) 
SET NOCOUNT ON
-- Sample Request
--<Api_UpdateClientAssociationToSnapPlan arrayId="5" planId="506" opType="2" includeAllAppTypes="false">
--  <appIds val="106"/>
--  <clients clientId="6" _type_="3"/>
--  <clients clientId="31" _type_="3" />
--</Api_UpdateClientAssociationToSnapPlan>
BEGIN TRY
DECLARE @canManageClient INTEGER
DECLARE	@now			 INTEGER
DECLARE	@arrayIds		 NVARCHAR(1024) = ''
DECLARE @operationType   INTEGER = ISNULL (( SELECT ref.value('@opType', 'INT') FROM @i_xmlText.nodes ('Api_UpdateClientAssociationToSnapPlan') R(ref)), 0)
DECLARE @currentArrayId	 INTEGER = ISNULL (( SELECT ref.value('@arrayId', 'INT') FROM @i_xmlText.nodes ('Api_UpdateClientAssociationToSnapPlan') R(ref)), 0)
SET @o_errCode = 0
SET @o_errString = ''
SET @now = dbo.GetUnixTime(GetUTCDate())
IF OBJECT_ID('tempdb.dbo.#clientListTemp') IS NOT NULL DROP TABLE #clientListTemp
CREATE TABLE #clientListTemp
(
    t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
)
IF OBJECT_ID('tempdb.dbo.#clientListInput') IS NOT NULL DROP TABLE #clientListInput
CREATE TABLE #clientListInput
(
    clientId INT
)
IF OBJECT_ID('tempdb.dbo.#clientListUpdate') IS NOT NULL DROP TABLE #clientListUpdate
CREATE TABLE #clientListUpdate
(
    clientId INT
)
-- Get all the provided client Id's in temp table
INSERT INTO #clientListInput SELECT distinct ISNULL(ref.value('@clientId', 'INT'),0) FROM @i_xmlText.nodes('Api_UpdateClientAssociationToSnapPlan/clients') R ( ref )
-- Get All the clients for this user with EV_MANAGE_APPLICATION CAPABILITY
EXEC sec_getIdaObjectsForUser @i_userId, 3 /*CLIENT_ENTITY*/ , 2 /*EV_MANAGE_APPLICATION*/, 0, '#clientListTemp'
-- Check If all provided client satisfy security settings
IF NOT EXISTS (SELECT TOP 1 * FROM #clientListInput CLI
				LEFT JOIN #clientListTemp CLT
					ON CLI.clientId=CLT.t_clientId
					WHERE CLT.t_clientId IS NULL)
BEGIN
	IF @operationType = 1	-- OVERWRITE
	BEGIN
		-- SET Array ID
		MERGE  App_ClientProp as Dest
			USING (SELECT DISTINCT clientId FROM #clientListInput) AS Src
			on  Dest.componentNameId = Src.clientId
				AND Dest.attrName = 'Arrays'
				AND Dest.modified = 0
			WHEN MATCHED
				THEN UPDATE SET attrVal = @currentArrayId
			WHEN NOT MATCHED THEN
			INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)
			Values( Src.clientId, 'Arrays', 1, @currentArrayId, @now, 0, 0);
		-- SET IntelliSNAP Option Checked
		MERGE  App_ClientProp as Dest
			USING (SELECT DISTINCT clientId FROM #clientListInput) AS Src
			on  Dest.componentNameId = Src.clientId
				AND Dest.attrName = 'Snap Backups Enabled'
				AND Dest.modified = 0
			WHEN MATCHED
				THEN UPDATE SET attrVal = 1
			WHEN NOT MATCHED THEN
			INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)
			Values( Src.clientId, 'Snap Backups Enabled', 2, 1, @now, 0, 0);
	END
	ELSE IF @operationType = 2			-- ADD
	BEGIN
		-- Get List Of All clients which doesn't have this array association
		INSERT INTO #clientListUpdate
			SELECT clientid FROM #clientListInput CLT
				LEFT OUTER JOIN APP_ClientProp ACP
					ON ACP.componentNameId = CLT.clientId AND ACP.attrName = 'Arrays'
				WHERE (ACP.modified = 0
				AND @currentArrayId NOT IN (SELECT _ID FROM dbo.SplitIDs(ACP.attrVal))) OR ACP.componentNameId IS NULL
		-- SET Array ID
		MERGE  App_ClientProp as Dest
			USING (SELECT DISTINCT clientId FROM #clientListUpdate) AS Src
			on  Dest.componentNameId = Src.clientId
				AND Dest.attrName = 'Arrays'
				AND Dest.modified = 0
			WHEN MATCHED
				THEN UPDATE SET attrVal = attrVal + ',' + CONVERT(NVARCHAR(128),@currentArrayId)
			WHEN NOT MATCHED THEN
			INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)
			Values( Src.clientId, 'Arrays', 1, @currentArrayId, @now, 0, 0);
		-- SET IntelliSNAP Option Checked
		MERGE  App_ClientProp as Dest
			USING (SELECT DISTINCT clientId FROM #clientListInput) AS Src
			on  Dest.componentNameId = Src.clientId
				AND Dest.attrName = 'Snap Backups Enabled'
				AND Dest.modified = 0
			WHEN MATCHED
				THEN UPDATE SET attrVal = 1
			WHEN NOT MATCHED THEN
			INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)
			Values( Src.clientId, 'Snap Backups Enabled', 2, 1, @now, 0, 0);
	END
	ELSE IF @operationType = 3	-- DELETE
	BEGIN
		-- Get List Of All clients which does have this array association
		INSERT INTO #clientListUpdate
			SELECT clientid FROM #clientListInput CLT
				INNER JOIN APP_ClientProp ACP
					ON ACP.componentNameId = CLT.clientId
				WHERE ACP.attrName = 'Arrays'
				AND ACP.modified = 0
				AND @currentArrayId IN (SELECT _ID FROM dbo.SplitIDs(ACP.attrVal))
		-- Remove Array ID from applicable clients
		MERGE  App_ClientProp as Dest
			USING (SELECT DISTINCT clientId FROM #clientListUpdate) AS Src
			on  Dest.componentNameId = Src.clientId
				AND Dest.attrName = 'Arrays'
				AND Dest.modified = 0
			WHEN MATCHED AND Dest.attrval = CONVERT(NVARCHAR(20), @currentArrayId)
				THEN DELETE
			WHEN MATCHED
				THEN UPDATE SET attrVal = (SELECT LEFT(T2.List,LEN(T2.List) - 1)
				FROM
				(
					SELECT (SELECT CONVERT(NVARCHAR(20), _ID) + ',' FROM dbo.SplitIDs(attrVal)  WHERE _ID <> @currentArrayId FOR XML PATH('')) AS List
				) T2);
		-- SET IntelliSNAP Option UnChecked. It will be only done, if user passed array id was mapped to this client
		MERGE  App_ClientProp as Dest
			USING (SELECT clientId FROM #clientListInput WHERE
						clientId NOT IN
						(SELECT clientId FROM #clientListInput CLI
							INNER JOIN APP_ClientProp ACP
							ON ACP.componentNameId=CLI.clientId
							WHERE ACP.attrName = 'Arrays'
							AND ACP.modified = 0)
					) AS Src
			ON  Dest.componentNameId = Src.clientId
				AND Dest.attrName = 'Snap Backups Enabled'
				AND Dest.modified = 0
			WHEN MATCHED
				THEN UPDATE SET attrVal = 0
			WHEN NOT MATCHED THEN
				INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)
				Values( Src.clientId, 'Snap Backups Enabled', 2, 0, dbo.GetUnixTime(GetUTCDate()), 0, 0);
		-- Update Clients list which have got all array disassociated for them
		SELECT @o_clientsWithNoArrays = COALESCE( @o_clientsWithNoArrays + ',','') + CONVERT(NVARCHAR(128),clientId)
					FROM #clientListInput WHERE
						clientId NOT IN
									(SELECT clientId FROM #clientListInput CLI
										INNER JOIN APP_ClientProp ACP
										ON ACP.componentNameId=CLI.clientId
										WHERE ACP.attrName = 'Arrays'
										AND ACP.modified = 0)
	END
	ELSE
	BEGIN
		SET @o_errCode = 2
		SET @o_errString = 'Invalid Operation type provided.'
	END
END
ELSE
BEGIN
	SET @o_errCode = 5
    SET @o_errString = 'Access denied.'
END
EXIT_ERROR:
SET @o_xmlText = (SELECT @o_errCode AS '@errorCode', @o_errString AS '@errorMessage' FOR XML PATH ('CVGui_GenericResp'))
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @o_errCode = ERROR_NUMBER()
    set @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @o_xmlText = (SELECT @o_errCode AS '@errorCode', @o_errString AS '@errorMessage' FOR XML PATH ('CVGui_GenericResp'))
	select @o_xmlText
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
SET @clientsWithNoArrays = @o_clientsWithNoArrays
SET @xmlText			 = @o_xmlText
SET @errCode			 = @o_errCode
SET @errString			 = @o_errString
SELECT @clientsWithNoArrays, @xmlText, @errCode, @errString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetArrayAssociationToClient')
	delete from GxQscripts where name = 'AppSetArrayAssociationToClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetArrayAssociationToClient')
	delete from GXDBVersions where aliasname = 'AppSetArrayAssociationToClient'
GO

insert into GXDBVersions values(2, 'AppSetArrayAssociationToClient',  '00010001000200060000', 'AppSetArrayAssociationToClient', '00010001000200060000')
GO

