

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetAdditionalSettingsForEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetAdditionalSettingsForEntity.sp,v $ $Id: AppSetAdditionalSettingsForEntity.sp,v 1.1.2.7 2019/03/19 12:33:05 vthakur Exp $";
--	+===================================================================+
--	| APPSetActivityControl - PRIMARY ENTRY POINT FOR ALL CCP OPS			|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetAdditionalSettingsForEntity')
BEGIN
	print '>>> Drop Stored Procedure: AppSetAdditionalSettingsForEntity <<<'
	drop procedure AppSetAdditionalSettingsForEntity
END
IF EXISTS (select * from GxQscripts where name='AppSetAdditionalSettingsForEntity')
	delete from GxQscripts where name = 'AppSetAdditionalSettingsForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetAdditionalSettingsForEntity')
	delete from GXDBVersions where aliasname = 'AppSetAdditionalSettingsForEntity'
GO
print '... Creating Procedure: AppSetAdditionalSettingsForEntity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetAdditionalSettingsForEntity
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
--		entityId = Client or Client group id			---
--		entityType = Client -> 3, Client Group -> 28	---
-----------------------------------------------------------
  @entityId INTEGER,
  @entityType INTEGER,
  @keyName NVARCHAR(1024),
  @relativePath NVARCHAR(4000),
  @type NVARCHAR(80),
  @value NVARCHAR(MAX), 
  @hidden INTEGER = 1,
  @comment NVARCHAR(MAX) = '' 
-----------------------------------------------------------
AS
SET NOCOUNT ON
  DECLARE @errorCode INTEGER = 0
DECLARE @now INTEGER = dbo.GetUnixTime(GetUTCDate())
BEGIN TRY
	DECLARE @outTable TABLE (keyId INTEGER)
	BEGIN TRANSACTION
	DECLARE @commentXML XML = ''
	SET @comment = (ISNULL(@comment,''))
	-- comment should be in XML fomat <App_AdvanceSettingProps comment="comment for testing" />
	SET @commentXML= ISNULL((select @comment as '@comment'
								where ISNULL(NULLIF(LTRIM(RTRIM(@comment)), ''), '') <> ''
									for XML path ('App_AdvanceSettingProps')),'')
	INSERT INTO @outTable
	SELECT id FROM
	(
		MERGE APP_AdvanceSettings as addSet
		USING (SELECT @entityId as entityID , @entityType as entityType ,@keyName as keyName,@type as type,@relativePath as relativePath) S
		ON addSet.entityId = S.entityID AND addSet.entityType = S.entityType AND addSet.KeyName = S.keyName AND addSet.type = S.type AND addSet.relativePath = S.relativePath AND addSet.sourceId = 0 AND addSet.sourceEntityType = 0
		WHEN MATCHED THEN UPDATE SET addSet.value = @value
		WHEN NOT MATCHED THEN
		INSERT VALUES(@entityId,@keyName,@type,@relativePath,@value,1,0,@entityType,0,0)
		OUTPUT $action,Inserted.id
	) AS Temp(MergeAction, id)
	MERGE APP_AdvanceSettingsEx addSetEx
	USING (SELECT keyId FROM @outTable) AS temp
	ON temp.keyId = addSetEx.keyId
	WHEN MATCHED THEN UPDATE SET addSetEx.hidden = @hidden , addSetEx.details = @commentXML
	WHEN NOT MATCHED THEN INSERT VALUES(temp.keyId,@commentXML,@hidden);
	IF @entityType = 3
	BEGIN
		IF EXISTS(SELECT 1 FROM APP_VMToPMMap WITH(NOLOCK) WHERE VMClientId = @entityId AND @entityId <> 2)
		BEGIN
			--WORK_TOKEN_REGISTRY
			INSERT INTO APP_WorkQueueRequest(clientId,remoteClient,workToken,workTokenParams,createTime,lastUpdateTime,retryCount,flag)
			SELECT PMClientId, -1,6,'',@now,0,0,0
				FROM APP_VMToPMMap WITH(NOLOCK)
				WHERE VMClientId = @entityId
		END
		ELSE
		BEGIN
			INSERT INTO APP_WorkQueueRequest(clientId,remoteClient,workToken,workTokenParams,createTime,lastUpdateTime,retryCount,flag)
			VALUES(@entityId,-1,6,'',@now,0,0,0) --WORK_TOKEN_REGISTRY
		END
	END
	ELSE IF @entityType = 28
	BEGIN
		INSERT INTO APP_WorkQueueRequest(clientId,remoteClient,workToken,workTokenParams,createTime,lastUpdateTime,retryCount,flag)
		SELECT DISTINCT clientId,-1,6,'',@now,0,0,0 --WORK_TOKEN_REGISTRY
		FROM APP_ClientGroupAssoc WITH(NOLOCK)
		WHERE clientGroupId = @entityId
	END
	COMMIT TRANSACTION
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	ROLLBACK TRANSACTION
	SET @errorCode = 1
END CATCH
SELECT @errorCode
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetAdditionalSettingsForEntity')
	delete from GxQscripts where name = 'AppSetAdditionalSettingsForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetAdditionalSettingsForEntity')
	delete from GXDBVersions where aliasname = 'AppSetAdditionalSettingsForEntity'
GO

insert into GXDBVersions values(2, 'AppSetAdditionalSettingsForEntity',  '00010001000200070000', 'AppSetAdditionalSettingsForEntity', '00010001000200070000')
GO

