

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSCPContentChangeToken.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSCPContentChangeToken.sp,v $ $Id: AppSCPContentChangeToken.sp,v 1.1.2.4 2018/03/22 01:36:12 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  AppSCPContentChangeToken()
--  |
--  | Description:
--  |
--  |       Input:
--  |      Output:
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSCPContentChangeToken <<<'

IF EXISTS (select * from sysobjects where name='AppSCPContentChangeToken')
	drop procedure AppSCPContentChangeToken
IF EXISTS (select * from GxQscripts where name='AppSCPContentChangeToken')
	delete from GxQscripts where name = 'AppSCPContentChangeToken'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSCPContentChangeToken')
	delete from GXDBVersions where aliasname = 'AppSCPContentChangeToken'
GO
print '... Creating Procedure: AppSCPContentChangeToken'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSCPContentChangeToken
  @i_subclientPolicyID INT
AS
  DECLARE @errorCode INT = 0
  DECLARE @errorString VARCHAR(MAX) = 'Success'
BEGIN TRY
	DECLARE @intPolicyID INT = @i_subclientPolicyID
	DECLARE @nowTime  INT = dbo.GetUnixTime(GETUTCDATE())
	IF OBJECT_ID('tempdb.dbo.#scpAssociatedClient') IS NOT NULL
    DROP TABLE #scpAssociatedClient
    CREATE TABLE #scpAssociatedClient (
                            subclientId INT PRIMARY KEY,
							clientId INT,
                            tokenParam NVARCHAR(MAX)
    )
	IF NOT EXISTS(SELECT 1 FROM APP_Application WITH(NOLOCK) WHERE id = @intPolicyID AND appTypeId = 1030 AND (subclientStatus = 8 OR subclientStatus = 0))
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Input subclient policy id is invalid. Unable to add WORK_TOKEN_SUBCLIENT_CONTENT on associated clients.'
		GOTO PROC_EXIT
	END
	DECLARE @strPolicyID NVARCHAR(64) = CAST(@intPolicyID as NVARCHAR(64))
	DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
	--Add work token 7(WORK_TOKEN_SUBCLIENT_CONTENT) to all laptop client associated to subclient policy
	INSERT #scpAssociatedClient(clientId, subclientId)
	SELECT client.id, subclient.id
	FROM APP_Client client
	INNER JOIN APP_Application subclient WITH(NOLOCK) ON subclient.clientId = client.id AND (client.status & 0x1000) = 0x1000
	INNER JOIN APP_SubClientProp prop WITH(NOLOCK) ON prop.componentNameId = subclient.id
	WHERE prop.cs_attrName = checksum(N'Associated subclient Policy') AND prop.attrName = N'Associated subclient Policy' AND prop.modified = 0 AND prop.attrVal = @strPolicyID
	IF EXISTS(SELECT 1 FROM #scpAssociatedClient)
	BEGIN
		UPDATE #scpAssociatedClient
		SET tokenParam = '<TMMsg_SubclientChangeReq subclientID="' + (CAST(subclientId AS NVARCHAR(64))) + '"/>'
		INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
		SELECT clientId, 7, tokenParam, @currentTime, 0, 0, 0, -1
		FROM #scpAssociatedClient
	END
PROC_EXIT:
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
   SET @errorCode = ERROR_NUMBER()
   SET @errorString = 'Problems executing [' +ERROR_PROCEDURE() + '], Line['
                    + CONVERT(nvarchar(10),ERROR_LINE()) + '] :' +ERROR_MESSAGE()
END CATCH
SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppSCPContentChangeToken')
	delete from GxQscripts where name = 'AppSCPContentChangeToken'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSCPContentChangeToken')
	delete from GXDBVersions where aliasname = 'AppSCPContentChangeToken'
GO

insert into GXDBVersions values(2, 'AppSCPContentChangeToken',  '00010001000200040000', 'AppSCPContentChangeToken', '00010001000200040000')
GO

