

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSCGUpdateClientGroupDependency.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSCGUpdateClientGroupDependency.sp,v $ $Id: AppSCGUpdateClientGroupDependency.sp,v 1.2.208.3 2019/10/04 04:43:34 abilbrey Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppSCGUpdateClientGroupDependency"
--	|	This Procedure is used to handle the different request for VM Allocation Policy
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSCGUpdateClientGroupDependency')
BEGIN
	print '>>> Drop Stored Procedure: AppSCGUpdateClientGroupDependency <<<'
	drop procedure AppSCGUpdateClientGroupDependency
END
IF EXISTS (select * from GxQscripts where name='AppSCGUpdateClientGroupDependency')
	delete from GxQscripts where name = 'AppSCGUpdateClientGroupDependency'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSCGUpdateClientGroupDependency')
	delete from GXDBVersions where aliasname = 'AppSCGUpdateClientGroupDependency'
GO
print '... Creating Procedure: AppSCGUpdateClientGroupDependency'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSCGUpdateClientGroupDependency
-- Input arguments
  @i_associatedGroup integer,
  @i_ownerGroup integer
AS
  DECLARE @r_returnStatus XML;
BEGIN
	DECLARE @emsg VARCHAR(1024) = ''
	SET @r_returnStatus = '<App_GenericResp errorCode="0" />'
	IF	(@i_associatedGroup = 0)
	BEGIN
		DELETE FROM APP_SCGClientGroupDependency WHERE ownerGrpId=@i_ownerGroup
	END
	ELSE
	BEGIN
		-- Check for circular client group dependency
		DECLARE @loopxml XML = NULL
		CREATE TABLE #DepCheck (
			associatedGrpId	INT,
			ownerGrpId		INT
		)
		INSERT INTO #DepCheck
			SELECT
				@i_associatedGroup,
				@i_ownerGroup
			UNION
			SELECT
				p.associatedGrpId,
				p.ownerGrpId
			FROM App_SCGClientGroupDependency p WITH(NOLOCK)
		-- Now create an XML Listing of all chains
		;WITH SCGFindLoop AS
		(
			SELECT
				p.ownerGrpId parentId,
				p.associatedGrpId childId,
				(
					SELECT
						p.ownerGrpId '@parentId',
						p.associatedGrpId 'Node/@id'
					FOR XML PATH('Path'), TYPE
				) path,
				1 distance,
				0 loop
			FROM #DepCheck p
			UNION ALL
			SELECT
				p.ownerGrpId parentId,
				c.childId,
				CASE CAST(c.path.exist('//Node[@id = sql:column("p.associatedGrpId")]') AS INT)
					WHEN 1 THEN
						(
							SELECT
								c.path.value('(/Path/@parentId)[1]', 'INT') '@parentId',
								c.path.query('/Path/Node'),
								p.associatedGrpId 'NodeLoop/@id'
							FOR XML PATH('Path'), TYPE
						)
					ELSE
						(
							SELECT
								c.path.value('(/Path/@parentId)[1]', 'INT') '@parentId',
								c.path.query('/Path/Node'),
								p.associatedGrpId 'Node/@id'
							FOR XML PATH('Path'), TYPE
						)
				END path,
				c.distance + 1,
				CAST(c.path.exist('//Node[@id = sql:column("p.associatedGrpId")]') AS INT) loop
			FROM #DepCheck p
				INNER JOIN SCGFindLoop c ON
					c.parentId = p.associatedGrpId
					AND p.ownerGrpId <> p.associatedGrpId
			WHERE
				c.loop = 0
		 )
			SELECT @loopxml = (
				SELECT TOP 1
					l.parentId '@parentId',
					l.childId '@childId',
					l.loop '@loop',
					l.distance '@distance',
					l.path.query('.')
				FROM SCGFindLoop l
				WHERE
					l.loop <> 0
					AND l.parentId = @i_ownerGroup
				FOR XML PATH('SCGLoopDetected'), TYPE
			)
		IF (@loopxml IS NOT NULL)
		BEGIN
			SET @emsg = 'Circular Client Group Dependencies are not allowed [' +  CAST(@loopxml AS VARCHAR(MAX)) +  ']'
			SET @r_returnStatus = (
				SELECT
					1001 '@errorCode',
					@emsg '@errorMessage'
				FOR XML PATH('App_GenericResp')
			)
		END
		ELSE IF (@i_ownerGroup = @i_associatedGroup)
		BEGIN
			SET @emsg = 'Client Group Dependencies do not allowed for a client group pointing to itself [owner:' +  CAST(@i_ownerGroup AS VARCHAR(12)) +  ' associated:' + CAST(@i_associatedGroup AS VARCHAR(12)) + ']'
			SET @r_returnStatus = (
				SELECT
					1002 '@errorCode',
					@emsg '@errorMessage'
				FOR XML PATH('App_GenericResp')
			)
		END
		ELSE IF NOT EXISTS (SELECT 1 FROM APP_SCGClientGroupDependency WITH(NOLOCK) WHERE associatedGrpId = @i_associatedGroup AND ownerGrpId = @i_ownerGroup)
		BEGIN
			INSERT INTO APP_SCGClientGroupDependency VALUES (@i_associatedGroup, @i_ownerGroup)
		END
	END
	SELECT @r_returnStatus;
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppSCGUpdateClientGroupDependency')
	delete from GxQscripts where name = 'AppSCGUpdateClientGroupDependency'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSCGUpdateClientGroupDependency')
	delete from GXDBVersions where aliasname = 'AppSCGUpdateClientGroupDependency'
GO

insert into GXDBVersions values(2, 'AppSCGUpdateClientGroupDependency',  '00010002020800030000', 'AppSCGUpdateClientGroupDependency', '00010002020800030000')
GO

