

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSCGUpdateClient.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSCGUpdateClient.sp,v $ $Id: AppSCGUpdateClient.sp,v 1.11.48.28.8.1 2021/04/20 12:27:05 abilbrey Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppSCGUpdateClient"
--	|	This Procedure is used to handle the different request for VM Allocation Policy
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppSCGUpdateClient')
BEGIN
	print '>>> Drop Stored Procedure: AppSCGUpdateClient <<<'
	drop procedure AppSCGUpdateClient
END
IF EXISTS (select * from GxQscripts where name='AppSCGUpdateClient')
	delete from GxQscripts where name = 'AppSCGUpdateClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSCGUpdateClient')
	delete from GXDBVersions where aliasname = 'AppSCGUpdateClient'
GO
print '... Creating Procedure: AppSCGUpdateClient'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppSCGUpdateClient
-- Input arguments
  @i_uid INT, 
--if -1, use externally created temp table #AppSCGUpdateClientExtTable contain list of clientIds to process
  @i_clientId INT=-1,
-- For Plan SCGs to refresh only targeted client group associations: comma separated clientGroupId List
  @i_clientGroupList VARCHAR(512) = ''
AS
BEGIN
	--===========================================================================
	--==	Logical:
	--==		if i_ClientId > 0 or i_ClientId = -1(external table passed in with clientIds)
	--==			if i_clientGroupList is null or ''
	--==				Refresh ALL Non-Plan and Non-Company SCGs
	--==			else
	--==				Refresh only Plan and Company in SCG List
	--==		else
	--==			Not supported for ClientId = 0 - error
	--===========================================================================
	SET NOCOUNT ON
	DECLARE @ruleQuery NVARCHAR(MAX)
	DECLARE @scgId INTEGER
	DECLARE @newSec INT = dbo.isNewSecurity();
	DECLARE @shouldRefreshCredentials INT = 0
	DECLARE @doOnce TINYINT = 0
	DECLARE @internalCId INT = 0
	DECLARE @isRule TINYINT = 0
	DECLARE @rcnt INTEGER = 0
	DECLARE @scgCGBit INTEGER = 4096	-- CV_FLAG_SMART_CLIENT_GROUP / 0x1000
	DECLARE @debug INT = 0
	DECLARE @scopeType INT = 0
	DECLARE @scopeId INT = 0
	DECLARE @updateOrder INT = 0
	DECLARE @scgTenantBit INTEGER = (1073741824 | 536870912)	-- (COMPANY_ASSOCIATED_ENTITY 0x40000000 | PLAN_ASSOCIATED_ENTITY 0x20000000)
	IF (@i_clientId = 0)
	BEGIN
		PRINT 'ERROR: AppSCGUpdateClient @i_ClientId not set.'
		RAISERROR('ERROR: AppSCGUpdateClient @i_ClientId not set.', 16, 1)
	END
	IF (@i_clientId = -1 AND OBJECT_ID('tempdb.dbo.#AppSCGUpdateClientExtTable') IS NULL)
	BEGIN
		PRINT 'ERROR: AppSCGUpdateClient not passed as input #AppSCGUpdateClientExtTable Temp Table.'
		RAISERROR('ERROR: AppSCGUpdateClient not passed as input #AppSCGUpdateClientExtTable Temp Table.', 16, 1)
	END
	DECLARE @extTableCreate TINYINT = 0
	IF OBJECT_ID('tempdb.dbo.#AppSCGUpdateClientExtTable') IS NULL
	BEGIN
		-- External Inputted Table does not exist
		CREATE TABLE #AppSCGUpdateClientExtTable (
			clientId		INT PRIMARY KEY
		)
		INSERT INTO #AppSCGUpdateClientExtTable (clientId) VALUES (@i_clientId)
		SET @extTableCreate = 1
	END
	-- Clients to always Exclude from SCG Listings
	-- CS Clustered Physical Clients
	DECLARE @isExcludeSet	INT = 0
	DECLARE @ExcludeClients TABLE (
		clientId	INT PRIMARY KEY
	)
	-- Get key to check for reverting to orignal implementation of no excluding clients
	DECLARE @isExcludeSetDisable	INT = 0
	SELECT
		@isExcludeSetDisable = CAST(p.value AS INT)
	FROM GXGlobalParam p WITH(NOLOCK)
	WHERE
		name = N'DisableSCGExcludeClientSet'
	IF (@isExcludeSetDisable IS NULL OR @isExcludeSetDisable = 0)
	BEGIN
		INSERT INTO @ExcludeClients (clientId)
			SELECT PMClientId
			FROM APP_VMToPMMap WITH(NOLOCK)
			WHERE VMClientId = 2	-- CS Id
		SET @isExcludeSet = @@ROWCOUNT
	END
	--*****************************************************************
	-- Support for MSP Commserver - START
	--		If clientId or Client External Table inputted without
	--		any SCG List then determine the set of SCGs that need to
	--		be updated for these clients only.
	--
	-- GXGlobalParam Control Properties:
	--		IsMSPCommcell - identifies Commservers that MSP configured.
	--		SCGEnableComputedMSPGroupList - Computed MSP Limited SCG Refresh List
	--*****************************************************************
	IF  (@i_clientGroupList = '')
	BEGIN
		DECLARE @isMSP INT = 0
		SELECT
			@isMSP = CAST(value AS INT)
		FROM GXGlobalParam WITH(NOLOCK)
		WHERE
			name = N'IsMSPCommcell'
		DECLARE @enableComputedGroupList INT = 0
		SELECT
			@enableComputedGroupList = CAST(value AS INT)
		FROM GXGlobalParam WITH(NOLOCK)
		WHERE
			name = N'SCGEnableComputedMSPGroupList'
		IF ((@isMSP = 1 AND @enableComputedGroupList = 1))
		BEGIN
			IF object_id('tempdb.dbo.#Groups') IS NOT NULL
			BEGIN
				DROP TABLE #Groups
			END
			CREATE TABLE #Groups (
				gid INT PRIMARY KEY
			)
			IF object_id('tempdb.dbo.#InCompanies') IS NOT NULL
			BEGIN
				DROP TABLE #InCompanies
			END
			CREATE TABLE #InCompanies (
				companyId		INT PRIMARY KEY
			)
			-- Get associated companies for inputted clients
			INSERT INTO  #InCompanies(companyId)
				SELECT DISTINCT
					CAST(cp.attrVal AS INT) companyId
				FROM APP_ClientProp cp  WITH(READUNCOMMITTED)
				WHERE
					cp.attrName = N'Installation Company ID'
					AND cp.modified = 0
					AND LEN(cp.attrVal) <= 10
					AND ISNUMERIC(cp.attrVal) = 1
					AND cp.componentNameId IN (SELECT clientId FROM #AppSCGUpdateClientExtTable)
			SET @rcnt = @@ROWCOUNT
			IF (@rcnt > 0)
			BEGIN
				-- Include Company Id=0 as we don't want to read umusers and umgroups again
				INSERT INTO #InCompanies
					SELECT 0 FROM #InCompanies WHERE companyId<>0
				IF OBJECT_ID('tempdb.dbo.#UserOrGroupTbl') IS NOT NULL
					DROP TABLE #UserOrGroupTbl
				CREATE TABLE #UserOrGroupTbl
				(
					isUser INT,
					userOrGroupId INT,
					companyID INT,
					UNIQUE CLUSTERED (isUser, userOrGroupId)
				)
				INSERT INTO #UserOrGroupTbl
					SELECT 1, UU.id, IC.companyId
					FROM UMUsers UU WITH(NOLOCK)
						INNER JOIN UMDSProviders UD WITH(NOLOCK)
							ON (UD.id=UU.umDSproviderId)
						INNER JOIN #InCompanies IC
ON ((UD.id=IC.companyId) OR ((IC.companyId=UD.ownerCompany) AND (UD.serviceType<>5)))
					UNION
					SELECT 0, UG.id, IC.companyId
					FROM UMGroups UG WITH(NOLOCK)
						INNER JOIN UMDSProviders UD WITH(NOLOCK)
							ON (UD.id=UG.umDSproviderId)
						INNER JOIN #InCompanies IC
ON ((UD.id=IC.companyId) OR ((IC.companyId=UD.ownerCompany) AND (UD.serviceType<>5)))
				INSERT INTO #Groups
					SELECT entityId1
					FROM UMSecurityAssociations UMS WITH(NOLOCK)
						INNER JOIN App_SCGRule ASG WITH(NOLOCK)
ON ASG.scgid=UMS.entityId1 AND UMS.entityType1=28
						INNER JOIN #UserOrGroupTbl U
							ON U.userOrGroupId=UMS.userOrGroupId AND UMS.isUser=U.isUser
					WHERE (UMS.isCreator=1) AND U.companyID<>0
					UNION
					SELECT entityId1
					FROM UMSecurityAssociations UMS WITH(NOLOCK)
						INNER JOIN APP_ClientGroup cg WITH(NOLOCK) ON
cg.id = UMS.entityId1 AND UMS.entityType1=28 AND (cg.flag & 1073741824) = 0 AND (cg.flag&0x1000 <>0)
						INNER JOIN #UserOrGroupTbl U
							ON U.userOrGroupId=UMS.userOrGroupId AND UMS.isUser=U.isUser
						WHERE (UMS.isCreator=1)  AND U.companyID=0
					UNION
					SELECT ACG.scgId
					FROM App_SCGRule ACG  WITH(NOLOCK)
						CROSS apply ACG.ruleXML.nodes('/scgRule/rules/rule/rules/rule') t(r)
						INNER JOIN #InCompanies IC
							ON CAST(IC.companyId AS NVARCHAR(32))=r.value('@value', 'NVARCHAR(max)')
					WHERE  r.value('@propID', 'int')=44  AND IC.companyId<>0
				IF OBJECT_ID('tempdb.dbo.#UserOrGroupTbl') IS NOT NULL
					DROP TABLE #UserOrGroupTbl
				IF EXISTS (SELECT 1 FROM #Groups)
				BEGIN
					-- Create comma separate SCG Listing
					DECLARE @cgList VARCHAR(MAX) = (
						SELECT
							STUFF((SELECT ',' + CAST(gid AS VARCHAR(12))
									FROM #Groups
									FOR XML PATH('')
								), 1, 1, ''
							)
					)
					IF (LEN(@cgList) > 0)
					BEGIN
						-- override group listing for processing below
						SET @i_clientGroupList = @cgList
					END
				END
			END
		END
	END
	--*****************************************************************
	-- Support for MSP Commserver - END
	--*****************************************************************
	IF OBJECT_ID('tempdb.dbo.#tmpClientIdTable') IS NOT NULL
		DROP TABLE #tmpClientIdTable
	CREATE TABLE #tmpClientIdTable (
		clientId INTEGER PRIMARY KEY
	)
	IF OBJECT_ID('tempdb.dbo.#clientGroupPermissionList') IS NOT NULL
		DROP TABLE #clientGroupPermissionList
	CREATE TABLE #clientGroupPermissionList (
		permissionId	INT
	)
	IF OBJECT_ID('tempdb.dbo.#scgTable') IS NOT NULL
		DROP TABLE #scgTable
	CREATE TABLE #scgTable (
		scgId		INTEGER PRIMARY KEY,
		ruleQuery	NVARCHAR(MAX),
		scopeType	INT,
		scopeId		INT,
		updateOrder	INT DEFAULT 0
	)
	-- Table to map UserGroupId to their hidden UserId
    IF OBJECT_ID('tempdb.dbo.#AppSCGUpdateClient_UserGroupToHiddenUser') is not null
        DROP TABLE #AppSCGUpdateClient_UserGroupToHiddenUser
    CREATE TABLE #AppSCGUpdateClient_UserGroupToHiddenUser (
        userGroupId     INTEGER PRIMARY KEY,
        userId          INT
    )
	IF OBJECT_ID('tempdb.dbo.#AppSCGUpdateClient_CompanyClients') IS NOT NULL
		DROP TABLE #AppSCGUpdateClient_CompanyClients
	CREATE TABLE #AppSCGUpdateClient_CompanyClients (
		companyId	INT,
		clientId	INT,
		PRIMARY KEY (companyId, clientId)
	)
	DECLARE @clientGroupCreatorId INT
	DECLARE @createMappingUserId INT
	DECLARE @capabilityFlag INT = 0
	DECLARE @origCCId INT = 2
	DECLARE @isCompanyClient INT = 0
	DECLARE @t_userCaps TABLE (
		userId INT,
		nodeCap BIGINT,
		childCap BIGINT
	)
	DECLARE @isClientGroupHasSecurityConfig INT = 0
	IF (@i_clientId > 0)
	BEGIN
		SET @internalCId = @i_clientId
	END
	ELSE IF ((SELECT COUNT(*) FROM #AppSCGUpdateClientExtTable) = 1)	-- only 1 row, handle as simple case
	BEGIN
		SELECT
			@internalCId = clientId
		FROM #AppSCGUpdateClientExtTable
	END
	IF EXISTS (SELECT 1 FROM #AppSCGUpdateClientExtTable)
	BEGIN
		DECLARE @isCGList TINYINT = 0
		IF (@i_clientGroupList IS NOT NULL AND @i_clientGroupList <> '')
		BEGIN
			-- Smart Client Group Id List to work on
			INSERT INTO  #scgTable (scgId, ruleQuery, scopeType, scopeId)
				SELECT
					cg.id,	-- fixed typo while aliasing
					N'SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED; ' + NCHAR(10) + r.ruleQuery + N' ; ',
					s.entityType,
					s.entityId
				FROM (
						SELECT DISTINCT _ID FROM dbo.SplitIDs(@i_clientGroupList)
					) l
					INNER JOIN APP_ClientGroup cg  WITH(NOLOCK) ON
						cg.id = l._ID
						AND (cg.flag & @scgCGBit) > 0		-- SCG Client Group
						AND (cg.flag & @scgTenantBit) > 0	-- Refresh Tenant Plan or Company SCGs only
					INNER JOIN APP_SCGRule r WITH(NOLOCK) ON
						r.scgId = cg.id
					INNER JOIN APP_SCGScope s WITH(NOLOCK) ON
						s.scgRuleId = r.id
			SET @isRule = @@ROWCOUNT
			IF (@isRule = 0)
			BEGIN
				PRINT 'ERROR: AppSCGUpdateClient @i_clientGroupList argument contains no valid Plan or Company SCGIds.'
				RAISERROR('ERROR: AppSCGUpdateClient @i_clientGroupList argument contains no valid Plan or Company SCGIds.', 16, 1)
			END
			SET @isCGList = 1
		END
		ELSE
		BEGIN
			-- Process all Smart Client Groups
			INSERT INTO #scgTable (scgId, ruleQuery, scopeType, scopeId)
				SELECT
					cg.id,	-- fixed typo while aliasing
					N'SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED; ' + NCHAR(10) + r.ruleQuery + N' ; ',
					s.entityType,
					s.entityId
				FROM App_ClientGroup cg WITH(NOLOCK)
					INNER JOIN APP_SCGRule r WITH(NOLOCK) ON
						r.scgId = cg.id
					INNER JOIN APP_SCGScope s WITH(NOLOCK) ON
						s.scgRuleId = r.id
				WHERE (cg.flag & @scgCGBit) > 0			-- SCG Client Group
					AND (cg.flag & @scgTenantBit) = 0	-- Refresh ALL other SCGs excluding Tenant Plan or Company SCGs
		END
		-- Need an order list of SCGs so that dependent SCGs used by other SCGs are
		-- update first so that their clients can be properly inherited into the using SCGs.
		-- External Output Table
		IF OBJECT_ID('tempdb.dbo.#AppSCGRefreshClientGroupOrderingExtTbl') IS NOT NULL
			DROP TABLE #AppSCGRefreshClientGroupOrderingExtTbl
		CREATE TABLE #AppSCGRefreshClientGroupOrderingExtTbl (
			scgId		INTEGER PRIMARY KEY,
			updateOrder	INTEGER		-- Update in ascending order. value indicates the depth of dependency between all the groups in the list
		)
		IF OBJECT_ID('tempdb.dbo.#AppSCGRefreshRecurExtTable') IS not NULL
			DROP TABLE #AppSCGRefreshRecurExtTable
		-- External Input Table
		CREATE TABLE #AppSCGRefreshRecurExtTable (
			scgId		INT PRIMARY KEY
		)
		-- Populate the input external table with the SCG Ids to determine ordering
		DECLARE @scgRowCount INT = 0
		INSERT INTO #AppSCGRefreshRecurExtTable (scgId)
			SELECT
				t.scgId
			FROM #scgTable t
		SET @scgRowCount = @@ROWCOUNT
		IF (@scgRowCount = 0)
		BEGIN
			-- No SCGs to refresh
			GOTO END_PROC
		END
		-- New SP to compute client group ordering also used in AppSCGRefreshRecur SP
		DECLARE @spRC INT = 0
		EXEC @spRC = AppSCGRefreshClientGroupOrdering
		IF (@spRC > 0)
		BEGIN
			DECLARE @emsg VARCHAR(128) = 'Error[' + CAST(@spRC AS VARCHAR(12)) + ']: AppSCGRefreshClientGroupOrdering SP Failure.'
			PRINT 'AppSCGUpdateClient ' + @emsg
			RAISERROR(@emsg, 16, 1)
		END
		-- Update SCG Table with client group ordering
		UPDATE s
			SET updateOrder = o.updateOrder
		FROM #scgTable s
			INNER JOIN #AppSCGRefreshClientGroupOrderingExtTbl o ON
				o.scgId = s.scgId
		-- If client group id list processed, Ordering SP may have identified other client groups that need to be refreshed as well
		IF (@isCGList = 1)
		BEGIN
			-- Insert client groups found while computing ordering that need to be refreshed as well. Does NOT need to be associated to tenant or company!
			INSERT INTO #scgTable (scgId, ruleQuery, scopeType, scopeId, updateOrder)
				SELECT
					o.scgId,
					N'SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED; ' + NCHAR(10) + r.ruleQuery + N' ; ',
					s.entityType,
					s.entityId,
					o.updateOrder
				FROM #AppSCGRefreshClientGroupOrderingExtTbl o
					INNER JOIN App_ClientGroup cg WITH(NOLOCK) ON
						cg.id = o.scgId
					INNER JOIN APP_SCGRule r WITH(NOLOCK) ON
						r.scgId = cg.id
					INNER JOIN APP_SCGScope s WITH(NOLOCK) ON
						s.scgRuleId = r.id
					LEFT OUTER JOIN #scgTable i ON
						i.scgId = o.scgId
				WHERE
					(cg.flag & @scgCGBit) > 0			-- SCG Client Group
					AND i.scgId IS NULL					-- only insert ordering client group rows
		END
		DROP TABLE #AppSCGRefreshClientGroupOrderingExtTbl
		DROP TABLE #AppSCGRefreshRecurExtTable
		-- Perform Client Table processing on External Created Table
		DECLARE SCGUpdateClientCur CURSOR FOR
			SELECT
				s.scgId,
				s.ruleQuery,
				s.scopeType,
				s.scopeId,
				s.updateOrder
			FROM #scgTable s
			ORDER BY s.updateOrder ASC			-- negative to positive values
		OPEN SCGUpdateClientCur
		-- Process each SCG configured
		FETCH NEXT FROM SCGUpdateClientCur INTO @scgId,  @ruleQuery, @scopeType, @scopeId, @updateOrder
		WHILE @@fetch_status = 0
		BEGIN
			IF (@debug > 0)
			BEGIN
				PRINT 'AppSCGUpdateClient Processing SCGId=' + CAST(@scgId AS VARCHAR(12))
			END
			--check if this client should be in the smart client group
			--T--> ( add it if it does not exist)
			--F--> (remove it if it exists)
			IF (@internalCId > 0)
			BEGIN
				-- only determine if given client is in SCG, instead of computing all clients in the SCG
				SELECT @ruleQuery = REPLACE(@ruleQuery, '0/*GetAllClients*/', CAST(@internalCId AS NVARCHAR(12)))
			END
			-- Tell the SCG Rule the SCGId being processed so that Security Queries can ignore the group and NOT inherit from itself causing a chicken / egg issue.
			SELECT @ruleQuery = REPLACE(@ruleQuery, '0/*SCGProcessing*/', CAST(@scgId AS NVARCHAR(12)))
			-- get clients matching the SCG Rule
			INSERT INTO #tmpClientIdTable
				EXEC (@ruleQuery)
			IF (@isExcludeSetDisable IS NULL OR @isExcludeSetDisable = 0)
			BEGIN
				IF (@isExcludeSet > 0)
				BEGIN
					-- Delete Exclude Clients that should never appear in group
					DELETE tct
					FROM #tmpClientIdTable tct
						INNER JOIN @ExcludeClients ec ON
							ec.clientId = tct.clientId
				END
			END
			DECLARE @tClientId	INT
			DECLARE @scgClient	TINYINT
			DECLARE @cgaExist	TINYINT
			-- Cursor to identify if clients exist or not in the SCG results
			DECLARE SCGUpdateClientListCur CURSOR LOCAL FORWARD_ONLY READ_ONLY FOR
				SELECT
					t.clientId,
					CASE
						WHEN c.clientId IS NOT NULL THEN 1	-- client meets SCG Rule
						ELSE 0	-- not exist
					END scgClient,
					CASE
						WHEN cga.cgaExist IS NOT NULL THEN 1	-- exists
						ELSE 0	-- not exist
					END cgaExist
				FROM #AppSCGUpdateClientExtTable t
					LEFT OUTER JOIN #tmpClientIdTable c ON
						c.clientId = t.clientId
					OUTER APPLY (
						SELECT	-- only need to find 1 matching row
							1 cgaExist
						FROM APP_ClientGroupAssoc WITH(NOLOCK)
						WHERE clientId = t.clientId
							AND clientGroupId = @scgId
					) cga
				WHERE
					-- performance change to eliminate unneeded clientid processing in the cursor below
					-- if both cga.cgaExist and c.clientId are NOT NULL nothing to do since the client is already member of the SCG and still found by the rule query
					(	-- client delete from SCG
						cga.cgaExist IS NOT NULL		-- client was a member of group
						AND c.clientId IS NULL			-- client no longer found by the rule query
					)
					OR (	-- client add to SCG
						cga.cgaExist IS NULL			-- client is not a member of the group
						AND c.clientId IS NOT NULL		-- client is now found by the rule query
					)
			OPEN SCGUpdateClientListCur
			-- Process each client in the table and update SCG associations
			FETCH NEXT FROM SCGUpdateClientListCur INTO @tClientId, @scgClient, @cgaExist
			WHILE @@fetch_status = 0
			BEGIN
				IF (@scgClient = 1)
				BEGIN
					--add if does not exist
					IF (@cgaExist = 0)
					BEGIN
						IF (@doOnce = 0)	-- only do once per SCG on the first client processed
						BEGIN
							SET @clientGroupCreatorId = 0
							SET @isClientGroupHasSecurityConfig = 0
IF (@scopeType = 15)
							BEGIN
								 -- Does userGroupId to UserId mapping already exists
								SELECT
									@clientGroupCreatorId = ug.userId
								FROM #AppSCGUpdateClient_UserGroupToHiddenUser ug
								WHERE
									ug.userGroupId = @scopeId
								IF (@clientGroupCreatorId = 0)
								BEGIN
									-- Get / create user mapping to User Group
									SET @createMappingUserId = 0
									EXEC sec_getCreateAsUserId 0, 0, @createMappingUserId OUTPUT, 0, 0, @scopeId        -- UserGroupId
									-- save mapping only want to call this SP once in the Loop for performance reasons
									INSERT INTO #AppSCGUpdateClient_UserGroupToHiddenUser (userGroupId, userId)
										VALUES (@scopeId, @createMappingUserId)
									-- Set mapping User as the group creator
									SET @clientGroupCreatorId = @createMappingUserId
								END
							END
ELSE IF (@scopeType = 13)
							BEGIN
								-- Set User Scope Id as the creator
								SET @clientGroupCreatorId = @scopeId
							END
IF (@scopeType IN ( 15, 13 ))
							BEGIN
								IF EXISTS (
										SELECT 1
										FROM UMSecurityAssociations WITH (NOLOCK)
WHERE entityType1 = 28		-- CLIENT_GROUP_ENTITY
											AND entityID1 = @scgID
											AND isCreator = 0
								)
								BEGIN
									SET @isClientGroupHasSecurityConfig = 1
								END
							END
							SET @doOnce = 1
						END
						SET @capabilityFlag = 0		-- Unset this variable every iteration and set it in the following block if needed.
IF (@scopeType IN ( 15, 13 ))
						BEGIN
							IF @clientGroupCreatorId > 0
							BEGIN
								EXEC sec_getPermissionsOnEntity '#clientGroupPermissionList',
									@clientGroupCreatorId,
3,			-- CLIENT_ENTITY
									@tClientId
								IF NOT EXISTS (
										SELECT 1
										FROM #clientGroupPermissionList
WHERE permissionId = 2		-- EV_MANAGE_APPLICATION
								)
								BEGIN
									SET @capabilityFlag = 0
								END
								ELSE
								BEGIN
									SET @capabilityFlag = 1
								END
								IF @isClientGroupHasSecurityConfig = 1
									AND NOT EXISTS (
										SELECT 1
										FROM #clientGroupPermissionList
WHERE permissionId = 107		-- CAT_USER_MANAGMENT_ASSOC_ON_ENTITY
								)
								BEGIN
									SET @capabilityFlag = 0
								END
								-- done with data, delete for next client loop
								TRUNCATE TABLE #clientGroupPermissionList
							END	-- IF @clientGroupCreatorId > 0
							ELSE
							BEGIN
								SET @capabilityFlag = 0 --don't insert client if the creator doesn't exist
							END
						END
						SET @isCompanyClient = 0
IF (@scopeType = 61)
						BEGIN
							-- Company scope only use company associated clients
							IF NOT EXISTS (SELECT TOP 1 1 FROM  #AppSCGUpdateClient_CompanyClients WHERE companyId = @scopeId)
							BEGIN
								-- Company Clients need to be populated only once during an iteration
								INSERT INTO #AppSCGUpdateClient_CompanyClients (companyId, clientId)
									SELECT
										@scopeId,
										clientid
									FROM (
											-- Get all the clients associated to this Company
											SELECT		-- Installed by Tenant Admin
												clientId
											FROM dbo.scgV2CompanyClientInstallAssociations('=', @scopeId, 0, 0)
											UNION
											SELECT		-- By Association
												clientId
											FROM dbo.scgV2CompanyClientAssociations('=', @scopeId, 0, 0)
										) q
							END
							-- Does the current client belong to the Company
							SELECT TOP 1
								@isCompanyClient = 1
							FROM #AppSCGUpdateClient_CompanyClients
							WHERE
								companyId = @scopeId
								AND clientId = @tClientId
						END
						-- @capabilityFlag applies for User and User Group Entities that have permissions to add to the client group
						-- @isCompanyClient applies for Provider Entities when it is a company client and can be added to the client group
						-- COMMCELL_ENTITY can always just add to the client group
IF (@capabilityFlag = 1 OR @scopeType = 1 OR @isCompanyClient = 1)
						BEGIN
                            -- We are facing issue when this same SP is called by 2 different process simulatenously post installation.
                            -- Call originate from 2 entry points - AppSetSpecialClientStatesSCGAsync and AppPlanPostInstallActions
                            -- so, this code will ensure no one gets failed and try to insert same row again
                            -- We don't want explicit IF check because we are in different transactions
                            -- We don't want merge as it do much more than what is expected
							INSERT INTO APP_ClientGroupAssoc (clientGroupId, clientId)
								SELECT @scgId, @tClientId
								WHERE NOT EXISTS (SELECT 1 FROM APP_ClientGroupAssoc cga WITH(NOLOCK) WHERE cga.clientGroupId = @scgId AND cga.clientId = @tClientId)
									-- Is Client Deleted - timing issue with WorKQueueRequest being processed after client deleted and incurring FK constraint on APP_ClientGroupAssoc insert
									AND EXISTS (SELECT 1 FROM APP_Client c WHERE c.id = @tClientId)		-- want clean read here so NOLOCK removed
							SET @rcnt = @@ROWCOUNT
							IF (@rcnt > 0)
							BEGIN
								--Audit
								EXEC AppAuditClientGroupUpdate @i_uid,
									@tClientId,
									@scgId,
									1
							END
						END
					END		-- IF (@cgaExist = 0)
				END		-- IF (@scgClient = 1)
				ELSE
				BEGIN
					--remove it if it exists
					IF (@cgaExist = 1)
					BEGIN
						-- {Previously creator security never ever checked on the deletion side of this SP? So leaving unchanged.
						-- Bascially the client if it exist no longer meets the SCG Rules of being in the client group
						-- so remove the clients association to the client group if it exists.
						DELETE
						FROM APP_ClientGroupAssoc
						WHERE clientId = @tClientId
							AND clientGroupId = @scgId
						SET @rcnt = @@ROWCOUNT		-- unlikely but possible, so avoid filling a false audit report
                        IF (@rcnt > 0)
	                    BEGIN
							--Audit
							EXEC AppAuditClientGroupUpdate @i_uid,
								@tClientId,
								@scgId,
								0
						END
					END
				END	-- IF (@scgClient = 1) ELSE
				FETCH NEXT FROM SCGUpdateClientListCur INTO @tClientId, @scgClient, @cgaExist
			END
			CLOSE SCGUpdateClientListCur
			DEALLOCATE SCGUpdateClientListCur
			-- clean SCG Table for the next SCG to process
			TRUNCATE TABLE #tmpClientIdTable
			SET @doOnce = 0
			-- Get the next SCG Id
			FETCH NEXT FROM SCGUpdateClientCur INTO @scgId,  @ruleQuery, @scopeType, @scopeId, @updateOrder
		END
		CLOSE SCGUpdateClientCur
		DEALLOCATE SCGUpdateClientCur
	END	-- IF EXISTS (SELECT 1 FROM #AppSCGUpdateClientExtTable)
END_PROC:
	IF OBJECT_ID('tempdb.dbo.#tmpClientIdTable') IS NOT NULL
		DROP TABLE #tmpClientIdTable
	IF OBJECT_ID('tempdb.dbo.#clientGroupPermissionList') IS NOT NULL
		DROP TABLE #clientGroupPermissionList
	IF (@extTableCreate = 1
		AND OBJECT_ID('tempdb.dbo.#AppSCGUpdateClientExtTable') IS NOT NULL
	)
	BEGIN
		-- Temp Table created internally
		DROP TABLE #AppSCGUpdateClientExtTable
	END
	RETURN;
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppSCGUpdateClient')
	delete from GxQscripts where name = 'AppSCGUpdateClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSCGUpdateClient')
	delete from GXDBVersions where aliasname = 'AppSCGUpdateClient'
GO

insert into GXDBVersions values(2, 'AppSCGUpdateClient',  'v1.11.48.28.8.1', 'AppSCGUpdateClient', 'v1.11.48.28.8.1')
GO

