

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSCGRefreshRecur.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSCGRefreshRecur.sp,v $ $Id: AppSCGRefreshRecur.sp,v 1.23.2.22.8.1 2021/04/22 18:29:10 jswaminathan Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppSCGRefreshRecur')
BEGIN
	print '>>> Drop Stored Procedure: AppSCGRefreshRecur <<<'
	drop procedure AppSCGRefreshRecur
END
IF EXISTS (select * from GxQscripts where name='AppSCGRefreshRecur')
	delete from GxQscripts where name = 'AppSCGRefreshRecur'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSCGRefreshRecur')
	delete from GXDBVersions where aliasname = 'AppSCGRefreshRecur'
GO
print '... Creating Procedure: AppSCGRefreshRecur'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppSCGRefreshRecur
-- Input arguments
  @i_uid INT, 
-- i_refreshId is an inputted UNIX Time
  @i_refreshId INT,
--if i_scgId=-1, use externally created temp table #AppSCGRefreshRecurExtTable contain list of scgIds to process
  @i_scgId INT
AS
BEGIN
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	-- instrumentation for performance and debug monitoring
	DECLARE @debug INT = 0
	SELECT
		@debug = CAST(value AS INT)
	FROM GXGlobalParam WITH(NOLOCK)
	WHERE
		name = N'AppSCGRefreshRecurLogging'
		AND modified = 0
	-- rolling back SCG Refresh Time Interval but leaving last time SCG refreshed
	--DECLARE @rn INT = dbo.GetUnixTime(GetUTCDate())
	--DECLARE @st INT = 1
	--DECLARE @sdt DATETIME2
	--DECLARE @edt DATETIME2
	--DECLARE @getIdaObjectsForUserMS BIGINT = 0
	--DECLARE @getuserObjectsMS BIGINT = 0
	--DECLARE @canAddClientToClientGroupMS BIGINT = 0
	--DECLARE @getCreateAsUserIdMS BIGINT = 0
	DECLARE @CurrentTime	INTEGER = dbo.GetUnixTime(GetUTCDate())
	DECLARE @newSecurity	INTEGER = dbo.isNewSecurity()
	DECLARE @refreshed		TINYINT = 0
	DECLARE @cgExists		TINYINT = 0
	DECLARE @isSCG			TINYINT = 0
	DECLARE @scgId			INTEGER = 0
	DECLARE @cgName			NVARCHAR(512) = ''
	DECLARE @ruleQuery		NVARCHAR(MAX) = ''
	DECLARE @scopeType		INT = 0
	DECLARE @scopeId		INT = 0
	DECLARE @clientGroupCreatorId		INTEGER = 0
	DECLARE @cantAddClient				INTEGER = 0
	DECLARE @isUMSecurityCheckNeeded	INTEGER = 0
	DECLARE @userGroupList				NVARCHAR(MAX) = ''
	DECLARE @capabilitiesWant			BIGINT = 0
	DECLARE @commcellLevelCaps			BIGINT = 0
	DECLARE @capsToBeChecked			BIGINT = 0
	DECLARE @createAsUserGroupId		INTEGER = 0
	DECLARE @exitCode					INTEGER = 0		-- success
	DECLARE @creatorHasRightsOnCC		INT = 0
	DECLARE @createMappingUserId		INT = 0
	DECLARE @creatorDeleted				TINYINT = 0
	DECLARE @companyId					INTEGER = 0
	DECLARE @extTableCreate TINYINT = 0		-- 1 indicates SP created the temp table, 0 externally created by caller of SP
	IF OBJECT_ID('tempdb.dbo.#AppSCGRefreshRecurExtTable') IS NULL
	BEGIN
		-- External Inputted Table does not exist
		CREATE TABLE #AppSCGRefreshRecurExtTable (
			scgId		INT PRIMARY KEY
		)
		INSERT INTO #AppSCGRefreshRecurExtTable (scgId) VALUES (@i_scgId)
		SET @extTableCreate = 1
	END
	IF OBJECT_ID('tempdb.dbo.#SCGTable') IS NOT NULL
		DROP TABLE #SCGTable
	CREATE TABLE #SCGTable (
		scgId			INTEGER,
		scgRefreshed	TINYINT,
		cgExists		TINYINT,
		isSCG			TINYINT,
		cgName			NVARCHAR(512),
		ruleQuery		NVARCHAR(MAX),
		updateOrder		INTEGER,
		scopeType		INT,			-- entityType
		scopeId			INT,			-- entityId
		companyId		INT,			-- companyId of the SCG.
		PRIMARY KEY (updateOrder DESC, scgId)
	)
	-- Clients to always Exclude from SCG Listings
	-- CS Clustered Physical Clients
	DECLARE @isExcludeSet	INT = 0
	DECLARE @ExcludeClients TABLE (
		clientId	INT PRIMARY KEY
	)
	-- Get key to check for reverting to orignal implementation of no excluding clients
	DECLARE @isExcludeSetDisable	INT = 0
	SELECT
		@isExcludeSetDisable = CAST(p.value AS INT)
	FROM GXGlobalParam p WITH(NOLOCK)
	WHERE
		name = N'DisableSCGExcludeClientSet'
	IF (@isExcludeSetDisable IS NULL OR @isExcludeSetDisable = 0)
	BEGIN
		INSERT INTO @ExcludeClients (clientId)
			SELECT PMClientId
			FROM APP_VMToPMMap WITH(NOLOCK)
			WHERE VMClientId = 2	-- CS Id
		SET @isExcludeSet = @@ROWCOUNT
	END
	IF EXISTS (SELECT 1 FROM #AppSCGRefreshRecurExtTable)
	BEGIN
		DECLARE @csName NVARCHAR(255) = (
			SELECT NAME
			FROM APP_Client WITH (NOLOCK)
			WHERE id = 2
		)
		IF OBJECT_ID('tempdb.dbo.#newClientIdTable') IS NOT NULL
			DROP TABLE #newClientIdTable
		CREATE TABLE #newClientIdTable (
			newClientId INTEGER PRIMARY KEY
		)
		IF OBJECT_ID('tempdb.dbo.#oldClientIdTable') IS NOT NULL
			DROP TABLE #oldClientIdTable
		CREATE TABLE #oldClientIdTable (
			oldClientId INTEGER PRIMARY KEY
		)
		IF OBJECT_ID('tempdb.dbo.#filteredClientIdTable') IS NOT NULL
			DROP TABLE #filteredClientIdTable
		CREATE TABLE #filteredClientIdTable (
			filteredClientId INTEGER PRIMARY KEY
		)
		IF OBJECT_ID('tempdb.dbo.#deletedClient') IS NOT NULL
			DROP TABLE #deletedClient
		CREATE TABLE #deletedClient (
			deletedClientId INTEGER PRIMARY KEY,
			name NVARCHAR(1024)
		)
		IF OBJECT_ID('tempdb.dbo.#addedClient') IS NOT NULL
			DROP TABLE #addedClient
		CREATE TABLE #addedClient (
			addedClientId INTEGER PRIMARY KEY,
			name NVARCHAR(1024)
		)
		IF OBJECT_ID('tempdb.dbo.#scgTable2') IS NOT NULL
			DROP TABLE #scgTable2
		CREATE TABLE #scgTable2 (
			scgIds INTEGER PRIMARY KEY
		)
		-- Temp tables to be used every iteration to pass Sec_GetIDAObjectsForUser.sp
		IF object_id('tempdb.dbo.#AppSCGRefreshRecur_userObjectsAgentMgmt') is not null
			DROP TABLE #AppSCGRefreshRecur_userObjectsAgentMgmt
		CREATE TABLE #AppSCGRefreshRecur_userObjectsAgentMgmt (
			clientId INT,
			appTypeId INT,
			instanceId INT,
			backupsetId INT,
			subclientId INT
		)
		IF object_id('tempdb.dbo.#AppSCGRefreshRecur_userObjectsUserMgmt') is not null
			DROP TABLE #AppSCGRefreshRecur_userObjectsUserMgmt
		CREATE TABLE #AppSCGRefreshRecur_userObjectsUserMgmt (
			clientId INT,
			appTypeId INT,
			instanceId INT,
			backupsetId INT,
			subclientId INT
		)
		-- Temp Table to consolidate the above table data into a smaller row per user to cache
		-- for future use in another iteration loop so that the above SP to populate the above
		-- table for a user needs to be executed again, thereby improving performance.
		IF object_id('tempdb.dbo.#AppSCGRefreshRecur_userObjectsByUser_AM') is not null
			DROP TABLE #AppSCGRefreshRecur_userObjectsByUser_AM
		CREATE TABLE #AppSCGRefreshRecur_userObjectsByUser_AM (
			userId			INT,
			clientId		INT,
			appTypeId		INT,
			instanceId		INT,
			backupsetId		INT,
			subClientId		INT
		)
		CREATE CLUSTERED INDEX AppSCGRefreshRecur_userObjectsByUser_AM_idx ON #AppSCGRefreshRecur_userObjectsByUser_AM (userId, clientId, appTypeId, instanceId, backupsetId, subClientId)
		IF object_id('tempdb.dbo.#AppSCGRefreshRecur_userObjectsByUser_UM') is not null
			DROP TABLE #AppSCGRefreshRecur_userObjectsByUser_UM
		CREATE TABLE #AppSCGRefreshRecur_userObjectsByUser_UM (
			userId			INT,
			clientId		INT,
			appTypeId		INT,
			instanceId		INT,
			backupsetId		INT,
			subClientId		INT
		)
		CREATE CLUSTERED INDEX AppSCGRefreshRecur_userObjectsByUser_UM_idx ON #AppSCGRefreshRecur_userObjectsByUser_UM (userId, clientId, appTypeId, instanceId, backupsetId, subClientId)
		IF object_id('tempdb.dbo.#AppSCGRefreshRecur_userCommCellCaps') is not null
			DROP TABLE #AppSCGRefreshRecur_userCommCellCaps
		CREATE TABLE #AppSCGRefreshRecur_userCommCellCaps (
			userId						INTEGER PRIMARY KEY,
			creatorHasRightsOnCC		TINYINT				-- CC Sec Level set
		)
		-- Table to map UserGroupId to their hidden UserId
		IF object_id('tempdb.dbo.#AppSCGRefreshRecur_UserGroupToHiddenUser') is not null
			DROP TABLE #AppSCGRefreshRecur_UserGroupToHiddenUser
		CREATE TABLE #AppSCGRefreshRecur_UserGroupToHiddenUser (
			userGroupId		INTEGER PRIMARY KEY,
			userId			INT
		)
		-- Need an order list of SCGs so that dependent SCGs used by other SCGs are
		-- update first so that their clients can be properly inherited into the using SCGs.
		IF OBJECT_ID('tempdb.dbo.#AppSCGRefreshClientGroupOrderingExtTbl') IS NOT NULL
			DROP TABLE #AppSCGRefreshClientGroupOrderingExtTbl
		CREATE TABLE #AppSCGRefreshClientGroupOrderingExtTbl (
			scgId		INTEGER PRIMARY KEY,
			updateOrder	INTEGER		-- Update in ascending order. value indicates the depth of dependency between all the groups in the list
		)
		-- New SP to compute client group ordering also used in APPSCGUpdateClient SP
		EXEC @exitCode = AppSCGRefreshClientGroupOrdering
		IF (@exitCode > 0)
		BEGIN
			PRINT 'AppSCGRefreshRecur Error: AppSCGRefreshClientGroupOrdering SP Failure'
			RETURN @exitCode
		END
		-- Create the master list of client groups and associated information needed to perform the refresh
		INSERT INTO #SCGTable (scgId, scgRefreshed, cgExists, isSCG, cgName, ruleQuery, updateOrder, scopeType, scopeId, companyId)
			SELECT
				et.scgId,
				CASE	-- has client group already been refreshed?
					WHEN cgr.refreshId IS NOT NULL THEN 1		-- found matching input time so group already refreshed
					ELSE 0		-- group eligible for refreshing
				END scgRefreshed,
				CASE	-- does clientgroup actually exist?
					WHEN cg.id IS NOT NULL THEN 1
					ELSE 0
				END cgExists,
				CASE	-- is it a SCG if it exists?
					WHEN cg.flag IS NOT NULL AND (cg.flag & 4096) <> 0 THEN 1		-- CV_FLAG_SMART_CLIENT_GROUP
					ELSE 0
				END isSCG,
				cg.name cgName,
				sr.ruleQuery ruleQuery,
				et.updateOrder,
				cgs.entityType,
				cgs.entityId,
				CASE
					WHEN ACE.companyId IS NOT NULL THEN ACE.companyId
					ELSE 0
				END companyId
			FROM #AppSCGRefreshClientGroupOrderingExtTbl et
				LEFT OUTER JOIN App_SCGClientGroupRefreshed cgr WITH(NOLOCK) ON
					cgr.refreshedGrpId = et.scgId
					AND cgr.refreshId = @i_refreshId
				LEFT OUTER JOIN APP_ClientGroup cg WITH(NOLOCK) ON
					cg.id = et.scgId
				LEFT OUTER JOIN App_SCGRule sr WITH(NOLOCK) ON
					sr.scgId = cg.id
				LEFT OUTER JOIN APP_SCGScope cgs WITH(NOLOCK) ON
					cgs.scgRuleId = sr.id
				LEFT OUTER JOIN APP_CompanyEntities ACE WITH(NOLOCK) ON
cg.id = ACE.entityId AND ACE.entityType = 28
			-- Perform Client Table processing on External Created Table
			DECLARE @updateOrder INT
			DECLARE SCGRefreshRecurCur CURSOR LOCAL FORWARD_ONLY READ_ONLY FOR
				SELECT
					scgId,
					scgRefreshed,
					cgExists,
					isSCG,
					cgName,
					ruleQuery,
					updateOrder,
					scopeType,
					scopeId,
					companyId
				FROM #SCGTable
				ORDER BY updateOrder ASC		-- negative to positive values
			OPEN SCGRefreshRecurCur
			-- Process each SCG configured
			FETCH NEXT FROM SCGRefreshRecurCur INTO @scgId, @refreshed, @cgExists, @isSCG, @cgName, @ruleQuery, @updateOrder, @scopeType, @scopeId, @companyId
			WHILE @@fetch_status = 0
			BEGIN
				IF (@debug > 0)
				BEGIN
					PRINT 'SCGRefreshRecurCur Ordering: ' +
						' @updateOrder=[' + CAST(@updateOrder AS VARCHAR(12)) +
						'] @scgId=[' + CAST(@scgId AS VARCHAR(12)) +
						'] @cgName=[' + @cgName +
						'] @cgExists=[' + CAST(@cgExists AS VARCHAR(12)) +
						'] @refreshed=[' + CAST(@refreshed AS VARCHAR(12)) +
						'] @isSCG=[' + CAST(@isSCG AS VARCHAR(12)) + ']' +
						'] @scopeType=[' + CAST(@scopeType AS VARCHAR(12)) + ']' +
						'] @scopeId=[' + CAST(@scopeId AS VARCHAR(12)) + ']' +
						'] @companyId=[' + CAST(@companyId AS VARCHAR(12))
				END
				IF (@refreshed = 1)
				BEGIN
					-- Already refreshed
					GOTO SCG_GetNextRow
				END
				-- Does group exists?
				IF (@cgExists = 0)
				BEGIN
					-- Group does not exist, by pass
					GOTO SCG_GetNextRow
				END
				--If its a smart group refresh this and the associations else just refresh the associations.
				IF (@isSCG = 1)
				BEGIN
					-- make sure temp tables are empty for processing of the client group
					TRUNCATE TABLE #AppSCGRefreshRecur_userObjectsAgentMgmt
					TRUNCATE TABLE #AppSCGRefreshRecur_userObjectsUserMgmt
					TRUNCATE TABLE #newClientIdTable
					TRUNCATE TABLE #oldClientIdTable
					TRUNCATE TABLE #deletedClient
					TRUNCATE TABLE #addedClient
					TRUNCATE TABLE #filteredClientIdTable
					-- Tell the SCG Rule the SCGId being processed so that Security Queries can ignore the group and NOT inherit from itself causing a chicken / egg issue.
					SELECT @ruleQuery = REPLACE(@ruleQuery, '0/*SCGProcessing*/', CAST(@scgId AS NVARCHAR(12)))
					-- Get all the clientIds associated with the SCG Rule.
					INSERT INTO #newClientIdTable
						EXEC (@ruleQuery)
					IF (@isExcludeSetDisable IS NULL OR @isExcludeSetDisable = 0)
					BEGIN
						IF (@isExcludeSet > 0)
						BEGIN
							-- Delete Exclude Clients that should never appear in group
							DELETE nct
							FROM #newClientIdTable nct
								INNER JOIN @ExcludeClients ec ON
									ec.clientId = nct.newClientId
						END
					END
					-- Get the configured list of clientIds assocaited with client group.
					INSERT INTO #oldClientIdTable
						SELECT
							clientId
						FROM APP_ClientGroupAssoc WITH(NOLOCK)
						WHERE clientGroupId = @scgId
					-- Use by User and UserGroup entities
					SET @clientGroupCreatorId = 0
					SET @creatorDeleted = 0
IF (@scopeType = 15)
					BEGIN
						-- Does userGroupId to UserId mapping already exists
						SELECT
							@clientGroupCreatorId = ug.userId
						FROM #AppSCGRefreshRecur_UserGroupToHiddenUser ug
						WHERE
							ug.userGroupId = @scopeId
						IF (@clientGroupCreatorId = 0)
						BEGIN
							-- Get / create user mapping to User Group
							SET @createMappingUserId = 0
							EXEC sec_getCreateAsUserId 0, 0, @createMappingUserId OUTPUT, 0, 0, @scopeId		-- UserGroupId
							-- save mapping only want to call this SP once in the Loop for performance reasons
							INSERT INTO #AppSCGRefreshRecur_UserGroupToHiddenUser (userGroupId, userId)
								VALUES (@scopeId, @createMappingUserId)
							-- Set mapping User as the group creator
							SET @clientGroupCreatorId = @createMappingUserId
						END
					END
ELSE IF (@scopeType = 13)
					BEGIN
						-- Set User Scope Id as the creator
						SET @clientGroupCreatorId = @scopeId
					END
					IF (@clientGroupCreatorId > 0)
					BEGIN
						-- Verify if user / group has been deleted and NOT transferred properly.
						-- Pre SP17 issue where this code was not being executed previously for deleted client group users / owners and therefore
						-- removing all the client associations. So to maintain similar operations, this code is being removed in SP17 so that
						-- the same behavior still exist going forward in the application.
						SELECT
							@creatorDeleted = 1
						FROM UMUsers u WITH(NOLOCK)
						WHERE
							u.id = @clientGroupCreatorId
							AND u.login LIKE '%(Deleted,%'
					END
					SET @cantAddClient = 0
					SET @isUMSecurityCheckNeeded = 0
					SET @userGroupList = ''
					--Create the new associations
					IF (
@scopeType IN (1, 61)		-- by passing any security checks for these scopes
						OR @clientGroupCreatorId > 0		-- User Security Check Good
					)
					BEGIN
IF (@scopeType IN ( 13 , 15 ))
						BEGIN
							--Verify if user management cap is needed to check , only if more than master and view all group is associated.
							--If client group creater is sharing clients with other, than creater should have User management on all user group assoicated
							--and all the clients.
							SET @creatorHasRightsOnCC = 0
							IF NOT EXISTS (SELECT 1 FROM #AppSCGRefreshRecur_userCommCellCaps WHERE userId = @clientGroupCreatorId)
							BEGIN
								-- First hit for this creator. Load all information.
								-- check to see if master
								SELECT @creatorHasRightsOnCC = 1
								FROM UMGroups G
								INNER JOIN UMUserGroup UG ON
									G.id = UG.groupId
									AND (G.groupFlags & 8) = 8		-- GF_GROUP_MASTER
									AND UG.userId = @clientGroupCreatorId
								-- check to see if he has rights on Commcell.
								IF @creatorHasRightsOnCC = 0
								BEGIN
EXEC sec_checkPermissionOnEntity @clientGroupCreatorId, '2,107' /*EV_MANAGE_APPLICATION,CAT_USER_MANAGMENT_ASSOC_ON_ENTITY*/, @creatorHasRightsOnCC OUTPUT, 1, 2,
										0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1                    --isAndOperation
								END
								INSERT INTO #AppSCGRefreshRecur_userCommCellCaps (userId, creatorHasRightsOnCC)
									VALUES (@clientGroupCreatorId, @creatorHasRightsOnCC)
								IF @creatorHasRightsOnCC = 0			-- If creator has right on CC, then no need to load individual tables.
								BEGIN
									-- Creator does not have rights on CC. So load individual clients.
									EXEC sec_getIdaObjectsForUser @clientGroupCreatorId, 3 /*CLIENT_ITEM*/, 2 /*EV_MANAGE_APPLICATION*/, 0, '#AppSCGRefreshRecur_userObjectsAgentMgmt'
									EXEC sec_getIdaObjectsForUser @clientGroupCreatorId, 3 /*CLIENT_ITEM*/, 107 /*CAT_USER_MANAGMENT_ASSOC_ON_ENTITY*/, 0, '#AppSCGRefreshRecur_userObjectsUserMgmt'
									INSERT INTO #AppSCGRefreshRecur_userObjectsByUser_AM
										SELECT
											@clientGroupCreatorId,
											t.clientId,
											t.appTypeId,
											t.instanceId,
											t.backupsetId,
											t.subClientId
										FROM #AppSCGRefreshRecur_userObjectsAgentMgmt t
									INSERT INTO #AppSCGRefreshRecur_userObjectsByUser_UM
										SELECT
											@clientGroupCreatorId,
											t.clientId,
											t.appTypeId,
											t.instanceId,
											t.backupsetId,
											t.subClientId
										FROM #AppSCGRefreshRecur_userObjectsUserMgmt t
								END			-- @creatorHasRightsOnCC = 0
							END			-- IF NOT EXISTS (SELECT 1 FROM #AppSCGRefreshRecur_userCommCellCaps WHERE userId = @clientGroupCreatorId)
							ELSE
							BEGIN
								SELECT @creatorHasRightsOnCC = creatorHasRightsOnCC
								FROM #AppSCGRefreshRecur_userCommCellCaps
								WHERE userId = @clientGroupCreatorId
							END
							-- if not admin check user rights
							IF (@creatorHasRightsOnCC = 0)
							BEGIN
								EXEC sec_canAddClientToClientGroup @clientGroupCreatorId, @scgId, 0, '<App_PerformClientGroupReq></App_PerformClientGroupReq>',
										0, @cantAddClient OUTPUT, @isUMSecurityCheckNeeded OUTPUT, @userGroupList OUTPUT
							END
						END
IF (@scopeType IN ( 13 , 15 ) AND @cantAddClient <> 0)
						BEGIN
							--Few user groups are associated on which creater dont have user management cap, so dropping all the clients
							INSERT INTO #deletedClient (deletedClientId)
								SELECT
									oldClientId
								FROM #oldClientIdTable --As per Amey remove all the associated client to the group when creator info is not present
						END		-- IF (@cantAddClient <> 0)
						ELSE
						BEGIN
IF (@scopeType IN ( 13 , 15 ))
							BEGIN
								IF (@creatorHasRightsOnCC = 1)			-- insert every thing from #newClientIDTable
								BEGIN
									INSERT INTO #filteredClientIdTable
										SELECT
											newClientId
										FROM #newClientIdTable
								END
								ELSE
								BEGIN
									IF @isUMSecurityCheckNeeded = 1		-- insert the clients on which creator has AM and UM
									BEGIN
										INSERT INTO #filteredClientIdTable
											SELECT
												newClientId
											FROM #newClientIdTable
											INTERSECT
											SELECT
												AM.clientId
											FROM #AppSCGRefreshRecur_userObjectsByUser_AM AM
											WHERE
												userId = @clientGroupCreatorId
											INTERSECT
											SELECT
												UM.clientID
											FROM #AppSCGRefreshRecur_userObjectsByUser_UM UM
											WHERE
												userID = @clientGroupCreatorId
									END
									ELSE								-- insert the clients on which creator has AM
									BEGIN
										INSERT INTO #filteredClientIdTable
											SELECT
												newClientId
											FROM #newClientIdTable
											INTERSECT
											SELECT
												AM.clientId
											FROM #AppSCGRefreshRecur_userObjectsByUser_AM AM
											WHERE
												userId = @clientGroupCreatorId
									END
								END
							END
ELSE IF (@scopeType = 1)
							BEGIN
								-- Commcell Scope all clients
								INSERT INTO #filteredClientIdTable
									SELECT
										newClientId
									FROM #newClientIdTable
							END
ELSE IF (@scopeType = 61)
							BEGIN
								-- Company scope only company clients
								-- Clients okay to associate with client group scope
								INSERT INTO #filteredClientIdTable
									SELECT
										newClientId
									FROM #newClientIdTable
									INTERSECT
									SELECT
										clientid
									FROM (
											-- Get all the clients associated to this Company
											SELECT		-- Installed by Tenant Admin
												clientId
											FROM dbo.scgV2CompanyClientInstallAssociations('=', @scopeId, 0, 0)
											UNION
											SELECT		-- By Association
												clientId
											FROM dbo.scgV2CompanyClientAssociations('=', @scopeId, 0, 0)
										) q
							END
							IF @companyId <> 0
							BEGIN
								DELETE Temp
								FROM #filteredClientIdTable Temp
									INNER JOIN APP_CompanyEntities ACE
ON ACE.entityType = 3 AND Temp.filteredClientId = ACE.entityId AND ACE.companyId <> 0 AND ACE.companyId <> @companyId
									LEFT OUTER JOIN CompanyFlatHierarchyView PCT1
										ON ACE.companyId = PCT1.parentCompanyId AND PCT1.childCompanyId = @companyId
									LEFT OUTER JOIN CompanyFlatHierarchyView PCT2
										ON ACE.companyId = PCT2.childCompanyId AND PCT2.parentCompanyId = @companyId
								WHERE (PCT1.parentCompanyId IS NULL) AND (PCT2.childCompanyId IS NULL)
							END
							INSERT INTO #addedClient (addedClientId)
								SELECT
									filteredClientId
								FROM #filteredClientIdTable
								EXCEPT
								SELECT
									oldClientId
								FROM #oldClientIdTable
							INSERT INTO #deletedClient (deletedClientId)
								SELECT
									oldClientId
								FROM #oldClientIdTable
								WHERE @creatorDeleted = 0		-- Only remove clients from the client group for valid owners, companies, etc.
																-- This is here to maintain pre SP17 behavior going forward were clients are not
																-- de-associated from the client group when the user / user group has been deleted
																-- and NOT transferred.
								EXCEPT
								SELECT
									filteredClientId
								FROM #filteredClientIdTable
						END		-- IF (@cantAddClient <> 0) ELSE
					END
					ELSE -- creator user has been deleted
					BEGIN
						-- Should on get here is client group scope is USER_ENTITY and no creator rights or user deleted.
						INSERT INTO #deletedClient (deletedClientId)
							SELECT
								oldClientId
							FROM #oldClientIdTable --As per Amey remove all the associated client to the group when creator info is not present
					END		-- IF (@clientGroupCreatorId > 0) ELSE
					-- delete the current configure clientIds from the client group
					DELETE FROM cga
					FROM APP_ClientGroupAssoc cga
					WHERE clientGroupId = @scgId
						AND clientId IN (
							SELECT deletedClientId
							FROM #deletedClient
						)
					-- associate the new clientIds to the client group - refreshed
					INSERT INTO APP_ClientGroupAssoc (
						clientGroupId,
						clientId
					)
						SELECT
							@scgId,
							ac.addedClientId
						FROM #addedClient ac
						-- this join could possibly cause a long block query to avoid use EXISTS sub-query to hit only 1 row at a time
						--	INNER JOIN APP_Client c ON
						--		c.id = ac.addedClientId
						WHERE
							-- only add client that exist, not physically deleted.  Timing issue where client was physically deleted while adding association, MR177375. Cannot use NOLOCK.
							EXISTS (SELECT c.id FROM APP_Client c WHERE c.id = ac.addedClientId)	-- cost more than the join but can avoid blocks.
				END		-- IF (@isSCG = 1)
				-- Update row that this SCG has been refreshed
				DECLARE @refreshCnt INT = 0
				UPDATE App_SCGClientGroupRefreshed
					SET refreshId = @i_refreshId
				WHERE refreshedGrpId = @scgId
				SET @refreshCnt = @@ROWCOUNT
				IF (@refreshCnt = 0)
				BEGIN
					-- New SCG insert row
					INSERT INTO App_SCGClientGroupRefreshed (refreshId, refreshedGrpId)
						VALUES (@i_refreshId, @scgId)
				END
				-- Process the next client group row
			SCG_GetNextRow:
				FETCH NEXT FROM SCGRefreshRecurCur INTO @scgId, @refreshed, @cgExists, @isSCG, @cgName, @ruleQuery, @updateOrder, @scopeType, @scopeId, @companyId
			END	-- WHILE @@fetch_status = 0
SCG_ExitCursorLoop:
			CLOSE SCGRefreshRecurCur
			DEALLOCATE SCGRefreshRecurCur
	END	-- IF EXISTS (SELECT 1 FROM #AppSCGRefreshRecurExtTable)
	ELSE
	BEGIN
		PRINT 'AppSCGRefreshRecur Error: no inputted data to process in external temp table #AppSCGRefreshRecurExtTable'
		SET @exitCode = 1		-- failure
	END		-- ELSE IF EXISTS (SELECT 1 FROM #AppSCGRefreshRecurExtTable)
	IF (@extTableCreate = 1 AND OBJECT_ID('tempdb.dbo.#AppSCGRefreshRecurExtTable') IS NOT NULL)
	BEGIN
		DROP TABLE #AppSCGRefreshRecurExtTable
	END
	-- instrumentation for performance monitoring
	--SELECT @getIdaObjectsForUserMS getIdaObjectsForUserMS,
	--		@getuserObjectsMS getuserObjectsMS,
	--		@canAddClientToClientGroupMS canAddClientToClientGroupMS,
	--		@getCreateAsUserIdMS getCreateAsUserIdMS
	RETURN @exitCode
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppSCGRefreshRecur')
	delete from GxQscripts where name = 'AppSCGRefreshRecur'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSCGRefreshRecur')
	delete from GXDBVersions where aliasname = 'AppSCGRefreshRecur'
GO

insert into GXDBVersions values(2, 'AppSCGRefreshRecur',  'v1.23.2.22.8.1', 'AppSCGRefreshRecur', 'v1.23.2.22.8.1')
GO

