

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSCGRefreshClientGroupOrdering.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSCGRefreshClientGroupOrdering.sp,v $ $Id: AppSCGRefreshClientGroupOrdering.sp,v 1.1.2.1 2020/10/28 13:17:08 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppSCGRefreshClientGroupOrdering')
BEGIN
	print '>>> Drop Stored Procedure: AppSCGRefreshClientGroupOrdering <<<'
	drop procedure AppSCGRefreshClientGroupOrdering
END
IF EXISTS (select * from GxQscripts where name='AppSCGRefreshClientGroupOrdering')
	delete from GxQscripts where name = 'AppSCGRefreshClientGroupOrdering'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSCGRefreshClientGroupOrdering')
	delete from GXDBVersions where aliasname = 'AppSCGRefreshClientGroupOrdering'
GO
print '... Creating Procedure: AppSCGRefreshClientGroupOrdering'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppSCGRefreshClientGroupOrdering
-- No Input arguments
AS
BEGIN
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	-- Some customers have so many dependent client group relationships that the CTE incurrs a
	-- SQL Exception due to recursion limit exceeded and using a SAVE TRANs point does not
	-- keep the Transaction from being trashed. So to work the issue need to set GXGlobalParam
	-- setting that has to be manually set to force previously implemented refresh operation that
	-- refreshed SCG in ID ordering vs the new way of computing a dependency ordering.
	DECLARE @exitCode					INTEGER = 0		-- success
	-- Temp Table created by caller and must exist and be populated with data
	IF OBJECT_ID('tempdb.dbo.#AppSCGRefreshClientGroupOrderingExtTbl') IS NULL
		OR OBJECT_ID('tempdb.dbo.#AppSCGRefreshRecurExtTable') IS NULL
	BEGIN
		SET @exitCode = 1
	END
	ELSE IF NOT EXISTS (SELECT 1 FROM #AppSCGRefreshRecurExtTable)
	BEGIN
		SET @exitCode = 2
	END
	IF (@exitCode = 1)
	BEGIN
		PRINT 'AppSCGRefreshClientGroupOrdering Error[' + CAST(@exitCode AS VARCHAR(12))  + ']: No inputted data to process in external temp tables: #AppSCGRefreshClientGroupOrderingExtTbl or #AppSCGRefreshRecurExtTable'
		RETURN @exitCode
	END
	-- instrumentation for performance and debug monitoring
	DECLARE @debug INT = 0
	SELECT
		@debug = CAST(value AS INT)
	FROM GXGlobalParam WITH(NOLOCK)
	WHERE
		name = N'AppSCGRefreshRecurLogging'
		AND modified = 0
	-- Some customers have so many dependent client group relationships that the CTE incurrs a
	-- SQL Exception due to recursion limit exceeded and using a SAVE TRANs point does not
	-- keep the Transaction from being trashed. So to work the issue need to set GXGlobalParam
	-- setting that has to be manually set to force previously implemented refresh operation that
	-- refreshed SCG in ID ordering vs the new way of computing a dependency ordering.
	DECLARE @idOrderingRefresh INT = 0
	SELECT
		@idOrderingRefresh = CAST(value AS INT)
	FROM GXGlobalParam WITH(NOLOCK)
	WHERE
		name = N'AppSCGRefreshIdOrdering'
		AND modified = 0
	IF (@idOrderingRefresh = 0)
	BEGIN
		BEGIN TRY
			-- For each row in #AppSCGRefreshRecurExtTable find all client group
			-- dependent associations and add them to the #AppSCGRefreshRecurExtTable
			-- for refreshing as well.  This use to be done at the end of a refresh and
			-- recusively call this SP to perform dependent associations refreshing.
			;WITH SCGList(associatedGrpId, ownerGrpId, level) AS
			(   -- recursion
				SELECT
					p.associatedGrpId,
					p.ownerGrpId,
					1 level
				FROM App_SCGClientGroupDependency p WITH(NOLOCK)
					INNER JOIN #AppSCGRefreshRecurExtTable et ON
						p.associatedGrpId = et.scgId
				UNION ALL
				SELECT
					p.associatedGrpId,
					p.ownerGrpId,
					c.level + 1		-- next higher level
				FROM App_SCGClientGroupDependency p WITH(NOLOCK)
					INNER JOIN SCGList c ON
						p.associatedGrpId = c.ownerGrpId
			)
				INSERT INTO #AppSCGRefreshClientGroupOrderingExtTbl		--#AppSCGRefreshRecurExtTable internal replacement for computed refresh ordering to avoid index ordering
					SELECT
						q.scgId,
						MAX(q.level) level
					FROM (
							SELECT
								l.associatedGrpId scgId,
								l.level
							FROM SCGList l
								LEFT OUTER JOIN #AppSCGRefreshRecurExtTable et ON
									et.scgId = l.associatedGrpId
							WHERE
								et.scgId IS NULL
							UNION ALL
							SELECT
								l.ownerGrpId scgId,
								l.level
							FROM SCGList l
								LEFT OUTER JOIN #AppSCGRefreshRecurExtTable et ON
									et.scgId = l.ownerGrpId
							WHERE
								et.scgId IS NULL
							UNION ALL
							SELECT
								et.scgId,
								0 level		-- inputted listing start level
							FROM #AppSCGRefreshRecurExtTable et
						) q
					GROUP BY q.scgId
					OPTION (MAXRECURSION 200)	-- doubling the default limit
			-- Identify any interdependent groupings within the inputted list and make sure they are refreshed in the correct order as well
			;WITH SCGList(associatedGrpId, ownerGrpId, level) AS
			(   -- recursion - get all interdependent groups then filter out unneeded groups
				SELECT
					p.associatedGrpId,
					p.ownerGrpId,
					-1 level		-- should be updated before inputted list
				FROM App_SCGClientGroupDependency p WITH(NOLOCK)
					INNER JOIN #AppSCGRefreshRecurExtTable et ON
						p.ownerGrpId = et.scgId
				UNION ALL
				SELECT
					p.associatedGrpId,
					p.ownerGrpId,
					c.level - 1		-- next lowest level
				FROM App_SCGClientGroupDependency p WITH(NOLOCK)
					INNER JOIN SCGList c ON
						p.associatedGrpId = c.ownerGrpId
			),
			SCGList2(associatedGrpId, ownerGrpId, level) AS
			(
				SELECT
					l.associatedGrpId,
					l.ownerGrpId,
					MIN(l.level) level		-- determine lowest level it should be updated at
				FROM SCGList l
					INNER JOIN #AppSCGRefreshRecurExtTable et ON		-- only want groups from inputted listing so that we do not try to update other dependent SCGs found
						l.ownerGrpId = et.scgId
					INNER JOIN #AppSCGRefreshRecurExtTable et2 ON		-- only want groups from inputted listing so that we do not try to update other dependent SCGs found
						et2.scgId = l.associatedGrpId
				GROUP BY
					l.associatedGrpId,
					l.ownerGrpId
			),
			SCGLowList(associatedGrpId, level) AS
			(	-- list of groups that are dependent and their level
				SELECT
					l.associatedGrpId,
					ISNULL((SUM(l2.level) - 1), MIN(l.level)) level		-- find owner group and if found push it down one more level then owner so that it is updated first
				FROM SCGList2 l
					LEFT OUTER JOIN SCGList2 l2 ON
						l.ownerGrpId = l2.associatedGrpId
				GROUP BY
					l.associatedGrpId
			),
			UpdateSCGList1(associatedGrpId, level) AS
			(	-- pass 1 - update level of dependents that have owners in this group
				SELECT DISTINCT
					l.associatedGrpId,
					CASE
						WHEN l3.level IS NULL THEN l.level
						WHEN l3.level <= l.level THEN (l3.level - 1)
						ELSE l.level
					END level
				FROM SCGLowList l
					INNER JOIN SCGList2 l2 ON
						l2.associatedGrpId = l.associatedGrpId
					LEFT OUTER JOIN SCGLowList l3 ON
						l3.associatedGrpId = l2.ownerGrpId		-- find an owner and set to level - 1
			),
			UpdateSCGList(associatedGrpId, level) AS
			(	-- pass 2 - update level of dependents that have owners in this group NOTE STOPPED at 2 Passes!
				SELECT DISTINCT
					l.associatedGrpId,
					CASE
						WHEN l3.level IS NULL THEN l.level
						WHEN l3.level <= l.level THEN (l3.level - 1)
						ELSE l.level
					END level
				FROM UpdateSCGList1 l
					INNER JOIN SCGList2 l2 ON
						l2.associatedGrpId = l.associatedGrpId
					LEFT OUTER JOIN UpdateSCGList1 l3 ON
						l3.associatedGrpId = l2.ownerGrpId		-- find an owner and set to level - 1
			)
				UPDATE l
					SET updateOrder = u.level
				FROM #AppSCGRefreshClientGroupOrderingExtTbl l
					INNER JOIN UpdateSCGList u ON
						u.associatedGrpId = l.scgId
				OPTION (MAXRECURSION 200)	-- doubling the default limit
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			PRINT 'AppSCGRefreshClientGroupOrdering: SQL Recursion Exception trapped for SCG Dependency Ordering - set additional setting - GXGlobalParam::AppSCGRefreshIdOrdering?'
			;THROW;		-- re-throw the trapped exception
		END CATCH
	END
	ELSE
	BEGIN
		PRINT 'AppSCGRefreshClientGroupOrdering: Note additional setting GXGlobalParam::AppSCGRefreshIdOrdering - SCG Id and Level Ordering one pass'
		-- Refresh SCG by ID Ordering and level inserted (original implementation) one pass insertion were the above performs
		-- recursion looping to move groups up down levels to build the dependency relationship.
		-- If refreshing a specific SCGId or list of SCGIds, it does NOT refresh SCGIds that have dependencies on these SCGIds like the above code.
		INSERT INTO #AppSCGRefreshClientGroupOrderingExtTbl
			SELECT DISTINCT
				p.associatedGrpId,
				99 level		-- first level dependent groups
			FROM App_SCGClientGroupDependency p WITH(NOLOCK)
				INNER JOIN #AppSCGRefreshRecurExtTable et ON
					p.ownerGrpId = et.scgId
				LEFT OUTER JOIN #AppSCGRefreshRecurExtTable orig ON
					p.ownerGrpId = orig.scgId
			WHERE
				orig.scgId IS NULL		-- group will be added below SELECT and only one entry allowed
			UNION ALL
			SELECT DISTINCT		-- DISTINCT added to make sure caller does not added an scgid more than once
				t.scgId,
				100 level		-- last level refreshed - initial groups to refresh
			FROM #AppSCGRefreshRecurExtTable t
		INSERT INTO #AppSCGRefreshClientGroupOrderingExtTbl
			SELECT DISTINCT
				p.ownerGrpId,
				101 level			-- groups who inherit the inputted #AppSCGRefreshRecurExtTable groups being refreshed
			FROM App_SCGClientGroupDependency p WITH(NOLOCK)
				INNER JOIN #AppSCGRefreshRecurExtTable et ON
					p.associatedGrpId = et.scgId
				LEFT OUTER JOIN #AppSCGRefreshClientGroupOrderingExtTbl o ON
					p.ownerGrpId = o.scgId
			WHERE
				o.scgId IS NULL		-- only add the group is not already present in the list
		-- loop thru adding each set of dependent SCG ids that need to be refreshed
		DECLARE @lcnt INT = 1
		DECLARE @level INT = 98		-- second level dependent groups
		WHILE (@lcnt > 0)
		BEGIN
			INSERT INTO #AppSCGRefreshClientGroupOrderingExtTbl
				SELECT DISTINCT
					p.associatedGrpId,
					@level level
				FROM App_SCGClientGroupDependency p WITH(NOLOCK)
					INNER JOIN #AppSCGRefreshClientGroupOrderingExtTbl o ON
						p.ownerGrpId = o.scgId
					LEFT OUTER JOIN #AppSCGRefreshClientGroupOrderingExtTbl a ON
						a.scgId = p.associatedGrpId
				WHERE
					a.scgId IS NULL		-- if group already in list do not add again
			SET @lcnt = @@ROWCOUNT		-- keep looping until no rows inserted for next level of dependent client groups
			SET @level = @level - 1		-- decrement for next lower level to refresh first
		END
	END
	RETURN @exitCode
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppSCGRefreshClientGroupOrdering')
	delete from GxQscripts where name = 'AppSCGRefreshClientGroupOrdering'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSCGRefreshClientGroupOrdering')
	delete from GXDBVersions where aliasname = 'AppSCGRefreshClientGroupOrdering'
GO

insert into GXDBVersions values(2, 'AppSCGRefreshClientGroupOrdering',  '00010001000200010000', 'AppSCGRefreshClientGroupOrdering', '00010001000200010000')
GO

