

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSCGRefresh.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSCGRefresh.sp,v $ $Id: AppSCGRefresh.sp,v 1.1.208.15 2020/11/23 08:27:07 jswaminathan Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppSCGRefresh"
--	|	This Procedure is used to handle the different request for VM Allocation Policy
-- 	+-----------------------------------------------------------------------+
-- Procedure Name
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppSCGRefresh')
BEGIN
	print '>>> Drop Stored Procedure: AppSCGRefresh <<<'
	drop procedure AppSCGRefresh
END
IF EXISTS (select * from GxQscripts where name='AppSCGRefresh')
	delete from GxQscripts where name = 'AppSCGRefresh'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSCGRefresh')
	delete from GXDBVersions where aliasname = 'AppSCGRefresh'
GO
print '... Creating Procedure: AppSCGRefresh'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppSCGRefresh
-- Input arguments
  @i_uid INT, 
  @i_scgId INT
AS
BEGIN
	SET NOCOUNT ON
	DECLARE @refreshId integer = dbo.GetUnixTime(GetUTCdate())
	DECLARE @rc	INT = 0
	-- rolling back SCG Refresh Time Interval but leaving last time SCG refreshed
	IF (@i_scgId = 0)
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#AppSCGRefreshRecurExtTable') IS NOT NULL
			DROP TABLE #AppSCGRefreshRecurExtTable
		-- External Inputted Table does not exist
		CREATE TABLE #AppSCGRefreshRecurExtTable (
			scgId		INT PRIMARY KEY
		)
		INSERT INTO #AppSCGRefreshRecurExtTable
			SELECT
				cg.id
			FROM App_ClientGroup cg WITH(NOLOCK)
WHERE (cg.flag & 0x1000) != 0
		--Update the Group and the Groups where this group is associated
		EXEC @rc = APPSCGRefreshRecur @i_uid, @refreshId, -1		-- process the above created table
	END
	ELSE
	BEGIN
		IF EXISTS (SELECT 1 FROM App_ClientGroup WHERE id=@i_scgId)
		BEGIN
			--Update the Group and the Groups where this group is associated
			EXEC @rc = APPSCGRefreshRecur @i_uid, @refreshId, @i_scgId
		END
	END
	-- Set installation company Id property for missing VMs part of this SCG.
	-- Do this only if all SCGs are refreshed. Because when only one SCG is being refreshed, the others might not be refreshed and up-to-date.
	-- For computing the correct company Id, we need all the Company SCGs to be updated, so that we can get all the companies this client is part of.
	IF @i_scgId = 0
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#AppSetInstallationCompanyId_clientsWithoutProp')IS NOT NULL
			DROP TABLE #AppSetInstallationCompanyId_clientsWithoutProp
		CREATE TABLE #AppSetInstallationCompanyId_clientsWithoutProp
		(
			clientId INT PRIMARY KEY
		)
		INSERT INTO #AppSetInstallationCompanyId_clientsWithoutProp
			SELECT DISTINCT CGA.clientId
			FROM #AppSCGRefreshRecurExtTable SG
				INNER JOIN APP_ClientGroupAssoc CGA (NOLOCK)
					ON SG.scgId = CGA.clientGroupId
				INNER JOIN APP_ClientGroup CG (NOLOCK)
ON (SG.scgId = CG.id) AND ((CG.flag & 1073741824) <> 0)		-- Consider only Company SCGs for this calculations.
				LEFT OUTER JOIN APP_ClientProp CP (NOLOCK)
					ON CGA.clientId = CP.componentNameID
AND CP.attrName = 'Installation Company ID'
					AND CP.modified = 0
				WHERE
					(CP.componentNameId IS NULL) OR (CP.attrVal = '0')		-- Sometimes, company clients are wrongly tagged with 0 as company Id.
		DECLARE @o_errorCode INT, @o_errorString VARCHAR(1024)
		EXEC AppSetInstallationCompanyId @refreshId, @o_errorCode OUTPUT, @o_errorString OUTPUT
	END
	RETURN @rc;
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppSCGRefresh')
	delete from GxQscripts where name = 'AppSCGRefresh'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSCGRefresh')
	delete from GXDBVersions where aliasname = 'AppSCGRefresh'
GO

insert into GXDBVersions values(2, 'AppSCGRefresh',  '00010001020800150000', 'AppSCGRefresh', '00010001020800150000')
GO

