

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSCGHandleReq.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSCGHandleReq.sp,v $ $Id: AppSCGHandleReq.sp,v 1.24.2.24.8.1 2021/03/07 08:51:08 kvinayak Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppSCGHandleReq"
--	|	This Procedure is used to handle the different request for VM Allocation Policy
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppSCGHandleReq')
BEGIN
	print '>>> Drop Stored Procedure: AppSCGHandleReq <<<'
	drop procedure AppSCGHandleReq
END
IF EXISTS (select * from GxQscripts where name='AppSCGHandleReq')
	delete from GxQscripts where name = 'AppSCGHandleReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSCGHandleReq')
	delete from GXDBVersions where aliasname = 'AppSCGHandleReq'
GO
print '... Creating Procedure: AppSCGHandleReq'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppSCGHandleReq
-- Input arguments
  @i_uid INT, 
  @i_req INT,
  @i_RuleData XML,
  @i_RuleQuery nvarchar(max)
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @r_RuleData XML;
SET NOCOUNT ON
DECLARE @i_rulexml XML
DECLARE @scgId INT
DECLARE @scgName nvarchar(256)
DECLARE @scgDesc nvarchar(max)
DECLARE @scgRuleId INT
DECLARE @now INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @masterGroupId INT = dbo.getMasterGroupId()
DECLARE @cgScopeType INT = NULL		-- EntityType: Commcell (CS Admin), Provider (Tenant-Admin), User (regular user)
DECLARE @cgScopeId INT = NULL		-- EntityId: Commcell Id(2), Provider Id, User Id
DECLARE @maxScopeType INT = NULL
DECLARE @maxScopeId INT = NULL
DECLARE @isScopeError TINYINT = 0
DECLARE @scopeMsg VARCHAR(1024)
DECLARE @noScopeRowChg TINYINT = 0
DECLARE @curScopeType INT = NULL
DECLARE @curScopeId INT = NULL
DECLARE @clientGroupCreatorId int = 0
DECLARE @oldClientIdTable TABLE (oldClientId integer)
DECLARE @origCCId int = 2
DECLARE @canAdministerClientGroup	int = 1
DECLARE @scopeCheckXML XML
DECLARE @scopeCheckXMLOutput XML
IF OBJECT_ID('tempdb.dbo.#scopeAllowedEntities') IS NOT NULL
	DROP TABLE #scopeAllowedEntities
CREATE TABLE #scopeAllowedEntities
(
	entityType INT,
	entityId INT
)
CREATE CLUSTERED INDEX scopeAllowedEntitiesIdx1 ON #scopeAllowedEntities (entityType, entityId);;
DECLARE @errorCode INT = 0
DECLARE @errorString VARCHAR(1024) = ''
DECLARE @localeId INT = 0
SET @localeId  = ISNULL((SELECT  ref.value('@localeId', 'int') AS C
                         FROM    @i_RuleData.nodes('App_PerformClientGroupReq/processinginstructioninfo/locale') R ( ref )),0)
-- Perform requested operation
IF (@i_req = '1')
BEGIN
	--Create new smart client group
	SET @i_rulexml  = @i_RuleData.query('App_PerformClientGroupReq/clientGroupDetail/scgRule')
	SET @scgName  = ( SELECT ref.value('@clientGroupName', 'nvarchar(256)') FROM  @i_RuleData.nodes('App_PerformClientGroupReq/clientGroupDetail/clientGroup') R(ref))
	SET @scgDesc  = ( SELECT ref.value('@description', 'nvarchar(max)') FROM  @i_RuleData.nodes('App_PerformClientGroupReq/clientGroupDetail') R(ref))
	--Make entry in App_ClientGroup table
	SET @scgId = NULL
	SELECT
		@scgId = id
	FROM APP_ClientGroup
	WHERE
		name = @scgName
	IF (@scgId IS NULL)
	BEGIN
		INSERT INTO [dbo].[App_ClientGroup] (name, description, flag, status, userId, refTime, modified, fwPorts, origCCId)
VALUES (@scgName,  @scgDesc, 0x1000, 0, @i_uid,  @now, '0', '',  2)
		SET @scgId = SCOPE_IDENTITY()		-- @@IDENTITY bad with trigger operations occurring
	END
	ELSE
	BEGIN
		-- Change manual group to automatic group
		UPDATE [dbo].[App_ClientGroup]
SET flag = flag | 0x1000
		WHERE id = @scgId
	END
	--Add into rule table
	INSERT INTO [dbo].[App_SCGRule] (scgId, ruleXml, ruleQuery, ownerId, created, modified)
		VALUES (@scgId, @i_rulexml, @i_RuleQuery, @i_uid, @now, '0')
	SET @scgRuleId = SCOPE_IDENTITY()
	-- Default SCG Scope computed and inserted by trigger APP_SCGRuleScope
	-- Has Scope been overriden from default computation by user inputs?
	-- Expect 1 to 1 mapping in List Node for now
	SELECT TOP 1	-- safety
		@cgScopeType = ref.value('@_type_', 'INT'),
		@cgScopeId = CASE ref.value('@_type_', 'INT')
						WHEN 1 THEN ref.value('@commCellId', 'INT')
						WHEN 13 THEN ref.value('@userId', 'INT')
						WHEN 15 THEN ref.value('@userGroupId', 'INT')
						WHEN 61 THEN ref.value('@providerId', 'INT')
						ELSE NULL
					END
	FROM  @i_RuleData.nodes('App_PerformClientGroupReq/clientGroupDetail/scgScope/entity') R(ref)
	IF (@cgScopeType IS NOT NULL)
	BEGIN
		-- Verify that scope is not being exceeded
		-- We should check for both scope type and scope Id.
		-- If from REST API / Qcommand XML some one tries to invoke it wrongly, we should error out.
IF @cgScopeType = 1
			SET @scopeCheckXML = '<App_GetSCGScopeEntitiesUserRequest property="20" scopeType="1"/>'
ELSE IF @cgScopeType = 15
			SET @scopeCheckXML = '<App_GetSCGScopeEntitiesUserRequest property="20" scopeType="15"/>'
ELSE IF @cgScopeType = 13
			SET @scopeCheckXML = '<App_GetSCGScopeEntitiesUserRequest property="20" scopeType="13"/>'
ELSE IF @cgScopeType = 61
			SET @scopeCheckXML = '<App_GetSCGScopeEntitiesUserRequest property="20" scopeType="61"/>'
		EXEC APPGetSCGScopeEntitiesForUserSQL @i_uid, 0, @scopeCheckXML, @scopeCheckXMLOutput OUTPUT
		INSERT INTO #scopeAllowedEntities
			SELECT DISTINCT
				ref.value('@entityType', 'INT'),
				ref.value('@entityId', 'INT')
			FROM @scopeCheckXMLOutput.nodes('App_GetSCGScopeEntitiesUserResponse/scopeEntities/entities/entity') R(ref)
		IF NOT EXISTS (SELECT TOP 1 1 FROM #scopeAllowedEntities WHERE entityType = @cgScopeType AND entityId = @cgScopeId)
				SET  @isScopeError = 1
		IF ( @isScopeError = 1 OR @cgScopeId IS NULL)
		BEGIN
			SET @scopeMsg = 'Automatic Client Group Scope Level exceeded by userId [' + CAST(@i_uid AS VARCHAR(12)) +
				'] max Scope Level [' + CAST(@maxScopeType AS VARCHAR(12)) +
				'] selected Scope Level [' +  CAST(@cgScopeType AS VARCHAR(12)) + ']'
			PRINT 'AppSCGHandleReq Error: ' + @scopeMsg
			RAISERROR(@scopeMsg, 16, 1)
			RETURN
		END
		-- Check scope values against table
		UPDATE s
			SET entityType = @cgScopeType,
				entityId = @cgScopeId
		FROM APP_SCGScope s
		WHERE
			s.scgRuleId = @scgRuleId
			AND (	-- only update if there is a value change
				s.entityType <> @cgScopeType
				OR s.entityId <> @cgScopeId
			)
	END
	--Use the refresh code for adding of clients also as GUI Audit is done there
	EXEC dbo.AppSCGRefresh @i_uid, @scgId
	SET @r_RuleData = ISNULL (
		(
			SELECT
				ACG.name as 'clientGroup/@clientGroupName',
				ACG.id as 'clientGroup/@clientGroupId',
				(
					SELECT
						s.entityType '@_type_',
						(
							CASE s.entityType
								WHEN 13 THEN s.entityId		-- USER_ENTITY
								ELSE NULL
							END
						) '@userId',
						(
							CASE s.entityType
								WHEN 15 THEN s.entityId		-- USERGROUP_ENTITY
								ELSE NULL
							END
						) '@userGroupId',
						(
							CASE s.entityType
								WHEN 61 THEN s.entityId		-- PROVIDER_ENTITY
								ELSE NULL
							END
						) '@providerId',
						(
							CASE s.entityType
								WHEN 1 THEN s.entityId		-- COMMCELL_ENTITY
								ELSE NULL
							END
						) '@commCellId',
						(
							CASE s.entityType
								WHEN 13 THEN (		-- USER_ENTITY
										SELECT
											u.login '@entityName'
										FROM UMUsers u WITH(NOLOCK)
										WHERE
											u.id = s.entityId
									)
								ELSE NULL
							END
						) '@userName',
						(
							CASE s.entityType
								WHEN 15 THEN (		-- USERGROUP_ENTITY
										SELECT
											CASE
												WHEN p.id IS NULL THEN g.name
												ELSE p.domainName + '\' + g.name
											END '@entityName'
										FROM UMGroups g WITH(NOLOCK)
											LEFT OUTER JOIN UMDSProviders p ON
												p.id = g.umdsProviderId
												AND g.umdsProviderId > 0
										WHERE
											g.id = s.entityId
									)
								ELSE NULL
							END
						) '@userGroupName',
						(
							CASE s.entityType
								WHEN 61 THEN (		-- PROVIDER_ENTITY
										SELECT
											p.domainName
										FROM UMDSProviders p WITH(NOLOCK)
										WHERE
											p.id = s.entityId
									)
								ELSE NULL
							END
						) '@providerDomainName',
						(
							CASE s.entityType
								WHEN 1 THEN (		-- COMMCELL_ENTITY
										SELECT
											cc.aliasName
										FROM APP_Commcell cc WITH(NOLOCK)
										WHERE
											cc.id = s.entityId
									)
								ELSE NULL
							END
						) '@commCellName'
					FROM APP_SCGScope s  WITH(NOLOCK)
					WHERE
						s.scgRuleId = ASR.id
					FOR XML PATH('entity'), ROOT('scgScope'), TYPE
				)
			FROM App_SCGRule as ASR
				INNER JOIN App_ClientGroup as ACG ON
					ACG.id = ASR.scgId
			WHERE
				ACG.id = @scgId
			FOR XML PATH('clientGroupDetail'), ROOT('App_PerformClientGroupResp')
		),
		'<App_PerformClientGroupResp/>'
	)
END
IF (@i_req = '2')
BEGIN
	--Edit existing client group
	SET @i_rulexml  = @i_RuleData.query('App_PerformClientGroupReq/clientGroupDetail/scgRule')
	SET @scgId  = ( SELECT ref.value('@clientGroupId', 'integer') FROM  @i_RuleData.nodes('App_PerformClientGroupReq/clientGroupDetail/clientGroup') R(ref))
	SET @scgName  = ( SELECT ref.value('@clientGroupName', 'nvarchar(256)') FROM  @i_RuleData.nodes('App_PerformClientGroupReq/clientGroupDetail/clientGroup') R(ref))
	SET @scgDesc  = ( SELECT ref.value('@description', 'nvarchar(max)') FROM  @i_RuleData.nodes('App_PerformClientGroupReq/clientGroupDetail') R(ref))
	DECLARE @companySmartCG INT = 0
SELECT @companySmartCG = 1 FROM APP_ClientGroup (NOLOCK) WHERE (id = @scgId) AND ((flag & 1073741824) <> 0)
	-- Does SCG Rule already exist?
	SELECT @scgRuleId = id FROM App_SCGRule WHERE scgId = @scgId
	IF (@scgRuleId IS NOT NULL)
	BEGIN
		IF(@companySmartCG = 0) -- Update rule only if SCG is not a company client grp TR:210215-94 SoftwareOne-Switzerland
		BEGIN
			--UPDATE into rule table
			UPDATE [dbo].[App_SCGRule]
				SET ruleXml = @i_rulexml,
					ruleQuery = @i_RuleQuery
			WHERE scgId = @scgId
			-- SCG Scope updated by trigger APP_SCGRuleScope
		END
	END
	ELSE
	BEGIN
		--A normal client when converted to smart client group comes here
		UPDATE [dbo].[App_ClientGroup]
SET flag = flag | 0x1000
		WHERE
			id = @scgId
		INSERT INTO [dbo].[App_SCGRule] (scgId, ruleXml, ruleQuery, ownerId, created, modified)
			VALUES (@scgId, @i_rulexml, @i_RuleQuery, @i_uid, @now, '0')
		SET @scgRuleId = SCOPE_IDENTITY()
		-- SCG Scope inserted by trigger APP_SCGRuleScope
	END
	-- Has Scope been overriden from default computation by user inputs?
	-- Expect 1 to 1 mapping in List Node for now
	SELECT TOP 1	-- safety
		@cgScopeType = ref.value('@_type_', 'INT'),
		@cgScopeId = CASE ref.value('@_type_', 'INT')
						WHEN 1 THEN ref.value('@commCellId', 'INT')
						WHEN 13 THEN ref.value('@userId', 'INT')
						WHEN 15 THEN ref.value('@userGroupId', 'INT')
						WHEN 61 THEN ref.value('@providerId', 'INT')
						ELSE NULL
					END
	FROM  @i_RuleData.nodes('App_PerformClientGroupReq/clientGroupDetail/scgScope/entity') R(ref)
	IF (@cgScopeType IS NOT NULL)
	BEGIN
		-- There are cases where a user has SCG Creator rights against client groups created by
		-- other user with higher SCG Scope rights that could fail since the editing user
		-- may NOT have rights to the SCG Scope assigned to the client group.
		-- So if SCG Scope level is NOT being changed from the current set value, ignore SCG Scope Check.
		-- Is SCG Scope being changed during edit operation?
		SET @noScopeRowChg = 1		-- set to changed incase query row not found below
		SELECT
			@noScopeRowChg = CASE
								WHEN s.entityType = @cgScopeType AND s.entityId = @cgScopeId THEN 0
								ELSE 1
							END,
			@curScopeType = s.entityType,
			@curScopeId = s.entityId
		FROM APP_SCGScope s WITH(NOLOCK)
		WHERE
			s.scgRuleId = @scgRuleId
		--PRINT 'APPSCGHandler 2S cgScopeType[' + cast(@cgScopeType as varchar(12)) + '] cgScopeId['+ cast(@cgScopeId as varchar(12)) + '] curScopeType[' + cast(@curScopeType as varchar(12)) + '] cgScopeId['+ cast(@curScopeId as varchar(12)) + ']'
		IF (@noScopeRowChg = 1)		-- is user changing the scope
		BEGIN
			-- If scope is being changed, check 2 things. (Same as changing SCG rule).
			-- 1. Caller user should have Change Client Associations permission.
			-- 2. This should not be a company SCG.
			BEGIN
				DECLARE @userHasPermissions INT = 0
				DECLARE @companySCG INT = 0
				DECLARE @planSCG	INT = 0
EXEC sec_checkPermissionOnEntity @i_uid, 181, @userHasPermissions OUTPUT, 28, @scgId
				IF @userHasPermissions = 0
				BEGIN
SET @errorCode = (1878 | (CAST(POWER(2, 24) AS BIGINT) * 35))
					SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @errorCode AND localeId = @localeId)
				END
				ELSE
				BEGIN
SELECT @companySCG = 1 FROM APP_ClientGroup (NOLOCK) WHERE (id = @scgId) AND ((flag & 1073741824) <> 0)
SELECT @planSCG = 1 FROM APP_ClientGroup (NOLOCK) WHERE (id = @scgId) AND ((flag & 536870912) <> 0)
					IF (@companySCG = 1 OR @planSCG=1)
					BEGIN
						IF (@companySCG = 1)
						BEGIN
SET @errorCode = (4678 | (CAST(POWER(2, 24) AS BIGINT) * 35))
						END
						ELSE
						BEGIN
SET @errorCode = (4680 | (CAST(POWER(2, 24) AS BIGINT) * 35))
						END
						SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @errorCode AND localeId = @localeId)
					END
				END
				IF @errorCode <> 0
				BEGIN
					SET @r_RuleData =	(
											SELECT
												@errorCode AS '@errorCode',
												@errorString AS '@errorMessage'
											FOR XML PATH ('App_GenericResp')
										)
					SELECT @r_RuleData
					RETURN
				END
			END
			-- Verify that scope is not being exceeded
			-- We should check for both scope type and scope Id.
			-- If from REST API / Qcommand XML some one tries to invoke it wrongly, we should error out.
IF @cgScopeType = 1
				SET @scopeCheckXML = '<App_GetSCGScopeEntitiesUserRequest property="20" scopeType="1"/>'
ELSE IF @cgScopeType = 15
				SET @scopeCheckXML = '<App_GetSCGScopeEntitiesUserRequest property="20" scopeType="15"/>'
ELSE IF @cgScopeType = 13
				SET @scopeCheckXML = '<App_GetSCGScopeEntitiesUserRequest property="20" scopeType="13"/>'
ELSE IF @cgScopeType = 61
				SET @scopeCheckXML = '<App_GetSCGScopeEntitiesUserRequest property="20" scopeType="61"/>'
			EXEC APPGetSCGScopeEntitiesForUserSQL @i_uid, 0, @scopeCheckXML, @scopeCheckXMLOutput OUTPUT
			INSERT INTO #scopeAllowedEntities
				SELECT DISTINCT
					ref.value('@entityType', 'INT'),
					ref.value('@entityId', 'INT')
				FROM @scopeCheckXMLOutput.nodes('App_GetSCGScopeEntitiesUserResponse/scopeEntities/entities/entity') R(ref)
			IF NOT EXISTS (SELECT TOP 1 1 FROM #scopeAllowedEntities WHERE entityType = @cgScopeType AND entityId = @cgScopeId)
					SET  @isScopeError = 1
			IF ( @isScopeError = 1 OR @cgScopeId IS NULL)
			BEGIN
				SET @scopeMsg = 'Automatic Client Group Scope Level exceeded by userId [' + CAST(@i_uid AS VARCHAR(12)) +
					'] max Scope Level [' + CAST(@maxScopeType AS VARCHAR(12)) +
					'] selected Scope Level [' +  CAST(@cgScopeType AS VARCHAR(12)) + ']'
				PRINT 'AppSCGHandleReq Error: ' + @scopeMsg
				RAISERROR(@scopeMsg, 16, 1)
				RETURN
			END
			-- Check scope values against table
			UPDATE s
				SET entityType = @cgScopeType,
					entityId = @cgScopeId
			FROM APP_SCGScope s
			WHERE
				s.scgRuleId = @scgRuleId
				AND (	-- only update if there is a value change
					s.entityType <> @cgScopeType
					OR s.entityId <> @cgScopeId
				)
		END
	END
	EXEC dbo.AppSCGRefresh @i_uid, @scgId
	SET @r_RuleData = ISNULL (
		(
			SELECT
				ACG.name as 'clientGroup/@clientGroupName',
				ACG.id as 'clientGroup/@clientGroupId',
				(
					SELECT
						s.entityType '@_type_',
						(
							CASE s.entityType
								WHEN 13 THEN s.entityId		-- USER_ENTITY
								ELSE NULL
							END
						) '@userId',
						(
							CASE s.entityType
								WHEN 15 THEN s.entityId		-- USERGROUP_ENTITY
								ELSE NULL
							END
						) '@userGroupId',
						(
							CASE s.entityType
								WHEN 61 THEN s.entityId		-- PROVIDER_ENTITY
								ELSE NULL
							END
						) '@providerId',
						(
							CASE s.entityType
								WHEN 1 THEN s.entityId		-- COMMCELL_ENTITY
								ELSE NULL
							END
						) '@commCellId',
						(
							CASE s.entityType
								WHEN 13 THEN (		-- USER_ENTITY
										SELECT
											u.login '@entityName'
										FROM UMUsers u WITH(NOLOCK)
										WHERE
											u.id = s.entityId
									)
								ELSE NULL
							END
						) '@userName',
						(
							CASE s.entityType
								WHEN 15 THEN (		-- USERGROUP_ENTITY
										SELECT
											CASE
												WHEN p.id IS NULL THEN g.name
												ELSE p.domainName + '\' + g.name
											END '@entityName'
										FROM UMGroups g WITH(NOLOCK)
											LEFT OUTER JOIN UMDSProviders p ON
												p.id = g.umdsProviderId
												AND g.umdsProviderId > 0
										WHERE
											g.id = s.entityId
									)
								ELSE NULL
							END
						) '@userGroupName',
						(
							CASE s.entityType
								WHEN 61 THEN (		-- PROVIDER_ENTITY
										SELECT
											p.domainName
										FROM UMDSProviders p WITH(NOLOCK)
										WHERE
											p.id = s.entityId
									)
								ELSE NULL
							END
						) '@providerDomainName',
						(
							CASE s.entityType
								WHEN 1 THEN (		-- COMMCELL_ENTITY
										SELECT
											cc.aliasName
										FROM APP_Commcell cc WITH(NOLOCK)
										WHERE
											cc.id = s.entityId
									)
								ELSE NULL
							END
						) '@commCellName'
					FROM APP_SCGScope s  WITH(NOLOCK)
					WHERE
						s.scgRuleId = ASR.id
					FOR XML PATH('entity'), ROOT('scgScope'), TYPE
				)
			FROM App_SCGRule as ASR
				INNER JOIN App_ClientGroup as ACG ON
					ACG.id = ASR.scgId
			WHERE
				ACG.id = @scgId
			FOR XML PATH('clientGroupDetail'), ROOT('App_PerformClientGroupResp')
		),
		'<App_PerformClientGroupResp/>'
	)
END
IF (@i_req = '3')
BEGIN
	--Refresh the Group
	DECLARE	@returnCode int = 0
	SET @scgId  = ( SELECT ref.value('@clientGroupId', 'integer') FROM  @i_RuleData.nodes('App_PerformClientGroupReq/clientGroupDetail/clientGroup') R(ref))
	EXEC @returnCode = dbo.AppSCGRefresh @i_uid, @scgId
	SET @r_RuleData = ( SELECT @returnCode as '@errorCode'
							FOR XML PATH('App_GenericResp'),TYPE)
END
IF (@i_req = '4')
BEGIN
	--Load
	SET @scgId  = ( SELECT ref.value('@clientGroupId', 'integer') FROM  @i_RuleData.nodes('App_PerformClientGroupReq/clientGroupDetail/clientGroup') R(ref))
	-- Has Scope been overriden from default computation by user inputs?
	-- Expect 1 to 1 mapping in List Node for now
	SELECT TOP 1	-- safety
		@cgScopeType = ref.value('@_type_', 'INT'),
		@cgScopeId = CASE ref.value('@_type_', 'INT')
						WHEN 1 THEN ref.value('@commCellId', 'INT')
						WHEN 13 THEN ref.value('@userId', 'INT')
						WHEN 15 THEN ref.value('@userGroupId', 'INT')
						WHEN 61 THEN ref.value('@providerId', 'INT')
						ELSE NULL
					END
	FROM  @i_RuleData.nodes('App_PerformClientGroupReq/clientGroupDetail/scgScope/entity') R(ref)
	IF (@cgScopeType IS NOT NULL)
	BEGIN
		-- There are cases where a user has SCG Creator rights against client groups created by
		-- other users with higher SCG Scope rights that could fail since the editing user
		-- may NOT have rights to the SCG Scope assigned to the client group.
		-- So if SCG Scope level is NOT being changed from the current set value, ignore SCG Scope Check.
		-- Is SCG Scope being changed during load operation?
		SET @noScopeRowChg = 1		-- set to changed incase query row not found below
		SELECT
			@noScopeRowChg = CASE
								WHEN s.entityType = @cgScopeType AND s.entityId = @cgScopeId THEN 0
								ELSE 1
							END,
			@curScopeType = s.entityType,
			@curScopeId = s.entityId
		FROM APP_SCGScope s WITH(NOLOCK)
		WHERE
			s.scgRuleId = @scgRuleId
		--PRINT 'APPSCGHandler 4 cgScopeType[' + cast(@cgScopeType as varchar(12)) + '] cgScopeId['+ cast(@cgScopeId as varchar(12)) + '] curScopeType[' + cast(@curScopeType as varchar(12)) + '] cgScopeId['+ cast(@curScopeId as varchar(12)) + ']'
		IF (@noScopeRowChg = 1)		-- is user changing the scope
		BEGIN
			-- Verify that scope is not being exceeded
			-- We should check for both scope type and scope Id.
			-- If from REST API / Qcommand XML some one tries to invoke it wrongly, we should error out.
IF @cgScopeType = 1
				SET @scopeCheckXML = '<App_GetSCGScopeEntitiesUserRequest property="20" scopeType="1"/>'
ELSE IF @cgScopeType = 15
				SET @scopeCheckXML = '<App_GetSCGScopeEntitiesUserRequest property="20" scopeType="15"/>'
ELSE IF @cgScopeType = 13
				SET @scopeCheckXML = '<App_GetSCGScopeEntitiesUserRequest property="20" scopeType="13"/>'
ELSE IF @cgScopeType = 61
				SET @scopeCheckXML = '<App_GetSCGScopeEntitiesUserRequest property="20" scopeType="61"/>'
			EXEC APPGetSCGScopeEntitiesForUserSQL @i_uid, 0, @scopeCheckXML, @scopeCheckXMLOutput OUTPUT
			INSERT INTO #scopeAllowedEntities
				SELECT DISTINCT
					ref.value('@entityType', 'INT'),
					ref.value('@entityId', 'INT')
				FROM @scopeCheckXMLOutput.nodes('App_GetSCGScopeEntitiesUserResponse/scopeEntities/entities/entity') R(ref)
			IF NOT EXISTS (SELECT TOP 1 1 FROM #scopeAllowedEntities WHERE entityType = @cgScopeType AND entityId = @cgScopeId)
					SET  @isScopeError = 1
			IF ( @isScopeError = 1 OR @cgScopeId IS NULL)
			BEGIN
				SET @scopeMsg = 'Automatic Client Group Scope Level exceeded by userId [' + CAST(@i_uid AS VARCHAR(12)) +
					'] max Scope Level [' + CAST(@maxScopeType AS VARCHAR(12)) +
					'] selected Scope Level [' +  CAST(@cgScopeType AS VARCHAR(12)) + ']'
				PRINT 'AppSCGHandleReq Error: ' + @scopeMsg
				RAISERROR(@scopeMsg, 16, 1)
				RETURN
			END
		END
	END
	SET @r_RuleData = ISNULL (
		(
			SELECT
				ACG.name as 'clientGroup/@clientGroupName',
				ACG.id as 'clientGroup/@clientGroupId',
				ruleXml.query('scgRule'),
				CASE
					WHEN @cgScopeType IS NULL OR @cgScopeType = 0 THEN
						(
							SELECT
								s.entityType '@_type_',
								(
									CASE s.entityType
										WHEN 13 THEN s.entityId		-- USER_ENTITY
										ELSE NULL
									END
								) '@userId',
								(
									CASE s.entityType
										WHEN 15 THEN s.entityId		-- USERGROUP_ENTITY
										ELSE NULL
									END
								) '@userGroupId',
								(
									CASE s.entityType
										WHEN 61 THEN s.entityId		-- PROVIDER_ENTITY
										ELSE NULL
									END
								) '@providerId',
								(
									CASE s.entityType
										WHEN 1 THEN s.entityId		-- COMMCELL_ENTITY
										ELSE NULL
									END
								) '@commCellId',
								(
									CASE s.entityType
										WHEN 13 THEN (		-- USER_ENTITY
												SELECT
													u.login '@entityName'
												FROM UMUsers u WITH(NOLOCK)
												WHERE
													u.id = s.entityId
											)
										ELSE NULL
									END
								) '@userName',
								(
									CASE s.entityType
										WHEN 15 THEN (		-- USERGROUP_ENTITY
												SELECT
													CASE
														WHEN p.id IS NULL THEN g.name
														ELSE p.domainName + '\' + g.name
													END '@entityName'
												FROM UMGroups g WITH(NOLOCK)
													LEFT OUTER JOIN UMDSProviders p ON
														p.id = g.umdsProviderId
														AND g.umdsProviderId > 0
												WHERE
													g.id = s.entityId
											)
										ELSE NULL
									END
								) '@userGroupName',
								(
									CASE s.entityType
										WHEN 61 THEN (		-- PROVIDER_ENTITY
												SELECT
													p.domainName
												FROM UMDSProviders p WITH(NOLOCK)
												WHERE
													p.id = s.entityId
											)
										ELSE NULL
									END
								) '@providerDomainName',
								(
									CASE s.entityType
										WHEN 1 THEN (		-- COMMCELL_ENTITY
												SELECT
													cc.aliasName
												FROM APP_Commcell cc WITH(NOLOCK)
												WHERE
													cc.id = s.entityId
											)
										ELSE NULL
									END
								) '@commCellName'
							FROM APP_SCGScope s  WITH(NOLOCK)
							WHERE
								s.scgRuleId = ASR.id
							FOR XML PATH('entity'), ROOT('scgScope'), TYPE
						)
					ELSE
						(
							SELECT
								@cgScopeType '@_type_',
								(
									CASE @cgScopeType
										WHEN 13 THEN @cgScopeId		-- USER_ENTITY
										ELSE NULL
									END
								) '@userId',
								(
									CASE @cgScopeType
										WHEN 15 THEN @cgScopeId		-- USERGROUP_ENTITY
										ELSE NULL
									END
								) '@userGroupId',
								(
									CASE @cgScopeType
										WHEN 61 THEN @cgScopeId		-- PROVIDER_ENTITY
										ELSE NULL
									END
								) '@providerId',
								(
									CASE @cgScopeType
										WHEN 1 THEN @cgScopeId		-- COMMCELL_ENTITY
										ELSE NULL
									END
								) '@commCellId',
								(
									CASE @cgScopeType
										WHEN 13 THEN (		-- USER_ENTITY
												SELECT
													u.login '@entityName'
												FROM UMUsers u WITH(NOLOCK)
												WHERE
													u.id = @cgScopeId
											)
										ELSE NULL
									END
								) '@userName',
								(
									CASE @cgScopeType
										WHEN 15 THEN (		-- USERGROUP_ENTITY
												SELECT
													CASE
														WHEN p.id IS NULL THEN g.name
														ELSE p.domainName + '\' + g.name
													END '@entityName'
												FROM UMGroups g WITH(NOLOCK)
													LEFT OUTER JOIN UMDSProviders p ON
														p.id = g.umdsProviderId
														AND g.umdsProviderId > 0
												WHERE
													g.id = @cgScopeId
											)
										ELSE NULL
									END
								) '@userGroupName',
								(
									CASE @cgScopeType
										WHEN 61 THEN (		-- PROVIDER_ENTITY
												SELECT
													p.domainName
												FROM UMDSProviders p WITH(NOLOCK)
												WHERE
													p.id = @cgScopeId
											)
										ELSE NULL
									END
								) '@providerDomainName',
								(
									CASE @cgScopeType
										WHEN 1 THEN (		-- COMMCELL_ENTITY
												SELECT
													cc.aliasName
												FROM APP_Commcell cc WITH(NOLOCK)
												WHERE
													cc.id = @cgScopeId
											)
										ELSE NULL
									END
								) '@commCellName'
							FOR XML PATH('entity'), ROOT('scgScope'), TYPE
						)
				END
			FROM App_SCGRule as ASR
				inner join App_ClientGroup as ACG on
					ACG.id = ASR.scgId
			where
				ACG.id = @scgId
			FOR XML PATH('clientGroupDetail'), ROOT('App_PerformClientGroupResp')
		)
		, '<App_PerformClientGroupResp/>'
	)
END
IF (@i_req = '5')
BEGIN
	--Delete
	SET @scgId = ( SELECT ref.value('@clientGroupId', 'integer') FROM  @i_RuleData.nodes('App_PerformClientGroupReq/clientGroupDetail/clientGroup') R(ref))
	DELETE FROM App_ClientGroupAssoc WHERE clientGroupId=@scgId
	DELETE FROM App_SCGRule	WHERE scgId = @scgId		-- APP_SCGScope cascade delete
	DELETE FROM App_ClientGroup WHERE id = @scgId
	DELETE FROM App_SCGClientGroupDependency WHERE ownerGrpId = @scgId
	UPDATE 	ArchGroupClientGroupAssociation SET	enabled = 0, modified = @now WHERE (clientGroupId = @scgId OR associatedClientGroupId = @scgId) AND enabled = 1
	SET @r_RuleData = '<App_GenericResp errorCode="0"/>'
END
IF (@i_req = '6')
BEGIN
	--Only preview generate the list of the clients that will be populated
	SET @scgId = ( SELECT ref.value('@clientGroupId', 'integer') FROM  @i_RuleData.nodes('App_PerformClientGroupReq/clientGroupDetail/clientGroup') R(ref))
	DECLARE @createAsUserId INT = ISNULL((SELECT ref.value('@userId', 'integer') FROM  @i_RuleData.nodes('App_PerformClientGroupReq/clientGroupDetail/createAs/user/user') R(ref)), 0)
	DECLARE @createAsUserGroupId INT = ISNULL((SELECT ref.value('@userGroupId', 'integer') FROM  @i_RuleData.nodes('App_PerformClientGroupReq/clientGroupDetail/createAs/userGroup') R(ref)), 0)
	DECLARE  @previewClientIdTable TABLE (clientId integer PRIMARY KEY)
	DECLARE  @finalClientList TABLE (clientId integer PRIMARY KEY)
	-- Clients to always Exclude from SCG Listings
	-- CS Clustered Physical Clients
	DECLARE @isExcludeSet	INT = 0
	DECLARE @ExcludeClients TABLE (
		clientId	INT PRIMARY KEY
	)
	-- Get key to check for reverting to orignal implementation of no excluding clients
	DECLARE @isExcludeSetDisable	INT = 0
	SELECT
		@isExcludeSetDisable = CAST(p.value AS INT)
	FROM GXGlobalParam p WITH(NOLOCK)
	WHERE
		name = N'DisableSCGExcludeClientSet'
	IF (@isExcludeSetDisable IS NULL OR @isExcludeSetDisable = 0)
	BEGIN
		INSERT INTO @ExcludeClients (clientId)
			SELECT PMClientId
			FROM APP_VMToPMMap WITH(NOLOCK)
			WHERE VMClientId = 2	-- CS Id
		SET @isExcludeSet = @@ROWCOUNT
	END
	-- Make a copy of the inputted ruleQuery so that the SCGId can be overridden if >0
	DECLARE @ruleQuery NVARCHAR(MAX) = @i_RuleQuery
	IF @scgId > 0
	BEGIN
		-- Tell the SCG Rule the SCGId being processed so that Security Queries can ignore the group and NOT inherit from itself causing a chicken / egg issue.
		SELECT @ruleQuery = REPLACE(@ruleQuery, '0/*SCGProcessing*/', CAST(@scgId AS NVARCHAR(12)))
	END
	INSERT INTO @previewClientIdTable EXEC (@ruleQuery)
	IF (@isExcludeSetDisable IS NULL OR @isExcludeSetDisable = 0)
	BEGIN
		IF (@isExcludeSet > 0)
		BEGIN
			-- Delete Exclude Clients that should never appear in group
			DELETE pct
			FROM @previewClientIdTable pct
				INNER JOIN @ExcludeClients ec ON
					ec.clientId = pct.clientId
		END
	END
	--filter @previewClientIdTable based on the capabilities of clientGrpCreator
	INSERT INTO @oldClientIdTable SELECT clientId  FROM app_clientgroupassoc with(nolock) WHERE clientGroupId = @scgId
	SET @cgScopeType = NULL
	SELECT TOP 1	-- safety
		@cgScopeType = ref.value('@_type_', 'INT'),
		@cgScopeId = CASE ref.value('@_type_', 'INT')
						WHEN 1 THEN ref.value('@commCellId', 'INT')
						WHEN 13 THEN ref.value('@userId', 'INT')
						WHEN 15 THEN ref.value('@userGroupId', 'INT')
						WHEN 61 THEN ref.value('@providerId', 'INT')
						ELSE NULL
					END
	FROM  @i_RuleData.nodes('App_PerformClientGroupReq/clientGroupDetail/scgScope/entity') R(ref)
	IF (@cgScopeType IS NULL)
	BEGIN
		-- try a default scope
		-- Determine Client Group Scope based on inputted User's rights
		EXEC APPComputeClientGroupScope @i_uid, @cgScopeType OUTPUT, @cgScopeId OUTPUT
	END
	ELSE
	BEGIN
		-- There are cases where a user has SCG Creator rights against client groups created by
		-- other users with higher SCG Scope rights that could fail since the editing user
		-- may NOT have rights to the SCG Scope assigned to the client group.
		-- So if SCG Scope level is NOT being changed from the current set value, ignore SCG Scope Check.
		-- Is SCG Scope being changed during perview operation?
		SET @noScopeRowChg = 1		-- set to changed incase query row not found below
		SELECT
			@noScopeRowChg = CASE
								WHEN s.entityType = @cgScopeType AND s.entityId = @cgScopeId THEN 0
								ELSE 1
							END,
			@curScopeType = s.entityType,
			@curScopeId = s.entityId
		FROM APP_SCGScope s WITH(NOLOCK)
		WHERE
			s.scgRuleId = @scgRuleId
		--PRINT 'APPSCGHandler cgScopeType[' + cast(@cgScopeType as varchar(12)) + '] cgScopeId['+ cast(@cgScopeId as varchar(12)) + '] curScopeType[' + cast(@curScopeType as varchar(12)) + '] cgScopeId['+ cast(@curScopeId as varchar(12)) + ']'
		IF (@noScopeRowChg = 1)		-- is user changing the scope
		BEGIN
			-- Verify that scope is not being exceeded
			-- We should check for both scope type and scope Id.
			-- If from REST API / Qcommand XML some one tries to invoke it wrongly, we should error out.
IF @cgScopeType = 1
				SET @scopeCheckXML = '<App_GetSCGScopeEntitiesUserRequest property="20" scopeType="1"/>'
ELSE IF @cgScopeType = 15
				SET @scopeCheckXML = '<App_GetSCGScopeEntitiesUserRequest property="20" scopeType="15"/>'
ELSE IF @cgScopeType = 13
				SET @scopeCheckXML = '<App_GetSCGScopeEntitiesUserRequest property="20" scopeType="13"/>'
ELSE IF @cgScopeType = 61
				SET @scopeCheckXML = '<App_GetSCGScopeEntitiesUserRequest property="20" scopeType="61"/>'
			EXEC APPGetSCGScopeEntitiesForUserSQL @i_uid, 0, @scopeCheckXML, @scopeCheckXMLOutput OUTPUT
			INSERT INTO #scopeAllowedEntities
				SELECT DISTINCT
					ref.value('@entityType', 'INT'),
					ref.value('@entityId', 'INT')
				FROM @scopeCheckXMLOutput.nodes('App_GetSCGScopeEntitiesUserResponse/scopeEntities/entities/entity') R(ref)
			IF NOT EXISTS (SELECT TOP 1 1 FROM #scopeAllowedEntities WHERE entityType = @cgScopeType AND entityId = @cgScopeId)
					SET  @isScopeError = 1
			IF ( @isScopeError = 1 OR @cgScopeId IS NULL)
			BEGIN
				SET @scopeMsg = 'Automatic Client Group Scope Level exceeded by userId [' + CAST(@i_uid AS VARCHAR(12)) +
					'] max Scope Level [' + CAST(@maxScopeType AS VARCHAR(12)) +
					'] selected Scope Level [' +  CAST(@cgScopeType AS VARCHAR(12)) + ']'
				PRINT 'AppSCGHandleReq Error: ' + @scopeMsg
				RAISERROR(@scopeMsg, 16, 1)
				RETURN
			END
		END
	END
	IF (@cgScopeType IN (13, 15))	-- USER_ENTITY / USERGROUP_ENTITY
	BEGIN
		-- Apply user filtering - perform previous filtering operations based on user rights
		DECLARE @shouldRefreshCredentials INT = 1
		--Set Client group creator id from create As info
		SET @clientGroupCreatorId = @cgScopeId
		IF (@cgScopeType = 13)
		BEGIN
			SET @clientGroupCreatorId = @cgScopeId
		END
		ELSE IF (@cgScopeType = 15) --If create As is a user group, get create As userId for that user group.
		BEGIN
			EXEC sec_getCreateAsUserId 0, 0, @clientGroupCreatorId OUTPUT, 0, @shouldRefreshCredentials, @cgScopeId
		END
		--If user is editing smart client group rules check for 'Administrative Management' + 'Change Client Associations' permission on client group to edit its client associations
		IF @scgId > 0
		BEGIN
			DECLARE @oldRuleQuery NVARCHAR(MAX) = ISNULL((SELECT ruleQuery FROM App_SCGRule WHERE scgId = @scgId), '')
			IF @oldRuleQuery <> @i_RuleQuery
			BEGIN
exec sec_checkPermissionOnEntity @i_uid, '181,1', @canAdministerClientGroup OUTPUT, 28, @scgId, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1
			END
		END
		IF @clientGroupCreatorId > 0 AND @canAdministerClientGroup = 1
		BEGIN
				DECLARE @canAddClientProcErrorCode  INTEGER=0
				DECLARE @canAddClientProcisSecurityNeeded INTEGER=0
				DECLARE @ruleXmlString   nvarchar(max) =		 CONVERT(nvarchar(max),@i_RuleData)
				exec sec_canAddClientToClientGroup @clientGroupCreatorId,@scgId,0,@ruleXmlString,0,@canAddClientProcErrorCode OUTPUT,@canAddClientProcisSecurityNeeded OUTPUT,''
				IF(@canAddClientProcErrorCode = 0) --Can see Clients
				BEGIN
					IF OBJECT_ID('tempdb.dbo.#clientsWithRequiredPermissions') IS NOT NULL
						DROP TABLE #clientsWithRequiredPermissions
					CREATE TABLE #clientsWithRequiredPermissions (clientId INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT)
					IF(@canAddClientProcisSecurityNeeded <> 0)	-- Check for 'Change Security Settings' permission in addition to 'Agent Management'
					BEGIN
exec sec_getIdaObjectsForUser @clientGroupCreatorId, 3, 0, 0, '#clientsWithRequiredPermissions', 0, '2,107', 1
					END
					ELSE
					BEGIN
exec sec_getIdaObjectsForUser @clientGroupCreatorId, 3, 2, 0, '#clientsWithRequiredPermissions'
					END
					DELETE P FROM @previewClientIdTable AS P
							LEFT OUTER JOIN #clientsWithRequiredPermissions AS C
							ON P.clientId = C.clientId
								WHERE C.clientId IS NULL
					INSERT INTO @finalClientList
						SELECT clientId FROM @previewClientIdTable
				END
		END
		ELSE   --User doesn't have required rights to change rules, hence no change in client list
		BEGIN
			INSERT INTO @finalClientList
				SELECT oldClientId FROM @oldClientIdTable
		END
	END
	ELSE IF (@cgScopeType = 61)	-- PROVIDER_ENTITY
	BEGIN
		-- Apply Company provider filtering
		-- Clients okay to associate with client group scope
		INSERT INTO @finalClientList
			SELECT
				clientId
			FROM @previewClientIdTable
			INTERSECT
			SELECT
                clientid
            FROM (
                    -- Get all the clients associated to this Company
                    SELECT      -- Installed by Tenant Admin
                        clientId
                    FROM dbo.scgV2CompanyClientInstallAssociations('=', @cgScopeId, 0, 0)
                    UNION
                    SELECT      -- By Association
                        clientId
                    FROM dbo.scgV2CompanyClientAssociations('=', @cgScopeId, 0, 0)
                ) q
	END
	ELSE
	BEGIN
		-- COMMCELL_ENTITY
		-- no filtering required
		INSERT INTO @finalClientList
			SELECT clientId FROM @previewClientIdTable
	END
	SET @r_RuleData = ISNULL(
		(
			SELECT
				(
					SELECT
						AC.id AS '@clientId',
						AC.name AS '@clientName'
					FROM
						[dbo].[APP_Client] AS AC
						INNER JOIN @finalClientList AS CT ON
							AC.id = CT.clientId
					FOR XML PATH('associatedClients'), TYPE
				) FOR XML PATH ('clientGroupDetail'), ROOT ('App_PerformClientGroupResp')
		),
		'<App_PerformClientGroupResp/>'
	)
END
SELECT @r_RuleData;
GO

IF EXISTS (select * from GxQscripts where name = 'AppSCGHandleReq')
	delete from GxQscripts where name = 'AppSCGHandleReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSCGHandleReq')
	delete from GXDBVersions where aliasname = 'AppSCGHandleReq'
GO

insert into GXDBVersions values(2, 'AppSCGHandleReq',  'v1.24.2.24.8.1', 'AppSCGHandleReq', 'v1.24.2.24.8.1')
GO

