

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSCGGetPropertyDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSCGGetPropertyDetails.sp,v $ $Id: AppSCGGetPropertyDetails.sp,v 1.8.208.4 2018/03/22 01:30:24 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppSCGGetPropertyDetails"
--	|	This Procedure is used to handle the different request for VM Allocation Policy
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSCGGetPropertyDetails <<<'

IF EXISTS (select * from sysobjects where name='AppSCGGetPropertyDetails')
	drop procedure AppSCGGetPropertyDetails
IF EXISTS (select * from GxQscripts where name='AppSCGGetPropertyDetails')
	delete from GxQscripts where name = 'AppSCGGetPropertyDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSCGGetPropertyDetails')
	delete from GXDBVersions where aliasname = 'AppSCGGetPropertyDetails'
GO
print '... Creating Procedure: AppSCGGetPropertyDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSCGGetPropertyDetails
-- Input arguments
  @i_userId INT, 
  @i_localeId INT, 
  @i_propId INT
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @r_propData XML;
IF (@i_propId = '0')
BEGIN
	--Send the list of all the properties
	DECLARE @temp_prop_table TABLE (
		id INTEGER
		,ptype INTEGER
		,NAME NVARCHAR(512)
		,label NVARCHAR(512)
		,funcName NVARCHAR(512)
		,complex INTEGER
		,locLabel NVARCHAR(512)
	)
	INSERT INTO @temp_prop_table
		SELECT
			id
			,ptype
			,NAME
			,label
			,funcName
			,complex
			,CASE
				WHEN localeMsgId > 0 THEN dbo.fn_EvFormatEventMsgText(0, @i_localeId, localeMsgId, 0, 2)
				ELSE NULL
			END
		FROM [dbo].[app_scgproperty]
		UNION ALL
		SELECT
			id
			,ptype
			,NAME
			,label
			,funcName
			,complex
			,CASE
				WHEN localeMsgId > 0 THEN dbo.fn_EvFormatEventMsgText(0, @i_localeId, localeMsgId, 0, 2)
				ELSE NULL
			END
		FROM [dbo].[app_scguserproperty]
		WHERE (enabled = 1)
	SET @r_propData = ISNULL((
			SELECT
				id AS '@id'
				,pType AS '@propType'
				,NAME AS '@name'
				,CASE
					WHEN locLabel IS NOT NULL THEN locLabel
					ELSE label
				END AS '@label'
				,funcName AS '@funcName'
				,complex AS '@isComplex'
			FROM @temp_prop_table
			ORDER BY label
			FOR XML PATH('props')
				,ROOT('App_SCGPropListResp')
			), '<App_SCGPropListResp/>')
END
ELSE
BEGIN
	--Details of a property
if (@i_propId < 100000)
	BEGIN
		SET @r_propData = ISNULL ((
											SELECT id AS '@id', pType as '@propType',  name as '@name',
											case when (localeMsgId=0) then label else dbo.fn_EvFormatEventMsgText(0,@i_localeId, localeMsgId, 0,2) end AS '@label',
											funcName as '@funcName', complex as '@isComplex'
											from dbo.app_scgproperty where id = @i_propId
											FOR XML PATH('App_SCGProperty'), TYPE),
											'<App_SCGProperty/>')
	END
	ELSE
	BEGIN
		SET @r_propData = ISNULL ((
											SELECT id AS '@id', pType as '@propType',  name as '@name',
											case when (localeMsgId=0) then label else dbo.fn_EvFormatEventMsgText(0,@i_localeId, localeMsgId, 0,2) end AS '@label',
											funcName as '@funcName', complex as '@isComplex'
											from dbo.app_scguserproperty where id = @i_propId
											FOR XML PATH('App_SCGProperty'), TYPE),
											'<App_SCGProperty/>')
	END
END
SELECT @r_propData;
GO

IF EXISTS (select * from GxQscripts where name = 'AppSCGGetPropertyDetails')
	delete from GxQscripts where name = 'AppSCGGetPropertyDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSCGGetPropertyDetails')
	delete from GXDBVersions where aliasname = 'AppSCGGetPropertyDetails'
GO

insert into GXDBVersions values(2, 'AppSCGGetPropertyDetails',  '00010008020800040000', 'AppSCGGetPropertyDetails', '00010008020800040000')
GO

