

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSCGGetOSVersionInfoEnum.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSCGGetOSVersionInfoEnum.sp,v $ $Id: AppSCGGetOSVersionInfoEnum.sp,v 1.1.2.1 2018/06/11 08:32:22 vsubramanian Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppSCGGetOSVersionInfoEnum"
--	|	Get TimeZone Regions
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSCGGetOSVersionInfoEnum <<<'

IF EXISTS (select * from sysobjects where name='AppSCGGetOSVersionInfoEnum')
	drop procedure AppSCGGetOSVersionInfoEnum
IF EXISTS (select * from GxQscripts where name='AppSCGGetOSVersionInfoEnum')
	delete from GxQscripts where name = 'AppSCGGetOSVersionInfoEnum'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSCGGetOSVersionInfoEnum')
	delete from GXDBVersions where aliasname = 'AppSCGGetOSVersionInfoEnum'
GO
print '... Creating Procedure: AppSCGGetOSVersionInfoEnum'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSCGGetOSVersionInfoEnum
-- Input arguments
  @i_userId INT, 
  @i_localeId INT
AS
-- Following are the "columns" returned, in the order in which they are declared
 BEGIN
  DECLARE @r_enumValues XML;
	 DECLARE @nowTime INT;
	 DECLARE @MaxID INT= 100;
	 DECLARE @NewRows INT= 0;
     SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;
--Send the list of all the properties
         SET @nowTime = dbo.GetUnixTime(GETUTCDATE());
		  DECLARE @OSList TABLE
                 (ID     INT ,
                  OSname NVARCHAR(4000)
                 )
         IF NOT EXISTS
         (
             SELECT 1
             FROM GxGlobalParam
             WHERE Name = 'SCGGetOSVersionInfoEnumXML'
         )
             BEGIN
				INSERT INTO @OSList
                 (ID,
                  OSName
                 )
				 SELECT ROW_NUMBER() OVER(ORDER BY Attrval ASC) + @MaxID ,
                                              Attrval
                                       FROM App_ClientProp
                                       WHERE attrname = 'Operating System Name'
											 AND Modified=0
                                       GROUP BY Attrval
                                       ORDER BY attrVal ASC
                 INSERT INTO GxGlobalParam
                 (name,
                  Value,
                  created,
                  modified
                 )
                        SELECT 'SCGGetOSVersionInfoEnumXML',
                               CAST(
                                   (
                                   (
                                       SELECT ID AS '@OSID',
                                              OSName AS '@OSName'
                                       FROM @OSList
                                       ORDER BY ID ASC FOR XML PATH('OSList'), ROOT('OS_Info'), TYPE
                                   )
                                   ) AS NVARCHAR(MAX)) AS Attrval,
                               @nowTime,
                               0
		  END
            ELSE
            BEGIN
			--Update The Latest Value if changed
                 DECLARE @XmlInfo XML
                 SELECT @XmlInfo = CAST(Value AS XML)
                 FROM GxGlobalParam
                 WHERE Name = 'SCGGetOSVersionInfoEnumXML'
                 INSERT INTO @OSList
                 (ID,
                  OSName
                 )
                        SELECT t.c.value('(@OSID[1])', 'int'),
                               t.c.value('(@OSName[1])', 'NVARCHAR(MAX)')
                        FROM @XmlInfo.nodes('OS_Info/OSList') AS T(C)
                 IF @@ROWCOUNT>0
					SELECT @MaxID = MAX(ID)   FROM @OSList
				 ELSE
					SET @MaxID=100
                 INSERT INTO @OSList
                 (ID,
                  OSName
                 )
                        SELECT ROW_NUMBER() OVER(ORDER BY Attrval ASC) + @MaxID,
                               attrVal
                        FROM App_ClientProp Acp
                             LEFT JOIN @OSList Os ON Acp.attrVal = Os.OSname
                        WHERE Os.ID IS NULL
                              AND acp.attrname = 'Operating System Name'
							  AND acp.Modified=0
                        GROUP BY attrVal
                        ORDER BY attrVal ASC
                 IF @@ROWCOUNT > 0  --New Rows Data changed
                     BEGIN
                         UPDATE GxGlobalParam
                           SET
                               Value = CAST(
                                           (
                                           (
                                               SELECT ID AS '@OSID',
                                                      OSName AS '@OSName'
                                               FROM @OSList
                                               ORDER BY ID ASC FOR XML PATH('OSList'), ROOT('OS_Info'), TYPE
                                           )
                                           ) AS NVARCHAR(MAX)),
                               created = @nowTime
                         WHERE NAME = 'SCGGetOSVersionInfoEnumXML' AND Modified=0
                 END;
         END;
--ReSync Value
         SET @r_enumValues = ISNULL(
                                   (
                                       SELECT DISTINCT
                                              ID AS '@value',
                                              OSName AS '@label'
                                       FROM @OSList FOR XML PATH('enumValues'), ROOT('App_SCGGetEnumValuesResp')
                                   ), '<App_SCGGetEnumValuesResp/>');
         SELECT @r_enumValues
     END
GO

IF EXISTS (select * from GxQscripts where name = 'AppSCGGetOSVersionInfoEnum')
	delete from GxQscripts where name = 'AppSCGGetOSVersionInfoEnum'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSCGGetOSVersionInfoEnum')
	delete from GXDBVersions where aliasname = 'AppSCGGetOSVersionInfoEnum'
GO

insert into GXDBVersions values(2, 'AppSCGGetOSVersionInfoEnum',  '00010001000200010000', 'AppSCGGetOSVersionInfoEnum', '00010001000200010000')
GO

