

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSCGDiscoverRefresh.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSCGDiscoverRefresh.sp,v $ $Id: AppSCGDiscoverRefresh.sp,v 1.1.2.4 2018/12/21 19:24:22 syadav Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppSCGDiscoverRefresh"
--	|	This Procedure is used for associating discovered clients
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSCGDiscoverRefresh')
BEGIN
	print '>>> Drop Stored Procedure: AppSCGDiscoverRefresh <<<'
	drop procedure AppSCGDiscoverRefresh
END
IF EXISTS (select * from GxQscripts where name='AppSCGDiscoverRefresh')
	delete from GxQscripts where name = 'AppSCGDiscoverRefresh'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSCGDiscoverRefresh')
	delete from GXDBVersions where aliasname = 'AppSCGDiscoverRefresh'
GO
print '... Creating Procedure: AppSCGDiscoverRefresh'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSCGDiscoverRefresh
-- Input arguments
  @clientGroupId INT,
  @context INT
AS
  DECLARE @errorCode INT
SET NOCOUNT ON
DECLARE @clientIdCsv VARCHAR(MAX)
DECLARE @instanceIdCsv VARCHAR(MAX)
IF(@context = 1)
BEGIN
	UPDATE APP_ComponentProp
	SET longVal = 0
	WHERE componentId = @clientGroupId
		AND propertyTypeId = 3318
		AND componentType = 8
		AND modified = 0
END
ELSE
BEGIN    -- Extreme case when sync request started but somehow thread got killed or abrupt ending, in that case we will wait for 2 hrs and will reset the sync Status
 IF EXISTS (
			SELECT 1 FROM
			APP_ComponentProp
			WHERE componentId = @clientGroupId
			AND propertyTypeId = 3318
			AND longVal = 1
			AND componentType = 8
			AND modified = 0
			AND dbo.getUnixtime(dbo.CellLocalToUTCTime(GETDATE(), 2)) - created > 7200 )
		BEGIN
			UPDATE APP_ComponentProp
			SET longVal = 0
			WHERE componentId = @clientGroupId
			AND propertyTypeId = 3318
			AND componentType = 8
			AND modified = 0
		END
END
SET @clientIdCsv =	ISNULL((SELECT stringVal
					FROM APP_ComponentProp AC WITH(NOLOCK)
					WHERE  AC.componentId = @clientGroupId
					AND AC.propertyTypeId = 3314
					AND componentType = 8
					AND modified = 0), '')
SET @instanceIdCsv =	ISNULL((SELECT stringVal
					FROM APP_ComponentProp AC WITH(NOLOCK)
					WHERE  AC.componentId = @clientGroupId
					AND AC.propertyTypeId = 3315
					AND componentType = 8
					AND modified = 0), '')
IF OBJECT_ID('tempdb.dbo.#NewClientIds') IS NOT NULL
    DROP TABLE #NewClientIds
CREATE TABLE #NewClientIds(clientId INT)
IF OBJECT_ID('tempdb.dbo.#InstanceIds') IS NOT NULL
    DROP TABLE #InstanceIds
CREATE TABLE #InstanceIds(instanceId INT)
IF OBJECT_ID('tempdb.dbo.#OldClientIds') IS NOT NULL
    DROP TABLE #OldClientIds
CREATE TABLE #OldClientIds (clientid INT)
INSERT #NewClientIds
SELECT DISTINCT T._ID
FROM dbo.splitids(@clientIdCsv) T
-- Once we have a proper fix from VSA team we will uncomment the below query till then we will doing normal delta of clients.
--INSERT #InstanceIds
--SELECT T._ID
--FROM dbo.splitids(@instanceIdCsv) T
--INSERT #OldClientIds
--SELECT A.clientId
--FROM (	SELECT clientId
--		FROM APP_ClientGroupAssoc
--		WHERE clientGroupId = @clientGroupId) A
--	INNER JOIN APP_ClientProp B
--			ON A.clientId = B.clientId AND B.attrName = N'Virtual Machine Instance ID'  AND B.modified = 0 AND B.attrType = 7
--	INNER JOIN #InstanceIds  C
--			ON CONVERT(INT,B.attrVal) = C.instanceId
INSERT #OldClientIds
SELECT clientId
FROM APP_ClientGroupAssoc WITH(NOLOCK)
		WHERE clientGroupId = @clientGroupId
INSERT APP_ClientGroupAssoc
SELECT @clientGroupId, Ins.clientId
FROM ( SELECT A.clientId
		FROM #NewClientIds A
			LEFT OUTER JOIN #OldClientIds B
				ON  A.clientId = B.clientId
		WHERE B.clientId IS NULL ) Ins
		INNER JOIN 	APP_Client AC WITH(NOLOCK)
				ON Ins.clientId = AC.id
DELETE CGA
FROM APP_ClientGroupAssoc CGA , ( SELECT A.clientId
								  FROM #OldClientIds A
									LEFT OUTER JOIN #NewClientIds B
										ON A.clientId = B.clientId
									WHERE B.clientid IS NULL ) R
WHERE CGA.clientId =  R.clientId
AND CGA.clientGroupId = @clientGroupId
IF OBJECT_ID('tempdb.dbo.#NewClientIds') IS NOT NULL
    DROP TABLE #NewClientIds
IF OBJECT_ID('tempdb.dbo.#OldClientIds') IS NOT NULL
    DROP TABLE #OldClientIds
IF OBJECT_ID('tempdb.dbo.#InstanceIds') IS NOT NULL
    DROP TABLE #InstanceIds
SET NOCOUNT OFF
SELECT 0
GO

IF EXISTS (select * from GxQscripts where name = 'AppSCGDiscoverRefresh')
	delete from GxQscripts where name = 'AppSCGDiscoverRefresh'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSCGDiscoverRefresh')
	delete from GXDBVersions where aliasname = 'AppSCGDiscoverRefresh'
GO

insert into GXDBVersions values(2, 'AppSCGDiscoverRefresh',  '00010001000200040000', 'AppSCGDiscoverRefresh', '00010001000200040000')
GO

