

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppResourcePoolUpdate.sp] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppResourcePoolUpdate')
BEGIN
	print '>>> Drop Stored Procedure: AppResourcePoolUpdate <<<'
	drop procedure AppResourcePoolUpdate
END
IF EXISTS (select * from GxQscripts where name='AppResourcePoolUpdate')
	delete from GxQscripts where name = 'AppResourcePoolUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppResourcePoolUpdate')
	delete from GXDBVersions where aliasname = 'AppResourcePoolUpdate'
GO
print '... Creating Procedure: AppResourcePoolUpdate'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppResourcePoolUpdate
  @i_userId INT, 
  @i_localeId INT,
  @x_xmlData XML OUTPUT
AS
	SET NOCOUNT ON;
	DECLARE @isCommCellAdmin INT = 0
	DECLARE @errorCode INT = 0
	DECLARE @errorString NVARCHAR(MAX) = ''
	DECLARE @nowTime				INT = datediff(second, '01/01/1970', GETDATE())
	-- Get resource pool creation details from XML
	DECLARE @executionUnixTime  INT           = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
	DECLARE @resourcePoolName  NVARCHAR(MAX) =  ISNULL((SELECT ref.value('@resourcePoolName', 'nvarchar(MAX)') AS [resourcePoolName]    FROM @x_xmlData.nodes('Api_UpdateResourcePoolReq/resourcePool/resourcePool') R ( ref )),'')
 	DECLARE @indexServerId INT = ISNULL((SELECT ref.value('@clientId', 'nvarchar(MAX)') AS [clientId]    FROM @x_xmlData.nodes('Api_UpdateResourcePoolReq/resourcePool/indexServer') R ( ref )),0)
	DECLARE @appType INT = ISNULL((SELECT ref.value('@appType', 'INT') AS [appType]    FROM @x_xmlData.nodes('Api_UpdateResourcePoolReq/resourcePool') R ( ref )),0)
	DECLARE @resourcePoolId INT = (SELECT ref.value('@resourcePoolId', 'INT') AS [resourcePoolId]   FROM @x_xmlData.nodes('Api_UpdateResourcePoolReq/resourcePool/resourcePool') R ( ref ))
	DECLARE @storagePoolId INT = ISNULL((SELECT ref.value('@storagePoolId', 'INT') AS [storagePoolId]    FROM @x_xmlData.nodes('Api_UpdateResourcePoolReq/resourcePool/storagePool') R ( ref )), 0)
	DECLARE @dataAccessNodeGrpId INT = ISNULL((SELECT ISNULL(ref.value('@clientGroupId', 'INT'), 0) AS [clientGroupId]
										FROM @x_xmlData.nodes('Api_UpdateResourcePoolReq/resourcePool/dataAccessNodeGroup') R ( ref )), 0)
	DECLARE @extendedProps XML = (SELECT @x_xmlData.query('Api_UpdateResourcePoolReq/resourcePool/extendedProp'))
	IF (@resourcePoolId = 0)
	BEGIN
		SET @errorCode = 100; SET @errorString = 'Invalid input. No ResourcePool id specified.'
		GOTO ERROR_EXIT;
	END
	ELSE IF (NOT EXISTS(SELECT 1 FROM APP_ResourcePool WHERE resourcePoolId = @resourcePoolId AND modified = 0))
	BEGIN
		SET @errorCode = 100; SET @errorString = 'Invalid input. ResourcePool id not found.'
		GOTO ERROR_EXIT;
	END
	-- Caller can change resourcepoolName, indexServerCLientId, appType, storagepoolId and accessNodesGroupId
	-- If any of the above values are provided then age out existing entry and create a new entry.
	DECLARE @oldName NVARCHAR(MAX),
			@oldIndexServerId INT,
			@oldAppType INT,
			@oldStoragePoolId INT,
			@olddataAccessNodeGrpId INT
	SELECT @oldName = resourcePoolName, @oldIndexServerId = indexServerClientId, @oldAppType = appType, @oldStoragePoolId = storagePoolId,
		@olddataAccessNodeGrpId = accessNodesGroupId
	FROM APP_ResourcePool WHERE resourcePoolId = @resourcePoolId AND modified = 0
	SET @resourcePoolName = IIF(@resourcePoolName='', @oldName, @resourcePoolName)
	SET @indexServerId = IIF(@indexServerId = 0, @oldIndexServerId, @indexServerId)
	SET @appType = IIF(@appType=0, @oldAppType, @appType)
	SET @storagePoolId = IIF(@storagePoolId=0, @oldStoragePoolId, @storagePoolId)
	SET @dataAccessNodeGrpId = IIF(@dataAccessNodeGrpId=0, @olddataAccessNodeGrpId, @dataAccessNodeGrpId)
	IF @indexServerId <> @oldIndexServerId
	BEGIN
		SET @errorCode = 100; SET @errorString = 'Invalid input. Index server cannot be changed.'
		GOTO ERROR_EXIT;
	END
	IF @resourcePoolName<>@oldName OR @appType <> @oldAppType OR @storagePoolId <> @oldStoragePoolId OR @dataAccessNodeGrpId <> @olddataAccessNodeGrpId	OR @extendedProps IS NOT NULL
	BEGIN
		IF @appType <> @oldAppType OR @storagePoolId <> @oldStoragePoolId
		BEGIN
			IF EXISTS (SELECT 1 FROM APP_ResourcePool WHERE apptype = @appType AND storagePoolId = @storagePoolId AND resourcePoolId <> @resourcePoolId AND modified = 0)
			BEGIN
				SET @errorCode = 87; SET @errorString = 'Another resource pool already exist for this storage pool and solution type.'
				GOTO ERROR_EXIT;
			END
		END
		--
		IF EXISTS(SELECT 1 FROM APP_ResourcePool RP WHERE RP.resourcePoolName = @resourcePoolName AND RP.resourcePoolId <> @resourcePoolId AND modified = 0)
		BEGIN
			SET @errorCode = 103; SET @errorString = 'A ResourcePool with the same name already exist.'
			GOTO ERROR_EXIT;
		END
		--
		-- Check if user has Administrative Management at Commcell level privilege
EXEC sec_checkPermissionOnEntity @i_userId, 1, @isCommCellAdmin OUT, 1, 2
		if(@isCommCellAdmin != 1)
		BEGIN
			SET @errorCode = 5
			SET @errorString = 'User is not CommCell Admin'
			GOTO ERROR_EXIT;
		END
		--
		-- IN CASE OF RESOURCEPOOL NAME CHANGE, UPDATE ACCESS NODE GROUP NAME AS WELL (IF CREATED BY RESOURCEPOOL)
			-- THIS WILL NOT COVER THE SCENARIO WHERE THE DATA ACCESS GROUP IS CHANGED ON THE REOUSRCE POOL.
		IF @resourcePoolName<>@oldName
		BEGIN
			UPDATE CG
				SET CG.name = @resourcePoolName + ' ResourcePool'
			FROM APP_ClientGroup CG
INNER JOIN App_ClientGroupProp CGP ON CGP.attrName = 'System Created' AND CGP.modified = 0 AND CGP.attrVal = 0
			WHERE CG.id = @olddataAccessNodeGrpId AND CG.flag = 0
		END
		--
		UPDATE APP_ResourcePool SET resourcePoolName = @resourcePoolName, storagePoolId=@storagePoolId, accessNodesGroupId=@dataAccessNodeGrpId,
			appType = @appType, extendedProps = @extendedProps
		WHERE resourcePoolId = @resourcePoolId AND modified = 0
		--
		--
		--	AUDIT ------------------------------------------------------------------------------------------------------------------------------------------------------------------------
DECLARE @opMsgId    INT = (704 | (CAST(POWER(2, 24) AS BIGINT) * 84)) -- 'Update resource pool'
		DECLARE @opEvMsgId  INT -- dummy not used.
		DECLARE @paramMsgId INT = 0
		DECLARE @opId       INT = 0
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userId, 191, @resourcePoolId, @opEvMsgId OUTPUT, @opId OUTPUT
		--
		IF @resourcePoolName<>@oldName
		BEGIN
SET @paramMsgId = (1865 | (CAST(POWER(2, 24) AS BIGINT) * 85))   --'Name changed from [^1%s] to [^2%s]'
			EXEC EvGuiAuditSetParamData @opId, @oldName, 0
			EXEC EvGuiAuditSetParamData @opId, @resourcePoolName, 0
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		END
		IF @indexServerId <> @oldIndexServerId
		BEGIN
SET @paramMsgId = (1864 | (CAST(POWER(2, 24) AS BIGINT) * 85))   --'Index server changed from [^1%d] to [^2%d]'
			EXEC EvGuiAuditSetParamData @opId, @oldIndexServerId, 0
			EXEC EvGuiAuditSetParamData @opId, @indexServerId, 0
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		END
		IF @appType <> @oldAppType
		BEGIN
SET @paramMsgId = (1863 | (CAST(POWER(2, 24) AS BIGINT) * 85))   --'Apptype changed from [^1%d] to [^2%d]'
			EXEC EvGuiAuditSetParamData @opId, @oldAppType, 0
			EXEC EvGuiAuditSetParamData @opId, @appType, 0
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		END
		IF @storagePoolId <> @oldStoragePoolId
		BEGIN
SET @paramMsgId = (1866 | (CAST(POWER(2, 24) AS BIGINT) * 85))   --'Storage pool changed from [^1%d] to [^2%d]'
			EXEC EvGuiAuditSetParamData @opId, @oldStoragePoolId, 0
			EXEC EvGuiAuditSetParamData @opId, @storagePoolId, 0
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		END
		IF @dataAccessNodeGrpId <> @olddataAccessNodeGrpId
		BEGIN
SET @paramMsgId = (1862 | (CAST(POWER(2, 24) AS BIGINT) * 85))   --'Access nodes group changed from [^1%d] to [^2%d]'
			EXEC EvGuiAuditSetParamData @opId, @olddataAccessNodeGrpId, 0
			EXEC EvGuiAuditSetParamData @opId, @dataAccessNodeGrpId, 0
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		END
		--	AUDIT ------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	END
ERROR_EXIT:
	--Fill in the response
	SET @x_xmlData =
	(SELECT -- <Api_UpdateResourcePoolResp>
		(SELECT -- <resourcePool>
			RP.appType AS '@appType',
			(SELECT
				RP.resourcePoolId AS '@resourcePoolId',
				RP.resourcePoolName AS '@resourcePoolName'
				FOR XML PATH('resourcePool'),TYPE),
			(SELECT
				RP.storagePoolId AS '@storagePoolId'
				FOR XML PATH('storagePool'),TYPE),
			(SELECT
				RP.indexServerClientId AS '@clientId',
				ISNULL((SELECT name FROM APP_Client C WHERE C.id = RP.indexServerClientId),'') AS '@clientName'
				FOR XML PATH('indexServer'),TYPE),
			(SELECT
				name AS '@clientGroupName',id AS '@clientGroupId' FROM APP_ClientGroup WHERE id = @dataAccessNodeGrpId
				FOR XML PATH('dataAccessNodeGroup'),TYPE),
			ISNULL((SELECT RP.extendedProps),'')
			FROM APP_ResourcePool AS RP WHERE resourcePoolId = @resourcePoolId
			FOR XML PATH('resourcePool'),TYPE),
			(SELECT @errorCode  AS '@errorCode',
                    @errorString   AS '@errorMessage'
             FOR XML PATH('error'), TYPE)
		FOR XML PATH('Api_UpdateResourcePoolResp'),TYPE
		)
	BEGIN
		SELECT @x_xmlData
	END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppResourcePoolUpdate')
	delete from GxQscripts where name = 'AppResourcePoolUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppResourcePoolUpdate')
	delete from GXDBVersions where aliasname = 'AppResourcePoolUpdate'
GO

insert into GXDBVersions values(2, 'AppResourcePoolUpdate',  '00000000000000000000', 'AppResourcePoolUpdate', '00000000000000000000')
GO

