

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppResourcePoolGetList.sp] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppResourcePoolGetList')
BEGIN
	print '>>> Drop Stored Procedure: AppResourcePoolGetList <<<'
	drop procedure AppResourcePoolGetList
END
IF EXISTS (select * from GxQscripts where name='AppResourcePoolGetList')
	delete from GxQscripts where name = 'AppResourcePoolGetList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppResourcePoolGetList')
	delete from GXDBVersions where aliasname = 'AppResourcePoolGetList'
GO
print '... Creating Procedure: AppResourcePoolGetList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppResourcePoolGetList
  @i_userId INT, 
  @i_localeId INT,
  @x_xmlData XML OUTPUT
AS
SET NOCOUNT ON;
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @errorCode INT = 0
	DECLARE @errorString NVARCHAR(MAX) = ''
	--
	-- START - GET PLAN FOR THE STORAGE POOLS -------------------------------------------------------------------------------------------------------
	IF OBJECT_ID('tempdb.dbo.#policyList') IS NOT NULL DROP TABLE #policyList
	CREATE TABLE #policyList (storagePoolId INT, planId INT)
	CREATE NONCLUSTERED INDEX pol_Idx ON #policyList (storagePoolId, planId)
	INSERT INTO #policyList (storagePoolId, planId)
		SELECT DC2GC.globalPolicyId, P.componentNameId
		FROM App_PlanProp P
INNER JOIN ArchGroup DAG ON P.attrName='Storage policy' AND P.modified = 0 AND P.attrVal = CAST(DAG.id AS VARCHAR(100))
		INNER JOIN ArchCopyToGlobalPolicy DC2GC ON DAG.defaultCopy = DC2GC.copyId
	UNION
		SELECT
			DC2GC.globalPolicyId,
			PP.componentNameId
		FROM App_PlanProp PP
		CROSS APPLY (SELECT CAST(PP.attrVal AS XML) AS storageRules) AS SR
		CROSS APPLY SR.storageRules.nodes('Api_PlanRuleMaps/rules/policy') R(ref)
		INNER JOIN ArchGroup DAG ON DAG.id = R.ref.value('@storagePolicyId', 'INT')
		INNER JOIN ArchCopyToGlobalPolicy DC2GC ON DAG.defaultCopy = DC2GC.copyId
WHERE PP.attrname = 'Storage Rules'
	-- END   - GET PLAN FOR THE STORAGE POOLS -------------------------------------------------------------------------------------------------------
	--
	SET @x_xmlData =
	(
		SELECT(
				SELECT
					(SELECT COUNT(*) FROM APP_ClientGroupAssoc WHERE clientGroupId = RP.accessNodesGroupId) AS '@numDataAccessNodes',
					(SELECT COUNT(DISTINCT planId) FROM #policyList WHERE storagePoolId = RP.storagePoolId) AS '@numAssocPlans',
					RP.appType AS '@appType',
					(SELECT RP.resourcePoolId AS '@resourcePoolId',
							RP.resourcePoolName AS '@resourcePoolName'
						FOR XML PATH('resourcePool'),TYPE),
					(SELECT
						RP.storagePoolId AS '@storagePoolId',
						AG.name AS '@storagePoolName'
						FOR XML PATH('storagePool'),TYPE),
					(SELECT
						RP.indexServerClientId AS '@clientId',
						C.name AS '@clientName'
						FOR XML PATH('indexServer'),TYPE),
					(CASE
						WHEN appType <> 9/*FILESYSTEM*/ THEN
							(SELECT G.name AS '@clientGroupName', accessNodesGroupId AS '@clientGroupId'
								FOR XML PATH('dataAccessNodeGroup'), TYPE)
						ELSE NULL
					END)
				FROM APP_ResourcePool AS RP
				LEFT OUTER JOIN APP_ClientGroup G ON G.id = RP.accessNodesGroupId
				LEFT OUTER JOIN archGroup AG ON AG.id = RP.storagePoolId
				LEFT OUTER JOIN APP_Client C ON C.id = RP.indexServerClientId
				FOR XML PATH('resourcePoolList'),TYPE),
				(SELECT @errorCode  AS '@errorCode',
						@errorString   AS '@errorMessage'
				 FOR XML PATH('error'), TYPE)
		FOR XML PATH(''), ROOT('Api_GetResourcePoolListResp')
	)
	BEGIN
		SELECT @x_xmlData
	END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppResourcePoolGetList')
	delete from GxQscripts where name = 'AppResourcePoolGetList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppResourcePoolGetList')
	delete from GXDBVersions where aliasname = 'AppResourcePoolGetList'
GO

insert into GXDBVersions values(2, 'AppResourcePoolGetList',  '00000000000000000000', 'AppResourcePoolGetList', '00000000000000000000')
GO

