

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppResourcePoolGetForEntity.sp] ---------- 

--	+===============================================================================+
--	|  			  PlanRuleEvaluateStoragePolicyForEntityV2							|
--	|																				|
--  |  PARAMETERS			  														|
--  |    i_entityId	  = id of subclient/plan/storagepolicy/storagepool				|
--  |    i_entityType = subclient->7,plan->158,policy->17,pool->160					|
--  |    i_retResultSet	  = 1 to return result set. For call from Cpp layer			|
--  |  OUTPUTS																		|
--  |	 o_xmlData	  = Api_GetResourcePoolDetailsResp xml							|
--	+===============================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppResourcePoolGetForEntity')
BEGIN
	print '>>> Drop Stored Procedure: AppResourcePoolGetForEntity <<<'
	drop procedure AppResourcePoolGetForEntity
END
IF EXISTS (select * from GxQscripts where name='AppResourcePoolGetForEntity')
	delete from GxQscripts where name = 'AppResourcePoolGetForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppResourcePoolGetForEntity')
	delete from GXDBVersions where aliasname = 'AppResourcePoolGetForEntity'
GO
print '... Creating Procedure: AppResourcePoolGetForEntity'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppResourcePoolGetForEntity
  @i_entityId INT = 0,
  @i_entityType INT = 0,
  @i_resourcePoolAppType INT = 0,
  @i_retResultSet INT = 0,
  @o_xmlData XML OUTPUT
AS
SET NOCOUNT ON;
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(MAX) = ''
DECLARE @isPrivilegedUser INT = 0
DECLARE @storagePoolId INT = 0
DECLARE @policies TABLE (storagePolicyId INT, storagePoolId INT)
IF (@i_entityId = 0 OR @i_entityType = 0)
BEGIN
	SET @errorCode = 100; SET @errorString = 'Invalid input. Please provide valid entity information.'
	GOTO ERROR_EXIT;
END
--
-- START - GET THE STORAGE POOL DETAILS FROM THE REQUEST ----------------------------------------------------------------------------------------
-- Get storagepool from plan if provided
IF @i_entityType = 158 /*PLAN_ENTITY*/
BEGIN
	IF NOT EXISTS (SELECT 1 FROM App_Plan WHERE id = @i_entityId)
	BEGIN
		SET @errorCode = 100; SET @errorString = 'Please provide valid planId.'
		GOTO ERROR_EXIT;
	END
	-- Get all the storage policies of the plan
DECLARE @storageRules XML = (SELECT dbo.AppPlanGetEntityValueV2(@i_entityId, 'Storage Rules', default))
	INSERT INTO @policies (storagePolicyId)
SELECT dbo.AppPlanGetEntityValueV2(@i_entityId, 'Storage policy', default)
		UNION
		SELECT ref.value('@storagePolicyId', 'INT')
		FROM @storageRules.nodes('/Api_PlanRuleMaps/rules/policy') R(ref)
	IF EXISTS (SELECT 1 FROM @policies)
	BEGIN
		UPDATE P
		SET P.storagepoolId = DC2GC.globalPolicyId
		FROM @policies P
		INNER JOIN ArchGroup DAG ON P.storagePolicyId = DAG.id
		INNER JOIN ArchCopyToGlobalPolicy DC2GC ON DAG.defaultCopy = DC2GC.copyId
	END
	ELSE
	BEGIN
		SET @errorCode = 100; SET @errorString = 'Could not find storagepolicy for the plan.'
		GOTO ERROR_EXIT;
	END
END
ELSE IF @i_entityType = 17 /*STORAGE_POLICY_ENTITY*/
BEGIN
	SELECT @storagePoolId = DC2GC.globalPolicyId
		FROM ArchGroup DAG
		INNER JOIN ArchCopyToGlobalPolicy DC2GC ON DAG.defaultCopy = DC2GC.copyId
		WHERE DAG.id = @i_entityId
END
ELSE IF @i_entityType = 7 /*SUBCLIENT_ENTITY*/
BEGIN
	SELECT @storagePoolId = DC2GC.globalPolicyId
		FROM App_Application A
		INNER JOIN ArchGroup DAG ON A.dataArchGrpID = DAG.id
		INNER JOIN ArchCopyToGlobalPolicy DC2GC ON DAG.defaultCopy = DC2GC.copyId
		WHERE A.id = @i_entityId
END
ELSE IF @i_entityType = 160 /*STORAGE_POOL_ENTITY*/
BEGIN
	SET @storagePoolId = @i_entityId
END
-- END  - GET THE STORAGE POOL DETAILS FROM THE REQUEST -----------------------------------------------------------------------------------------
--
--
-- START - GET RESOURCE POOL DETAILS AND CREATE RESPONSE ----------------------------------------------------------------------------------------
IF(@storagePoolId > 0 OR EXISTS (SELECT 1 FROM @policies))
BEGIN
	DECLARE @resourcePoolId INT = 0
	IF @storagePoolId > 0
	BEGIN
		SELECT @resourcePoolId = ISNULL((SELECT TOP 1 resourcePoolId FROM APP_ResourcePool RP
									WHERE RP.storagePoolId = @storagePoolId AND (@i_resourcePoolAppType = 0 OR appType = @i_resourcePoolAppType) AND RP.modified = 0), 0)
		-- Per Nagaraju, fallback to O365 apptype for Exchange/Sharepoint/OneDrive/Teams
		IF @resourcePoolId = 0 AND (@i_resourcePoolAppType IN (3,4,5,6)) --Api::ResourcePoolAppType enum values for Exchange/Sharepoint/OneDrive/Teams
		BEGIN
			SELECT @resourcePoolId = ISNULL((SELECT TOP 1 resourcePoolId FROM APP_ResourcePool RP
									WHERE RP.storagePoolId = @storagePoolId AND appType = 1/*Office 365*/ AND RP.modified = 0), 0)
		END
	END
	ELSE
		SELECT @resourcePoolId = ISNULL((SELECT TOP 1 resourcePoolId FROM APP_ResourcePool RP
										INNER JOIN @policies P ON P.storagePoolId = RP.storagePoolId AND RP.modified = 0
									WHERE (@i_resourcePoolAppType = 0 OR appType = @i_resourcePoolAppType)), 0)
		-- Per Nagaraju, fallback to O365 apptype for Exchange/Sharepoint/OneDrive/Teams
		IF @resourcePoolId = 0 AND (@i_resourcePoolAppType IN (3,4,5,6)) --Api::ResourcePoolAppType enum values for Exchange/Sharepoint/OneDrive/Teams
		BEGIN
			SELECT @resourcePoolId = ISNULL((SELECT TOP 1 resourcePoolId FROM APP_ResourcePool RP
										INNER JOIN @policies P ON P.storagePoolId = RP.storagePoolId AND RP.modified = 0
									WHERE appType = 1/*Office 365*/), 0)
		END
	--
	IF(@resourcePoolId = 0)
	BEGIN
		SET @errorCode = 100; SET @errorString = 'Could not find resource pool for the provided inputs.'
		GOTO ERROR_EXIT;
	END
	ELSE
	BEGIN
		--EXEC AppResourcePoolGetDetails @i_userId,@i_localeId,@resourcePoolId,@o_xmlData OUTPUT
			SET @o_xmlData =
			(SELECT -- <Api_GetResourcePoolDetailsResp>
				(SELECT -- <resourcePool>
					appType AS '@appType',
					(SELECT
						resourcePoolId AS '@resourcePoolId',
						resourcePoolName AS '@resourcePoolName'
						FOR XML PATH('resourcePool'),TYPE),
					(SELECT
						storagePoolId AS '@storagePoolId'
						FOR XML PATH('storagePool'),TYPE),
					(SELECT
						indexServerClientId AS '@clientId'
						FOR XML PATH('indexServer'),TYPE),
					(SELECT ISNULL((SELECT name FROM APP_ClientGroup G WHERE G.id = accessNodesGroupId), '') AS '@clientGroupName',
						accessNodesGroupId AS '@clientGroupId'
						FOR XML PATH('dataAccessNodeGroup'), TYPE),
						extendedProps  as [node()]
				FOR XML PATH('resourcePool'),TYPE)
			FROM APP_ResourcePool R
			WHERE resourcePoolId=@resourcePoolId
			FOR XML PATH('Api_GetResourcePoolDetailsResp'),TYPE)
	END
END
-- END   - GET RESOURCE POOL DETAILS AND CREATE RESPONSE ----------------------------------------------------------------------------------------
ERROR_EXIT:
	IF(@errorCode != 0)
	BEGIN
	SET @o_xmlData =
		(SELECT -- <Api_GetResourcePoolDetailsResp>
			(SELECT @errorCode  AS '@errorCode',
                    @errorString   AS '@errorMessage'
             FOR XML PATH('error'), TYPE)
		FOR XML PATH('Api_GetResourcePoolDetailsResp'),TYPE
		)
	END
IF @i_retResultSet = 1
	SELECT @o_xmlData
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppResourcePoolGetForEntity')
	delete from GxQscripts where name = 'AppResourcePoolGetForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppResourcePoolGetForEntity')
	delete from GXDBVersions where aliasname = 'AppResourcePoolGetForEntity'
GO

insert into GXDBVersions values(2, 'AppResourcePoolGetForEntity',  '00000000000000000000', 'AppResourcePoolGetForEntity', '00000000000000000000')
GO

