

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppResourcePoolGetDetails.sp] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppResourcePoolGetDetails')
BEGIN
	print '>>> Drop Stored Procedure: AppResourcePoolGetDetails <<<'
	drop procedure AppResourcePoolGetDetails
END
IF EXISTS (select * from GxQscripts where name='AppResourcePoolGetDetails')
	delete from GxQscripts where name = 'AppResourcePoolGetDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppResourcePoolGetDetails')
	delete from GXDBVersions where aliasname = 'AppResourcePoolGetDetails'
GO
print '... Creating Procedure: AppResourcePoolGetDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppResourcePoolGetDetails
  @i_userId INT, 
  @i_localeId INT,
  @i_resourcePoolId INT,
  @x_xmlData XML OUTPUT
AS
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @isCommCellAdmin INT = 0
	DECLARE @resourcePoolName NVARCHAR(MAX) = ''
	DECLARE @indexServerId INT = 0
	DECLARE @extendedProps XML = ''
	DECLARE @appType INT = 0
	DECLARE @accessNodesGroupId INT = 0
	DECLARE @errorCode INT = 0
	DECLARE @errorString NVARCHAR(MAX) = ''
	DECLARE @storagePoolId INT = 0
	IF OBJECT_ID('tempdb.dbo.#TempDataAccessNodesList')   IS NOT NULL DROP TABLE #TempDataAccessNodesList
	CREATE TABLE #TempDataAccessNodesList(clientId INT NOT NULL)
	IF (@i_resourcePoolId = 0)
	BEGIN
		SET @errorCode = 100; SET @errorString = 'Invalid input. ResourcePool id not specified.'
	END
	ELSE
	IF NOT EXISTS (SELECT * from APP_ResourcePool WHERE resourcePoolId = @i_resourcePoolId AND modified = 0)
	BEGIN
		SET @errorCode = 87; SET @errorString = 'Invalid ResourcePool id provided in the request.'
	END
	BEGIN
		-- Check if user has Administrative Management at Commcell level privilege
EXEC sec_checkPermissionOnEntity @i_userId, 1, @isCommCellAdmin OUT, 1, 2
		if(@isCommCellAdmin != 1)
		BEGIN
			SET @errorCode = 5
			SET @errorString = 'User is not CommCell Admin'
		END
	END
	IF(@errorCode = 0)
	BEGIN
		SELECT @resourcePoolName = resourcePoolName, @storagePoolId = storagePoolId, @indexServerId = indexServerClientId, @extendedProps = extendedProps,
			@appType = appType, @accessNodesGroupId = accessNodesGroupId
		FROM APP_ResourcePool
		WHERE resourcePoolId = @i_resourcePoolId AND modified = 0
		INSERT INTO #TempDataAccessNodesList
		SELECT clientId FROM APP_ClientGroupAssoc WHERE clientGroupId = @accessNodesGroupId
	END
    SET @x_xmlData =
	(SELECT -- <Api_GetResourcePoolDetailsResp>
		(SELECT -- <resourcePool>
			@appType AS '@appType',
			(SELECT
				@i_resourcePoolId AS '@resourcePoolId',
				@resourcePoolName AS '@resourcePoolName'
				FOR XML PATH('resourcePool'),TYPE),
			(SELECT
				@storagePoolId AS '@storagePoolId',
				'' AS '@storagePoolName'
				FOR XML PATH('storagePool'),TYPE),
			(CASE
				WHEN @appType <> 10/*K8*/ THEN
					(SELECT
						@indexServerId AS '@clientId',
						ISNULL((SELECT name FROM APP_Client C WHERE C.id = @indexServerId),'') AS '@clientName'
						FOR XML PATH('indexServer'),TYPE)
				ELSE NULL
			END),
			(CASE
				WHEN @appType <> 9/*FILESYSTEM*/ THEN
					(SELECT T.clientId AS '@clientId',
							ISNULL((SELECT name FROM APP_Client C WHERE C.id = T.clientId),'')  AS '@clientName' FROM #TempDataAccessNodesList T FOR XML PATH('dataAccessNodes'),TYPE)
				ELSE NULL
			END),
			ISNULL((SELECT @extendedProps),''),
			(CASE
				WHEN @appType <> 9/*FILESYSTEM*/ THEN
					(SELECT ISNULL((SELECT name FROM APP_ClientGroup G WHERE G.id = @accessNodesGroupId), '') AS '@clientGroupName', @accessNodesGroupId AS '@clientGroupId'
						FOR XML PATH('dataAccessNodeGroup'), TYPE)
				ELSE NULL
			END)
		FOR XML PATH('resourcePool'),TYPE),
		(SELECT @errorCode  AS '@errorCode',
                @errorString   AS '@errorMessage'
            FOR XML PATH('error'), TYPE)
	FOR XML PATH('Api_GetResourcePoolDetailsResp'),TYPE
	)
	IF OBJECT_ID('tempdb.dbo.#TempDataAccessNodesList') IS NOT NULL DROP TABLE #TempDataAccessNodesList
	BEGIN
		SELECT @x_xmlData
	END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppResourcePoolGetDetails')
	delete from GxQscripts where name = 'AppResourcePoolGetDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppResourcePoolGetDetails')
	delete from GXDBVersions where aliasname = 'AppResourcePoolGetDetails'
GO

insert into GXDBVersions values(2, 'AppResourcePoolGetDetails',  '00000000000000000000', 'AppResourcePoolGetDetails', '00000000000000000000')
GO

