

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppResourcePoolCreate.sp] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppResourcePoolCreate')
BEGIN
	print '>>> Drop Stored Procedure: AppResourcePoolCreate <<<'
	drop procedure AppResourcePoolCreate
END
IF EXISTS (select * from GxQscripts where name='AppResourcePoolCreate')
	delete from GxQscripts where name = 'AppResourcePoolCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppResourcePoolCreate')
	delete from GXDBVersions where aliasname = 'AppResourcePoolCreate'
GO
print '... Creating Procedure: AppResourcePoolCreate'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppResourcePoolCreate
  @i_userId INT, 
  @i_localeId INT,
  @x_xmlData XML OUTPUT
AS
	SET NOCOUNT ON;
	DECLARE @isCommCellAdmin INT = 0
	DECLARE @errorCode INT = 0
	DECLARE @errorString NVARCHAR(MAX) = ''
	IF OBJECT_ID('tempdb.dbo.#TempDataAccessNodesList')   IS NOT NULL DROP TABLE #TempDataAccessNodesList
	CREATE TABLE #TempDataAccessNodesList(clientId INT NOT NULL)
	BEGIN TRAN
	BEGIN TRY
		-- Get resource pool creation details from XML
		DECLARE @executionUnixTime  INT           = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
		DECLARE @resourcePoolName  NVARCHAR(MAX) =        (SELECT ref.value('@resourcePoolName', 'nvarchar(MAX)') AS [resourcePoolName]    FROM @x_xmlData.nodes('Api_CreateResourcePoolReq/resourcePool/resourcePool') R ( ref ))
 		DECLARE @indexServerId INT = (SELECT ref.value('@clientId', 'nvarchar(MAX)') AS [clientId]    FROM @x_xmlData.nodes('Api_CreateResourcePoolReq/resourcePool/indexServer') R ( ref ))
		-- NOTE: Apptype is defined in enum Api::ResourcePoolAppType
		DECLARE @appType INT = ISNULL((SELECT ref.value('@appType', 'INT') AS [appType]    FROM @x_xmlData.nodes('Api_CreateResourcePoolReq/resourcePool') R ( ref )), 0)
		DECLARE @storagePoolId INT = (SELECT ref.value('@storagePoolId', 'INT') AS [storagePoolId]    FROM @x_xmlData.nodes('Api_CreateResourcePoolReq/resourcePool/storagePool') R ( ref ))
		DECLARE @dataAccessNodeGrpId INT = ISNULL((SELECT ref.value('@clientGroupId', 'INT') AS [clientGroupId]
											FROM @x_xmlData.nodes('Api_CreateResourcePoolReq/resourcePool/dataAccessNodeGroup') R ( ref )), 0)
		DECLARE @extendedProps XML = (SELECT @x_xmlData.query('Api_CreateResourcePoolReq/resourcePool/extendedProp'))
		DECLARE @resourcePoolId INT
		--
		--
		IF (@resourcePoolName IS NULL) OR (LEN(@resourcePoolName) = 0)
		BEGIN
			SET @errorCode = 100; SET @errorString = 'Incomplete definition. No ResourcePool name NOT specified.'
		END
		ELSE IF ((@storagePoolId IS NULL) OR (@storagePoolId = 0))
		BEGIN
			SET @errorCode = 100; SET @errorString = 'Incomplete definition. Storage Pool id NOT specified.'
		END
		ELSE IF EXISTS(SELECT 1 FROM APP_ResourcePool AS RP WHERE RP.storagePoolId = @storagePoolId AND RP.appType = @appType AND modified = 0)
		BEGIN
			SET @errorCode = 87; SET @errorString = 'Resource pool exist for the storage pool and solution type.'
		END
		ELSE IF EXISTS(SELECT 1 FROM APP_ResourcePool RP WHERE RP.resourcePoolName = @resourcePoolName AND modified = 0)
		BEGIN
			SET @errorCode = 103; SET @errorString = 'A ResourcePool with same name exist.'
		END
		ELSE IF (@appType = 0)
		BEGIN
			SET @errorCode = 100; SET @errorString = 'Invalid solution type Specified.'
		END
		ELSE IF @indexServerId IS NULL AND @appType <> 10/*Kubernetes*/ AND @appType <> 2/*salesforce*/ -- INDEXSERVER IS NOT REQUIRED FOR K8 AND SALESFORCE
		BEGIN
			SET @errorCode = 100; SET @errorString = 'Incomplete definition. Indexserver details NOT specified.'
		END
		ELSE
		BEGIN
			-- Check if user has Administrative Management at Commcell level privilege
EXEC sec_checkPermissionOnEntity @i_userId, 1, @isCommCellAdmin OUT, 1, 2
			if(@isCommCellAdmin != 1)
			BEGIN
				SET @errorCode = 5
				SET @errorString = 'User is not CommCell Admin'
			END
		END
		--
		if (@errorCode = 0)
		BEGIN
			-- SET INDEXSERVERCLIENTID TO COMMSERV BY DEFAULT
			IF @indexServerId IS NULL
				SET @indexServerId = 2
			--
			-- Insert all data access nodes into a temp table
			INSERT INTO #TempDataAccessNodesList
				SELECT ref.value('@clientId', 'INT') AS [clientId]    FROM @x_xmlData.nodes('Api_CreateResourcePoolReq/resourcePool/dataAccessNodes') R ( ref )
			--
			IF NOT EXISTS (SELECT id FROM APP_ClientGroup (nolock) WHERE id = @dataAccessNodeGrpId) AND
				NOT EXISTS (SELECT 1 FROM #TempDataAccessNodesList)
			BEGIN
				IF @appType = 9 OR @appType = 12/*ACCESS NODES NOT REQUIRED FOR FS AND LAPTOPS*/
				BEGIN
					--ASSIGN A REAL CLIENTGROUPID WHICH WILL ACT AS DUMMY FOR THE FS
					SELECT TOP 1 @dataAccessNodeGrpId=id FROM App_ClientGroup ORDER BY id ASC
				END
				ELSE
				BEGIN
					SET @errorCode = 100
					SET @errorString = 'Incomplete definition. Please check access nodes are present and valid.'
					GOTO ERROR_EXIT;
				END
			END
			--
			-- CREATE MANUAL CLIENT GROUP HERE
			IF @dataAccessNodeGrpId = 0
			BEGIN
				-- KEEP THE CLIENT GROUP NAME AS (<resourcepool Name> ResourcePool).
				DECLARE @clientGroupName NVARCHAR(1020) = @resourcePoolName + ' ResourcePool'
				-- GET UNIQUE NAME TO AVOID CONFLICTS
EXEC AppGetUniqueEntityName 28, @clientGroupName, @i_userId, @clientGroupName OUTPUT
				INSERT INTO APP_ClientGroup(name, description, flag, status, userId, refTime, modified, origCCid, GUID)
				VALUES(@clientGroupName, @resourcePoolName + ' access nodes' , 0, 0, @i_userId, @executionUnixTime, @executionUnixTime, 2, NEWID())
				SET @dataAccessNodeGrpId = SCOPE_IDENTITY()
				-- AS THIS CLIENTGROUP IS DYANMIC WITH NAMES AND WILL BE CREATED WITH EVERY RESOURCPOOL, SO WE WILL NOT BE ADDING ANY CLIENT GROUP UNIQUEID
				-- WE WILL JUST ADD A PROPERTY SYSTEM CREATED.
				INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@dataAccessNodeGrpId, 'System Created', 7, 0, @executionUnixTime, 0)
				--
				-- ADD CLIENTS TO GROUP
		        INSERT INTO APP_ClientGroupAssoc
		        SELECT @dataAccessNodeGrpId, T.clientId FROM #TempDataAccessNodesList AS T
			END
			--
			--Insert into resource pool table
			INSERT INTO APP_ResourcePool (resourcePoolName,storagePoolId,accessNodesGroupId,indexServerClientId,created,modified,flags,appType,extendedProps)
				VALUES (@resourcePoolName, @storagePoolId, @dataAccessNodeGrpId, @indexServerId,dbo.GetUnixTime(GetUTCdate()),0,0,@appType,@extendedProps)
			SET @resourcePoolId = SCOPE_IDENTITY()
		END
--
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
END CATCH
--
--
ERROR_EXIT:
	IF @errorCode = 0 AND XACT_STATE() = 1
		COMMIT TRAN
	ELSE
		ROLLBACK TRAN
--
--
--Fill in the response
SET @x_xmlData =
(SELECT -- <Api_CreateResourcePoolResp>
	(SELECT -- <resourcePool>
		@appType AS '@appType',
		(SELECT
			@resourcePoolId AS '@resourcePoolId',
			@resourcePoolName AS '@resourcePoolName'
			FOR XML PATH('resourcePool'),TYPE),
		(SELECT
			@storagePoolId AS '@storagePoolId',
			'' AS '@storagePoolName'
			FOR XML PATH('storagePool'),TYPE),
		(SELECT
			@indexServerId AS '@clientId',
			ISNULL((SELECT name FROM APP_Client C WHERE C.id = @indexServerId),'') AS '@clientName'
			FOR XML PATH('indexServer'),TYPE),
		(SELECT T.clientId '@clientId',
		ISNULL((SELECT name FROM APP_Client C WHERE C.id = T.clientId),'')  AS '@clientName' FROM #TempDataAccessNodesList T FOR XML PATH('dataAccessNodes'),TYPE),
		ISNULL((SELECT @extendedProps),''),
		(SELECT ISNULL((SELECT name FROM APP_ClientGroup G WHERE G.id = @dataAccessNodeGrpId), '') AS '@clientGroupName', @dataAccessNodeGrpId AS '@clientGroupId'
			FOR XML PATH('dataAccessNodeGroup'), TYPE)
	FOR XML PATH('resourcePool'),TYPE),
			(SELECT @errorCode  AS '@errorCode',
                @errorString   AS '@errorMessage'
            FOR XML PATH('error'), TYPE)
	FOR XML PATH('Api_CreateResourcePoolResp'),TYPE
	)
IF OBJECT_ID('tempdb.dbo.#TempDataAccessNodesList') IS NOT NULL DROP TABLE #TempDataAccessNodesList
BEGIN
	SELECT @x_xmlData
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppResourcePoolCreate')
	delete from GxQscripts where name = 'AppResourcePoolCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppResourcePoolCreate')
	delete from GXDBVersions where aliasname = 'AppResourcePoolCreate'
GO

insert into GXDBVersions values(2, 'AppResourcePoolCreate',  '00000000000000000000', 'AppResourcePoolCreate', '00000000000000000000')
GO

