

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppResetStoragePolicyOfDeletedCompanySubclient.sp] ---------- 

--  +------------------------------------------------------------------------------------------+
--  |   Procedure : "AppResetStoragePolicyOfDeletedCompanySubclient"
--  |   Description: Stored procedure to set storage policy of deleted
--  |       companies subclient's to 1.
--  |   Author: sghatbale
--  +------------------------------------------------------------------------------------------+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppResetStoragePolicyOfDeletedCompanySubclient')
BEGIN
	print '>>> Drop Stored Procedure: AppResetStoragePolicyOfDeletedCompanySubclient <<<'
	drop procedure AppResetStoragePolicyOfDeletedCompanySubclient
END
IF EXISTS (select * from GxQscripts where name='AppResetStoragePolicyOfDeletedCompanySubclient')
	delete from GxQscripts where name = 'AppResetStoragePolicyOfDeletedCompanySubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppResetStoragePolicyOfDeletedCompanySubclient')
	delete from GXDBVersions where aliasname = 'AppResetStoragePolicyOfDeletedCompanySubclient'
GO
print '... Creating Procedure: AppResetStoragePolicyOfDeletedCompanySubclient'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppResetStoragePolicyOfDeletedCompanySubclient
  @companyId INTEGER
AS
SET NOCOUNT ON
  DECLARE @errorCode INT
set @errorCode = 0
DECLARE @c_flags INT = 0
SELECT @c_flags = flags FROM UMDSProviders WHERE id = @companyId AND enabled=0
IF  @c_flags & 0x0002 = 0x0002
BEGIN
	IF OBJECT_ID('tempdb.dbo.#subclientsToUpdate') IS NOT NULL
        DROP TABLE #subclientsToUpdate
    CREATE TABLE #subclientsToUpdate
        (
            id INT NOT NULL
            primary key (id)
        )
	INSERT INTO #subclientsToUpdate(id)
            SELECT id
			FROM App_Application Appl WITH(NOLOCK)
			INNER JOIN App_CompanyEntities Comp WITH(NOLOCK)
On Comp.entityType = 3 AND Comp.entityId = Appl.ClientId
			WHERE Comp.companyId = @companyId AND
				(Appl.dataArchGrpId <> 1 OR Appl.logArchGrpId <> 1)
			UNION
			SELECT id
			FROM App_Application Appl WITH(NOLOCK)
			INNER JOIN App_CompanyEntities Comp WITH(NOLOCK)
On Comp.entityType = 7 AND Comp.entityId = Appl.id
			WHERE Comp.companyId = @companyId AND
				(Appl.dataArchGrpId <> 1 OR Appl.logArchGrpId <> 1)
			UNION
			SELECT id
			FROM App_Application Appl WITH(NOLOCK)
			INNER JOIN App_CompanyEntities Comp WITH(NOLOCK)
On Comp.entityType = 6 AND Comp.entityId = Appl.backupset
			WHERE Comp.companyId = @companyId AND
				(Appl.dataArchGrpId <> 1 OR Appl.logArchGrpId <> 1)
			UNION
			/*Get all subclients associated with company's storage policy which are in deleted or uninstalled state irrespective of subclient's company */
			SELECT Appl.id
			FROM App_Application Appl WITH(NOLOCK)
			INNER JOIN App_CompanyEntities ACE WITH(NOLOCK)
ON ACE.entityType = 17
				AND ACE.companyId = @companyId
				AND (Appl.dataArchGrpId = ACE.entityId OR Appl.logArchGrpId = ACE.entityId)
			INNER JOIN App_client AC WITH(NOLOCK)
				ON AC.id = Appl.clientId
WHERE (Appl.subclientStatus & 0x00004 <> 0)
OR (Appl.subclientStatus &  0x00002 <> 0)
OR (AC.status & 0x00004 <> 0)
OR (AC.status & 0x00002 <> 0)
	UPDATE App
    SET
        dataArchGrpId = 1,
        logArchGrpId = 1
    FROM App_Application App
    INNER JOIN #subclientsToUpdate t ON
    t.id = App.id
END
ELSE
BEGIN
    set @errorCode = 1
END
SELECT @errorCode AS 'errorCode'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppResetStoragePolicyOfDeletedCompanySubclient')
	delete from GxQscripts where name = 'AppResetStoragePolicyOfDeletedCompanySubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppResetStoragePolicyOfDeletedCompanySubclient')
	delete from GXDBVersions where aliasname = 'AppResetStoragePolicyOfDeletedCompanySubclient'
GO

insert into GXDBVersions values(2, 'AppResetStoragePolicyOfDeletedCompanySubclient',  '00000000000000000000', 'AppResetStoragePolicyOfDeletedCompanySubclient', '00000000000000000000')
GO

