

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppReportsSaveTranslations.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppReportsSaveTranslations.sp,v $ $Id: AppReportsSaveTranslations.sp,v 1.3 2015/07/10 21:02:04 kramachandran Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppReportsSaveTranslations <<<'

IF EXISTS (select * from sysobjects where name='AppReportsSaveTranslations')
	drop procedure AppReportsSaveTranslations
IF EXISTS (select * from GxQscripts where name='AppReportsSaveTranslations')
	delete from GxQscripts where name = 'AppReportsSaveTranslations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppReportsSaveTranslations')
	delete from GXDBVersions where aliasname = 'AppReportsSaveTranslations'
GO
print '... Creating Procedure: AppReportsSaveTranslations'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppReportsSaveTranslations
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @i_entityType INT,
  @i_entityId INT,
  @i_locale NVARCHAR(100) = '',
  @i_isBuiltIn BIT = 1 -- default is Built-in
AS
SET NOCOUNT ON
BEGIN
-- Rerpot Translations
  DECLARE @o_ErrorCode INT = 0
  DECLARE @o_ErrorString NVARCHAR(MAX) = ''
-- Delete existing built-in translations
IF(@i_isBuiltIn = 1)
BEGIN
	DELETE FROM APP_Translations
		WHERE entityType = @i_entityType
		AND entityId = @i_entityId
		AND (flags & 1) = @i_isBuiltIn
END
ELSE
BEGIN
	DELETE FROM APP_Translations
		WHERE entityType = @i_entityType
		AND entityId = @i_entityId
		AND (flags & 1) = @i_isBuiltIn
		AND locale = @i_locale
END
-- Insert all built or imported translations
INSERT INTO APP_Translations(entityId, entityType, flags, locale, localeKey, localeValue)
SELECT @i_entityId, @i_entityType, @i_isBuiltIn,
		ref.value('(locale/text())[1]', 'NVARCHAR(100)'),
		ref.value('(localeKey/text())[1]', 'NVARCHAR(MAX)') ,
		ref.value('(localeValue/text())[1]', 'NVARCHAR(MAX)')
FROM  @i_xmlText.nodes ('list/Translations') R(ref)
WHERE NOT EXISTS
(
	SELECT locale, localeKey FROM APP_Translations
	WHERE entityId = @i_entityId
	AND entityType = @i_entityType
	AND locale = ref.value('(locale/text())[1]', 'NVARCHAR(100)')
	AND localeKey = ref.value('(localeKey/text())[1]', 'NVARCHAR(MAX)')
)
IF(@i_isBuiltIn = 0)
BEGIN
	SELECT @o_ErrorCode AS o_ErrorCode, @o_ErrorString AS o_ErrorString
END
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppReportsSaveTranslations')
	delete from GxQscripts where name = 'AppReportsSaveTranslations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppReportsSaveTranslations')
	delete from GXDBVersions where aliasname = 'AppReportsSaveTranslations'
GO

insert into GXDBVersions values(2, 'AppReportsSaveTranslations',  '00010003000000000000', 'AppReportsSaveTranslations', '00010003000000000000')
GO

