

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppReportsSave.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppReportsSave.sp,v $ $Id: AppReportsSave.sp,v 1.16.2.24 2018/10/31 09:53:36 praju Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppReportsSave')
BEGIN
	print '>>> Drop Stored Procedure: AppReportsSave <<<'
	drop procedure AppReportsSave
END
IF EXISTS (select * from GxQscripts where name='AppReportsSave')
	delete from GxQscripts where name = 'AppReportsSave'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppReportsSave')
	delete from GXDBVersions where aliasname = 'AppReportsSave'
GO
print '... Creating Procedure: AppReportsSave'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppReportsSave
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @i_userId int,
  @i_localeId int,
  @i_engineVersion int,
  @i_oldReportId int,
  @i_flags int,
  @i_incVer int,
  @i_source int,
  @i_overrideReadOnly int,
  @i_location nvarchar(255),
  @i_minVer nvarchar(MAX),
  @i_maxVer nvarchar(MAX),
  @i_reportType int,
  @i_tileType int,
  @i_categoryId int,
  @i_customIcon nvarchar(MAX)
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_historyId int
  DECLARE @o_version int
  DECLARE @o_ErrorCode int
  DECLARE @o_ErrorString nvarchar(max)
  DECLARE @i_reportId int
  DECLARE @i_reportName nvarchar(255)
  DECLARE @i_userReportId nvarchar(255)
  DECLARE @i_guid nvarchar(256)
  DECLARE @translationsXmlText XML
SET @o_ErrorCode = 0
SET @o_ErrorString = ''
IF ( @i_userId = 0 OR @i_userId IS null )
BEGIN
	SET @o_ErrorCode = 1
	SET	@o_ErrorString = 'User not provided'
	GOTO FINISH
END
SET @i_guid = ISNULL((SELECT ref.value('text()[1]', 'NVARCHAR(MAX)') FROM  @i_xmlText.nodes ('CustomReport/guid') R(ref)), NEWID())
SET @i_reportName = ISNULL((SELECT ref.value('text()[1]', 'NVARCHAR(255)') FROM  @i_xmlText.nodes ('CustomReport/report/customReportName') R(ref)), '')
SET @i_userReportId = ISNULL((SELECT ref.value('text()[1]', 'NVARCHAR(255)') FROM  @i_xmlText.nodes ('CustomReport/userReportId') R(ref)), '')
IF EXISTS(SELECT * FROM APP_Reports Where guid = @i_guid)
BEGIN
	SELECT @i_reportId = reportId FROM APP_Reports Where guid = @i_guid
END
ELSE
BEGIN
	SET @i_reportId = 0
END
IF (LEN(@i_userReportId) = 0)
	SET @i_userReportId = @i_reportName
DECLARE @hasRights INT = 0
DECLARE @isUserAdmin INT = 0
DECLARE @origCCId int = 2
DECLARE @t_userCaps   TABLE(userId INT, nodeCap bigint, childCap bigint)
INSERT INTO @t_userCaps
EXEC dbo.sec_NoNiDaNodeAccess @i_userId , @origCCId, 2018, @origCCId
DECLARE @commCellCap bigint = 0
SELECT @commCellCap = ISNULL(nodeCap, 0) FROM @t_userCaps
IF (@commCellCap & CAST(POWER(2.0, 1 - 1) AS bigint) <> 0)
	SET @hasRights = 1;
IF (@i_reportId = 0)
BEGIN
	--only check standard non-hidden reports for duplicate names
	IF @i_flags & 1 = 0 AND @i_reportType = 0
	BEGIN
		IF EXISTS(SELECT * FROM APP_Reports Where name = @i_reportName AND flags & 1 = 0 AND [type] = 0)
		BEGIN
			SET @o_ErrorCode = 1
			SET @o_ErrorString = 'report [' + @i_reportName + '] already exists'
			GOTO FINISH
		END
	END
	IF EXISTS(SELECT * FROM APP_Reports Where userReportId = @i_userReportId)
	BEGIN
		SET @o_ErrorCode = 1
		SET @o_ErrorString = 'report id ['+@i_userReportId+'] already exists'
		GOTO FINISH
	END
	IF @hasRights = 0
	BEGIN
		IF @i_reportType = 2
			SET @hasRights = 1
		ELSE
exec sec_userHasCapability @i_userId,0,@hasRights OUTPUT,0,0,'129'
	END
	IF @hasRights = 0
	BEGIN
		SET @o_ErrorCode = 1
		SET @o_ErrorString = 'user does not have required capability to create reports'
		GOTO FINISH
	END
	SET @o_version = 1
	INSERT INTO APP_Reports(name, description, definition, version, createTime, modifiedTime, userId, guid, revision, flags, engineVersion, referenceId, icon, source, userReportId, minCommCellVersion, maxCommCellVersion, [type], tileType, CategoryId, customIcon)
	VALUES (
		@i_reportName,
		ISNULL ((SELECT ref.value('text()[1]', 'NVARCHAR(MAX)') FROM  @i_xmlText.nodes ('CustomReport/reportDescription') R(ref)), ''),
		@i_xmlText,
		@o_version,
		dbo.GetUnixTime(GETUTCDATE()),
		dbo.GetUnixTime(GETUTCDATE()),
		@i_userId,
		@i_guid,
		ISNULL ((SELECT ref.value('text()[1]', 'NVARCHAR(255)') FROM  @i_xmlText.nodes ('CustomReport/revision') R(ref)), ''),
		@i_flags,
		@i_engineVersion,
		@i_oldReportId,
		ISNULL ((SELECT ref.value('text()[1]', 'NVARCHAR(MAX)') FROM  @i_xmlText.nodes ('CustomReport/icon') R(ref)), ''),
		@i_source,
		@i_userReportId,
		@i_minVer,
		@i_maxVer,
		@i_reportType,
		@i_tileType,
		@i_categoryId,
		@i_customIcon
	)
	SELECT @i_reportId = @@IDENTITY
	DECLARE @permissionsList NVARCHAR(MAX)
SET @permissionsList = CAST(130 AS NVARCHAR(10)) + ',' + CAST(131 AS NVARCHAR(10)) + ',' + CAST(132 AS NVARCHAR(10)) + ',' + CAST(107 AS NVARCHAR(10))
EXEC sec_setCreatorForEntity @i_userId, 0, @permissionsList, @o_ErrorCode OUTPUT, @o_ErrorString OUTPUT, 131, @i_reportId
END
ELSE
BEGIN
	IF NOT EXISTS(SELECT * FROM APP_Reports Where reportId = @i_reportId)
	BEGIN
		SET @o_ErrorCode = 1
		SET @o_ErrorString = 'report id [' + @i_reportId + '] does not exist'
		GOTO FINISH
	END
	--IF EXISTS(SELECT * FROM APP_Reports Where name = @i_reportName AND reportId <> @i_reportId)
	--BEGIN
	--	SET @o_ErrorCode = 1
	--	SET @o_ErrorString = 'report already exists'
	--	GOTO FINISH
	--END
	IF EXISTS(SELECT * FROM APP_Reports Where userReportId = @i_userReportId AND reportId <> @i_reportId)
	BEGIN
		SET @o_ErrorCode = 1
		SET @o_ErrorString = 'user report id ['+@i_userReportId+'] already exists'
		GOTO FINISH
	END
	DECLARE @currentFlags int
	SELECT @currentFlags = flags FROM APP_Reports Where reportId = @i_reportId
	IF (@i_overrideReadOnly = 0 AND @currentFlags & 4 = 4)
	BEGIN
		SET @o_ErrorCode = 1
		SET @o_ErrorString = 'report is read only'
		GOTO FINISH
	END
	IF @hasRights = 0
	BEGIN
EXEC sec_checkPermissionOnEntity @i_userId,130,@hasRights OUTPUT,131,@i_reportId
	END
	IF @hasRights = 0
	BEGIN
		SET @o_ErrorCode = 1
		SET @o_ErrorString = 'user does not have required capability to edit report'
		GOTO FINISH
	END
	SELECT @o_version = version FROM APP_Reports Where reportId = @i_reportId
	IF (@i_incVer = 1)
	BEGIN
		SET @o_version = @o_version + 1
	END
	UPDATE APP_Reports
	SET name = @i_reportName,
		description = ISNULL ((SELECT ref.value('text()[1]', 'NVARCHAR(MAX)') FROM  @i_xmlText.nodes ('CustomReport/reportDescription') R(ref)), ''),
		definition = @i_xmlText,
		modifiedTime = dbo.GetUnixTime(GETUTCDATE()),
		version = @o_version,
		guid = @i_guid,
		revision = ISNULL ((SELECT ref.value('text()[1]', 'NVARCHAR(255)') FROM  @i_xmlText.nodes ('CustomReport/revision') R(ref)), ''),
		engineVersion = @i_engineVersion,
		icon = ISNULL ((SELECT ref.value('text()[1]', 'NVARCHAR(MAX)') FROM  @i_xmlText.nodes ('CustomReport/icon') R(ref)), ''),
		flags = @i_flags,
		source = @i_source,
		userReportId = @i_userReportId,
		minCommCellVersion = @i_minVer,
		maxCommCellVersion = @i_maxVer,
		[type] = @i_reportType,
		tileType = @i_tileType,
		CategoryId = @i_categoryId,
		customIcon = @i_customIcon
	WHERE reportId = @i_reportId
END
IF NOT EXISTS(SELECT * FROM APP_ReportsHistory WHERE reportId = @i_reportId AND version = @o_version)
BEGIN
	INSERT INTO APP_ReportsHistory (reportId, definition, version, deployed, createTime, userId, engineVersion, source, location)
	VALUES (@i_reportId, @i_xmlText, @o_version, 0, dbo.GetUnixTime(GETUTCDATE()), @i_userId, @i_engineVersion, @i_source, @i_location)
	SELECT @o_historyId = @@IDENTITY
END
ELSE
BEGIN
	SELECT @o_historyId = id FROM APP_ReportsHistory WHERE reportId = @i_reportId AND version = @o_version
	UPDATE APP_ReportsHistory
	SET definition = @i_xmlText,
		userId = @i_userId,
		engineVersion = @i_engineVersion,
		source = @i_source
	WHERE id = @o_historyId
END
DECLARE @tagTbl TABLE (tag nvarchar(255))
INSERT INTO @tagTbl
SELECT t.p.query('.').value('.', 'nvarchar(255)') AS tag
FROM @i_xmlText.nodes('/CustomReport/systemTags/string') t(p)
INSERT INTO APP_ReportTags(reportId, type, tag)
SELECT @i_reportId, 0, tag
FROM @tagTbl
WHERE tag NOT IN (SELECT tag FROM APP_ReportTags WHERE reportId = @i_reportId AND [type] = 0)
DELETE FROM APP_ReportTags
WHERE reportId = @i_reportId
AND [type] = 0
AND tag NOT IN (SELECT tag FROM @tagTbl)
FINISH:
SELECT @o_historyId As o_historyId, @i_reportId AS i_reportId, @o_version AS o_version, @o_ErrorCode AS o_ErrorCode, @o_ErrorString AS o_ErrorString
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppReportsSave')
	delete from GxQscripts where name = 'AppReportsSave'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppReportsSave')
	delete from GXDBVersions where aliasname = 'AppReportsSave'
GO

insert into GXDBVersions values(2, 'AppReportsSave',  '00010016000200240000', 'AppReportsSave', '00010016000200240000')
GO

