

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppReportsGetListing.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppReportsGetListing.sp,v $ $Id: AppReportsGetListing.sp,v 1.13.2.34 2020/12/15 21:59:53 cnaik Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppReportsGetListing')
BEGIN
	print '>>> Drop Stored Procedure: AppReportsGetListing <<<'
	drop procedure AppReportsGetListing
END
IF EXISTS (select * from GxQscripts where name='AppReportsGetListing')
	delete from GxQscripts where name = 'AppReportsGetListing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppReportsGetListing')
	delete from GXDBVersions where aliasname = 'AppReportsGetListing'
GO
print '... Creating Procedure: AppReportsGetListing'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppReportsGetListing
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT,
  @i_localeId NVARCHAR(100),
  @i_manage INTEGER=0,
  @i_offlineOnly INTEGER=0,
  @i_tags XML=null,
  @i_reportType INTEGER=0,
  @i_tileType INTEGER=0,
  @i_showHidden INTEGER=0,
  @i_tenantAdmin INTEGER=0,
  @o_xmlSearchOutput XML=N''  OUTPUT,
  @outputTable NVARCHAR(20)='',
  @i_reportId INTEGER=0
AS
  DECLARE @reportId int 
  DECLARE @name NVARCHAR(510)
SET NOCOUNT ON
BEGIN
-- Prepare tags information to be displayed in the report manager
DECLARE @outtbl table
(
tagXML xml
)
DECLARE @inputxml xml = '<WebReport_TagViewEditReq userId="-1"/>'
SET @inputxml.modify('replace value of /WebReport_TagViewEditReq[1]/@userId with sql:variable("@i_userId")')
INSERT INTO @outtbl
EXEC WebReportsTagOperations  @inputxml
DECLARE @reportTags table
(
   reportId int,
   tagName nvarchar(max)
   )
INSERT INTO @reportTags
   SELECT tag.value('@reportId', 'int') as reportId,
					ISNULL(tag.value('@tagName', 'nvarchar(max)'),'Untagged') as 'Tag Name'
FROM @outtbl O
CROSS APPLY O.tagXML.nodes('/WebReport_TagViewEditResp/tagInfoList')  tag(tag)
WHERE tag.value('@reportType', 'varchar(256)') ='custom'
DECLARE @tagTbl TABLE (tag nvarchar(255))
IF (@i_tags IS NOT NULL)
BEGIN
	INSERT INTO @tagTbl
	SELECT t.p.query('.').value('.', 'nvarchar(255)') AS tag
	FROM @i_tags.nodes('/root/tag') t(p)
END
-- end of temp table with tags to report id information
DECLARE @origCCId int = 2
DECLARE @t_userCaps   TABLE(userId INT, nodeCap bigint, childCap bigint)
INSERT INTO @t_userCaps
EXEC dbo.sec_NoNiDaNodeAccess @i_userId , @origCCId, 2018, @origCCId
DECLARE @isViewAllCap INT = 0
IF (ISNULL((SELECT nodeCap & CAST(POWER(2.0, 1 - 1) AS bigint) FROM @t_userCaps), 0) <> 0)
    SET @isViewAllCap = 1;
--IF (@isViewAllCap = 0)
--	EXECUTE sec_userHasCapability @i_userId, 0, @isViewAllCap OUTPUT, 0, 1, '130,131'
IF object_id('tempdb.dbo.#APPReportsListing_Objects') is not null DROP TABLE #APPReportsListing_Objects
CREATE TABLE #APPReportsListing_Objects (reportId INT)
IF (@isViewAllCap = 1)
BEGIN
	INSERT INTO #APPReportsListing_Objects SELECT reportId FROM APP_Reports
END
ELSE
BEGIN
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 131, 130, '#APPReportsListing_Objects'
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 131, 131, '#APPReportsListing_Objects'
	IF @i_manage = 0
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 131, 132, '#APPReportsListing_Objects'
	--ELSE
	--	EXEC sec_getNonIdaObjectsForThisUser @i_userId, REPORT_PLUS_ENTITY, EV_VISIBILITY, '#APPReportsListing_Objects'
END
DECLARE @translations TABLE(reportId INT, reportTitle NVARCHAR(MAX), reportdescription NVARCHAR(MAX))
DECLARE @rptTranslations TABLE(reportId INT, reportTitle NVARCHAR(MAX), reportdescription NVARCHAR(MAX))
INSERT INTO @translations EXEC AppGetTranslations 131, -1, @i_localeId, '''RPT_TITLE'', ''RPT_DESCRIPTION'''
INSERT INTO @rptTranslations(reportId, reportTitle, reportdescription)
(
	SELECT reportId, [RPT_TITLE], [RPT_DESCRIPTION]
	FROM
	(
		SELECT reportId, reportTitle, reportdescription FROM @translations
	) as translations
	PIVOT
	(
		MAX(reportdescription)
		FOR reportTitle IN ([RPT_TITLE], [RPT_DESCRIPTION])
	) as pvt
)
--DECLARE @tileFlag INT = 0
--IF @i_tileReports = 1
--	SET @tileFlag = 8
Declare @roleId int
Declare @providerId int
Declare @errCode int
Declare @errString nvarchar(1024)
EXEC AppGetUserRoleType @i_userId, @roleId OUTPUT, @providerId OUTPUT, @errCode OUTPUT, @errString OUTPUT
DECLARE @filterTable TABLE (reportId int, [type] nvarchar(255))
IF EXISTS (SELECT * FROM @tagTbl)
BEGIN
	INSERT INTO @filterTable
	SELECT r.reportId, ISNULL(o.[type], 'Online')
	FROM APP_Reports r
	LEFT OUTER JOIN
	(
		Select reportId, Case When Sum(Offline) > 0 THEN 'Offline' ELSE 'Online' END As [type]
		From APP_DataSet
		Group By reportId
	) o ON r.reportId = o.reportId
	INNER JOIN APP_ReportTags t ON r.reportId = t.reportId AND t.[type] = 0
	--WHERE r.flags & 1 = 0 --skip hidden reports --need to show hidden reports when filtering by tags
	--AND r.flags & 8 = @tileFlag --tile reports
	WHERE r.[type] = @i_reportType
	AND (@i_tileType = 0 OR r.tileType = @i_tileType) --tile offline or online
	AND (
		r.reportId IN (SELECT reportId FROM #APPReportsListing_Objects) OR
		(@i_manage = 0 AND r.flags & 2 > 0) OR
(@roleId = 0 AND r.flags & 64 > 0) OR
(@roleId = 1 AND r.flags & 16 > 0) OR
(@roleId = 2 AND r.flags & 32 > 0)
		)
	AND t.tag IN (SELECT tag FROM @tagTbl)
END
ELSE
BEGIN
	INSERT INTO @filterTable
	SELECT r.reportId, ISNULL(o.[type], 'Online')
	FROM APP_Reports r
	LEFT OUTER JOIN
	(
		Select reportId, Case When Sum(Offline) > 0 THEN 'Offline' ELSE 'Online' END As [type]
		From APP_DataSet
		Group By reportId
	) o ON r.reportId = o.reportId
	WHERE (@i_showHidden = 1 OR r.flags & 1 = 0) --skip hidden reports
	--AND r.flags & 8 = @tileFlag --tile reports
	AND r.[type] = @i_reportType
	AND (@i_tileType = 0 OR r.tileType = @i_tileType) --tile offline or online
	AND (
		r.reportId IN (SELECT reportId FROM #APPReportsListing_Objects) OR
		(@i_manage = 0 AND r.flags & 2 > 0) OR
(@roleId = 0 AND r.flags & 64 > 0) OR
(@roleId = 1 AND r.flags & 16 > 0) OR
(@roleId = 2 AND r.flags & 32 > 0)
		)
END
IF OBJECT_ID('tempdb..#ReportsListing_Internal') IS NOT NULL
	DROP TABLE #ReportsListing_Internal
create table #ReportsListing_Internal(reportId int, userReportId nvarchar(max), name nvarchar(max), description nvarchar(max), definition xml, version int, deployedVersion int,
createTime int, modifiedTime int, userId int, guid nvarchar(max), revision nvarchar(max),flags int, engineVersion int, referenceId int, icon nvarchar(max), source int, Tags nvarchar(max),
RemoteRevision nvarchar(max), WhatsNew nvarchar(max), packageId int, platformId int, type nvarchar(max), tileProperties nvarchar(max), minCommCellVersion nvarchar(max),
maxCommCellVersion nvarchar(max), tileType nvarchar(max), CategoryId int, CategoryName nvarchar(max), customIcon nvarchar(max));
-- filter by reportId
IF @i_reportId <> 0
BEGIN
	IF @i_offlineOnly = 0
	BEGIN
		Insert into #ReportsListing_Internal(reportId, userReportId , name , description , definition , version , deployedVersion ,
		createTime , modifiedTime , userId , guid , revision ,flags , engineVersion , referenceId , icon , source , Tags ,
		RemoteRevision , WhatsNew , packageId , platformId , type , tileProperties , minCommCellVersion ,
		maxCommCellVersion , tileType , CategoryId , CategoryName , customIcon )
		SELECT 	r.reportId,
				r.userReportId,
				ISNULL(t.reportTitle, r.name) AS name,
				ISNULL(t.reportdescription, r.description) AS description,
				r.[definition],
				r.[version],
				r.[deployedVersion],
				r.[createTime],
				r.[modifiedTime],
				r.[userId],
				r.guid,
				r.[revision],
				r.flags,
				r.[engineVersion],
				r.[referenceId],
				r.[icon],
				r.[source],
				ISNULL(( stuff( ( select ',' + tagName from @reportTags rt	 where rt.reportId = r.reportId for xml path('')),1,1,'')),'') as 'Tags',
				ISNULL(DCCache.remoteRevision, '') AS 'RemoteRevision',
				ISNULL(DCCache.whatsNew, '') AS 'WhatsNew',
				DCCache.packageId AS 'packageId',
				DCCache.platformId AS 'platformId',
				f.[type] As 'type',
				r.tileProperties,
				r.minCommCellVersion,
				r.maxCommCellVersion,
				CASE
					WHEN r.tileType = 1 THEN 'Online'
					WHEN r.tileType = 2 THEN 'Offline'
					ELSE null END AS tileType,
				r.CategoryId,
				c.CategoryName,
				r.customIcon
		FROM APP_Reports r
		INNER JOIN @filterTable f ON r.reportId = f.reportId
		LEFT OUTER JOIN @rptTranslations t ON r.reportId = t.reportId
		LEFT OUTER JOIN DCStoreItemCache DCCache ON r.guid = DCCache.guid
		LEFT OUTER JOIN RptTileCategories c ON r.CategoryId = c.CategoryId
		WHERE r.reportId = @i_reportId
	END
	ELSE
	BEGIN
		Insert into #ReportsListing_Internal(reportId, userReportId , name , description , definition , version , deployedVersion ,
		createTime , modifiedTime , userId , guid , revision ,flags , engineVersion , referenceId , icon , source , Tags ,
		RemoteRevision , WhatsNew , packageId , platformId , type , tileProperties , minCommCellVersion ,
		maxCommCellVersion , tileType , CategoryId , CategoryName , customIcon )
		SELECT 	r.reportId,
				r.userReportId,
				ISNULL(t.reportTitle, r.name) AS name,
				ISNULL(t.reportdescription, r.description) AS description,
				r.[definition],
				r.[version],
				r.[deployedVersion],
				r.[createTime],
				r.[modifiedTime],
				r.[userId],
				r.guid,
				r.[revision],
				r.flags,
				r.[engineVersion],
				r.[referenceId],
				r.[icon],
				r.[source],
				ISNULL(( stuff( ( select ',' + tagName from @reportTags rt	 where rt.reportId = r.reportId for xml path('')),1,1,'')),'') as 'Tags',
				ISNULL(DCCache.remoteRevision, '') AS 'RemoteRevision',
				ISNULL(DCCache.whatsNew, '') AS 'WhatsNew',
				DCCache.packageId AS 'packageId',
				DCCache.platformId AS 'platformId',
				f.[type] As 'type',
				r.tileProperties,
				r.minCommCellVersion,
				r.maxCommCellVersion,
				CASE
					WHEN r.tileType = 1 THEN 'Online'
					WHEN r.tileType = 2 THEN 'Offline'
					ELSE null END AS tileType,
				r.CategoryId,
				c.CategoryName,
				r.customIcon
		FROM APP_Reports r
		INNER JOIN @filterTable f ON r.reportId = f.reportId
		LEFT OUTER JOIN @rptTranslations t ON r.reportId = t.reportId
		LEFT OUTER JOIN DCStoreItemCache DCCache ON r.guid = DCCache.guid
		LEFT OUTER JOIN RptTileCategories c ON r.CategoryId = c.CategoryId
		WHERE (f.[type] = 'Offline') AND r.reportId = @i_reportId
	END
END
ELSE
BEGIN
	IF @i_offlineOnly = 0
	BEGIN
		Insert into #ReportsListing_Internal(reportId, userReportId , name , description , definition , version , deployedVersion ,
		createTime , modifiedTime , userId , guid , revision ,flags , engineVersion , referenceId , icon , source , Tags ,
		RemoteRevision , WhatsNew , packageId , platformId , type , tileProperties , minCommCellVersion ,
		maxCommCellVersion , tileType , CategoryId , CategoryName , customIcon )
		SELECT 	r.reportId,
				r.userReportId,
				ISNULL(t.reportTitle, r.name) AS name,
				ISNULL(t.reportdescription, r.description) AS description,
				r.[definition],
				r.[version],
				r.[deployedVersion],
				r.[createTime],
				r.[modifiedTime],
				r.[userId],
				r.guid,
				r.[revision],
				r.flags,
				r.[engineVersion],
				r.[referenceId],
				r.[icon],
				r.[source],
				ISNULL(( stuff( ( select ',' + tagName from @reportTags rt	 where rt.reportId = r.reportId for xml path('')),1,1,'')),'') as 'Tags',
				ISNULL(DCCache.remoteRevision, '') AS 'RemoteRevision',
				ISNULL(DCCache.whatsNew, '') AS 'WhatsNew',
				DCCache.packageId AS 'packageId',
				DCCache.platformId AS 'platformId',
				f.[type] As 'type',
				r.tileProperties,
				r.minCommCellVersion,
				r.maxCommCellVersion,
				CASE
					WHEN r.tileType = 1 THEN 'Online'
					WHEN r.tileType = 2 THEN 'Offline'
					ELSE null END AS tileType,
				r.CategoryId,
				c.CategoryName,
				r.customIcon
		FROM APP_Reports r
		INNER JOIN @filterTable f ON r.reportId = f.reportId
		LEFT OUTER JOIN @rptTranslations t ON r.reportId = t.reportId
		LEFT OUTER JOIN DCStoreItemCache DCCache ON r.guid = DCCache.guid
		LEFT OUTER JOIN RptTileCategories c ON r.CategoryId = c.CategoryId
	END
	ELSE
	BEGIN
		Insert into #ReportsListing_Internal(reportId, userReportId , name , description , definition , version , deployedVersion ,
		createTime , modifiedTime , userId , guid , revision ,flags , engineVersion , referenceId , icon , source , Tags ,
		RemoteRevision , WhatsNew , packageId , platformId , type , tileProperties , minCommCellVersion ,
		maxCommCellVersion , tileType , CategoryId , CategoryName , customIcon )
		SELECT 	r.reportId,
				r.userReportId,
				ISNULL(t.reportTitle, r.name) AS name,
				ISNULL(t.reportdescription, r.description) AS description,
				r.[definition],
				r.[version],
				r.[deployedVersion],
				r.[createTime],
				r.[modifiedTime],
				r.[userId],
				r.guid,
				r.[revision],
				r.flags,
				r.[engineVersion],
				r.[referenceId],
				r.[icon],
				r.[source],
				ISNULL(( stuff( ( select ',' + tagName from @reportTags rt	 where rt.reportId = r.reportId for xml path('')),1,1,'')),'') as 'Tags',
				ISNULL(DCCache.remoteRevision, '') AS 'RemoteRevision',
				ISNULL(DCCache.whatsNew, '') AS 'WhatsNew',
				DCCache.packageId AS 'packageId',
				DCCache.platformId AS 'platformId',
				f.[type] As 'type',
				r.tileProperties,
				r.minCommCellVersion,
				r.maxCommCellVersion,
				CASE
					WHEN r.tileType = 1 THEN 'Online'
					WHEN r.tileType = 2 THEN 'Offline'
					ELSE null END AS tileType,
				r.CategoryId,
				c.CategoryName,
				r.customIcon
		FROM APP_Reports r
		INNER JOIN @filterTable f ON r.reportId = f.reportId
		LEFT OUTER JOIN @rptTranslations t ON r.reportId = t.reportId
		LEFT OUTER JOIN DCStoreItemCache DCCache ON r.guid = DCCache.guid
		LEFT OUTER JOIN RptTileCategories c ON r.CategoryId = c.CategoryId
		WHERE (f.[type] = 'Offline')
	END
END
SET @o_xmlSearchOutput = (select reportId as "@reportId", userReportId as "@userReportId" FROM #ReportsListing_Internal order by name ASC FOR XML PATH('reportNode'),ROOT ('Report'));
--if an outputTable name is not specified, we will display results and drop the table
IF(ISNULL(LEN(@outputTable),0) = 0)
	BEGIN
	select * from #ReportsListing_Internal order by name ASC
	END
--otherwise the results will be pushed into the specified output table
ELSE
	BEGIN
	DECLARE @sql NVARCHAR(300) = 'IF OBJECT_ID(''tempdb..#'+@outputTable+''') IS NOT NULL
	insert into #'+@outputTable+'(reportId, userReportId, name, description, guid, version, Tags, deployedVersion)
	SELECT reportId, userReportId, name, description, guid, version, Tags, deployedVersion FROM #ReportsListing_Internal'
	EXEC (@sql)
	END
DROP TABLE #ReportsListing_Internal
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppReportsGetListing')
	delete from GxQscripts where name = 'AppReportsGetListing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppReportsGetListing')
	delete from GXDBVersions where aliasname = 'AppReportsGetListing'
GO

insert into GXDBVersions values(2, 'AppReportsGetListing',  '00010013000200340000', 'AppReportsGetListing', '00010013000200340000')
GO

