

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppReportsDeploy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppReportsDeploy.sp,v $ $Id: AppReportsDeploy.sp,v 1.6.2.3 2018/03/27 08:12:42 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppReportsDeploy <<<'

IF EXISTS (select * from sysobjects where name='AppReportsDeploy')
	drop procedure AppReportsDeploy
IF EXISTS (select * from GxQscripts where name='AppReportsDeploy')
	delete from GxQscripts where name = 'AppReportsDeploy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppReportsDeploy')
	delete from GXDBVersions where aliasname = 'AppReportsDeploy'
GO
print '... Creating Procedure: AppReportsDeploy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppReportsDeploy
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_reportId int,
  @i_userId int,
  @i_localeId int
AS
SET NOCOUNT ON
BEGIN
  DECLARE @i_tileProp nvarchar(max) 
  DECLARE @o_Definition XML
  DECLARE @o_version int
  DECLARE @o_ErrorCode int
  DECLARE @o_ErrorString nvarchar(max)
SET @o_ErrorCode = 0
SET @o_ErrorString = ''
SELECT @o_version = version, @o_Definition = definition
FROM APP_Reports
WHERE reportId = @i_reportId
SET @i_tileProp = (SELECT ref.value('text()[1]', 'NVARCHAR(MAX)') FROM  @o_Definition.nodes ('CustomReport/tileProperties') R(ref))
IF NOT EXISTS(SELECT * FROM APP_ReportsHistory WHERE reportId = @i_reportId AND version = @o_version)
BEGIN
	SET @o_ErrorCode = 1
	SET	@o_ErrorString = 'report does not exist'
	GOTO FINISH
END
UPDATE APP_Reports
SET deployedVersion = @o_version,
	tileProperties = @i_tileProp
WHERE reportId = @i_reportId
UPDATE APP_ReportsHistory
SET deployed = 1,
	deployTime = dbo.GetUnixTime(GETUTCDATE())
WHERE reportId = @i_reportId
AND version = @o_version
FINISH:
SELECT @o_Definition As o_Definition, @o_version As o_version, @o_ErrorCode AS o_ErrorCode, @o_ErrorString AS o_ErrorString
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppReportsDeploy')
	delete from GxQscripts where name = 'AppReportsDeploy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppReportsDeploy')
	delete from GXDBVersions where aliasname = 'AppReportsDeploy'
GO

insert into GXDBVersions values(2, 'AppReportsDeploy',  '00010006000200030000', 'AppReportsDeploy', '00010006000200030000')
GO

