

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppRemoveSearchEngine.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppRemoveSearchEngine <<<'

IF EXISTS (select * from sysobjects where name='AppRemoveSearchEngine')
	drop procedure AppRemoveSearchEngine
IF EXISTS (select * from GxQscripts where name='AppRemoveSearchEngine')
	delete from GxQscripts where name = 'AppRemoveSearchEngine'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppRemoveSearchEngine')
	delete from GXDBVersions where aliasname = 'AppRemoveSearchEngine'
GO
print '... Creating Procedure: AppRemoveSearchEngine'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppRemoveSearchEngine
  @i_cloudId integer = 0
AS
  DECLARE @o_errorCode INT = 0
  DECLARE @o_errorString NVARCHAR(1024)=N''
IF @i_cloudId > 0
BEGIN
	DELETE FROM archContentIndexingAged WHERE cloudId = @i_cloudId
	IF (@@ERROR <> 0)
	BEGIN
		SET @o_errorCode = @@ERROR
		SET @o_errorString = 'Failed to delete rows from archContentIndexingAged.'
		GOTO ERROR_EXIT
	END
	DELETE FROM archContentIndexingRestart WHERE cloudId = @i_cloudId
	IF (@@ERROR <> 0)
	BEGIN
		SET @o_errorCode = @@ERROR
		SET @o_errorString = 'Failed to delete rows from archContentIndexingRestart.'
		GOTO ERROR_EXIT
	END
	DELETE FROM DM2SearchServerHealthInfo WHERE clientId IN ( SELECT clientId FROM DM2SearchServerCoreInfo WITH (NOLOCK) WHERE cloudId = @i_cloudId)
	IF (@@ERROR <> 0)
	BEGIN
		SET @o_errorCode = @@ERROR
		SET @o_errorString = 'Failed to delete rows from DM2SearchServerHealthInfo.'
		GOTO ERROR_EXIT
	END
	DELETE FROM APP_AdvanceSettings WHERE entityId IN ( SELECT clientId FROM DM2SearchServerCoreInfo WITH (NOLOCK) WHERE cloudId = @i_cloudId)
										AND keyName like 'solr.%'
	IF (@@ERROR <> 0)
	BEGIN
		SET @o_errorCode = @@ERROR
		SET @o_errorString = 'Failed to delete rows from APP_AdvanceSettings.'
		GOTO ERROR_EXIT
	END
DELETE FROM APP_Componentprop WHERE (Id = @i_cloudId AND componentType = 1 AND componentId = 2) OR (componentId = @i_cloudId AND componentType = 2 )
	IF (@@ERROR <> 0)
	BEGIN
		SET @o_errorCode = @@ERROR
		SET @o_errorString = 'Failed to delete rows from APP_Componentprop.'
		GOTO ERROR_EXIT
	END
	DELETE FROM APP_clientProp WHERE componentNameId IN (SELECT clientid FROM DM2SearchServerCoreInfo WITH (NOLOCK) WHERE cloudId = @i_cloudId)
				AND (attrName like 'FAST%' OR attrName IN ('CLOUD_ID','CLOUD_TYPE'))
    IF (@@ERROR <> 0)
    BEGIN
        SET @o_errorCode = @@ERROR
        SET @o_errorString = 'Failed to delete rows from APP_clientProp.'
        GOTO ERROR_EXIT
    END
	DELETE FROM DM2SearchServerCoreInfo WHERE cloudId = @i_cloudId
	IF (@@ERROR <> 0)
	BEGIN
		SET @o_errorCode = @@ERROR
		SET @o_errorString = 'Failed to delete rows from DM2SearchServerCoreInfo.'
		GOTO ERROR_EXIT
	END
END
ERROR_EXIT:
SELECT @o_errorCode, @o_errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppRemoveSearchEngine')
	delete from GxQscripts where name = 'AppRemoveSearchEngine'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppRemoveSearchEngine')
	delete from GXDBVersions where aliasname = 'AppRemoveSearchEngine'
GO

insert into GXDBVersions values(2, 'AppRemoveSearchEngine',  '00000000000000000000', 'AppRemoveSearchEngine', '00000000000000000000')
GO

