

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppRemovePlanforIdaEntity.sp] ---------- 

--  +===================================================================================================+
--  |		 		 Name:  AppPlanGetEnitityDefaultPlan()
--  | Description:  Fetches applicable Plan for the entity provided from any where in the hierarchy
--  +===================================================================================================+
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppRemovePlanforIdaEntity.sp,v $ $Id: AppRemovePlanforIdaEntity.sp,v 1.1.2.7 2020/10/15 17:15:07 njain Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppRemovePlanforIdaEntity')
BEGIN
	print '>>> Drop Stored Procedure: AppRemovePlanforIdaEntity <<<'
	drop procedure AppRemovePlanforIdaEntity
END
IF EXISTS (select * from GxQscripts where name='AppRemovePlanforIdaEntity')
	delete from GxQscripts where name = 'AppRemovePlanforIdaEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppRemovePlanforIdaEntity')
	delete from GXDBVersions where aliasname = 'AppRemovePlanforIdaEntity'
GO
print '... Creating Procedure: AppRemovePlanforIdaEntity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppRemovePlanforIdaEntity
  @i_userId INT,
  @i_localeId INT,
  @i_entityType INT,
  @i_entityId INT,
  @i_planId INT,
  @i_subclientPolicyAttrName VARCHAR(255),
  @o_errCode INTEGER OUTPUT,
  @o_errString VARCHAR(1024) OUTPUT
AS
  DECLARE @errCode INTEGER
  DECLARE @errString VARCHAR(1024)
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
    SET @o_errCode = 0 -- Optimism
    SET @o_errString = '' -- Optimism
	DECLARE @nowTime INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @processStoragePolicy INT = 1
	-- Lets start processing.
	-- Lets go bottom up approach, starting from subclient level.
IF (@i_entityType= 7)
	BEGIN
		-- Get Backupset Id
		DECLARE @backupsetId INT
		DECLARE @instanceId INT
		SELECT @backupsetId=backupset, @instanceId=instance FROM APP_Application WHERE id=@i_entityId
		IF EXISTS (SELECT 1 FROM APP_SubClientProp WHERE componentNameId = @i_entityId AND modified = 0 AND attrName='Associated subclient Policy' AND cs_attrName = CHECKSUM(N'Associated subclient Policy'))
		BEGIN
			-- First check if subclient has plan subclient policy associated to it.
			DECLARE @subClientPolicy INT = ISNULL(dbo.AppPlanGetEntityValueV2(@i_planId, @i_subclientPolicyAttrName, default),0)
			-- Get the associated subclient of the subclient policy
DECLARE @assocSubclient INT = (SELECT CAST(attrVal AS INT) FROM APP_SubClientProp WHERE componentNameId = @i_entityId AND modified = 0 AND attrName = N'Associated subclient Policy' AND cs_attrName = CHECKSUM(N'Associated subclient Policy'))
			-- Now check if subclient policy associated with subclient is same as one present in plan
			-- In case of nothing being present in plan and some subclient policy being associated, then we will not touch Storage Policy also (as that will be coming from subclient policy)
			-- Get backupset associated with the SCP subclient
			DECLARE @subclientPolicyEntity INT = (SELECT backupSet FROm APP_Application WHERE id = @assocSubclient)
			DECLARE @returnValueTbl TABLE (rc INT)
			IF (@subClientPolicy = @subclientPolicyEntity)
			BEGIN
				-- Subclient policy from plan to subclient matches. Just de-associate it
				-- Remove subclient policy association
				IF OBJECT_ID('tempdb.dbo.#DissocSCPSubclients') IS NOT NULL
				DROP TABLE #DissocSCPSubclients
				CREATE TABLE #DissocSCPSubclients(subclientId INT PRIMARY KEY)
				INSERT INTO #DissocSCPSubclients
				SELECT @i_entityId
				INSERT INTO @returnValueTbl
				EXEC AppDissocSubClientPolicy 0, @nowTime
			END
			ELSE
			BEGIN
				-- there is some subclient policy associated and it is not coming form plan.
				-- Leave it as is and also mark to not touch Storage Policy for this subclient
				SET @processStoragePolicy = 0
			END
		END
DECLARE @planStoragePolicy INT = ISNULL(dbo.AppPlanGetEntityValueV2(@i_planId, 'Storage policy', default),0)
		IF (@processStoragePolicy=1)
		BEGIN
			-- First update App_application for the default Storage Policy Id
			-- This will be only done, if we have matching Storage Policy
			-- CV_DEFAULT_ARCHIVE_GROUP = 1
			UPDATE APP_Application
				SET logArchGrpID=1 /*CV_DEFAULT_ARCHIVE_GROUP*/, dataArchGrpID=1 /*CV_DEFAULT_ARCHIVE_GROUP*/
			WHERE id=@i_entityId AND (dataArchGrpID IN
			(
				SELECT ref.value('@storagePolicyId', 'INT') AS storagePolicyId
FROM (SELECT (CAST(dbo.AppPlanGetEntityValueV2(@i_planId, 'Storage Rules', default) AS XML)) AS storageRules) AS SR
				 CROSS APPLY SR.storageRules.nodes('Api_PlanRuleMaps/rules/policy') R(ref)
			)
			OR dataArchGrpID = @planStoragePolicy)
		END
		-- Remove backupset plan when removing default subclient plan only
		DECLARE @isDefaultSubclient INT = ISNULL((SELECT 1 FROM APP_Application WHERE id = @i_entityId AND subclientStatus & 8 = 8),0)
		IF @isDefaultSubclient = 1
		BEGIN
UPDATE APP_BackupSetProp SET modified=@nowTime WHERE  attrName = 'Associated Plan' AND componentNameId = @backupsetId AND modified = 0
		END
DELETE APP_SubclientProp WHERE  attrName = 'Associated Plan' AND componentNameId = @i_entityId AND modified = 0 AND cs_attrName = CHECKSUM(N'Associated Plan')
DELETE APP_SubclientProp  WHERE  attrName = 'Associated Plan Parent EntityType' AND componentNameId = @i_entityId AND modified = 0 AND cs_attrName = CHECKSUM(N'Associated Plan Parent EntityType')
DELETE APP_SubclientProp  WHERE  attrName = 'Associated Plan Parent EntityId' AND componentNameId = @i_entityId AND modified = 0 AND cs_attrName = CHECKSUM(N'Associated Plan Parent EntityId')
	END
IF (@i_entityType= 6)
	BEGIN
DELETE FROM APP_BackupSetProp WHERE  attrName = 'Associated Plan' AND componentNameId = @i_entityId
	END
IF (@i_entityType= 5)
	BEGIN
DELETE FROM APP_InstanceProp WHERE  attrName = 'Associated Plan' AND componentNameId = @i_entityId
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @o_errCode = ERROR_NUMBER()
    SET @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
SCRIPT_EXIT:
IF OBJECT_ID('tempdb.dbo.#DissocSCPSubclients') IS NOT NULL
				DROP TABLE #DissocSCPSubclients
SET @errCode        = @o_errCode
SET @errString      = @o_errString
IF object_id('tempdb.dbo.#tempRemovePlanForIdaTbl') IS NOT null
BEGIN -- if output temp table is present, populate result
   INSERT INTO #tempRemovePlanForIdaTbl
   SELECT @errCode, @errString
END
ELSE
BEGIN
    SELECT @errCode, @errString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppRemovePlanforIdaEntity')
	delete from GxQscripts where name = 'AppRemovePlanforIdaEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppRemovePlanforIdaEntity')
	delete from GXDBVersions where aliasname = 'AppRemovePlanforIdaEntity'
GO

insert into GXDBVersions values(2, 'AppRemovePlanforIdaEntity',  '00010001000200070000', 'AppRemovePlanforIdaEntity', '00010001000200070000')
GO

