

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppRemoveBackupRefTimes.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppRemoveBackupRefTimes   - Reset the refTimes of subclients to 0.
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppRemoveBackupRefTimes <<<'

IF EXISTS (select * from sysobjects where name='AppRemoveBackupRefTimes')
	drop procedure AppRemoveBackupRefTimes
IF EXISTS (select * from GxQscripts where name='AppRemoveBackupRefTimes')
	delete from GxQscripts where name = 'AppRemoveBackupRefTimes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppRemoveBackupRefTimes')
	delete from GXDBVersions where aliasname = 'AppRemoveBackupRefTimes'
GO
print '... Creating Procedure: AppRemoveBackupRefTimes'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppRemoveBackupRefTimes
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @inLevel INTEGER,
  @inClientID INTEGER,
  @inAppTypeID INTEGER,
  @inEntityId INTEGER,
  @inClearReason INTEGER
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  DECLARE @errorCode INTEGER
	SET @errorCode = 0
	DECLARE @errorString			NVARCHAR(1024)
	DECLARE @currentTime INT = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @appIDTable TABLE
	(appId INTEGER)
------------------------------------------------------------------------------------
--  GATHERED ENOUGH INFORMATION, TIME TO START INSERTING SOME DATA TO THE TABLES! --
------------------------------------------------------------------------------------
	IF @inLevel <> 2
	BEGIN
		INSERT INTO @appIDTable
		SELECT id FROM APP_Application WHERE
		CASE @inLevel
			WHEN 1 THEN clientId
			WHEN 3 THEN instance
			WHEN 4 THEN backupset
			WHEN 5 THEN id
		END = @inEntityId
		SET @errorCode = @@ERROR
		IF @errorCode <> 0
		GOTO ERROR_EXIT
	END
	ELSE
	BEGIN
		INSERT INTO @appIDTable
		SELECT id FROM APP_Application WHERE
		clientId = @inClientID AND appTypeId = @inAppTypeID
		SET @errorCode = @@ERROR
		IF @errorCode <> 0
		GOTO ERROR_EXIT
	END
	DECLARE @appID INT = 0
	DECLARE @reFTime INT = 0
	DECLARE appIDCursor CURSOR
	FOR SELECT appId FROM @appIDTable
	OPEN appIDCursor
	FETCH appIDCursor INTO @appID
	WHILE @@FETCH_STATUS = 0
	BEGIN
		-- If refTime is valid only then take turbo copy, else we will end up taking 0 as copy
		IF EXISTS (SELECT *
				   FROM APP_SubClientProp
				   WHERE componentNameId = @appID
				   AND attrName = 'sys:last full' AND modified = 0 AND CAST(attrVal AS INTEGER) <> 0)
		BEGIN
			-- Remove existing turbo refTime and taking a copy
			DELETE FROM APP_SubClientProp
			WHERE componentNameId = @appID	AND attrName = 'turbo:last full' AND modified = 0
			SET @errorCode = @@ERROR
			IF @errorCode <> 0
			GOTO ERROR_EXIT
			INSERT INTO APP_SubClientProp
			SELECT componentNameId, 'turbo:last full', attrType, attrVal , dbo.GetUnixTime(GETUTCDATE()), 0, ccpId
			FROM APP_SubClientProp
			WHERE componentNameId = @appID
			AND attrName = 'sys:last full' AND modified = 0 AND CAST(attrVal AS INTEGER) <> 0
			SET @errorCode = @@ERROR
			IF @errorCode <> 0
			GOTO ERROR_EXIT
		END
		-- If refTime is valid only then take turbo copy, else we will end up taking 0 as copy
		IF EXISTS (SELECT *
				   FROM APP_SubClientProp
				   WHERE componentNameId = @appID
				   AND attrName = 'sys:last incr' AND modified = 0 AND CAST(attrVal AS INTEGER) <> 0)
		BEGIN
			-- Remove existing turbo refTime and taking a copy
			DELETE FROM APP_SubClientProp
			WHERE componentNameId = @appID	AND attrName = 'turbo:last incr' AND modified = 0
			SET @errorCode = @@ERROR
			IF @errorCode <> 0
			GOTO ERROR_EXIT
			INSERT INTO APP_SubClientProp
			SELECT componentNameId, 'turbo:last incr', attrType, attrVal , dbo.GetUnixTime(GETUTCDATE()), 0, ccpId
			FROM APP_SubClientProp
			WHERE componentNameId = @appID
			AND attrName = 'sys:last incr' AND modified = 0 AND CAST(attrVal AS INTEGER) <> 0
			SET @errorCode = @@ERROR
			IF @errorCode <> 0
			GOTO ERROR_EXIT
		END
		FETCH appIDCursor INTO @appID
	END
	--MR 146895: reset only last full and last incremental
	-- Now reset all the refTimes to 0 in one shot
	UPDATE APP_SubClientProp
	SET attrVal = '0'
	WHERE componentNameId IN (SELECT appId FROM @appIDTable)
	AND attrName IN('sys:last full','sys:last incr') AND modified = 0
	SET @errorCode = @@ERROR
	IF @errorCode <> 0
	GOTO ERROR_EXIT
	-- Reset reftime clear reason
	DELETE APP_SubClientProp
	WHERE componentNameId IN (SELECT appId FROM @appIDTable)
	AND attrName = 'Reason last backup time cleared' AND modified = 0
	SET @errorCode = @@ERROR
	IF @errorCode <> 0
	GOTO ERROR_EXIT
	INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
	SELECT appId, 'Reason last backup time cleared', 7, '30', @currentTime, 0, 0
	FROM @appIDTable
	SET @errorCode = @@ERROR
	IF @errorCode <> 0
	GOTO ERROR_EXIT
	ERROR_EXIT:
	CLOSE appIDCursor
	DEALLOCATE appIDCursor
	SELECT @errorCode
	SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'AppRemoveBackupRefTimes')
	delete from GxQscripts where name = 'AppRemoveBackupRefTimes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppRemoveBackupRefTimes')
	delete from GXDBVersions where aliasname = 'AppRemoveBackupRefTimes'
GO

insert into GXDBVersions values(2, 'AppRemoveBackupRefTimes',  '00000000000000000000', 'AppRemoveBackupRefTimes', '00000000000000000000')
GO

