

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppRemoveAnalyticsCloud.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppRemoveAnalyticsCloud <<<'

IF EXISTS (select * from sysobjects where name='AppRemoveAnalyticsCloud')
	drop procedure AppRemoveAnalyticsCloud
IF EXISTS (select * from GxQscripts where name='AppRemoveAnalyticsCloud')
	delete from GxQscripts where name = 'AppRemoveAnalyticsCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppRemoveAnalyticsCloud')
	delete from GXDBVersions where aliasname = 'AppRemoveAnalyticsCloud'
GO
print '... Creating Procedure: AppRemoveAnalyticsCloud'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppRemoveAnalyticsCloud
  @i_clientId integer
AS
  DECLARE @o_errorCode INT
  DECLARE @o_errorString VARCHAR(255)
DECLARE @cloudId INT
SET @cloudId = ISNULL((SELECT cloudId FROM DM2SearchServerCoreInfo WHERE clientId = @i_clientId), 0)
IF EXISTS (SELECT * FROM archFLAIndexingInfo WHERE cloudId = @cloudId)
BEGIN
	DELETE FROM archFLAIndexingInfo WHERE cloudId = @cloudId
	IF (@@ERROR <> 0)
	BEGIN
		SET @o_errorCode = @@ERROR
		SET @o_errorString = 'Failed to delete rows from archFLAIndexingInfo.'
		GOTO ERROR_EXIT
	END
END
IF EXISTS (SELECT * FROM archFLAIndexingAged WHERE cloudId = @cloudId)
BEGIN
	DELETE FROM archFLAIndexingAged WHERE cloudId = @cloudId
	IF (@@ERROR <> 0)
	BEGIN
		SET @o_errorCode = @@ERROR
		SET @o_errorString = 'Failed to delete rows from archFLAIndexingAged.'
		GOTO ERROR_EXIT
	END
END
IF EXISTS (SELECT * FROM archFLAIndexingRestart WHERE cloudId = @cloudId)
BEGIN
	DELETE FROM archFLAIndexingRestart WHERE cloudId = @cloudId
	IF (@@ERROR <> 0)
	BEGIN
		SET @o_errorCode = @@ERROR
		SET @o_errorString = 'Failed to delete rows from archFLAIndexingRestart.'
		GOTO ERROR_EXIT
	END
END
IF EXISTS (SELECT * FROM archFLAIndexingAF WHERE clientId = @i_clientId)
BEGIN
	DELETE FROM archFLAIndexingAF WHERE clientId = @i_clientId
	IF (@@ERROR <> 0)
	BEGIN
		SET @o_errorCode = @@ERROR
		SET @o_errorString = 'Failed to delete rows from archFLAIndexingAF.'
		GOTO ERROR_EXIT
	END
END
IF EXISTS (SELECT * FROM DM2SearchServerCoreInfo WHERE clientId = @i_clientId)
BEGIN
	DELETE FROM DM2SearchServerCoreInfo WHERE clientId = @i_clientId
	IF (@@ERROR <> 0)
	BEGIN
		SET @o_errorCode = @@ERROR
		SET @o_errorString = 'Failed to delete rows from DM2SearchServerCoreInfo.'
		GOTO ERROR_EXIT
	END
END
IF EXISTS (SELECT * FROM APP_clientProp WHERE componentNameId = @i_clientId AND (attrName like 'FAST%' OR attrName IN ('CLOUD_ID', 'CLOUD_TYPE','AnalyticSearchEngineEnabled')))
BEGIN
	DELETE FROM APP_clientProp WHERE componentNameId = @i_clientId AND ( attrName like 'FAST%' OR attrName IN ('CLOUD_ID', 'CLOUD_TYPE', 'AnalyticSearchEngineEnabled'))
	IF (@@ERROR <> 0)
	BEGIN
		SET @o_errorCode = @@ERROR
		SET @o_errorString = 'Failed to delete rows from APP_clientProp.'
		GOTO ERROR_EXIT
	END
END
IF EXISTS (SELECT * FROM APP_componentProp WHERE id = @cloudId OR componentId =@cloudId)
BEGIN
	DELETE FROM APP_componentProp WHERE id = @cloudId OR componentId =@cloudId
	IF (@@ERROR <> 0)
	BEGIN
		SET @o_errorCode = @@ERROR
		SET @o_errorString = 'Failed to delete rows from APP_componentProp.'
		GOTO ERROR_EXIT
	END
END
ERROR_EXIT:
SELECT @o_errorCode, @o_errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppRemoveAnalyticsCloud')
	delete from GxQscripts where name = 'AppRemoveAnalyticsCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppRemoveAnalyticsCloud')
	delete from GXDBVersions where aliasname = 'AppRemoveAnalyticsCloud'
GO

insert into GXDBVersions values(2, 'AppRemoveAnalyticsCloud',  '00000000000000000000', 'AppRemoveAnalyticsCloud', '00000000000000000000')
GO

