

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppRefreshUserConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppRefreshUserConfig							|
--	|  Procedure to get all the sync folders and user centric clients configured on a laptop.
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppRefreshUserConfig <<<'

IF EXISTS (select * from sysobjects where name='AppRefreshUserConfig')
	drop procedure AppRefreshUserConfig
IF EXISTS (select * from GxQscripts where name='AppRefreshUserConfig')
	delete from GxQscripts where name = 'AppRefreshUserConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppRefreshUserConfig')
	delete from GXDBVersions where aliasname = 'AppRefreshUserConfig'
GO
print '... Creating Procedure: AppRefreshUserConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppRefreshUserConfig
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	-- Read the XML
	DECLARE @inWebFolderId			INT				= ISNULL (( SELECT ref.value('@syncWebFolderId', 'INT')
														FROM @i_xmlString.nodes ('App_RefreshConfigRequest/syncFolder') R(ref)), 0)
	DECLARE @inClientId			INT				= ISNULL (( SELECT ref.value('@clientId', 'INT')
														FROM @i_xmlString.nodes ('App_RefreshConfigRequest/laptop') R(ref)), 0)
	DECLARE @subclientId			INT				= ISNULL (( SELECT ref.value('@subclientId', 'INT')
														FROM @i_xmlString.nodes ('App_RefreshConfigRequest/subclient') R(ref)), 0)
	DECLARE @inClientName		nvarchar(100)			= ISNULL (( SELECT ref.value('@clientName', 'nvarchar(100)')
														FROM @i_xmlString.nodes ('App_RefreshConfigRequest/laptop') R(ref)), 0)
	DECLARE @getEdgeDriveData	INT				= ISNULL (( SELECT ref.value('@edgeDriveData', 'INT')
														FROM @i_xmlString.nodes ('App_RefreshConfigRequest') R(ref)), 0)
	DECLARE @getUserCentricData	INT				= ISNULL (( SELECT ref.value('@userCentricData', 'INT')
														FROM @i_xmlString.nodes ('App_RefreshConfigRequest') R(ref)), 0)
	IF @inClientId = 0
	BEGIN
			SET @inClientId = (SELECT id from APP_CLIENT WHERE name = @inClientName)
	END
   --Frame the response
    IF @getEdgeDriveData = 1
	BEGIN
		 DECLARE @edgeData XML =
			(
			(SELECT
				SYNC.flag AS '@flag',
				(SELECT
					DISTINCT SYNC.syncWebFolderId  AS '@syncWebFolderId',
					SYNC.syncWebFolderName AS '@syncWebFolderName'
					FOR XML PATH('syncWebFolder'), TYPE
				),
				(SELECT
					CO.syncPath AS '@syncPath',
					ISNULL(CO.syncType, 4) AS '@syncType',
					CO.flag AS '@flag',
					(SELECT CO.configOptions  TYPE),
					(SELECT
						CO.clientId AS '@clientId',
						EDC.subclientId as '@subclientId',
						App.subclientName as '@subclientName',
						bkupSet.id as '@backupsetId',
						bkupSet.name as '@backupsetName'
						FROM App_SyncCloudConfig EDC
						JOIN APP_Client CL2  ON EDC.clientId = CL2.id
						JOIN APP_APPLICATION App ON App.id = EDC.subclientId
						JOIN APP_BackupSetName bkupSet ON bkupset.id = App.backupSet
						AND EDC.syncWebFolderId = SYNC.syncWebFolderId
						AND CL2.status & 0x10000000 <> 0
						FOR XML PATH('client'), TYPE
					)
					FOR XML PATH('associatedClients'), TYPE
				),
				(SELECT
					SYNC.ownerId AS '@userId',
					login as '@userName'
					FROM UMUSers
					Where id = SYNC.ownerId
					FOR XML PATH('syncOwner'), TYPE
				)	,
				(
					SELECT TOP 1
					CL2.id  AS '@clientId',
					CL2.name AS '@clientName'
					FROM App_Application App JOIN
					App_Client CL2
					ON CL2.id = App.clientId
					AND App.id = Co.subclientId
					FOR XML PATH('edgeDriveClient'), TYPE
				)
				FROM App_SyncCloudFolder SYNC
				JOIN App_SyncCloudConfig CO
				ON CO.syncWebFolderId = SYNC.syncWebFolderId
WHERE SYNC.flag & 0x10 <> 0
				-- For this physical client/laptop
				AND (@inClientId <> 0 AND Co.clientId = @inClientId)
				-- either provide scId or FolderId
				AND ((@subclientId = 0) OR (@subclientId <> 0 AND Co.subclientId = @subclientId))
				AND ((@inWebFolderId = 0) OR  (@inWebFolderId <> 0 AND  SYNC.syncWebFolderId = @inWebFolderId))
				FOR XML PATH('syncInfo'),TYPE
			)
		)
	END
	IF @getUserCentricData = 1
	BEGIN
		DECLARE @userCentricData XML=
		(SELECT
			(
				SELECT
				sc.subclientname as '@subclientName',
				sc.id as'@subclientId',
				client.name as '@clientName',
				client.id as'@clientId',
				client.displayName as '@displayName'
				FROM APP_APPLICATION sc
				JOIN APP_CLIENT client ON sc.clientId = client.id
				-- Do not choose deconfigured/deleted sc/indexing sc.
				Where sc.subclientStatus & 2 <> 2 and sc.subclientStatus & 4 <> 4 and
				sc.subclientStatus & 16 <> 16 and sc.subclientStatus & 32 <> 32
				and client.id = uc.id
				FOR XML PATH('userCentricSubclients'),TYPE
			),
			(
				SELECT login as '@userName',
				id as '@userId'
				FROM UMUSers U
				where U.id = uc.userId
				FOR XML PATH('user'),TYPE
			),
			(
				SELECT @inClientId as '@clientId',
				@inClientName as '@clientName'
				FOR XML PATH('physicalClient'),TYPE
			)
			FROM
			(
				SELECT owners.ClientID as id,owners.userId FROM
				sec_getClientOwners(1) owners
				JOIN APP_CLIENTPROP prop
				on owners.ClientID = prop.componentNameId
WHERE attrName = 'Physical Client Id'
				AND attrval = @inClientId
			) as uc
		FOR XML PATH('userCentricSubclientInfo'),TYPE)
	END
	END_SP:
	SET @o_xmlString = (
						 SELECT  @userCentricData,
								@edgeData
						 FOR  XML PATH ('App_RefreshConfigResponse'),TYPE
						)
	IF @o_xmlString IS NULL
		SET @o_xmlString = '<App_RefreshConfigResponse/>'
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppRefreshUserConfig')
	delete from GxQscripts where name = 'AppRefreshUserConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppRefreshUserConfig')
	delete from GXDBVersions where aliasname = 'AppRefreshUserConfig'
GO

insert into GXDBVersions values(2, 'AppRefreshUserConfig',  '00000000000000000000', 'AppRefreshUserConfig', '00000000000000000000')
GO

