

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppRMSetRecord.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppRMSetRecord.sp,v $ $Id: AppRMSetRecord.sp,v 1.1.2.8 2018/03/27 08:11:07 jiechen Exp $";
--	+===================================================================+
--	|  					  AppRMSetRecord								|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppRMSetRecord <<<'

IF EXISTS (select * from sysobjects where name='AppRMSetRecord')
	drop procedure AppRMSetRecord
IF EXISTS (select * from GxQscripts where name='AppRMSetRecord')
	delete from GxQscripts where name = 'AppRMSetRecord'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppRMSetRecord')
	delete from GXDBVersions where aliasname = 'AppRMSetRecord'
GO
print '... Creating Procedure: AppRMSetRecord'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppRMSetRecord
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML,
  @i_userId INT,
  @i_localeId INT
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(1024) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @recordId			INT = 0
	DECLARE @recordName			NVARCHAR(512)
	DECLARE @description		NVARCHAR(MAX)
	DECLARE @foldersOpType		INT = 0
	DECLARE @propertiesOpType	INT = 0
	DECLARE @retentionInDays	INT = 0
	DECLARE @statusFlags		INT = 0
	DECLARE @recordTranStarted INT = 0
	DECLARE @recordConfigOptions XML
	IF OBJECT_ID('tempdb.dbo.#Folders') IS NOT NULL
	    DROP TABLE #Folders
	IF OBJECT_ID('tempdb.dbo.#Properties') IS NOT NULL
	    DROP TABLE #Properties
	CREATE TABLE #Folders
	(
		folderId		INT,
		folderPath		NVARCHAR(MAX),
		displayName		NVARCHAR(512),
		folderGUID		NVARCHAR(512),
		statusFlags		INT
	)
	CREATE TABLE #Properties
	(
		propertyId		INT,
		propertyValue	NVARCHAR(MAX),
	)
	BEGIN TRY
		-- Read the XML
		SELECT
			@recordId = ISNULL(ref.value('(//record/@recordId)[1]', 'INT'), 0),
			@recordName = LTRIM(RTRIM(ref.value('(//record/@recordName)[1]', 'NVARCHAR(512)'))),
			@description = LTRIM(RTRIM(ref.value('@description', 'NVARCHAR(MAX)'))),
			@foldersOpType = ISNULL(ref.value('@foldersOperationType', 'INT'), 0),
			@propertiesOpType = ISNULL(ref.value('@propertiesOperationType', 'INT'), 0),
			@retentionInDays = ref.value('(//retention/@retention)[1]', 'INT')
		FROM
		@i_xmlString.nodes('/App_RecordInfo') doc(ref)
		SET @recordConfigOptions = @i_xmlString.query('/App_RecordInfo/configOptions')
		IF CAST(@recordConfigOptions AS NVARCHAR(MAX)) = ''
			SET @recordConfigOptions = NULL
		INSERT INTO #Folders(folderId, folderPath, displayName, folderGUID)
		SELECT
			ISNULL((ref.value('@folderId', 'INT')), 0),
			LTRIM(RTRIM(ref.value('@folderPath', 'NVARCHAR(MAX)'))),
			LTRIM(RTRIM(ref.value('@displayName', 'NVARCHAR(512)'))),
			LTRIM(RTRIM(ISNULL(ref.value('@folderGUID', 'NVARCHAR(512)'), '')))
		FROM
		@i_xmlString.nodes('/App_RecordInfo/folders') doc(ref)
		INSERT INTO #Properties(propertyId, propertyValue)
		SELECT
			ISNULL((ref.value('@propertyId', 'INT')), 0),
			LTRIM(RTRIM(ISNULL((ref.value('@propertyValue', 'NVARCHAR(MAX)')), '')))
		FROM
		@i_xmlString.nodes('/App_RecordInfo/properties') doc(ref)
		-- If record ID is passed check if it already exists to update
		IF @recordId > 0
		BEGIN
			IF NOT EXISTS(SELECT 1 FROM App_RMRecord WITH (NOLOCK) WHERE recordId = @recordId)
			BEGIN
SET @errorCode = (1287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) --TODO
				SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @errorCode, 0, 2)
				GOTO ERROR_EXIT
			END
		END
		ELSE
		BEGIN
			-- No recordID means create operation
			IF @recordName IS NULL
			BEGIN
SET @errorCode = (1287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) --TODO
				SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @errorCode, 0, 2)
				GOTO ERROR_EXIT
			END
			SET @foldersOpType = 1 --ListOperationType_OVERWRITE
			SET @propertiesOpType = 1 --ListOperationType_OVERWRITE
		END
		-- Do we need any security check?
		-- Check if name is unique
		IF EXISTS(SELECT 1 FROM App_RMRecord WITH (NOLOCK)
				  WHERE recordName = @recordName AND recordId <> @recordId
				  AND ownerId = @i_userId)
		BEGIN
SET @errorCode = (1287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) --TODO
			--SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @errorCode, 0, 2)
			SET @errorString = 'Another Record exists with the same name.'
			GOTO ERROR_EXIT
		END
		-- Check if path is not already existing
		IF EXISTS(SELECT 1
				  FROM App_RMRecord R WITH (NOLOCK)
				  INNER JOIN App_RMFolder F WITH(NOLOCK) ON R.recordId = F.recordId
				  INNER JOIN #Folders NF ON NF.folderPath = F.folderPath
				  AND R.recordId <> @recordId
				  AND ownerId = @i_userId)
		BEGIN
SET @errorCode = (1287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) --TODO
			--SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @errorCode, 0, 2)
			SET @errorString = 'The specified UNC folder path is already part of another record.'
			GOTO ERROR_EXIT
		END
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION RecordTran
			SET @recordTranStarted = 1
		END
		-- Do create or update accordingly.
		IF @recordId = 0
		BEGIN
			-- Create the record
			INSERT INTO App_RMRecord(recordName, description, retention, ownerId, statusFlags, createdTime, configOptions)
			VALUES(@recordName, ISNULL(@description, ''), @retentionInDays, @i_userId, @statusFlags, @nowTime, CAST(@recordConfigOptions AS NVARCHAR(MAX)))
			SELECT @recordId = SCOPE_IDENTITY()
		END
		ELSE
		BEGIN
			UPDATE App_RMRecord
			SET recordName = ISNULL(@recordName, recordName),
				retention = ISNULL(@retentionInDays, retention),
				description = ISNULL(@description, description),
				configOptions = ISNULL(CAST(@recordConfigOptions AS NVARCHAR(MAX)), configOptions)
			WHERE recordId = @recordId
		END
		-- TODO AUDIT TRAIL
		IF @foldersOpType = 1 -- ListOperationType_OVERWRITE
		BEGIN
			MERGE App_RMFolder AS TARGET
			USING (SELECT folderId, folderPath, displayName, folderGUID FROM #Folders WHERE folderPath IS NOT NULL) AS SOURCE (folderId, folderPath, displayName, folderGUID)
				ON (TARGET.recordId = @recordId AND (TARGET.folderId = SOURCE.folderId OR TARGET.folderPath = SOURCE.folderPath))
			WHEN MATCHED THEN
				UPDATE SET displayName = TARGET.displayName, folderGUID = SOURCE.folderGUID
			WHEN NOT MATCHED BY TARGET THEN
				INSERT (folderPath, displayName, recordId, folderGUID, statusFlags, lastUploadedTime, uploadFrequency, createdTime)
				VALUES(SOURCE.folderPath, SOURCE.displayName, @recordId, folderGUID, 0, 0, 0, @nowTime)
			WHEN NOT MATCHED BY SOURCE AND TARGET.recordId = @recordId THEN
				DELETE;
		END
		ELSE IF @foldersOpType = 2 -- ListOperationType_ADD
		BEGIN
			MERGE App_RMFolder AS TARGET
			USING (SELECT folderId, folderPath, displayName, folderGUID FROM #Folders WHERE folderPath IS NOT NULL) AS SOURCE (folderId, folderPath, displayName, folderGUID)
				ON (TARGET.recordId = @recordId AND (TARGET.folderId = SOURCE.folderId OR TARGET.folderPath = SOURCE.folderPath))
			WHEN MATCHED THEN
				UPDATE SET displayName = TARGET.displayName
			WHEN NOT MATCHED BY TARGET THEN
				INSERT (folderPath, displayName, recordId, folderGUID, statusFlags, lastUploadedTime, uploadFrequency, createdTime)
				VALUES(SOURCE.folderPath, SOURCE.displayName, @recordId, folderGUID, 0, 0, 0, @nowTime);
		END
		ELSE IF @foldersOpType = 3 -- ListOperationType_DELETE
		BEGIN
			DELETE App_RMFolder
			WHERE recordId = @recordId
			AND folderId IN (SELECT folderId FROM #Folders)
		END
		IF @propertiesOpType = 1 -- ListOperationType_OVERWRITE
		BEGIN
			MERGE App_RMRecordProperty AS TARGET
			USING (SELECT propertyId, propertyValue FROM #Properties) AS
									SOURCE (propertyId, propertyValue)
				ON (TARGET.recordId = @recordId AND TARGET.propertyId = SOURCE.propertyId)
			WHEN MATCHED THEN
				UPDATE SET TARGET.propertyValue = SOURCE.propertyValue
			WHEN NOT MATCHED BY TARGET THEN
				INSERT(recordId, propertyId, propertyValue)
				VALUES(@recordId, SOURCE.propertyId, SOURCE.propertyValue)
			WHEN NOT MATCHED BY SOURCE AND TARGET.recordId = @recordId THEN
				DELETE;
		END
		ELSE IF @propertiesOpType = 2 -- ListOperationType_ADD
		BEGIN
			MERGE App_RMRecordProperty AS TARGET
			USING (SELECT propertyId, propertyValue FROM #Properties) AS
									SOURCE (propertyId, propertyValue)
				ON (TARGET.recordId = @recordId AND TARGET.propertyId = SOURCE.propertyId)
			WHEN MATCHED THEN
				UPDATE SET TARGET.propertyValue = SOURCE.propertyValue
			WHEN NOT MATCHED BY TARGET THEN
				INSERT(recordId, propertyId, propertyValue)
				VALUES(@recordId, SOURCE.propertyId, SOURCE.propertyValue);
		END
		ELSE IF @propertiesOpType = 3 -- ListOperationType_DELETE
		BEGIN
			DELETE App_RMRecordProperty
			WHERE recordId = @recordId
			AND propertyId IN (SELECT propertyId FROM #Properties)
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
	END CATCH
ERROR:
	IF @errorCode <> 0
	BEGIN
		IF XACT_STATE() <> 0 AND @recordTranStarted = 1
		BEGIN
			ROLLBACK TRANSACTION RecordTran
		END
		IF @errorString = ''
		BEGIN
SET @errorCode = (1287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) --TODO
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @errorCode, 0, 2)
		END
	END
	ELSE IF @recordTranStarted = 1
		COMMIT TRANSACTION RecordTran
	IF OBJECT_ID('tempdb.dbo.#Folders') IS NOT NULL
	    DROP TABLE #Folders
	IF OBJECT_ID('tempdb.dbo.#Properties') IS NOT NULL
	    DROP TABLE #Properties
ERROR_EXIT:
		SET @o_xmlString = (SELECT
								    (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
									 FOR XML PATH('error'), TYPE),
									(SELECT @recordId AS 'record/@recordId', @recordName AS 'record/@recordName'
									 FOR XML PATH('records'),TYPE)
							FOR XML PATH('App_RecordsResponse'), TYPE)
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppRMSetRecord')
	delete from GxQscripts where name = 'AppRMSetRecord'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppRMSetRecord')
	delete from GXDBVersions where aliasname = 'AppRMSetRecord'
GO

insert into GXDBVersions values(2, 'AppRMSetRecord',  '00010001000200080000', 'AppRMSetRecord', '00010001000200080000')
GO

