

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppRMGetRecordInfoForBackup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppRMGetRecordInfoForBackup.sp,v $ $Id: AppRMGetRecordInfoForBackup.sp,v 1.1.2.6 2018/03/27 08:05:47 jiechen Exp $";
--	+===================================================================+
--	|  					  AppRMGetRecordInfoForBackup								|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppRMGetRecordInfoForBackup <<<'

IF EXISTS (select * from sysobjects where name='AppRMGetRecordInfoForBackup')
	drop procedure AppRMGetRecordInfoForBackup
IF EXISTS (select * from GxQscripts where name='AppRMGetRecordInfoForBackup')
	delete from GxQscripts where name = 'AppRMGetRecordInfoForBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppRMGetRecordInfoForBackup')
	delete from GXDBVersions where aliasname = 'AppRMGetRecordInfoForBackup'
GO
print '... Creating Procedure: AppRMGetRecordInfoForBackup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppRMGetRecordInfoForBackup
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			BIGINT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @oneDayInSecs		BIGINT = 24*60*60
	DECLARE @subclientId		INT = 0
	DECLARE @scope				INT = 0
	DECLARE @jobID				INT = 0
	DECLARE @userId INT = 0
	DECLARE @webServerURL NVARCHAR(MAX) = ''
	-- Read the XML
	SELECT
		@subclientId = ISNULL(ref.value('(//subclient/@subclientId)[1]', 'INT'), 0),
		@scope = ISNULL(ref.value('(@scope)[1]', 'INT'), 2), --Properties
		@jobID = ISNULL(ref.value('(@jobId)[1]', 'INT'), 0)
	FROM
	@i_xmlString.nodes('/Api_GetRecordInfoForBackupRequest') doc(ref)
	-- Get the user id for records manager
	SELECT @userId = CAST(SP.attrVal as INT)
	FROM APP_Application APP
	INNER JOIN APP_SubClientProp SP ON APP.id = SP.componentNameId AND SP.modified = 0 AND SP.attrName = 'Edge Drive User Id'
	WHERE APP.id = @subclientId
	IF @scope = 1
	BEGIN
		DECLARE @assocSCId INT = 0
		SELECT @assocSCId = attrVal FROM APP_SubClientProp WITH(NOLOCK) WHERE componentNameId = @subclientId AND modified = 0 AND attrName = N'Associated subclient Policy'  AND cs_attrName = checksum(N'Associated subclient Policy')
		SELECT TOP 1 @webServerURL = attrVal
		FROM APP_SubClientProp WITH(NOLOCK)
		WHERE componentNameId = @assocSCId
		AND attrName = 'Edge Web Server URL' AND cs_attrName = checksum(N'Edge Web Server URL')
		AND modified = 0
		SET @webServerURL = @webServerURL + 'CVWebService.svc/'
		SET @o_xmlString = (
								SELECT @webServerURL AS '@webServerURL',
								(
									SELECT	CASE
												WHEN F.folderPath LIKE '%\' THEN F.folderPath
												ELSE F.folderPath + '\'
											END AS '@uncPath',
											F.folderGUID AS '@objectStoreGUID',
											R.retention  AS '@retentionInDays'
									FROM App_RMRecord R
									INNER JOIN App_RMFolder F ON R.recordId = F.recordId
									WHERE R.ownerId = @userId
									FOR XML PATH('folders'), TYPE
								)
								FOR XML PATH('Api_GetRecordInfoForBackupResponse'), TYPE
						   )
	END
	ELSE
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#customProps') IS NOT NULL
			DROP TABLE #customProps
		IF OBJECT_ID('tempdb.dbo.#oldProps') IS NOT NULL
			DROP TABLE #oldProps
		CREATE TABLE #customProps(recordId INT, name NVARCHAR(MAX), value NVARCHAR(MAX))
		CREATE TABLE #oldProps(recordId INT, name NVARCHAR(MAX), value NVARCHAR(MAX))
		INSERT INTO #customProps
		--SELECT R.recordId, 'EXPIRY_DATE', CAST(@nowTime + (retention * @oneDayInSecs) AS NVARCHAR(MAX))
		--FROM App_RMRecord R
		--WHERE ownerId = @userId
		--UNION
		SELECT R.recordId, CP.indexingFieldName, ISNULL(RP.propertyValue, CP.defaultValue)
		FROM App_RMRecord R
		INNER JOIN App_RMRecordProperty RP ON R.recordId = RP.recordId
		INNER JOIN App_CustomProperty CP ON CP.propertyId = RP.propertyId
		WHERE R.ownerId = @userId
		INSERT INTO #oldProps
		SELECT 0, 'JOBID', CAST(@jobID AS NVARCHAR(MAX))
		UNION
		SELECT R.recordId, 'PARENT_GUID', RF.folderGUID
		FROM App_RMRecord R
		INNER JOIN App_RMFolder RF ON R.recordId = RF.recordId
		WHERE ownerId = @userId
		SET @o_xmlString = (
								SELECT
								(
									(SELECT 1 AS '@passDownFlag',
											4 AS '@datatype',
										(
											SELECT
											(
												SELECT name AS '@name',
													   value AS '@value'
												FROM #customProps CP
												WHERE CP.recordId = R.recordId
												FOR XML PATH('nameValues'), TYPE
											)
											FOR XML PATH('customProperties'), TYPE
										),
										(
											SELECT
											(
												SELECT name AS '@name', value AS '@value'
												FROM #oldProps OP
												WHERE OP.recordId = R.recordId OR OP.recordId = 0
												FOR XML PATH('nameValues'), TYPE
											)
											FOR XML PATH('oldProperties'), TYPE
										)
									 FROM App_RMRecord R
									 WHERE ownerId = @userId
									 FOR XML PATH('indexItems'), TYPE
									)
								)
								FOR XML PATH('App_CVCentralIndexItemResp'), TYPE
						)
			IF @o_xmlString IS NULL
			BEGIN
				SET @errorCode = 1
				SET @errorString = 'No data found.'
				SET @o_xmlString = (SELECT
											(SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
											 FOR XML PATH('error'), TYPE)
									FOR XML PATH('App_CVCentralIndexItemResp'), TYPE)
			END
	END
ERROR_EXIT:
	IF @o_xmlString IS NULL
	BEGIN
		SET @o_xmlString = (SELECT
								    (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
									 FOR XML PATH('error'), TYPE)
							FOR XML PATH('Api_GetRecordInfoForBackupResponse'), TYPE)
	END
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppRMGetRecordInfoForBackup')
	delete from GxQscripts where name = 'AppRMGetRecordInfoForBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppRMGetRecordInfoForBackup')
	delete from GXDBVersions where aliasname = 'AppRMGetRecordInfoForBackup'
GO

insert into GXDBVersions values(2, 'AppRMGetRecordInfoForBackup',  '00010001000200060000', 'AppRMGetRecordInfoForBackup', '00010001000200060000')
GO

