

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppRMGetRecord.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppRMGetRecord.sp,v $ $Id: AppRMGetRecord.sp,v 1.1.2.4 2018/03/27 08:09:24 jiechen Exp $";
--	+===================================================================+
--	|  					  AppRMGetRecord								|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppRMGetRecord <<<'

IF EXISTS (select * from sysobjects where name='AppRMGetRecord')
	drop procedure AppRMGetRecord
IF EXISTS (select * from GxQscripts where name='AppRMGetRecord')
	delete from GxQscripts where name = 'AppRMGetRecord'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppRMGetRecord')
	delete from GXDBVersions where aliasname = 'AppRMGetRecord'
GO
print '... Creating Procedure: AppRMGetRecord'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppRMGetRecord
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML,
  @i_userId INT,
  @i_localeId INT
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @recordId			INT = 0
	DECLARE @recordName			NVARCHAR(MAX) = ''
	DECLARE @propertyLevel		INT = 0
	-- Read the XML
	SELECT
		@recordId = ISNULL(ref.value('(//record/@recordId)[1]', 'INT'), 0),
		@recordName = ISNULL(ref.value('(//record/@recordName)[1]', 'NVARCHAR(MAX)'), ''),
		@propertyLevel = ISNULL(ref.value('(@propertyLevel)[1]', 'INT'), 30) --AllProperties
	FROM
	@i_xmlString.nodes('/App_GetRecordRequest') doc(ref)
	IF @recordId > 0
	BEGIN
		IF NOT EXISTS(SELECT 1 FROM App_RMRecord WITH (NOLOCK) WHERE recordId = @recordId)
		BEGIN
SET @errorCode = (1287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) --TODO
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @errorCode, 0, 2)
			GOTO ERROR_EXIT
		END
	END
	ELSE IF @recordName <> ''
	BEGIN
		SET @recordId = ISNULL((SELECT recordId FROM App_RMRecord WITH (NOLOCK) WHERE recordName = @recordName), 0)
		IF @recordId = 0
		BEGIN
SET @errorCode = (1287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) --TODO
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @errorCode, 0, 2)
			GOTO ERROR_EXIT
		END
	END
	-- Do we need any security check?
	SET @o_xmlString = (
							SELECT
								(
								SELECT  R.description AS '@description',
									(
										SELECT R.recordId AS '@recordId',
											   R.recordName AS '@recordName'
										FOR XML PATH('record'), TYPE
									),
									(
										SELECT RF.folderId AS '@folderId' ,
											   RF.folderPath AS '@folderPath',
											   RF.displayName AS '@displayName',
											   RF.folderGUID AS '@folderGUID'
										FROM App_RMFolder RF
										WHERE Rf.recordId = R.recordId
										FOR XML PATH('folders'), TYPE
									),
									(
										SELECT RP.propertyId AS '@propertyId',
											   CP.propertyName AS '@propertyName',
											   RP.propertyValue AS '@propertyValue',
											   CP.defaultValue AS '@defaultValue',
											   CP.description AS '@description',
											   CP.dataType AS '@dataType'
										FROM App_RMRecordProperty RP
										INNER JOIN App_CustomProperty CP ON RP.propertyId = CP.propertyId
										WHERE RP.recordId = R.recordId
										FOR XML PATH('properties'), TYPE
									),
									(
										SELECT R.retention AS '@retention'
										FOR XML PATH('retention'), TYPE
									),
									CAST(R.configOptions AS XML)
								FROM App_RMRecord R
								WHERE R.ownerId = @i_userId
								AND (@recordId = 0 OR R.recordId = @recordId)
								FOR XML PATH('records'), TYPE
								)
							FOR XML PATH('App_RecordsResponse'), TYPE
					   )
ERROR_EXIT:
	IF @o_xmlString IS NULL
	BEGIN
		SET @o_xmlString = (SELECT
								    (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
									 FOR XML PATH('error'), TYPE),
									(SELECT @recordId AS '@recordId', @recordName AS '@recordName'
									 FOR XML PATH('records'),TYPE)
							FOR XML PATH('App_RecordsResponse'), TYPE)
	END
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppRMGetRecord')
	delete from GxQscripts where name = 'AppRMGetRecord'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppRMGetRecord')
	delete from GXDBVersions where aliasname = 'AppRMGetRecord'
GO

insert into GXDBVersions values(2, 'AppRMGetRecord',  '00010001000200040000', 'AppRMGetRecord', '00010001000200040000')
GO

