

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppRMDeleteRecord.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppRMDeleteRecord.sp,v $ $Id: AppRMDeleteRecord.sp,v 1.1.2.3 2018/03/27 08:12:13 jiechen Exp $";
--	+===================================================================+
--	|  					  AppRMDeleteRecord 							|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppRMDeleteRecord <<<'

IF EXISTS (select * from sysobjects where name='AppRMDeleteRecord')
	drop procedure AppRMDeleteRecord
IF EXISTS (select * from GxQscripts where name='AppRMDeleteRecord')
	delete from GxQscripts where name = 'AppRMDeleteRecord'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppRMDeleteRecord')
	delete from GXDBVersions where aliasname = 'AppRMDeleteRecord'
GO
print '... Creating Procedure: AppRMDeleteRecord'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppRMDeleteRecord
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML,
  @i_userId INT,
  @i_localeId INT
-----------------------------------------------------------
AS
  DECLARE @o_xmlString XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @recordId			INT = 0
	DECLARE @ownerId			INT = 0
	DECLARE @deleteRecordTranStarted INT = 0
	BEGIN TRY
		-- Read the XML
		SELECT
			@recordId = ISNULL(ref.value('(//record/@recordId)[1]', 'INT'), 0)
		FROM
		@i_xmlString.nodes('/App_RecordInfo') doc(ref)
		SET @ownerId = ISNULL( (SELECT ownerId FROM App_RMRecord WITH(READUNCOMMITTED) WHERE recordId = @recordId), 0)
		If @ownerId = 0
		BEGIN
			SET @errorCode = 2
			SET @errorString = 'Error : Record does not exist.'
			GOTO ERROR_EXIT
		END
		ELSE IF @ownerId <> @i_userId
		BEGIN
			SET @errorCode = 3
			SET @errorString = 'Error : Unable to delete as user is not the owner.'
			GOTO ERROR_EXIT
		END
		-- Do we need any other security check?
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION DeleteRecordTran
			SET @deleteRecordTranStarted = 1
		END
		-- Do delete
		DELETE FROM App_RMRecord
		WHERE recordId =  @recordId
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
	END CATCH
ERROR:
	IF @errorCode <> 0
	BEGIN
		IF XACT_STATE() <> 0 AND @deleteRecordTranStarted = 1
		BEGIN
			ROLLBACK TRANSACTION DeleteRecordTran
		END
		IF @errorString = ''
		BEGIN
SET @errorCode = (1287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) --TODO
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @errorCode, 0, 2)
		END
	END
	ELSE IF @deleteRecordTranStarted = 1
		COMMIT TRANSACTION DeleteRecordTran
ERROR_EXIT:
		SET @o_xmlString = (SELECT
								    (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
									 FOR XML PATH('error'), TYPE),
									(SELECT @recordId AS 'record/@recordId'
									 FOR XML PATH('records'),TYPE)
							FOR XML PATH('App_RecordsResponse'), TYPE)
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppRMDeleteRecord')
	delete from GxQscripts where name = 'AppRMDeleteRecord'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppRMDeleteRecord')
	delete from GXDBVersions where aliasname = 'AppRMDeleteRecord'
GO

insert into GXDBVersions values(2, 'AppRMDeleteRecord',  '00010001000200030000', 'AppRMDeleteRecord', '00010001000200030000')
GO

