

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPruneUnusedData.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPruneUnusedData.sp,v $ $Id: AppPruneUnusedData.sp,v 1.39.40.28.8.1 2021/02/17 02:47:11 dgupta Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppPruneUnusedData   - Prune ununsed data from the app manager tables
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppPruneUnusedData')
BEGIN
	print '>>> Drop Stored Procedure: AppPruneUnusedData <<<'
	drop procedure AppPruneUnusedData
END
IF EXISTS (select * from GxQscripts where name='AppPruneUnusedData')
	delete from GxQscripts where name = 'AppPruneUnusedData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPruneUnusedData')
	delete from GXDBVersions where aliasname = 'AppPruneUnusedData'
GO
print '... Creating Procedure: AppPruneUnusedData'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppPruneUnusedData
AS
BEGIN
	SET NOCOUNT ON
	DECLARE @errorCode		INT = 0
	DECLARE @errorString	NVARCHAR(1024)
	DECLARE @now			INT = dbo.GetUnixTime(GETUTCDATE())
	-- To avoid race condition and outstanding commit we will avoid last one hour data for one touch pruning.
	DECLARE @captureTime INT = @now - 3600 -- seconds in one hour
	------------------------------------------------------------------------------------
	--  GATHERED ENOUGH INFORMATION, TIME TO START INSERTING SOME DATA TO THE TABLES! --
	------------------------------------------------------------------------------------
	IF object_id('tempdb.dbo.#archFileTempTbl') IS NOT NULL
		DROP TABLE #archFileTempTbl
	CREATE TABLE #archFileTempTbl (
		appId INT PRIMARY KEY,
		minTime INT
	)
	IF object_id('tempdb.dbo.#subclientPropIds') IS NOT NULL
		DROP TABLE #subclientPropIds
	CREATE TABLE #subclientPropIds (
		id  INT PRIMARY KEY
	)
	INSERT INTO #archFileTempTbl
	SELECT appId,
		MIN(cTime)
	FROM archFile WITH (READUNCOMMITTED)
	GROUP BY appId
   INSERT INTO #subclientPropIds
	SELECT SCP.id
	FROM APP_subclientprop SCP WITH (NOLOCK)
	INNER JOIN #archFileTempTbl ARC on SCP.componentNameId = ARC.appId
	WHERE SCP.modified <> 0
		AND SCP.modified < ARC.minTime
		AND SCP.attrType <> 111 	-- Do not prune exchange mailbox association entries  TR 180106-2
	--Check Error
	SET @errorCode = @@error
	IF (@errorCode <> 0)
		GOTO ERROR_EXIT
	--Error Check
	DELETE
	FROM APP_scfilterfile
	FROM #archFileTempTbl AS ARC
	WHERE APP_scfilterfile.componentNameId = ARC.appId
		AND (APP_scfilterfile.modified <> 0)
		AND APP_scfilterfile.modified < ARC.minTime
	--Check Error
	SET @errorCode = @@error
	IF (@errorCode <> 0)
		GOTO ERROR_EXIT
	DELETE ep
	FROM APP_ExtendedProperties ep
	WHERE ep.modified <> 0
		AND ep.modified < (
			SELECT MIN(af.minTime)
			FROM #archFileTempTbl af
				LEFT OUTER JOIN APP_application a WITH(NOLOCK) ON
					af.appId = a.id
					AND a.clientId = ep.clientId
			WHERE
				a.id IS NOT NULL
			)
	--Check Error
	SET @errorCode = @@error
	IF (@errorCode <> 0)
		GOTO ERROR_EXIT
	--------MDM Pruning
	DECLARE @PruneTime INT = 90
	SELECT @PruneTime = CAST(value AS INT)
	FROM GXGlobalParam WITH(NOLOCK)
	WHERE NAME = 'MDMUnusedDataPruneDays'
	SET @PruneTime = (@now - (@PruneTime * 24 * 60 * 60))
	DELETE
	FROM app_clientprop
	WHERE componentnameid IN (
			SELECT id
			FROM app_client WITH(NOLOCK)
			WHERE STATUS & 0x80000000 = 0x80000000
			)
		AND modified <> 0
		AND modified < @PruneTime
	--Check Error
	SET @errorCode = @@error
	IF (@errorCode <> 0)
		GOTO ERROR_EXIT
	--==== One Touch Pruning: START
	-- PERFORMANCE: SQL Query to replace previous cursor
	IF object_id('tempdb.dbo.#OneTouchApps') IS NOT NULL
		DROP TABLE #OneTouchApps
	CREATE TABLE #OneTouchApps (
		appId			INT,
		clientId		INT,
		backupSetId		INT,
		subclientId		INT,
		PRIMARY KEY (appId, clientId, backupSetId, subClientId)
	)
	INSERT INTO #OneTouchApps  (appId, clientId, backupSetId, subClientId)
		SELECT --DISTINCT
			a.id appId,
			l.clientId,
			l.backupSet backupSetId,
			l.subclientId
		FROM APP_Application a WITH (NOLOCK)
			INNER JOIN (
				SELECT DISTINCT
					clientId,
					backupset,
					subclientId
				FROM APP_ExtendedProperties WITH (NOLOCK)
				WHERE attrType = 127
				AND created < @captureTime
				--ORDER BY clientId, backupset, subclientId
			) l  ON
				a.clientId = l.clientId
				AND (
					l.backupSet = 0
					OR a.backupSet = l.backupSet
				)
				AND (	--For 9.0 clients backupsetid = 0, from 10.0 backupsetid <> 0
					l.subclientId = 0
					OR a.id = l.subclientId
				)
	SET @errorCode = @@error
	IF (@errorCode <> 0)
		GOTO ERROR_EXIT
	IF object_id('tempdb.dbo.#OneTouchWorkList') IS NOT NULL
		DROP TABLE #OneTouchWorkList
	CREATE TABLE #OneTouchWorkList (
        clientId        INT,
        backupSetId     INT,
        subclientId     INT,
		jobId			INT,
        created  		INT
    )
	CREATE CLUSTERED INDEX OneTouchWorkList_idx ON #OneTouchWorkList (clientId, backupSetId, subclientId, jobId)
	INSERT INTO #OneTouchWorkList
		SELECT DISTINCT
            a.clientId,
            a.backupSetId,
            a.subclientId,
			J.jobId,
			cb.created
		FROM #OneTouchApps a
            OUTER APPLY (
                SELECT -- Get all job since we don't have order in pruning logic
                    bs.jobId jobId,
					bs.servEndDate endTime
                FROM JMBkpStats bs WITH (NOLOCK)
                WHERE
                    bs.appId = a.appId
                    --Check whether it is a non-aged 1-touch backup job
                    AND (
                        bs.opType = 43
                        OR (bs.bkpattributes & 1048576) <> 0
                    )
                    AND bs.dataStatus = 0
            ) j
			OUTER APPLY (
                SELECT TOP 1
                    ep.created created
                FROM APP_ExtendedProperties ep WITH (NOLOCK)
                WHERE
                    j.endTime IS NOT NULL
                    AND ep.attrType = 127
                    AND ep.clientId = a.clientId
                    AND ep.backupset = a.backupSetId
                    AND ep.subclientId = a.subclientId
                    AND ep.created <= j.endTime
                    AND ep.modified = 0
                ORDER BY ep.created DESC
            ) cb    -- if job present then get the latest response time before the job completed.
	--Check Error
	SET @errorCode = @@error
	IF (@errorCode <> 0)
		GOTO ERROR_EXIT
			--Error Check
	-- We will prune all entries which are neither the latest nor associated with any jobs
		DECLARE @rcnt INT = 1
		WHILE (@rcnt > 0)
		BEGIN
			DELETE TOP (2000) EP FROM APP_ExtendedProperties EP WITH (NOLOCK)
				LEFT OUTER JOIN #OneTouchWorkList OT
					ON EP.clientId = OT.clientId
					AND EP.backupSet = OT.backupSetId
					AND EP.subclientId = OT.subclientId
					AND EP.created = OT.created
				WHERE EP.attrType = 127
					AND OT.clientId IS NULL
					AND EP.created < @captureTime
				SET @rcnt = @@ROWCOUNT
		END
		-- Delete Service pack info and Service pack info time attributes based on backup cycles retained.
		IF object_id('tempdb.dbo.#SPInfoListToRemove') IS NOT NULL
			DROP TABLE #SPInfoListToRemove
		CREATE TABLE #SPInfoListToRemove (
			clientId        INT,
			appTypeId		INT,
			attrName		NVARCHAR(128),
			modified		INT
		)
		CREATE NONCLUSTERED INDEX SPInfoListToRemove_idx ON #SPInfoListToRemove (clientId, appTypeId, attrName, modified)
		INSERT INTO #SPInfoListToRemove
		SELECT DISTINCT App_Extendedproperties.clientId, App_Extendedproperties.appTypeId, App_Extendedproperties.attrName, App_Extendedproperties.modified
		FROM App_Extendedproperties (NOLOCK)
		LEFT JOIN
		(
			   SELECT App_Extendedproperties.clientId, App_Extendedproperties.appTypeId, JMBKpstats.fullCycleNum, MIN(JMBKpstats.servStartDate) cycleStart, MAX(JMBKpstats.servEndDate) cycleEnd FROM app_extendedproperties
			   INNER JOIN App_application ON app_extendedproperties.clientId = APP_Application.clientId
			   AND APP_ExtendedProperties.appTypeId = APP_Application.appTypeId
			   AND APP_ExtendedProperties.attrName IN ('Service Pack Info', 'Service Pack Info Time')
			   INNER JOIN JMBkpStats ON  JMBkpStats.appId = App_application.Id and JMBkpStats.status in (1,3,14) --_JMSUCCESS,_PARTIALSUCCESS,_JMSUCCESSWITHWARNINGS
			   GROUP BY app_extendedproperties.clientId, app_extendedproperties.appTypeId, App_Extendedproperties.instance, JMBKpstats.fullCycleNum
		) SPInfo
		ON SPInfo.clientid = app_extendedproperties.clientId
		AND SPInfo.appTypeId = app_extendedproperties.appTypeId
		AND (
							 --cyclestart <= app_extendedproperties.created and cycleend >= app_extendedproperties.created
							 ( cyclestart >= app_extendedproperties.created and (cyclestart<=app_extendedproperties.modified OR app_extendedproperties.modified=0)  ) OR
							 ( cycleend >= app_extendedproperties.created and (cycleend<=app_extendedproperties.modified OR app_extendedproperties.modified=0)  )
			   )
		WHERE attrName IN ('Service Pack Info', 'Service Pack Info Time')
		and SPInfo.clientId is null
		OPTION (MAXDOP 2)
		SET @rcnt = 1
		WHILE (@rcnt > 0)
		BEGIN
			DELETE TOP (5000) EP FROM APP_ExtendedProperties EP WITH (NOLOCK)
			INNER JOIN #SPInfoListToRemove SPInfoListToRemove ON
			EP.clientID = SPInfoListToRemove.clientID AND
			EP.appTypeId = SPInfoListToRemove.appTypeId AND
			EP.attrName = SPInfoListToRemove.attrName AND
			EP.modified = SPInfoListToRemove.modified
			SET @rcnt = @@ROWCOUNT
		END
	--Check Error
	SET @errorCode = @@error
	IF (@errorCode <> 0)
		GOTO ERROR_EXIT
	DELETE app_ComponentProp
	WHERE componentType = 7
		AND componentID NOT IN (
			SELECT id
			FROM app_subClientProp WITH(NOLOCK)
			WHERE attrType = 111
			)
	--Check Error
	SET @errorCode = @@error
	IF (@errorCode <> 0)
		GOTO ERROR_EXIT
	-- Remove all sync config history except the most recent one before backup.
	;WITH CTE AS
	(
		SELECT ROW_NUMBER() OVER (ORDER BY CP.created DESC) AS RN
		FROM APP_ComponentProp CP
WHERE componentType = 19 -- CV_COMPONENT_SYNC_CONFIG_HISTORY
		AND created < (SELECT TOP 1 servStartDate FROM JMBkpStats JM
						 WHERE CP.componentId = JM.appId AND CP.propertyTypeId = JM.targetClientId AND JM.opType = 4 -- Backup
						 AND JM.status IN (1, 3, 14) AND JM.displayStatus <> 16 -- Success, CWE and CWW and not committed
						 ORDER BY servEndDate DESC)
	)
	DELETE FROM CTE
	WHERE RN > 1
	--Check Error
	SET @errorCode = @@error
	IF (@errorCode <> 0)
		GOTO ERROR_EXIT
	--LM Pruning
	DECLARE @retain INT
	SELECT @retain = value
	FROM GXGlobalParam
	WHERE NAME = 'SRMPruningRetentionDaysLM'
	DELETE
	FROM APP_MonitoringPolicy
	WHERE STATUS = 3
		AND DATEADD(day, @retain, DATEADD(s, modified, '01/01/1970 00:00:00')) <= GETDATE()
	--pruning the older data(60 days) in app_montirotingPolicyProp table for attrName = 'size' -- thers rows indicate the size of indexed data based on the monitoringPolicy for each day.
	DECLARE @noOfDays INT
	DECLARE @epochDate BIGINT
	SET @noOfDays = ISNULL((
				SELECT value
				FROM GXGlobalParam WITH(NOLOCK)
				WHERE NAME = 'LMMonitoringPropPruneLevel'
				), 60)
	SET @epochDate = dbo.GETUNIXTIME(DATEADD(d, - @noOfDays, GETUTCDATE()))
	DELETE
	FROM APP_MonitoringPolicyProp
	WHERE attrName LIKE 'size\_%' ESCAPE ('\')
		AND CONVERT(INTEGER, STUFF(attrName, 1, 5, '')) < @epochDate
	--Active Alert Pruning
	DECLARE @pruningDays INTEGER = ISNULL((
				SELECT value
				FROM GXGlobalParam WITH(NOLOCK)
				WHERE NAME = 'NTActiveAlertRetentionDays'
				), 1)
	DECLARE @pruningDaysUnread INTEGER = ISNULL((
				SELECT value
				FROM GXGlobalParam WITH(NOLOCK)
				WHERE NAME = 'NTUnReadActiveAlertRetentionDays'
				), 7)
	DECLARE @pruningDaysImportant INTEGER = ISNULL((
				SELECT value
				FROM GXGlobalParam WITH(NOLOCK)
				WHERE NAME = 'NTImportantActiveAlertRetentionDays'
				), 30)
	DECLARE @pruningSec BIGINT
	DECLARE @pruningSecUnRead BIGINT
	DECLARE @pruningSecImportant BIGINT
	SET @pruningSec = @pruningDays * 3600 * 24
	SET @pruningSecUnRead = @pruningDaysUnread * 3600 * 24
	SET @pruningSecImportant = @pruningDaysImportant * 3600 * 24
	DECLARE @pruneFromTime INTEGER
	DECLARE @presentTime INTEGER = dbo.GetUnixTime(GETUTCDATE())
	SET @pruneFromTime = @presentTime - @pruningSec
	-- Purne the status table first, purnce the user who has not marked an console alert important or unread
	DELETE NTS
	FROM NTLiveFeedsMessageHistory NTMH
	INNER JOIN NTLiveFeedsStatus NTS ON NTMH.LiveFeedId = NTS.liveFeedsId
		AND (
			(NTS.livefeedstatus & 2) = 0
			AND (NTS.livefeedstatus & 8) = 0
			)
	WHERE NTMH.created < @pruneFromTime
	--Force prune the console alert that are not read for more than 7 days
	DELETE NTS
	FROM NTLiveFeedsMessageHistory NTMH
	INNER JOIN NTLiveFeedsStatus NTS ON NTMH.LiveFeedId = NTS.liveFeedsId
		AND (NTS.livefeedstatus & 8) <> 0
	WHERE (@presentTime - NTMH.created) > @pruningSecUnRead
	DELETE NTS
	FROM NTLiveFeedsMessageHistory NTMH
	INNER JOIN NTLiveFeedsStatus NTS ON NTMH.LiveFeedId = NTS.liveFeedsId
		AND (NTS.livefeedstatus & 2) <> 0
	WHERE (@presentTime - NTMH.created) > @pruningSecImportant
	-- Prune the LiveFeeds table, if an alert has no status for it, then remove it from the table
	DELETE
	FROM NTLiveFeedsMessageHistory
	WHERE created < @pruneFromTime
		AND livefeedid NOT IN (
			SELECT liveFeedsId
			FROM NTLiveFeedsStatus WITH(NOLOCK)
			)
	--Prune Indexed alerts from NTNotificationsForCI
	SET @pruningDays = ISNULL((
				SELECT value
				FROM GXGlobalParam WITH(NOLOCK)
				WHERE NAME = 'NTCIAlertRetentionDays'
				), 2)
	SET @pruningSec = @pruningDays * 3600 * 24
	SET @pruneFromTime = @presentTime - @pruningSec
	DECLARE @lastIndexAlert INTEGER = 0
	DECLARE @AlertTemplateId INTEGER = (
			SELECT templateId
			FROM APP_Template WITH(NOLOCK)
			WHERE templateName = 'Alert'
				AND templateForMonitoringType = 5
			)
	SET @lastIndexAlert = (
			SELECT MIN(attrVal)
			FROM APP_MonitoringPolicyProp
			WHERE attrName = 'last DataSet Index'
				AND monitorPolicyId IN (
					SELECT mp.monitorPolicyId
					FROM APP_MonitorTemplateAssoc mptemp WITH(NOLOCK)
					INNER JOIN APP_MonitoringPolicy mp WITH(NOLOCK) ON mptemp.monitorPolicyId = mp.monitorPolicyId
						AND mp.STATUS <> 3
					WHERE templateId = @AlertTemplateId
					)
			)
	DELETE
	FROM NTNotificationsForCI
	WHERE AlertId < @lastIndexAlert
		AND Created < @pruneFromTime
	DELETE
	FROM NTNotificationsForCI
	WHERE Created < (@pruneFromTime - ((@pruningDays + 3) * 3600 * 24))
	--Check Error
	SET @errorCode = @@error
	IF (@errorCode <> 0)
		GOTO ERROR_EXIT
	--RDS pruning
	DECLARE @retentionDays INT = 30 --days
	DECLARE @retentionSec INT = @retentionDays * 3600 * 24
	DELETE SCM
	FROM App_RDSSubclientContentMap SCM
		LEFT OUTER JOIN ArchFileCopyRegion AFCR WITH (READUNCOMMITTED) ON
			AFCR.DBContentId > 0
			AND AFCR.DBContentId = SCM.id
	WHERE SCM.modified != 0
		AND (@presentTime - SCM.modified) > @retentionSec --	Prune only older than 30 days
		AND AFCR.ArchFileId IS NULL
	--Check Error
	SET @errorCode = @@error
	IF (@errorCode <> 0)
		GOTO ERROR_EXIT
	--Prune deleted sessions from App_ShortURL
	--if flag is 2 - SessionGUID, then remove entry if is not found on umqsdksessions , as long longurl has session guid in this case
	DELETE url
	FROM App_ShortUrl url
	LEFT JOIN UMQSDKSessions  qsdksession WITH (NOLOCK)
	ON cast(qsdksession.guid AS nvarchar(36)) = url.longUrl
	WHERE (url.flag & 2) = 2 AND qsdksession.GUID IS NULL
	DECLARE @timeToPruneShortenedSAMLToken INT  = dbo.GetUnixTime(DATEADD(d, -ISNULL((SELECT TOP 1 CAST(value as INT) from GxGlobalParam (Nolock) where name = 'nDaysToKeepShortSamlToken'),7),GetUTCDate()))
	DELETE FROM App_ShortUrl WHERE flag & 4 = 4 AND lastAccessed < @timeToPruneShortenedSAMLToken
	--Check Error
	SET @errorCode = @@error
	IF (@errorCode <> 0)
		GOTO ERROR_EXIT
	-- Prune Last data protected time if all successful jobs are deleted for the subclient
   INSERT INTO #subclientPropIds
	SELECT SP.id
	FROM APP_SubClientProp SP WITH (NOLOCK)
	LEFT OUTER JOIN JMBkpStats JM ON JM.appId = SP.componentNameId AND JM.status IN (1, 3, 14)
	WHERE SP.attrName = 'Last Data Protected Time' AND SP.cs_attrName = CHECKSUM(N'Last Data Protected Time') ANd modified = 0
	AND JM.jobid IS NULL
	-- delete subclientProps
	DELETE SP
	FROM APP_SubClientProp SP
	INNER JOIN #subclientPropIds IDS ON SP.id = IDS.id
	-- Prune old data from app_componentprop
	-- Delete the old properties which were created more than 24 hours ago
	DELETE FROM App_ComponentProp
WHERE componentType = 1 AND componentId = 2
AND propertyTypeId  IN (3322,3320,3321)
	AND created < @now - (24*3600)
	-- Delete the old index afile recall info (Indexing_IdxAfileInfoToRecall)from cold storage data after 7 days
	DECLARE @idxAfileRecallAgeTime INT = (@now - (7*24*3600))
	DELETE FROM App_ComponentProp
WHERE componentType = 22 AND propertyTypeId = 3801
	AND created < @idxAfileRecallAgeTime
	--Prune security associations
	EXEC sec_pruneSecurityAssociations @errorCode OUTPUT, @errorString OUTPUT
	-- Prune Diagnostic Tracking for ExecuteSP Monitoring that is older than 7 days
	DECLARE @diagDelTime	INT = @now - (7*24*3600)
	DECLARE @diagBatchRC	INT = 1
	WHILE (@diagBatchRC > 0)
	BEGIN
		-- Batch deleting to keep implicit transaction short and avoid TempDb Growth
		DELETE TOP (1000) et
		FROM DIAG_ExecuteSPTracking et
		WHERE startTime <= @diagDelTime
		SET @diagBatchRC = @@ROWCOUNT
	END
	-- Reset Application Size from SubclientProp and BackupsetProp for manually deleted subclients or aged subclients
	IF OBJECT_ID('tempdb.dbo.#validSubClients') IS NOT NULL DROP TABLE #validSubClients
	CREATE TABLE #validSubClients (subclientId INT PRIMARY KEY,backupset INT)
	CREATE NONCLUSTERED INDEX validSubClients_backupSet_subclientStatus_idx ON #validSubClients(backupset)
	INSERT INTO #validSubClients
	SELECT AAP.id,AAP.backupSet
	FROM   JMBkpStats JB  WITH(NOLOCK)
		   INNER JOIN APP_Application AAP WITH(NOLOCK) ON JB.appId=AAP.id AND JB.status IN (1,3,14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
		   AND JB.dataStatus = 0 -- DATA_STATUS_VALID
		   AND JB.optype IN (4, 18, 59, 65, 30, 43, 14) -- JMShouldUpdateLastBackupTime and synthetic full
	GROUP BY AAP.id,AAP.backupSet
	DELETE ASP
	FROM APP_SubClientProp ASP
	LEFT OUTER JOIN #validSubClients VS ON VS.subclientId = ASP.componentNameId
	WHERE ASP.attrName=N'Application Size' AND ASP.cs_attrName = CHECKSUM(N'Application Size') AND ASP.modified = 0
	AND VS.subclientId IS NULL
	DELETE ABP
	FROM APP_BackupSetProp ABP
	LEFT OUTER JOIN #validSubClients VS ON VS.backupset = ABP.componentNameId
	WHERE ABP.attrName=N'Application Size' AND ABP.modified = 0
	AND VS.subclientId IS NULL
	--not cleaning up #validSubClients as SQL Cleanup of temp table is much faster
	-- One Time Cleanup for APP_VMProp bloated rows that are being consolidated to the
	-- APP_ClientProp table as one set of row entries per client.
	DECLARE @vmPropGuid    VARCHAR(40) = '2A23B0F9-4757-47F5-B581-0C8F85A13555'
	IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @vmPropGuid)
	BEGIN
		PRINT 'Start: Cleanup for VM Property Rows.'
		DECLARE @vmp_rcnt INT = 1
		DECLARE @vmp_tcnt INT = 0
		WHILE (@vmp_rcnt > 0)
		BEGIN
			DELETE TOP (2000) vp
			FROM APP_VMProp vp
			WHERE vp.attrName IN (
					N'vmDatastore',
					N'vmHardwareVersion',
					N'vmHostVersion',
					N'vmInstanceSize',
					N'vmOperatingSystem',
					N'vmToolsVersion'
				)
			SET @vmp_rcnt = @@ROWCOUNT
			SET @vmp_tcnt += @vmp_rcnt
		END
		PRINT 'Completed: Cleanup for VM Property Rows. Rows Deleted [' + CAST(@vmp_tcnt AS VARCHAR(12)) + ']'
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)
VALUES (@vmPropGuid, 'CleanupVMPropRows', 'Cleanup for VM Property Rows', @now,  16, 0, (16 + 2))
	END
	DECLARE @CGVMAssociation TABLE(CGID INT PRIMARY KEY)
	INSERT INTO @CGVMAssociation
	SELECT DISTINCT componentId FROM App_ComponentProp
WHERE componentType = 8 AND propertyTypeID IN (3314, 3323) AND modified = 0
	DECLARE @CGID INT = 0
	WHILE @CGID IS NOT NULL
	BEGIN
		SET @CGID = (SELECT TOP 1 CGID FROM @CGVMAssociation
		WHERE CGID > @CGID)
		EXEC AppPruneDeletedVirtualMachines @CGID, @errorCode OUTPUT
		IF @errorCode <> 0
		PRINT 'Failed to Prune VM Clients for Client group ' + CAST(@CGID AS NVARCHAR)+ '.'
	END
	-- One Time Cleanup for last backup info rows that are set at client and ida level for VSA which is not required.
	DECLARE @lastBackupInfoCleanupScriptGuid    VARCHAR(40) = '0D31BFB6-EBA5-45A1-B32C-F38248BF1E86'
	IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @lastBackupInfoCleanupScriptGuid)
	BEGIN
		PRINT 'Start: Cleanup for Last backup info rows'
		DECLARE @l_rowCount INT = 1
		DECLARE @l_totalRowCount INT = 0
		WHILE (@l_rowCount > 0)
		BEGIN
			DELETE TOP (2000) CP
			FROM APP_ClientProp CP
			WHERE CP.attrName = 'Last Backup Job Info'
			AND CP.modified = 0 -- Just to make use of index APP_ClientProp_modified_attrName_idx
			SET @l_rowCount = @@ROWCOUNT
			SET @l_totalRowCount += @l_rowCount
			-- Micro second yield for high CPU issue in tight loop
			WAITFOR DELAY '00:00:00.001'
		END
		PRINT 'Completed: Cleanup for Last backup info rows in client prop. Rows Deleted [' + CAST(@l_totalRowCount AS VARCHAR(12)) + ']'
		SET @l_rowCount = 1
		SET @l_totalRowCount = 0
		IF OBJECT_ID('tempdb..#PropIDs') IS NOT NULL DROP TABLE #PropIDs
		CREATE TABLE #PropIDs (propId INT)
		INSERT INTO #propIDs
		SELECT PROP.id
		FROM App_IDAName IDA (NOLOCK)
		INNER JOIN App_IDAProp PROP (NOLOCK) ON IDA.id = PROP.componentNameId AND PROP.attrName = 'Last Backup Job Info' AND PROP.modified = 0
		WHERE IDA.appTypeId  = 106 -- VIRTUAL_SERVER_IDA
		WHILE (@l_rowCount > 0)
		BEGIN
			DELETE TOP (2000) IDA
			FROM App_IDAProp IDA
			INNER JOIN #propIDs PROP ON IDA.id = PROP.propId
			SET @l_rowCount = @@ROWCOUNT
			SET @l_totalRowCount += @l_rowCount
			-- Micro second yield for high CPU issue in tight loop
			WAITFOR DELAY '00:00:00.001'
		END
		PRINT 'Completed: Cleanup for Last backup info rows in IDA prop. Rows Deleted [' + CAST(@l_totalRowCount AS VARCHAR(12)) + ']'
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)
VALUES (@lastBackupInfoCleanupScriptGuid, 'CleanupLastBackupInfoPropRows', 'Cleanup for VSA last backup info rows', @now,  16, 0, (16 + 2))
	END
	-- one time cleanup for subclient prop 'RunSFImmediately' created before SP 16 to prevent bloating issue
	DECLARE @runSFImmediatelyGUID VARCHAR(40) = 'A7597DAE-05D3-4462-978D-2C744505A206'
	IF NOT EXISTS(SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @runSFImmediatelyGUID)
	BEGIN
		PRINT 'Start: Cleanup for subclient prop RunSFImmediately '
		DECLARE @runSFImmediatelyPropName NVARCHAR(128) = N'RunSFImmediately'
		DECLARE @scproc_rowCount INT = 1
		DECLARE @scproc_totalRowCount INT = 0
		WHILE (@scproc_rowCount > 0)
		BEGIN
			DELETE TOP (2000) SCP
			FROM APP_SubClientProp SCP
			WHERE SCP.attrName = @runSFImmediatelyPropName
			AND cs_attrName = CHECKSUM(@runSFImmediatelyPropName)
			-- delete all rows without modified check since the property gets regenerated every 12 hours for eligible subclients
			SET @scproc_rowCount = @@ROWCOUNT
			SET @scproc_totalRowCount += @scproc_rowCount
			-- Micro second yield for high CPU issue in tight loop
			WAITFOR DELAY '00:00:00.001'
		END
		PRINT 'Completed: Cleanup for subclient prop "RunSFImmediately". Rows Deleted [' + CAST(@scproc_totalRowCount AS VARCHAR(12)) + ']'
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)
VALUES (@runSFImmediatelyGUID, 'CleanupRunSFImmediatelyPropRows', 'Cleanup for subclient prop "RunSFImmediately" rows', @now,  16, 0, (16 + 2))
	END
ERROR_EXIT:
	IF object_id('tempdb.dbo.#SPInfoListToRemove') IS NOT NULL
		DROP TABLE #SPInfoListToRemove
	--------------------------------------------
	-- THIS IS THE RESPONSE IF ALL WENT WELL ----
	---------------------------------------------
	SELECT 1 AS TAG,
		NULL AS Parent,
		@errorCode AS [CVGui_GenericResp!1!errorCode],
		@errorString AS [CVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppPruneUnusedData')
	delete from GxQscripts where name = 'AppPruneUnusedData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPruneUnusedData')
	delete from GXDBVersions where aliasname = 'AppPruneUnusedData'
GO

insert into GXDBVersions values(2, 'AppPruneUnusedData',  'v1.39.40.28.8.1', 'AppPruneUnusedData', 'v1.39.40.28.8.1')
GO

