

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPruneJobOptions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPruneJobOptions.sp,v $ $Id: AppPruneJobOptions.sp,v 1.18.36.4 2020/03/13 23:45:07 vmishra Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppPruneJobOptions   - Prune ununsed job options from task manager tables
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPruneJobOptions')
BEGIN
	print '>>> Drop Stored Procedure: AppPruneJobOptions <<<'
	drop procedure AppPruneJobOptions
END
IF EXISTS (select * from GxQscripts where name='AppPruneJobOptions')
	delete from GxQscripts where name = 'AppPruneJobOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPruneJobOptions')
	delete from GXDBVersions where aliasname = 'AppPruneJobOptions'
GO
print '... Creating Procedure: AppPruneJobOptions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPruneJobOptions
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
declare @errorCode				int
declare @errorString				nvarchar(1024)
set @errorCode = 0
------------------------------------------------------------------------------------
--  GATHERED ENOUGH INFORMATION, TIME TO START INSERTING SOME DATA TO THE TABLES! --
------------------------------------------------------------------------------------
BEGIN
	SET NOCOUNT ON
	-- AEB: performance change from table variable to temp table
	IF OBJECT_ID('tempdb.dbo.#jobRequestTable') IS NOT NULL
		DROP TABLE dbo.#jobRequestTable
	CREATE TABLE #jobRequestTable (
		jobRequestId	BIGINT,
		jobId			BIGINT PRIMARY KEY
	);
	IF OBJECT_ID('tempdb.dbo.#jobOpts') IS NOT NULL
		DROP TABLE dbo.#jobOpts
	CREATE TABLE #jobOpts (
		seq				INT PRIMARY KEY IDENTITY(1,1),
		jobOptId		INT
	);
	IF OBJECT_ID('tempdb.dbo.#jobOptsXml') IS NOT NULL
		DROP TABLE dbo.#jobOptsXml
	CREATE TABLE #jobOptsXml (
		seq				INT PRIMARY KEY IDENTITY(1,1),
		jobOptId		INT
	);
	DECLARE @pruneTopN INT = 100000
	SELECT
		@pruneTopN = CAST(value AS INT)
	FROM GXGlobalParam WITH (NOLOCK)
	WHERE name='AppPruneJobOptionTopN'
	DECLARE @currentTime INT = dbo.GetUnixTime(getdate())
	DECLARE @numOfDays INT = ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='NumberOfDaysToKeepJobOptionsFromPruning'), 7)
	DECLARE @keepSearchOptions INT = ISNULL((SELECT CAST(value AS INT) FROM GXGlobalParam WITH (NOLOCK) WHERE name='keepSchedSearchOptionsForJobs'), 0)
	DECLARE @lastWeek INT = @currentTime-(@numOfDays*24*60*60)
	--DECLARE @minOptionId BIGINT = (SELECT MIN(optionId) FROM TM_StaticTaskOption WHERE xpath like '%/%')
	DECLARE @totalRowsDel INT = 0
	-- -------------------------------------------------------------------------------
	-- Determine rows that need to be deleted and store in temp tables
	-- -------------------------------------------------------------------------------
	BEGIN TRY
		--=== GET JOB REQUEST FOR COMPLETED JOBS OLDER THAN A WEEK OR FROM DELETED SCHEDULES WITH NO RUNNING JOBS
		INSERT INTO #jobRequestTable
			SELECT
				TR.jobRequestId,
				TJ.jobId
			FROM
				TM_JobRequest AS TR WITH(READUNCOMMITTED)
				INNER JOIN TM_Jobs AS TJ WITH(READUNCOMMITTED) ON
					TR.created < @lastWeek -- JOB IS OLDER THAN 7 DAYS
					AND TJ.jobRequestId = TR.jobRequestId
			WHERE
				NOT EXISTS (SELECT TOP 1 JM.jobId FROM JMJobInfo JM WITH(READUNCOMMITTED) WHERE JM.jobId = TJ.jobId ) -- JOB IS NOT RUNNING
				AND TJ.status = 2 -- CHECK THAT JOB HAS BEEN SUBMITTED
				AND TJ.jobId <> 0
		--=== TM_JobOptions Rows to delete
		--Capture: DELETE ALL THE OPTIONS THAT ARE NOT USED FOR RE-SUBMIT JOBS
		INSERT INTO #jobOpts
			SELECT
				jo.id
			FROM TM_JobOptions jo WITH(READUNCOMMITTED)
			WHERE jobId in (
				SELECT jobId FROM #jobRequestTable
			)
		--Capture: DELETE ALL THE OPTIONS FROM THE DELETED SCHEDULES WHICH HAVE NO JOBS IN HISTORY
		INSERT INTO #jobOpts
			SELECT
				TJ.id
			FROM TM_JobOptions TJ WITH(READUNCOMMITTED)
			WHERE NOT EXISTS (
					SELECT 1 FROM TM_SubTask WITH(READUNCOMMITTED) WHERE subTaskId=TJ.subTaskId
					)
				AND NOT EXISTS (
					SELECT 1 FROM TM_JobRequest WITH(READUNCOMMITTED) WHERE subTaskId=TJ.subTaskId
					)
				AND TJ.subTaskId > 0
		--=== TM_JobXMLOptions Rows to delete
		INSERT INTO #jobOptsXml
			SELECT
				jo.id
			FROM TM_JobXMLOptions jo WITH(READUNCOMMITTED)
			WHERE jobId in (
				SELECT jobId FROM #jobRequestTable
			)
		INSERT INTO #jobOptsXml
			SELECT
				TJ.id
			FROM TM_JobXMLOptions TJ WITH(READUNCOMMITTED)
			WHERE NOT EXISTS (
					SELECT 1 FROM TM_SubTask WITH(READUNCOMMITTED) WHERE subTaskId=TJ.subTaskId
					)
				AND NOT EXISTS (
					SELECT 1 FROM TM_JobRequest WITH(READUNCOMMITTED) WHERE subTaskId=TJ.subTaskId
					)
				AND TJ.subTaskId > 0
		DECLARE @BeyonLast30Days BIGINT = dbo.getunixtimebig(DATEADD(D, -30, getutcdate()))
		INSERT INTO #jobOptsXml
			SELECT
				TJ.id
			FROM TM_JobXMLOptions TJ WITH(READUNCOMMITTED)
				WHERE jobId = 0 AND modified > 0 AND modified < @BeyonLast30Days
		-- -------------------------------------------------------------------------------
		-- DELETES THE JOB INFO FOR PRUNE JOBS
		-- -------------------------------------------------------------------------------
		--=== Delete TM_JobOptions in blocks of 100000 rows for better performance
		DECLARE @r		INT = 1
		DECLARE @t		INT = 0
		DECLARE @topn	INT = @pruneTopN
		DECLARE @epos	INT = @pruneTopN
		DECLARE @spos	INT = 0
		WHILE @r > 0
		BEGIN
			DELETE TOP (@topn) TM_JobOptions
			WHERE id IN (SELECT jobOptId FROM #jobOpts WHERE seq > @spos AND seq <= @epos)
			SET @r = @@ROWCOUNT
			SET @t = @t + @r
			SET @spos = @epos
			SET @epos = @epos + @topn
		END
		SET @totalRowsDel = @totalRowsDel + @t
		--=== Delete TM_JobXMLOptions in blocks of 100000 rows for better performance
		SET @r = 1
		SET @t = 0
		SET @epos = @pruneTopN
		SET @spos = 0
		WHILE @r > 0
		BEGIN
			DELETE TOP (@topn) TM_JobXMLOptions
			WHERE id IN (SELECT jobOptId FROM #jobOptsXml WHERE seq > @spos AND seq <= @epos)
			SET @r = @@ROWCOUNT
			SET @t = @t + @r
			SET @spos = @epos
			SET @epos = @epos + @topn
		END
		SET @totalRowsDel = @totalRowsDel + @t
		--DELETE JOB REQUESTS WHICH DO NOT HAVE ANY JOBID
		--DELETE TM_JobRequest
		--FROM TM_JobRequest JR
		--	WHERE NOT EXISTS (SELECT 1 FROM TM_Jobs TJ WITH (NOLOCK) WHERE TJ.jobRequestId = JR.jobRequestId)
	IF object_id('tempdb.dbo.#pruneSearchTable') is not null
		DROP TABLE #pruneSearchTable
	CREATE TABLE #pruneSearchTable (searchId INT)
	DECLARE @defaultRestoreTask INT = (SELECT id FROM SchedRestoreTask WITH (NOLOCK) WHERE flags=9999)
	DECLARE @topSearchFile INT = ISNULL((SELECT CAST(value AS INT) FROM GXGlobalParam WITH (NOLOCK) WHERE name='pruneRowsForSchedRestoreSearchFiles'), 1000000)
	INSERT INTO #pruneSearchTable
	SELECT id FROM SchedRestoreSearchTask WHERE restoreTaskId = @defaultRestoreTask AND (created < (@currentTime + 1000))
	DELETE #pruneSearchTable
		WHERE EXISTS (SELECT 1 FROM JMJobInfo WITH (NOLOCK) WHERE jobId=searchId)
		OR EXISTS ( SELECT 1 FROM TM_Jobs WITH (NOLOCK) WHERE jobId=searchId AND @keepSearchOptions = 1)
	IF @topSearchFile > 0
		DELETE TOP (@topSearchFile) SchedRestoreSearchFilesOrder
		WHERE searchId IN (SELECT searchId FROM #pruneSearchTable)
	ELSE
		DELETE SchedRestoreSearchFilesOrder
		WHERE searchId IN (SELECT searchId FROM #pruneSearchTable)
	IF @topSearchFile > 0
		DELETE TOP (@topSearchFile) SchedRestoreSearchFiles
		FROM dbo.SchedRestoreSearchFiles
		JOIN #pruneSearchTable ON #pruneSearchTable.searchId = dbo.SchedRestoreSearchFiles.searchId
	ELSE
		DELETE SchedRestoreSearchFiles
		FROM dbo.SchedRestoreSearchFiles
		JOIN #pruneSearchTable ON #pruneSearchTable.searchId = dbo.SchedRestoreSearchFiles.searchId
	DELETE SchedRestoreSearchTask
	FROM SchedRestoreSearchTask T
	WHERE NOT EXISTS(SELECT 1 FROM SchedRestoreSearchFiles)
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		set @errorCode = @@error
	END CATCH
	IF object_id('tempdb.dbo.#pruneSearchTable') is not null
		DROP TABLE #pruneSearchTable
	--------------------------------------------
	-- THIS IS THE RESPONSE IF ALL WENT WELL ----
	---------------------------------------------
	SELECT	1			         as TAG,
			NULL		         as Parent,
		@errorCode			     as [CVGui_GenericResp!1!errorCode],
		@errorString	         as [CVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT
	SET NOCOUNT OFF
END
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'AppPruneJobOptions')
	delete from GxQscripts where name = 'AppPruneJobOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPruneJobOptions')
	delete from GXDBVersions where aliasname = 'AppPruneJobOptions'
GO

insert into GXDBVersions values(2, 'AppPruneJobOptions',  '00010018003600040000', 'AppPruneJobOptions', '00010018003600040000')
GO

