

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPruneGeoLocations.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2012  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppPruneGeoLocations   - Retain only latest N (say 10) GeoLocation records of the given client and delete the rest
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppPruneGeoLocations <<<'

IF EXISTS (select * from sysobjects where name='AppPruneGeoLocations')
	drop procedure AppPruneGeoLocations
IF EXISTS (select * from GxQscripts where name='AppPruneGeoLocations')
	delete from GxQscripts where name = 'AppPruneGeoLocations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPruneGeoLocations')
	delete from GXDBVersions where aliasname = 'AppPruneGeoLocations'
GO
print '... Creating Procedure: AppPruneGeoLocations'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPruneGeoLocations
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @clientID integer,
  @recordsToRetain integer
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
declare @count				int
declare @errorCode			int
declare @errorString		nvarchar(1024)
set @count					= 0
set @errorCode				= 0
BEGIN
	BEGIN TRY
		DECLARE @geoLocations INT = ISNULL((SELECT CAST(value AS INT) FROM GXGlobalParam WITH(NOLOCK) WHERE name = N'nMaxGeoLocations'), 10)
		IF (@geoLocations > 10)
		BEGIN
			SET @recordsToRetain = @geoLocations
		END
		-- Fix SaaS Deadlock issue with AppActivateLaptop SP
		DECLARE @cgl TABLE (
			cpId	INT,
			created	INT,
			PRIMARY KEY (created ASC, cpId)
		)
		INSERT INTO @cgl (cpId, created)
			SELECT
				cp.id,
				cp.created
			FROM APP_ClientProp cp WITH(READUNCOMMITTED)
			WHERE
				cp.componentNameId = @clientID
				AND cp.attrName = N'Client Geo Location'
				AND cp.modified > 0		-- Do Not count or delete active row.
		SET @count = @@ROWCOUNT		-- how many inactive rows exist
		IF (@count > @recordsToRetain)
		BEGIN
			DELETE cp
			FROM APP_ClientProp cp
			WHERE cp.id IN (
					SELECT TOP (@count - @recordsToRetain) cpId FROM  @cgl		-- sorted by PK created ASC cpId returned
				)
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode = ERROR_NUMBER()
		SET @errorString = ERROR_MESSAGE()
	END CATCH
END
ERROR_EXIT:
SELECT	1			         as TAG,
		NULL		         as Parent,
	@errorCode			     as [CVGui_GenericResp!1!errorCode],
	@errorString	         as [CVGui_GenericResp!1!errorMessage]
FOR XML EXPLICIT
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'AppPruneGeoLocations')
	delete from GxQscripts where name = 'AppPruneGeoLocations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPruneGeoLocations')
	delete from GXDBVersions where aliasname = 'AppPruneGeoLocations'
GO

insert into GXDBVersions values(2, 'AppPruneGeoLocations',  '00000000000000000000', 'AppPruneGeoLocations', '00000000000000000000')
GO

