

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPruneDeletedVirtualMachines.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--  Author: Manoj Kumar Gopinath
--  Date:   08/17/2020
-- ----------------------------------------------------------------------*/
/*
--  +------------------------------------------------------------------------------------------+
--  |           Procedure : "AppPruneDeletedVirtualMachines"
--  |   This Procedure is used to prune the deleted VMs which are not deleted from the Commcell.
--  +------------------------------------------------------------------------------------------+
*/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppPruneDeletedVirtualMachines')
BEGIN
	print '>>> Drop Stored Procedure: AppPruneDeletedVirtualMachines <<<'
	drop procedure AppPruneDeletedVirtualMachines
END
IF EXISTS (select * from GxQscripts where name='AppPruneDeletedVirtualMachines')
	delete from GxQscripts where name = 'AppPruneDeletedVirtualMachines'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPruneDeletedVirtualMachines')
	delete from GXDBVersions where aliasname = 'AppPruneDeletedVirtualMachines'
GO
print '... Creating Procedure: AppPruneDeletedVirtualMachines'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPruneDeletedVirtualMachines
  @i_clientGroupId INT,
  @errorCode INT OUTPUT
AS
BEGIN TRY
	DECLARE @deletedVMsString NVARCHAR(MAX) = (SELECT stringVal
												 FROM APP_ComponentProp WITH (NOLOCK)
WHERE componentId = @i_clientGroupId AND propertyTypeId = 3323 AND modified = 0) -- 3323 - CV_COMPONENT_CG_VM_DELETED_CLIENTID_CSV_STRING
	-- If there are no deleted VMs, nothing to prune. Return
	IF ISNULL(@deletedVMsString, N'') <> N''
	BEGIN
		DECLARE @VMsString NVARCHAR(MAX) = (SELECT stringVal
											 FROM APP_ComponentProp WITH (NOLOCK)
WHERE componentId = @i_clientGroupId AND propertyTypeId = 3314 AND modified = 0)-- 3314 - CV_COMPONENT_CG_VM_CLIENTID_CSV_STRING
		DECLARE @ValidVMs TABLE(VMId INT PRIMARY KEY, deletedVMId INT)
		-- Only keep VMs which are still present in App_client table.
		-- This will ensure VMs which are valid and not aged or deleted are kept in the App_ComponentProp table
		INSERT INTO @ValidVMs
			SELECT DISTINCT VMB.Data, DVM.Data
			FROM dbo.Splitstring(@VMsString, ',') VMB
				LEFT JOIN dbo.Splitstring(@deletedVMsString, ',') DVM ON DVM.Data = VMB.Data
				INNER JOIN App_Client AC WITH (NOLOCK) ON VMB.Data = AC.id
		SET @VMsString = (SELECT DISTINCT
									STUFF((
										SELECT ',' + CAST(DVM.VMId AS VARCHAR) +''
										FROM @ValidVMs DVM
										WHERE DVM.VMId = VMId
										ORDER BY DVM.VMId
										FOR XML PATH('')
									),1,1,'')
									FROM @ValidVMs
									GROUP BY VMId)
		SET @deletedVMsString = (SELECT DISTINCT
									STUFF((
										SELECT ',' + CAST(DVM.deletedVMId AS VARCHAR) +''
										FROM @ValidVMs DVM
										WHERE DVM.deletedVMId = deletedVMId
										ORDER BY DVM.deletedVMId
										FOR XML PATH('')
									),1,1,'')
									FROM @ValidVMs
									GROUP BY deletedVMId)
		BEGIN TRAN
			UPDATE APP_ComponentProp
			SET modified = dbo.GetUnixTime(GETDATE())
			WHERE componentId = @i_clientGroupId AND
propertyTypeId IN (3314, --CV_COMPONENT_CG_VM_CLIENTID_CSV_STRING
3323) AND    --CV_COMPONENT_CG_VM_DELETED_CLIENTID_CSV_STRING
				  modified = 0
			INSERT INTO APP_ComponentProp (componentType, componentId, propertyTypeId, dataType, longVal, longlongVal, stringVal, created, modified)
			VALUES
(8,				--CV_COMPONENT_TYPE_CLIENTGROUP
				@i_clientGroupId,		--Client Group ID
3314,		--CV_COMPONENT_CG_VM_CLIENTID_CSV_STRING
				7,					--PROPERTY_INTEGER
				0, 0, @VMsString, dbo.GetUnixTime(GETDATE()), 0)
			INSERT INTO APP_ComponentProp (componentType, componentId, propertyTypeId, dataType, longVal, longlongVal, stringVal, created, modified)
			VALUES
(8,					--CV_COMPONENT_TYPE_CLIENTGROUP
				@i_clientGroupId,		--Client Group ID
3323,	--CV_COMPONENT_CG_VM_DELETED_CLIENTID_CSV_STRING
				7,					--PROPERTY_INTEGER
				0, 0, @deletedVMsString, dbo.GetUnixTime(GETDATE()), 0)
		COMMIT TRAN
	END
	SET @errorCode = 0
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    ROLLBACK TRAN
    SET @errorCode = 1
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'AppPruneDeletedVirtualMachines')
	delete from GxQscripts where name = 'AppPruneDeletedVirtualMachines'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPruneDeletedVirtualMachines')
	delete from GXDBVersions where aliasname = 'AppPruneDeletedVirtualMachines'
GO

insert into GXDBVersions values(2, 'AppPruneDeletedVirtualMachines',  '00000000000000000000', 'AppPruneDeletedVirtualMachines', '00000000000000000000')
GO

