

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPruneDeleteProviderUsers.sp] ---------- 

--  +===========================================================================+
--  |		 		 Name:  AppMarkProviderForDelete()
--  | Description:  Mark Provider For Delete. will be deleted by EVMGRS Thread.
--  +===========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPruneDeleteProviderUsers.sp,v $ $Id: AppPruneDeleteProviderUsers.sp,v 1.1.2.5 2020/11/26 06:14:06 nshah Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppPruneDeleteProviderUsers')
BEGIN
	print '>>> Drop Stored Procedure: AppPruneDeleteProviderUsers <<<'
	drop procedure AppPruneDeleteProviderUsers
END
IF EXISTS (select * from GxQscripts where name='AppPruneDeleteProviderUsers')
	delete from GxQscripts where name = 'AppPruneDeleteProviderUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPruneDeleteProviderUsers')
	delete from GXDBVersions where aliasname = 'AppPruneDeleteProviderUsers'
GO
print '... Creating Procedure: AppPruneDeleteProviderUsers'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppPruneDeleteProviderUsers
  @companyId INTEGER=0
AS
DECLARE @pruneCount INT = 0
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
IF OBJECT_ID('TEMPDB.DBO.#userList') is not NULL
	DROP TABLE #userList
CREATE TABLE #userList( ID Int)
INSERT #userList
SELECT u.id FROM UMUsers u
INNER JOIN UMDSProviders um on U.umDSproviderId=um.id
WHERE um.id =@companyId and um.flags & 0x0002 = 0x0002 --UMDS_PROVIDER_FLAGS_MARKED_FOR_DELETE
SET @pruneCount = @@ROWCOUNT
IF @pruneCount =0
BEGIN
    goto SCRIPT_EXIT
END
BEGIN TRY
DECLARE @adminUserFlags int = 0x040
	DECLARE @adminUserId int
    select @adminUserId = id from UMUsers WHERE ((UMUsers.flags & @adminUserFlags) <> 0) and enabled =1
	If object_id('MDM_InstalledApp') IS NOT NULL AND object_id('MDM_InstalledAppProp') IS NOT NULL
	BEGIN
		DELETE P
		FROM  MDM_InstalledAppProp P
		INNER JOIN MDM_InstalledApp I ON I.id=P.componentNameId
		WHERE I.activeUserId in  (Select ID FROM #userList)
		DELETE from MDM_InstalledApp WHERE activeUserId in (Select ID FROM #userList)
	END
	 If object_id('EvGuiAuditTrailInfo') IS NOT NULL AND object_id('EvGuiAuditTrailParams') IS NOT NULL
	 BEGIN
		DELETE P
		FROM  EvGuiAuditTrailParams P
		INNER JOIN EvGuiAuditTrailInfo I ON I.id=P.guiAuditTrailId
		WHERE I.userId in (Select ID FROM #userList)
		DELETE from EvGuiAuditTrailInfo  WHERE userid in (Select ID FROM #userList)
	END
    If object_id('App_CCUserAccounts') IS NOT NULL DELETE from App_CCUserAccounts  WHERE userid in (Select ID FROM #userList)
	If object_id('App_Profile') IS NOT NULL AND object_id('App_ProfileProp') IS NOT NULL
	 BEGIN
		DELETE P
		FROM  App_ProfileProp P
		INNER JOIN App_Profile I ON I.profileId=P.profileId
		WHERE I.ownerid in (Select ID FROM #userList)
		DELETE from App_Profile  WHERE ownerid in (Select ID FROM #userList)
	END
	If object_id('App_ThirdPartyAppProp') IS NOT NULL AND object_id('App_ThirdPartyApp') IS NOT NULL
	 BEGIN
		DELETE P
		FROM  App_ThirdPartyAppProp P
		INNER JOIN App_ThirdPartyApp I ON I.id=P.componentNameId
		WHERE I.ownerid in (Select ID FROM #userList)
		DELETE from App_ThirdPartyApp  WHERE ownerid in (Select ID FROM #userList)
	END
	If object_id('LMDashSearchAssoc') IS NOT NULL AND object_id('APP_LMAlertInfo') IS NOT NULL AND object_id('LMUserSearch') IS NOT NULL
	 BEGIN
		DELETE P
		FROM  LMDashSearchAssoc P
		INNER JOIN LMUserSearch I ON I.searchId=P.searchId
		WHERE I.creatorUserId in (Select ID FROM #userList)
		DELETE P
		FROM  APP_LMAlertInfo P
		INNER JOIN LMUserSearch I ON I.searchId=P.searchId
		WHERE I.creatorUserId in (Select ID FROM #userList)
		DELETE from LMUserSearch   WHERE creatorUserId in (Select ID FROM #userList)
	END
    If object_id('UMSearchstring') IS NOT NULL DELETE from UMSearchstring   WHERE userid in (Select ID FROM #userList)
	If object_id('SchedAdminTask') IS NOT NULL AND object_id('JMJobTaskLink') IS NOT NULL AND object_id('SchedAppZIPWorkFlow') IS NOT NULL
	 BEGIN
		DELETE P
		FROM  SchedAppZIPWorkFlow P
		INNER JOIN SchedAdminTask I ON I.id=P.adminTaskId
		WHERE I.userId in (Select ID FROM #userList)
		DELETE P
		FROM  JMJobTaskLink P
		INNER JOIN SchedAdminTask I ON I.id=P.adminTaskId
		WHERE I.userId in (Select ID FROM #userList)
		DELETE from SchedAdminTask   WHERE userid in (Select ID FROM #userList)
	END
    If object_id('APP_LMCoreReqInfo') IS NOT NULL DELETE from APP_LMCoreReqInfo   WHERE userid in (Select ID FROM #userList)
    If object_id('UMQSDKSessions') IS NOT NULL DELETE from UMQSDKSessions   WHERE userid in (Select ID FROM #userList)
    If object_id('UMUserPrefs') IS NOT NULL DELETE from UMUserPrefs   WHERE userid in (Select ID FROM #userList)
    If object_id('APP_ConfigurationPolicy') IS NOT NULL DELETE from APP_ConfigurationPolicy   WHERE ownerid in (Select ID FROM #userList)
    If object_id('TM_Pattern') IS NOT NULL  UPDATE TM_Pattern SET deleted = 1,ownerid=@adminUserId WHERE ownerid in (Select ID FROM #userList)
    If object_id('APP_EmailConfigPolicyAssoc') IS NOT NULL DELETE from APP_EmailConfigPolicyAssoc   WHERE ownerid in (Select ID FROM #userList)
    If object_id('SchedRestoreTask') IS NOT NULL AND object_id('JMJobTaskLink') IS NOT NULL
	BEGIN
		DELETE P
		FROM  JMJobTaskLink P
		INNER JOIN SchedRestoreTask I ON I.id=P.adminTaskId
		WHERE I.userId in  (Select ID FROM #userList)
		DELETE from SchedRestoreTask   WHERE userid in (Select ID FROM #userList)
	END
    If object_id('App_SyncCloudFolder') IS NOT NULL DELETE from App_SyncCloudFolder   WHERE ownerId in (Select ID FROM #userList)
	If object_id('APP_SmartFolderAssoc') IS NOT NULL AND object_id('App_SmartFolder') IS NOT NULL
	BEGIN
		DELETE P
		FROM  APP_SmartFolderAssoc P
		INNER JOIN App_SmartFolder I ON I.id=P.folderId
		WHERE I.ownerId in  (Select ID FROM #userList)
		DELETE from App_SmartFolder    WHERE ownerId in (Select ID FROM #userList)
	END
    If object_id('SProvLUN') IS NOT NULL DELETE from SProvLUN    WHERE userid in (Select ID FROM #userList)
    If object_id('SProvMountLUN') IS NOT NULL DELETE from SProvMountLUN    WHERE userid in (Select ID FROM #userList)
    If object_id('SProvAction') IS NOT NULL DELETE from SProvAction    WHERE userid in (Select ID FROM #userList)
    If object_id('SProvQuota') IS NOT NULL DELETE from SProvQuota    WHERE userid in (Select ID FROM #userList)
    If object_id('SProvEndPoint') IS NOT NULL DELETE from SProvEndPoint    WHERE userid in (Select ID FROM #userList)
    If object_id('SProvHost') IS NOT NULL DELETE from SProvHost    WHERE userid in (Select ID FROM #userList)
    If object_id('SprovAllocationPolicyType') IS NOT NULL DELETE from SprovAllocationPolicyType    WHERE createdBy    in (Select ID FROM #userList)
    If object_id('SprovAllocationPolicy') IS NOT NULL DELETE from SprovAllocationPolicy    WHERE createdBy    in (Select ID FROM #userList)
    If object_id('UMProfile') IS NOT NULL DELETE from UMProfile    WHERE userid    in (Select ID FROM #userList)
    If object_id('ANalertassociation') IS NOT NULL DELETE from ANalertassociation    WHERE userid    in (Select ID FROM #userList)
    If object_id('UMUserPrefs') IS NOT NULL DELETE from UMUserPrefs    WHERE userid    in (Select ID FROM #userList)
    If object_id('UMUserWebPrefs') IS NOT NULL DELETE from UMUserWebPrefs    WHERE userid    in (Select ID FROM #userList)
    If object_id('App_SCGRule') IS NOT NULL DELETE FROM App_SCGRule WHERE ownerId in  (Select ID FROM #userList)
    If object_id('UMUserCredentials') IS NOT NULL DELETE from UMUserCredentials     WHERE userId    in (Select ID FROM #userList)
    If object_id('UMDSUserGroup') IS NOT NULL DELETE from UMDSUserGroup      WHERE userId    in (Select ID FROM #userList)
    If object_id('UMUserGroup') IS NOT NULL DELETE from UMUserGroup     WHERE userId    in (Select ID FROM #userList)
    If object_id('App_VirtualApp') IS NOT NULL DELETE from App_VirtualApp     WHERE ownerId    in (Select ID FROM #userList)
    If object_id('App_VMAllocationPolicy') IS NOT NULL DELETE from App_VMAllocationPolicy     WHERE ownerId    in (Select ID FROM #userList)
    If object_id('App_VirtualLab') IS NOT NULL AND object_id('App_VirtualLabProp') IS NOT NULL
	 BEGIN
		DELETE P
		FROM  App_VirtualLabProp P
		INNER JOIN App_VirtualLab I ON I.id=P.componentNameId
		WHERE I.ownerid in (Select ID FROM #userList)
		DELETE from App_VirtualLab  WHERE ownerid in (Select ID FROM #userList)
	END
    If object_id('APP_EmailConfigPolicyAssoc') IS NOT NULL DELETE from APP_EmailConfigPolicyAssoc     WHERE ownerId    in (Select ID FROM #userList)
    If object_id('SchedBackupTask') IS NOT NULL DELETE from SchedBackupTask     WHERE userId    in (Select ID FROM #userList)
    If object_id('TM_Task') IS NOT NULL UPDATE Tbl SET ownerId = 0 FROM TM_Task Tbl WHERE ownerId    in (Select ID FROM #userList)
    If object_id('TM_Task') IS NOT NULL UPDATE Tbl SET runUserId = 0 FROM TM_Task Tbl WHERE runUserId    in (Select ID FROM #userList)
    If object_id('LMDashBoard') IS NOT NULL DELETE from LMDashBoard      WHERE creatorUserId    in (Select ID FROM #userList)
    If object_id('DM2CompliancePolicy') IS NOT NULL DELETE from DM2CompliancePolicy     WHERE ownerUserId    in (Select ID FROM #userList)
    If object_id('DM2Container') IS NOT NULL DELETE from DM2Container     WHERE userId    in (Select ID FROM #userList)
    If object_id('SEDataSource') IS NOT NULL DELETE from SEDataSource     WHERE ownerUserId    in (Select ID FROM #userList)
    If object_id('SESearchView') IS NOT NULL DELETE from SESearchView     WHERE ownerUserId    in (Select ID FROM #userList)
    If object_id('App_Reports') IS NOT NULL DELETE from App_Reports     WHERE userId    in (Select ID FROM #userList)
    If object_id('APP_BackupsetProp') IS NOT NULL DELETE Tbl from APP_BackupsetProp Tbl    WHERE Tbl.attrName = 'Subclient Policy Create UserId' AND Tbl.modified = 0 AND Tbl.attrVal in  (Select CAST(ID AS VARCHAR(MAX)) FROM #userList)
    If object_id('APP_MonitoringPolicyProp') IS NOT NULL DELETE Tbl from APP_MonitoringPolicyProp Tbl    WHERE Tbl.attrName = 'Creater User Id' AND Tbl.modified = 0 AND Tbl.attrVal in  (Select CAST(ID AS VARCHAR(MAX)) FROM #userList)
	--In case plan was not deleted
    If object_id('App_Plan') IS NOT NULL UPDATE App_Plan SET ownerId=@adminUserId   WHERE ownerid    in (Select ID FROM #userList)
    If object_id('App_SyncWebFolder') IS NOT NULL DELETE from App_SyncWebFolder    WHERE ownerid    in (Select ID FROM #userList)
     UPDATE NTNotificationRule SET notifOwner=1,status=2 ,revision = 0 where notifOwner in (Select ID FROM #userList)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	IF ERROR_NUMBER() = 1205  --DEADLOCK error
    BEGIN
        ;THROW;   -- rethrow the DEADLOCK so XE captures.
    END
END CATCH
SCRIPT_EXIT:
IF OBJECT_ID('TEMPDB.DBO.#userList') is not NULL
       DROP TABLE #userList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppPruneDeleteProviderUsers')
	delete from GxQscripts where name = 'AppPruneDeleteProviderUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPruneDeleteProviderUsers')
	delete from GXDBVersions where aliasname = 'AppPruneDeleteProviderUsers'
GO

insert into GXDBVersions values(2, 'AppPruneDeleteProviderUsers',  '00010001000200050000', 'AppPruneDeleteProviderUsers', '00010001000200050000')
GO

