

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPruneContentStoreSites.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppPruneContentStoreSites.sp,v $ $Id: AppPruneContentStoreSites.sp,v 1.1.276.1 2018/03/22 01:43:40 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppPruneContentStoreSites"	|
-- 	+-----------------------------------------------------------------------+
--  +-------------------------------------------------------------------------------------+
--  |   Revision History                                                                  |
--  |   ================                                                                  |
--  |   Procedure Name                        Description                                 |
--  |   -----------------------------         ------------------------------------------  |
--  +-------------------------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppPruneContentStoreSites <<<'

IF EXISTS (select * from sysobjects where name='AppPruneContentStoreSites')
	drop procedure AppPruneContentStoreSites
IF EXISTS (select * from GxQscripts where name='AppPruneContentStoreSites')
	delete from GxQscripts where name = 'AppPruneContentStoreSites'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPruneContentStoreSites')
	delete from GXDBVersions where aliasname = 'AppPruneContentStoreSites'
GO
print '... Creating Procedure: AppPruneContentStoreSites'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppPruneContentStoreSites
  @i_subclientId integer
AS
  DECLARE @o_xmlText XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
BEGIN
DECLARE @o_errorCode		INT = 0
DECLARE @o_errorString		NVARCHAR(MAX) = ''
DECLARE @siteDetails XML = (SELECT REPLACE(attrval,'UTF-8','UTF-16') FROM APP_SubClientProp WHERE componentNameId = @i_subclientId
				AND attrName = 'Object Server Site Info' and modified = 0)
DECLARE @siteTable TABLE(subContent NVARCHAR(1024))
INSERT INTO @siteTable
SELECT ref.value('@url', 'NVARCHAR(1024)')
FROM  @siteDetails.nodes ('Ida_ObjServerSetContentReq/contentMappingList') R(ref)
DELETE APP_ScFilterFile
WHERE componentNameId = @i_subclientId
	AND fileName NOT IN ( SELECT subContent
						  FROM @siteTable
						 )
SET @o_errorCode = 0
SET @o_errorString = 'Success'
EXIT_ERROR:
	BEGIN
		SELECT	1					as TAG,
				0					as Parent,
				@o_errorCode		as [CVGui_GenericResp!1!errorCode],
				@o_errorString		as [CVGui_GenericResp!1!errorMessage]
		FOR XML EXPLICIT
	END
END
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'AppPruneContentStoreSites')
	delete from GxQscripts where name = 'AppPruneContentStoreSites'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPruneContentStoreSites')
	delete from GXDBVersions where aliasname = 'AppPruneContentStoreSites'
GO

insert into GXDBVersions values(2, 'AppPruneContentStoreSites',  '00010001027600010000', 'AppPruneContentStoreSites', '00010001027600010000')
GO

