

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppPruneCMCredentials.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppPruneCMCredentials						    |
--	|				Delete Credential Manager Records					|
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppPruneCMCredentials')
BEGIN
	print '>>> Drop Stored Procedure: AppPruneCMCredentials <<<'
	drop procedure AppPruneCMCredentials
END
IF EXISTS (select * from GxQscripts where name='AppPruneCMCredentials')
	delete from GxQscripts where name = 'AppPruneCMCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPruneCMCredentials')
	delete from GXDBVersions where aliasname = 'AppPruneCMCredentials'
GO
print '... Creating Procedure: AppPruneCMCredentials'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppPruneCMCredentials
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
-----------------------------------------------------------
AS
  DECLARE @o_ErrorString VARCHAR(1024) =''
  DECLARE @o_ErrorCode integer = 0
SET NOCOUNT ON
BEGIN TRY
	if OBJECT_ID('tempdb.dbo.#credDeletedEntities') is not null drop table dbo.#credDeletedEntities
	CREATE TABLE #credDeletedEntities
	(
		assocId INT PRIMARY KEY,
		assocEntityId INT
	)
	--PRUNE INVALID ENTRIES FROM ASSOCIATION TABLE BEFORE DELETING THE CREDENTIAL
	INSERT INTO #credDeletedEntities
	(assocId, assocEntityId)
	SELECT DISTINCT CA.assocId, A.id
	FROM APP_CredentialAssoc CA (NOLOCK)
	LEFT JOIN APP_Application A (NOLOCK) ON A.id = CA.entityId
	WHERE CA.entityType = 7		--SUBCLIENT_ENTITY
	UNION ALL
	SELECT DISTINCT CA.assocId, B.id
	FROM APP_CredentialAssoc CA (NOLOCK)
	LEFT JOIN APP_BackupSetName B (NOLOCK) ON B.id = CA.entityId
	WHERE CA.entityType = 6		--BACKUPSET_ENTITY
	UNION ALL
	SELECT DISTINCT CA.assocId, I.id
	FROM APP_CredentialAssoc CA (NOLOCK)
	LEFT JOIN APP_InstanceName I (NOLOCK) ON I.id = CA.entityId
	WHERE CA.entityType = 5		--INSTANCE_ENTITY
	UNION ALL
	SELECT DISTINCT CA.assocId, D.id
	FROM APP_CredentialAssoc CA (NOLOCK)
	LEFT JOIN APP_IDAName D (NOLOCK) ON D.id = CA.entityId
	WHERE CA.entityType = 4		--APPTYPE_ENTITY
	UNION ALL
	SELECT DISTINCT CA.assocId, C.id
	FROM APP_CredentialAssoc CA (NOLOCK)
	LEFT JOIN APP_Client C (NOLOCK) ON C.id = CA.entityId
	WHERE CA.entityType = 3		--CLIENT_ENTITY
	--UNION ALL
	--SELECT DISTINCT CA.assocId, L.LibraryId
	--FROM APP_CredentialAssoc CA (NOLOCK)
	--LEFT JOIN MMLibrary L (NOLOCK) ON L.LibraryId = CA.entityId
	--WHERE CA.entityType = 9		--LIBRARY_ENTITY
	UNION ALL
	SELECT DISTINCT CA.assocId, G.id
	FROM APP_CredentialAssoc CA (NOLOCK)
	LEFT JOIN APP_ClientGroup G (NOLOCK) ON G.id = CA.entityId
	WHERE CA.entityType = 28	--CLIENT_GROUP_ENTITY
	--UNION ALL
	--SELECT DISTINCT CA.assocId, P.id
	--FROM APP_CredentialAssoc CA (NOLOCK)
	--LEFT JOIN archGroup P (NOLOCK) ON P.id = CA.entityId
	--WHERE CA.entityType = 17	--STORAGE_POLICY_ENTITY
	--UNION ALL
	--SELECT DISTINCT CA.assocId, GC.id
	--FROM APP_CredentialAssoc CA (NOLOCK)
	--LEFT JOIN archGroupCopy GC (NOLOCK) ON GC.id = CA.entityId
	--WHERE CA.entityType = 18	--STORAGE_POLICY_COPY_ENTITY
	UNION ALL
	SELECT DISTINCT CA.assocId, W.WorkflowId
	FROM APP_CredentialAssoc CA (NOLOCK)
	LEFT JOIN WF_Definition W (NOLOCK) ON W.WorkflowId = CA.entityId
	WHERE CA.entityType = 83	--WORKFLOW_ENTITY
	UNION ALL
	SELECT DISTINCT CA.assocId, MC.DeviceControllerId
	FROM APP_CredentialAssoc CA (NOLOCK)
	LEFT JOIN MMDeviceController MC (NOLOCK) ON MC.DeviceControllerId = CA.entityId
	WHERE CA.entityType = 186	--DEVICE_CONTROLLER_ENTITY
	UNION ALL
	SELECT DISTINCT CA.assocId, MD.DeviceId
	FROM APP_CredentialAssoc CA (NOLOCK)
	LEFT JOIN MMDevice MD (NOLOCK) ON MD.DeviceId = CA.entityId
	WHERE CA.entityType = 185	--DEVICE_ENTITY
	UNION ALL
	SELECT DISTINCT CA.assocId, SH.ControlHostId
	FROM APP_CredentialAssoc CA (NOLOCK)
	LEFT JOIN SMControlHost SH (NOLOCK) ON SH.ControlHostId = CA.entityId
	WHERE CA.entityType = 153	--ARRAY_ENTITY
	DELETE APP_CredentialAssoc
	WHERE assocId IN (SELECT assocId FROM #credDeletedEntities WHERE assocEntityId IS NULL )
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @o_ErrorCode = ERROR_NUMBER()
		SET @o_ErrorString = ERROR_MESSAGE()
END CATCH
IF OBJECT_ID('tempdb.dbo.#credDeletedEntities') is not null drop table dbo.#credDeletedEntities
SELECT @o_ErrorString o_ErrorString, @o_ErrorCode o_ErrorCode
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppPruneCMCredentials')
	delete from GxQscripts where name = 'AppPruneCMCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppPruneCMCredentials')
	delete from GXDBVersions where aliasname = 'AppPruneCMCredentials'
GO

insert into GXDBVersions values(2, 'AppPruneCMCredentials',  '00000000000000000000', 'AppPruneCMCredentials', '00000000000000000000')
GO

