

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppProcessWildcardInterfaces.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppProcessWildcardInterfaces')
BEGIN
	print '>>> Drop Stored Procedure: AppProcessWildcardInterfaces <<<'
	drop procedure AppProcessWildcardInterfaces
END
IF EXISTS (select * from GxQscripts where name='AppProcessWildcardInterfaces')
	delete from GxQscripts where name = 'AppProcessWildcardInterfaces'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppProcessWildcardInterfaces')
	delete from GXDBVersions where aliasname = 'AppProcessWildcardInterfaces'
GO
print '... Creating Procedure: AppProcessWildcardInterfaces'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppProcessWildcardInterfaces
/*
*	This SP processes interfaces to match IP/hostname and CIDR representation
*/
  @i_srcClientId INTEGER,
  @i_srcClientGroupId INTEGER,
  @i_dstClientId INTEGER,
  @i_dstClientGroupId INTEGER,
  @i_srcType INTEGER,
  @i_srcInterface NVARCHAR (64),
  @i_dstType INTEGER,
  @i_dstInterface NVARCHAR (64)
AS
  DECLARE @errorCode INTEGER
  DECLARE @errorMessage NVARCHAR(MAX)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
/* Interface wildcard type. Non_Wildcard = 0, CIDR = 1, Wildcard = 2 */
	IF @i_srcClientId<>0 OR @i_srcClientGroupId<>0
	BEGIN
		/* Process source interface */
		IF object_id('tempdb.dbo.#SrcClientInterfaceMap') IS NOT NULL
		BEGIN
IF @i_srcType = 0 /* Non_Wildcard */
			BEGIN
				INSERT INTO #SrcClientInterfaceMap (clientId, interface)
				SELECT @i_srcClientId, @i_srcInterface
				WHERE @i_srcClientId<>0
				UNION ALL
				SELECT ACGA.clientId, AC.net_hostname
				FROM APP_ClientGroupAssoc ACGA
				INNER JOIN APP_Client AC
				ON ACGA.clientId=AC.id AND ACGA.clientGroupId=@i_srcClientGroupId
				WHERE @i_srcClientGroupId<>0
			END
ELSE IF @i_srcType = 1 /*CIDR*/
			BEGIN
				DECLARE @srcInterfaceCIDR VARCHAR(50) = REPLACE(@i_srcInterface, '/', ',')
				IF CHARINDEX('.', @i_srcInterface)<>0
				BEGIN
					-- IPv4
					INSERT INTO #SrcClientInterfaceMap (clientId, interface)
					SELECT clientId, ip FROM getClientIPv4WithCIDRMask('=', @srcInterfaceCIDR, @i_srcClientId, @i_srcClientGroupId)
				END
				ELSE IF CHARINDEX(':', @i_srcInterface)<>0
				BEGIN
					-- IPv6
					INSERT INTO #SrcClientInterfaceMap (clientId, interface)
					SELECT clientId, ip FROM getClientIPv6WithCIDRMask('=', @srcInterfaceCIDR, @i_srcClientId, @i_srcClientGroupId)
				END
				ELSE
				BEGIN
					PRINT 'Invalid IP ' + @i_srcInterface
					RETURN
				END
			END
ELSE IF @i_srcType = 2 /* Wildcard */
			BEGIN
				IF LTRIM(RTRIM(@i_srcInterface)) = '*'
				BEGIN
					/* When * is specified, consider only N'Client IP Addresses' */
					/* Client IP Addresses are moved to App_ComponentProp table under property type CV_COMPONENT_CLIENT_IP_ADDRESSES */
					INSERT INTO #SrcClientInterfaceMap
					SELECT   ComponentID, LTRIM(RTRIM(S.Data))
					FROM APP_ComponentProp AC
					CROSS APPLY dbo.SplitString(AC.stringVal, ',') S
WHERE AC.propertyTypeId = 2102 AND modified = 0 AND componentId = @i_srcClientId AND @i_srcClientId<>0
					UNION ALL
					SELECT   ComponentID, LTRIM(RTRIM(S.Data))
					FROM APP_ComponentProp AC
					CROSS APPLY dbo.SplitString(AC.stringVal, ',') S
					INNER JOIN APP_ClientGroupAssoc ACGA
					ON AC.componentId=ACGA.clientId AND ACGA.clientGroupId=@i_srcClientGroupId AND @i_srcClientGroupId<>0
WHERE AC.propertyTypeId = 2102 AND modified = 0 AND componentId = ACGA.clientId
				END
				ELSE
				BEGIN
DECLARE @srcRegExpression NVARCHAR(255) = REPLACE (@i_srcInterface, '*', '%')
					INSERT INTO #SrcClientInterfaceMap
					SELECT   ComponentID, LTRIM(RTRIM(S.Data))
					FROM app_ComponentProp AC
					CROSS APPLY dbo.SplitString(AC.stringVal, ',') S
WHERE (AC.propertyTypeId = 2102 OR AC.propertyTypeId = 2103) AND modified = 0 AND componentId = @i_srcClientId AND @i_srcClientId<>0 AND S.Data LIKE @srcRegExpression
					UNION ALL
					SELECT   ComponentID, LTRIM(RTRIM(S.Data))
					FROM app_ComponentProp AC
					CROSS APPLY dbo.SplitString(AC.stringVal, ',') S
					INNER JOIN APP_ClientGroupAssoc ACGA
					ON AC.componentId=ACGA.clientId AND ACGA.clientGroupId=@i_srcClientGroupId AND @i_srcClientGroupId<>0
WHERE (AC.propertyTypeId = 2102  OR AC.propertyTypeId = 2103) AND modified = 0 AND componentId = ACGA.clientId AND S.Data LIKE @srcRegExpression
					UNION ALL
					SELECT  id, net_hostname
					FROM App_Client AC
					WHERE id=@i_srcClientId AND @i_srcClientId<>0 AND net_hostname like @srcRegExpression
					UNION ALL
					SELECT AC.id, AC.net_hostname
					FROM App_Client AC
					INNER JOIN APP_ClientGroupAssoc ACGA
					ON AC.id=ACGA.clientId
					WHERE ACGA.clientGroupId=@i_srcClientGroupId AND @i_srcClientGroupId<>0 AND AC.net_hostname LIKE @srcRegExpression
				END
			END
		END
	END
	/* Client IP Addresses and Client Hostnames are moved to App_ComponentProp table under property type CV_COMPONENT_CLIENT_IP_ADDRESSES and CV_COMPONENT_CLIENT_HOSTNAMES respectively */
	IF @i_dstClientId<>0 OR @i_dstClientGroupId<>0
	BEGIN
		IF object_id('tempdb.dbo.#DstClientInterfaceMap') IS NOT NULL
		BEGIN
			/* Process destination interface */
IF @i_dstType = 0 /* Non_Wildcard */
			BEGIN
				INSERT INTO #DstClientInterfaceMap (clientId, interface)
				SELECT @i_dstClientId, @i_dstInterface
				WHERE @i_dstClientId<>0
				UNION ALL
				SELECT ACGA.clientId, AC.net_hostname
				FROM APP_ClientGroupAssoc ACGA
				INNER JOIN APP_Client AC
				ON ACGA.clientId=AC.id AND ACGA.clientGroupId=@i_dstClientGroupId
				WHERE @i_dstClientGroupId<>0
			END
ELSE IF @i_dstType = 1 /*CIDR*/
			BEGIN
				DECLARE @dstInterfaceCIDR VARCHAR(50) = REPLACE(@i_dstInterface, '/', ',')
				IF CHARINDEX('.', @i_dstInterface)<>0
				BEGIN
					-- IPv4
					INSERT INTO #DstClientInterfaceMap (clientId, interface)
					SELECT clientId, ip FROM getClientIPv4WithCIDRMask('=', @dstInterfaceCIDR, @i_dstClientId, @i_dstClientGroupId)
				END
				ELSE IF CHARINDEX(':', @i_dstInterface)<>0
				BEGIN
					-- IPv6
					INSERT INTO #DstClientInterfaceMap (clientId, interface)
					SELECT clientId, ip FROM getClientIPv6WithCIDRMask('=', @dstInterfaceCIDR, @i_dstClientId, @i_dstClientGroupId)
				END
				ELSE
				BEGIN
					PRINT 'Invalid IP ' + @i_dstInterface
					RETURN
				END
			END
ELSE IF @i_dstType = 2 /* Wildcard */
			BEGIN
				IF LTRIM(RTRIM(@i_dstInterface)) = '*'
				BEGIN
					/* When * is specified, consider only N'Client IP Addresses' */
					INSERT INTO #DstClientInterfaceMap
					SELECT   componentId, LTRIM(RTRIM(S.Data))
					FROM app_ComponentProp AC
					CROSS APPLY dbo.SplitString(AC.stringVal, ',') S
WHERE AC.propertyTypeId = 2102 AND modified = 0 AND componentId = @i_dstClientId AND @i_dstClientId<>0
					UNION ALL
					SELECT   componentId, LTRIM(RTRIM(S.Data))
					FROM app_ComponentProp AC
					CROSS APPLY dbo.SplitString(AC.stringVal, ',') S
					INNER JOIN APP_ClientGroupAssoc ACGA
					ON AC.componentId=ACGA.clientId AND ACGA.clientGroupId=@i_dstClientGroupId AND @i_dstClientGroupId<>0
WHERE AC.propertyTypeId = 2102 AND modified = 0 AND componentId = ACGA.clientId
				END
				ELSE
				BEGIN
DECLARE @dstRegExpression NVARCHAR(255) = REPLACE (@i_dstInterface, '*', '%')
					INSERT INTO #DstClientInterfaceMap
					SELECT   componentId, LTRIM(RTRIM(S.Data))
					FROM app_ComponentProp AC
					CROSS APPLY dbo.SplitString(AC.stringVal, ',') S
WHERE (AC.propertyTypeId = 2102 OR AC.propertyTypeId = 2103) AND modified = 0 AND componentId = @i_dstClientId AND @i_dstClientId<>0 AND S.Data LIKE @dstRegExpression
					UNION ALL
					SELECT   componentId, LTRIM(RTRIM(S.Data))
					FROM app_ComponentProp AC
					CROSS APPLY dbo.SplitString(AC.stringVal, ',') S
					INNER JOIN APP_ClientGroupAssoc ACGA
					ON AC.componentId=ACGA.clientId AND ACGA.clientGroupId=@i_dstClientGroupId AND @i_dstClientGroupId<>0
WHERE (AC.propertyTypeId = 2102 OR AC.propertyTypeId = 2103) AND modified = 0 AND componentId = ACGA.clientId AND S.Data LIKE @dstRegExpression
					UNION ALL
					SELECT  id, net_hostname
					FROM App_Client AC
					WHERE id=@i_dstClientId AND @i_dstClientId<>0 AND net_hostname like @dstRegExpression
					UNION ALL
					SELECT AC.id, AC.net_hostname
					FROM App_Client AC
					INNER JOIN APP_ClientGroupAssoc ACGA
					ON AC.id=ACGA.clientId
					WHERE ACGA.clientGroupId=@i_dstClientGroupId AND @i_dstClientGroupId<>0 AND AC.net_hostname LIKE @dstRegExpression
				END
			END
		END
	END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppProcessWildcardInterfaces')
	delete from GxQscripts where name = 'AppProcessWildcardInterfaces'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppProcessWildcardInterfaces')
	delete from GXDBVersions where aliasname = 'AppProcessWildcardInterfaces'
GO

insert into GXDBVersions values(2, 'AppProcessWildcardInterfaces',  '00000000000000000000', 'AppProcessWildcardInterfaces', '00000000000000000000')
GO

