

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppProcessPostRetireClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppProcessPostRetireClients')
BEGIN
	print '>>> Drop Stored Procedure: AppProcessPostRetireClients <<<'
	drop procedure AppProcessPostRetireClients
END
IF EXISTS (select * from GxQscripts where name='AppProcessPostRetireClients')
	delete from GxQscripts where name = 'AppProcessPostRetireClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppProcessPostRetireClients')
	delete from GXDBVersions where aliasname = 'AppProcessPostRetireClients'
GO
print '... Creating Procedure: AppProcessPostRetireClients'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppProcessPostRetireClients
  @xmlstr XML,
  @localeId INT,
  @userId INT
AS
  DECLARE @errorCode INT
  DECLARE @errorString NVARCHAR(MAX)
SET NOCOUNT ON
BEGIN TRY
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @nowTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())
	SET @errorCode = 0
	SET @errorString = ''
DECLARE @retirePhase NVARCHAR(1024)
	DECLARE @numOfClients INT = 0
	IF object_id('tempdb.dbo.#RetiredClientsTable') IS NOT NULL
		DROP TABLE #RetiredClientsTable
	CREATE TABLE #RetiredClientsTable
	(clientId INT PRIMARY KEY)
	-- READ CLIENTS FROM REQUEST XML
	INSERT INTO #RetiredClientsTable
	(clientId)
	SELECT ref.value('@clientId', 'INTEGER')
	FROM @xmlstr.nodes('App_ProcessPostRetireClientsRequest/client') R(ref)
	SET @numOfClients = @@ROWCOUNT
	IF @numOfClients = 0
	BEGIN
		GOTO PROC_EXIT
	END
	-- IF NULL, DEFAULT TO App::RetireClientPhase::RetireClientPhase_RETIRE_IN_PROGRESS
SET @retirePhase = ISNULL((SELECT  ref.value('@retirePhase', 'nvarchar(1024)')
      FROM    @xmlstr.nodes('App_ProcessPostRetireClientsRequest') R ( ref )), '1')
	-- UPDATE CLIENT RETIRE PHASE PROPERTY
	MERGE App_ClientProp AS TARGET
	USING #RetiredClientsTable AS SOURCE
ON TARGET.attrName = 'Retire Client Phase' AND TARGET.modified = 0 AND TARGET.componentNameId = SOURCE.clientId
	WHEN MATCHED AND TARGET.attrVal <> @retirePhase
		THEN UPDATE SET TARGET.attrVal = @retirePhase
	WHEN NOT MATCHED
		THEN INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (SOURCE.clientId, 'Retire Client Phase', 7, @retirePhase, @nowTime, 0);
	-- AUDIT CLIENTS BEING RETIRED
DECLARE @opMsgId    INT = (707 | (CAST(POWER(2, 24) AS BIGINT) * 84))
    DECLARE @opEvMsgId  INT = 0
    DECLARE @opId       INT = 0
    DECLARE @clientNames NVARCHAR(MAX) = NULL
DECLARE @paramMsgId INT = (1871 | (CAST(POWER(2, 24) AS BIGINT) * 85))  -- Client(s) [^1%s] are retired.
	SELECT @clientNames = COALESCE(@clientNames + ', ', '') + ISNULL(Name, 'N/A')
	FROM #RetiredClientsTable C
	JOIN App_Client AC ON C.clientId = AC.id
    EXEC EvGuiAuditSetOperation  @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
    -- audit record parameter values
    EXEC EvGuiAuditSetParamData @opId, @clientNames, 0
    -- tie up
    EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @errorCode = ERROR_NUMBER()
    set @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
PROC_EXIT:
	IF @errorCode <> 0 AND @errorString <> ''
	BEGIN
		SET @errorString = (SELECT Message FROM EvLocaleMsgs WHERE MessageId = @errorCode and localeId = @localeId)
	END
IF object_id('tempdb.dbo.#RetiredClientsTable') IS NOT NULL
	DROP TABLE #RetiredClientsTable
SELECT @errorCode AS errorCode, @errorString AS errorString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppProcessPostRetireClients')
	delete from GxQscripts where name = 'AppProcessPostRetireClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppProcessPostRetireClients')
	delete from GXDBVersions where aliasname = 'AppProcessPostRetireClients'
GO

insert into GXDBVersions values(2, 'AppProcessPostRetireClients',  '00000000000000000000', 'AppProcessPostRetireClients', '00000000000000000000')
GO

